/*
 * Decompiled with CFR 0.152.
 */
package ec.co.ant;

import ec.EvolutionState;
import ec.co.Component;
import ec.co.ConstructiveIndividual;
import ec.co.ant.PheromoneTable;
import ec.co.ant.UpdateRule;
import ec.util.Parameter;
import java.util.List;

public class ACSLocalUpdateRule
implements UpdateRule {
    private static final long serialVersionUID = 1L;
    public static final String P_RHO = "rho";
    public static final String P_MINIMUM_PHEROMONE = "minimum-pheromone";
    private double rho;
    private double minimumPheromone;

    public double getMinimumPheromone() {
        return this.minimumPheromone;
    }

    public double getRho() {
        return this.rho;
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        assert (state != null);
        assert (base != null);
        this.rho = state.parameters.getDouble(base.push(P_RHO), null, 0.0);
        this.minimumPheromone = state.parameters.getDouble(base.push(P_RHO), null, 0.0);
        assert (this.repOK());
    }

    @Override
    public void updatePheromones(EvolutionState state, PheromoneTable pheromones, List individuals) {
        assert (pheromones != null);
        assert (individuals != null);
        assert (!individuals.isEmpty());
        for (Object ind : individuals) {
            for (Object oo : (ConstructiveIndividual)ind) {
                assert (oo instanceof Component);
                Component c = (Component)oo;
                double oldPheromone = pheromones.get(state, c, 0);
                pheromones.set(c, (1.0 - this.rho) * oldPheromone + this.rho * this.minimumPheromone);
            }
        }
        assert (this.repOK());
    }

    public final boolean repOK() {
        return P_RHO != null && !P_RHO.isEmpty() && !Double.isInfinite(this.rho) && !Double.isNaN(this.rho) && this.rho >= 0.0;
    }
}

