/*
 * Decompiled with CFR 0.152.
 */
package ec.co.ant;

import ec.EvolutionState;
import ec.Fitness;
import ec.Individual;
import ec.Species;
import ec.Subpopulation;
import ec.co.ConstructiveIndividual;
import ec.co.ant.ConstructionRule;
import ec.co.ant.PheromoneTable;
import ec.co.ant.UpdateRule;
import ec.util.Parameter;
import java.util.ArrayList;

public class AntSpecies
extends Species {
    private static final long serialVersionUID = 1L;
    public static final Parameter DEFAULT_BASE = new Parameter("constructive");
    public static final String SPECIES_NAME = "constructive-species";
    public static final String P_CONSTRUCTION_RULE = "construction-rule";
    public static final String P_PHEROMONE_TABLE = "pheromone-table";
    public static final String P_UPDATE_RULE = "update-rule";
    public static final String P_LOCAL_UPDATE_RULE = "local-update-rule";
    private ConstructionRule constructionRule;
    private PheromoneTable pheromones;
    private UpdateRule updateRule;
    private UpdateRule localUpdateRule;

    @Override
    public void setup(EvolutionState state, Parameter base) {
        this.setupSuper(state, base);
        assert (state != null);
        assert (base != null);
        this.constructionRule = (ConstructionRule)state.parameters.getInstanceForParameter(base.push(P_CONSTRUCTION_RULE), null, ConstructionRule.class);
        this.constructionRule.setup(state, base.push(P_CONSTRUCTION_RULE));
        this.pheromones = (PheromoneTable)state.parameters.getInstanceForParameter(base.push(P_PHEROMONE_TABLE), null, PheromoneTable.class);
        this.pheromones.setup(state, base.push(P_PHEROMONE_TABLE));
        if (state.parameters.exists(base.push(P_UPDATE_RULE), null)) {
            this.updateRule = (UpdateRule)state.parameters.getInstanceForParameter(base.push(P_UPDATE_RULE), null, UpdateRule.class);
            this.updateRule.setup(state, base.push(P_UPDATE_RULE));
        }
        if (state.parameters.exists(base.push(P_LOCAL_UPDATE_RULE), null)) {
            this.localUpdateRule = (UpdateRule)state.parameters.getInstanceForParameter(base.push(P_LOCAL_UPDATE_RULE), null, UpdateRule.class);
            this.localUpdateRule.setup(state, base.push(P_LOCAL_UPDATE_RULE));
        }
        assert (this.repOK());
    }

    private void setupSuper(EvolutionState state, Parameter base) {
        assert (state != null);
        assert (base != null);
        Parameter def = this.defaultBase();
        this.i_prototype = (Individual)state.parameters.getInstanceForParameter(base.push("ind"), def.push("ind"), Individual.class);
        this.i_prototype.species = this;
        this.i_prototype.setup(state, base.push("ind"));
        this.f_prototype = (Fitness)state.parameters.getInstanceForParameter(base.push("fitness"), def.push("fitness"), Fitness.class);
        this.f_prototype.setup(state, base.push("fitness"));
    }

    @Override
    public void updateSubpopulation(EvolutionState state, Subpopulation subpop) {
        this.updateRule.updatePheromones(state, this.pheromones, subpop.individuals);
        assert (this.repOK());
    }

    @Override
    public void updateIndividual(EvolutionState state, Individual ind) {
        if (this.localUpdateRule != null) {
            ArrayList<Individual> inds = new ArrayList<Individual>();
            inds.add(ind);
            this.localUpdateRule.updatePheromones(state, this.pheromones, inds);
        }
    }

    @Override
    public ConstructiveIndividual<?> newIndividual(EvolutionState state, int thread) {
        assert (state != null);
        assert (thread >= 0);
        ConstructiveIndividual ind = (ConstructiveIndividual)super.newIndividual(state, thread);
        assert (this.repOK());
        return this.constructionRule.constructSolution(state, ind, this.pheromones, thread);
    }

    @Override
    public Parameter defaultBase() {
        return DEFAULT_BASE.push(SPECIES_NAME);
    }

    public final boolean repOK() {
        return DEFAULT_BASE != null && SPECIES_NAME != null && !SPECIES_NAME.isEmpty() && P_UPDATE_RULE != null && !P_UPDATE_RULE.isEmpty() && P_CONSTRUCTION_RULE != null && !P_CONSTRUCTION_RULE.isEmpty() && this.constructionRule != null && this.updateRule != null && this.pheromones != null;
    }
}

