/*
 * Decompiled with CFR 0.152.
 */
package ec.co.ant;

import ec.EvolutionState;
import ec.co.Component;
import ec.co.ConstructiveIndividual;
import ec.co.ConstructiveProblemForm;
import ec.co.ant.PheromoneTable;
import ec.co.ant.UpdateRule;
import ec.util.Parameter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class AntSystemUpdateRule
implements UpdateRule {
    private static final long serialVersionUID = 1L;
    public static final String P_DECAY_RATE = "decay-rate";
    public static final String P_DEPOSIT_RULE = "deposit-rule";
    public static final String P_Q = "Q";
    private double decayRate;
    private DepositRule depositRule;
    private double q;

    @Override
    public void setup(EvolutionState state, Parameter base) {
        String depositString;
        assert (state != null);
        assert (base != null);
        this.decayRate = state.parameters.getDouble(base.push(P_DECAY_RATE), null);
        if (this.decayRate < 0.0 || this.decayRate >= 1.0 || Double.isInfinite(this.decayRate) || Double.isNaN(this.decayRate)) {
            state.output.fatal(String.format("%s: '%s' parameter is set to '%f,' but must be on the interval [0,1).", this.getClass().getSimpleName(), base.push(P_DECAY_RATE), this.decayRate));
        }
        double d = this.q = state.parameters.exists(base.push(P_Q), null) ? state.parameters.getDouble(base.push(P_Q), null) : 1.0;
        if (this.q <= 0.0) {
            state.output.fatal(String.format("%s: parameter '%s' has a value of %f, but must be positive.", this.getClass().getSimpleName(), base.push(P_Q), this.q));
        }
        if ((depositString = state.parameters.getString(base.push(P_DEPOSIT_RULE), null)) == null) {
            state.output.fatal(String.format("%s: missing required parameter '%s'.", this.getClass().getSimpleName(), base.push(P_DEPOSIT_RULE)));
        }
        try {
            depositString = depositString.replace('-', '_');
            this.depositRule = DepositRule.valueOf(depositString);
        }
        catch (NullPointerException e) {
            state.output.fatal(String.format("%s: invalid value '%s' found for parameter '%s'.  Allowed values are %s.", this.getClass().getSimpleName(), depositString, base.push(P_DEPOSIT_RULE), Arrays.asList(DepositRule.values())));
        }
        catch (IllegalArgumentException e) {
            state.output.fatal(String.format("%s: invalid value '%s' found for parameter '%s'.  Allowed values are %s.", this.getClass().getSimpleName(), depositString, base.push(P_DEPOSIT_RULE), Arrays.asList(DepositRule.values())));
        }
        assert (this.repOK());
    }

    public double getDecayRate() {
        return this.decayRate;
    }

    public DepositRule getDepositRule() {
        return this.depositRule;
    }

    public double getQ() {
        return this.q;
    }

    @Override
    public void updatePheromones(EvolutionState state, PheromoneTable pheromones, List individuals) {
        assert (pheromones != null);
        assert (individuals != null);
        assert (!individuals.isEmpty());
        this.decayPheromones(state, pheromones);
        HashMap<Component, Double> contributions = new HashMap<Component, Double>();
        for (Object o : individuals) {
            ConstructiveIndividual ind = (ConstructiveIndividual)o;
            assert (ind.size() > 0L);
            for (Object oo : ind) {
                assert (oo instanceof Component);
                Component c = (Component)oo;
                double cPheromone = this.pheromoneContribution(ind, c);
                if (contributions.containsKey(c)) {
                    contributions.put(c, (Double)contributions.get(c) + cPheromone);
                    continue;
                }
                contributions.put(c, cPheromone);
            }
        }
        for (Component c : contributions.keySet()) {
            double oldPheromone = pheromones.get(state, c, 0);
            double newPheromone = oldPheromone + (Double)contributions.get(c);
            pheromones.set(c, newPheromone);
        }
        assert (this.repOK());
    }

    private void decayPheromones(EvolutionState state, PheromoneTable pheromones) {
        assert (state != null);
        assert (pheromones != null);
        List components = ((ConstructiveProblemForm)((Object)state.evaluator.p_problem)).getAllComponents();
        for (Component c : components) {
            pheromones.set(c, (1.0 - this.decayRate) * pheromones.get(state, c, 0));
        }
    }

    private double pheromoneContribution(ConstructiveIndividual<?> ind, Component component) {
        assert (ind != null);
        assert (component != null);
        double fitness = ind.fitness.fitness();
        switch (this.depositRule) {
            case ANT_CYCLE: {
                assert (fitness > 0.0);
                return this.q * fitness;
            }
            case ANT_DENSITY: {
                return this.q;
            }
            case ANT_QUANTITY: {
                return this.q * component.desirability();
            }
        }
        throw new IllegalStateException(String.format("%s: no deposit rule logic implemented for %s.", new Object[]{this.getClass().getSimpleName(), this.depositRule}));
    }

    public final boolean repOK() {
        return P_DECAY_RATE != null && !P_DECAY_RATE.isEmpty() && !Double.isInfinite(this.decayRate) && !Double.isNaN(this.decayRate) && this.decayRate >= 0.0 && this.decayRate < 1.0;
    }

    public static enum DepositRule {
        ANT_CYCLE,
        ANT_DENSITY,
        ANT_QUANTITY;

    }
}

