/*
 * Decompiled with CFR 0.152.
 */
package ec.co.ant;

import ec.EvolutionState;
import ec.Individual;
import ec.co.Component;
import ec.co.ConstructiveIndividual;
import ec.co.ant.PheromoneTable;
import ec.co.ant.UpdateRule;
import ec.util.Parameter;
import java.util.Arrays;
import java.util.List;

public class GlobalUpdateRule
implements UpdateRule {
    public static final String P_RHO = "rho";
    public static final String P_BEST_STRATEGY = "best-strategy";
    private BestStrategy bestStrategy;
    private double rho;
    private ConstructiveIndividual best;

    public BestStrategy getBestStrategy() {
        return this.bestStrategy;
    }

    public double getRho() {
        return this.rho;
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        assert (state != null);
        assert (base != null);
        this.rho = state.parameters.getDouble(base.push(P_RHO), null, 0.0);
        String bestString = state.parameters.getString(base.push(P_BEST_STRATEGY), null);
        try {
            bestString = bestString.replace('-', '_');
            this.bestStrategy = BestStrategy.valueOf(bestString);
        }
        catch (NullPointerException e) {
            state.output.fatal(String.format("%s: invalid value '%s' found for parameter '%s'.  Allowed values are %s.", this.getClass().getSimpleName(), bestString, base.push(P_BEST_STRATEGY), Arrays.asList(BestStrategy.values())));
        }
        catch (IllegalArgumentException e) {
            state.output.fatal(String.format("%s: invalid value '%s' found for parameter '%s'.  Allowed values are %s.", this.getClass().getSimpleName(), bestString, base.push(P_BEST_STRATEGY), Arrays.asList(BestStrategy.values())));
        }
        this.best = null;
        assert (this.repOK());
    }

    @Override
    public void updatePheromones(EvolutionState state, PheromoneTable pheromones, List individuals) {
        assert (pheromones != null);
        assert (individuals != null);
        assert (!individuals.isEmpty());
        this.updateBest(individuals);
        assert (this.best.size() > 0L);
        double delta_pheromone = this.best.fitness.fitness();
        for (Object oo : this.best) {
            assert (oo instanceof Component);
            Component c = (Component)oo;
            double oldPheromone = pheromones.get(state, c, 0);
            pheromones.set(c, (1.0 - this.rho) * oldPheromone + this.rho * delta_pheromone);
        }
        assert (this.repOK());
    }

    private void updateBest(List<ConstructiveIndividual> individuals) {
        assert (individuals != null);
        assert (!individuals.isEmpty());
        switch (this.bestStrategy) {
            case ITERATION_BEST: {
                this.best = individuals.get(0);
            }
            case GLOBAL_BEST: {
                for (Individual individual : individuals) {
                    if (this.best != null && !individual.fitness.betterThan(this.best.fitness)) continue;
                    this.best = (ConstructiveIndividual)individual;
                }
                break;
            }
            default: {
                throw new IllegalStateException(String.format("%s: Unrecognized update strategy '%s'.  Please report.", new Object[]{this.getClass().getSimpleName(), this.bestStrategy}));
            }
        }
    }

    public final boolean repOK() {
        return P_RHO != null && !P_RHO.isEmpty() && P_BEST_STRATEGY != null && !P_BEST_STRATEGY.isEmpty() && this.bestStrategy != null && !Double.isInfinite(this.rho) && !Double.isNaN(this.rho) && this.rho >= 0.0 && (this.best == null || this.best.size() > 0L);
    }

    public static enum BestStrategy {
        GLOBAL_BEST,
        ITERATION_BEST;

    }
}

