/*
 * Decompiled with CFR 0.152.
 */
package ec.co.ant;

import ec.EvolutionState;
import ec.Setup;
import ec.co.Component;
import ec.co.ant.ComponentSelector;
import ec.co.ant.PheromoneTable;
import ec.util.Parameter;
import java.util.ArrayList;
import java.util.List;

public class ProportionateComponentSelector
implements ComponentSelector,
Setup {
    public static final String P_ALPHA = "alpha";
    public static final String P_BETA = "beta";
    private double alpha;
    private double beta;

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    public ProportionateComponentSelector() {
    }

    public ProportionateComponentSelector(double alpha, double beta) {
        if (!Double.isFinite(alpha)) {
            throw new IllegalArgumentException(String.format("%s: alpha is %f, but must be finite.", this.getClass().getSimpleName(), alpha));
        }
        if (!Double.isFinite(beta)) {
            throw new IllegalArgumentException(String.format("%s: beta is %f, but must be finite.", this.getClass().getSimpleName(), beta));
        }
        this.alpha = alpha;
        this.beta = beta;
        assert (this.repOK());
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        assert (state != null);
        assert (base != null);
        this.alpha = state.parameters.getDouble(base.push(P_ALPHA), null, 0.0);
        this.beta = state.parameters.getDouble(base.push(P_BETA), null, 0.0);
        assert (this.repOK());
    }

    @Override
    public Component choose(EvolutionState state, List<Component> components, PheromoneTable pheromones, int thread) {
        assert (state != null);
        assert (state.random != null);
        assert (components != null);
        assert (!components.isEmpty());
        assert (pheromones != null);
        assert (thread >= 0);
        double denominator = 0.0;
        ArrayList<Double> scores = new ArrayList<Double>();
        for (Component c : components) {
            double tau = pheromones.get(state, c, thread);
            double eta = c.desirability();
            double score = Math.pow(tau, this.alpha) * Math.pow(eta, this.beta);
            scores.add(score);
            denominator += score;
        }
        assert (!Double.isInfinite(denominator));
        assert (!Double.isNaN(denominator));
        assert (denominator >= 0.0);
        double dart = state.random[thread].nextDouble();
        int i = 0;
        for (double val = (Double)scores.get(0) / denominator; val < dart; val += (Double)scores.get(++i) / denominator) {
        }
        assert (i < components.size());
        assert (this.repOK());
        return components.get(i);
    }

    public final boolean repOK() {
        return P_ALPHA != null && !P_ALPHA.isEmpty() && P_BETA != null && !P_BETA.isEmpty() && !Double.isInfinite(this.alpha) && !Double.isNaN(this.alpha) && !Double.isInfinite(this.beta) && !Double.isNaN(this.beta);
    }
}

