/*
 * Decompiled with CFR 0.152.
 */
package ec.co.ant;

import ec.EvolutionState;
import ec.Setup;
import ec.co.Component;
import ec.co.ant.ComponentSelector;
import ec.co.ant.PheromoneTable;
import ec.co.ant.ProportionateComponentSelector;
import ec.util.Misc;
import ec.util.Parameter;
import java.util.List;

public class PseudorandomProportionateComponentSelector
implements ComponentSelector,
Setup {
    public static final String P_PROB_BEST = "prob-best";
    private double probBest;
    private ProportionateComponentSelector proportionateSelector;

    public double getProbBest() {
        return this.probBest;
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        assert (base != null);
        this.probBest = state.parameters.getDouble(base.push(P_PROB_BEST), null, 0.0);
        this.proportionateSelector = new ProportionateComponentSelector();
        this.proportionateSelector.setup(state, base);
        assert (this.repOK());
    }

    @Override
    public Component choose(EvolutionState state, List<Component> components, PheromoneTable pheromones, int thread) {
        assert (state != null);
        assert (components != null);
        assert (pheromones != null);
        assert (thread >= 0);
        assert (thread < state.random.length);
        if (state.random[thread].nextDouble() <= this.probBest) {
            Component best = null;
            double best_score = Double.NEGATIVE_INFINITY;
            for (Component c : components) {
                double score = c.desirability() * pheromones.get(state, c, thread);
                if (!(score > best_score)) continue;
                best = c;
                best_score = score;
            }
            assert (this.repOK());
            return best;
        }
        assert (this.repOK());
        return this.proportionateSelector.choose(state, components, pheromones, thread);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PseudorandomProportionateComponentSelector)) {
            return false;
        }
        PseudorandomProportionateComponentSelector ref = (PseudorandomProportionateComponentSelector)o;
        return Misc.doubleEquals(this.probBest, ref.probBest, 1.0E-6) && this.proportionateSelector.equals(ref.proportionateSelector);
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + (int)(Double.doubleToLongBits(this.probBest) ^ Double.doubleToLongBits(this.probBest) >>> 32);
        hash = 89 * hash + (this.proportionateSelector != null ? this.proportionateSelector.hashCode() : 0);
        return hash;
    }

    public final boolean repOK() {
        return P_PROB_BEST != null && !P_PROB_BEST.isEmpty() && Double.isFinite(this.probBest) && this.probBest >= 0.0 && this.probBest <= 1.0 && this.proportionateSelector != null;
    }
}

