/*
 * Decompiled with CFR 0.152.
 */
package ec.co.ant;

import ec.EvolutionState;
import ec.co.Component;
import ec.co.ConstructiveIndividual;
import ec.co.ConstructiveProblemForm;
import ec.co.ant.ComponentSelector;
import ec.co.ant.ConstructionRule;
import ec.co.ant.PheromoneTable;
import ec.util.Parameter;
import java.util.List;

public class SimpleConstructionRule
implements ConstructionRule {
    private static final long serialVersionUID = 1L;
    public static final String P_SELECTOR = "component-selector";
    public static final String P_START = "start-component";
    private String startComponent;
    private ComponentSelector selector;

    @Override
    public void setup(EvolutionState state, Parameter base) {
        assert (state != null);
        assert (base != null);
        this.startComponent = state.parameters.getString(base.push(P_START), null);
        this.selector = (ComponentSelector)state.parameters.getInstanceForParameter(base.push(P_SELECTOR), null, ComponentSelector.class);
        this.selector.setup(state, base.push(P_SELECTOR));
        assert (this.repOK());
    }

    @Override
    public ConstructiveIndividual constructSolution(EvolutionState state, ConstructiveIndividual ind, PheromoneTable pheromones, int thread) {
        assert (state != null);
        assert (ind != null);
        assert (ind.isEmpty());
        assert (state.evaluator.p_problem instanceof ConstructiveProblemForm);
        ConstructiveProblemForm problem = (ConstructiveProblemForm)((Object)state.evaluator.p_problem);
        assert (!problem.isCompleteSolution(ind));
        if (this.startComponent != null) {
            ind.add(state, problem.getComponentFromString(this.startComponent));
        } else {
            ind.add(state, problem.getArbitraryComponent(state, thread));
        }
        while (!problem.isCompleteSolution(ind)) {
            List<Component> allowedMoves = problem.getAllowedComponents(ind);
            Component component = this.selector.choose(state, allowedMoves, pheromones, thread);
            ind.add(state, component);
        }
        assert (this.repOK());
        return ind;
    }

    public final boolean repOK() {
        return P_SELECTOR != null && !P_SELECTOR.isEmpty() && P_START != null && !P_START.isEmpty() && this.selector != null;
    }
}

