/*
 * Decompiled with CFR 0.152.
 */
package ec.co.ant;

import ec.EvolutionState;
import ec.co.Component;
import ec.co.ConstructiveProblemForm;
import ec.co.ant.PheromoneTable;
import ec.util.Parameter;
import java.util.HashMap;

public class SimplePheromoneTable
implements PheromoneTable {
    public static final String P_INITIAL_CONCENTRATION = "initial-concentration";
    public static final String P_INITIALIZE_WITH_NOISE = "initialize-with-noise";
    public static final String P_NOISE = "starting-noise";
    private int numComponents;
    private double initialConcentration;
    private boolean initializeWithNoise;
    private double noise;
    private HashMap<Component, Double> pheromones;

    @Override
    public void setup(EvolutionState state, Parameter base) {
        assert (state != null);
        assert (base != null);
        if (!(state.evaluator.p_problem instanceof ConstructiveProblemForm)) {
            state.output.fatal(String.format("%s: tried to use pheromone table with a %s, but must be %s.", this.getClass().getSimpleName(), state.evaluator.p_problem.getClass().getSimpleName(), ConstructiveProblemForm.class.getSimpleName()));
        }
        this.numComponents = ((ConstructiveProblemForm)((Object)state.evaluator.p_problem)).numComponents();
        this.pheromones = new HashMap(this.numComponents);
        this.initializeWithNoise = state.parameters.getBoolean(base.push(P_INITIALIZE_WITH_NOISE), null, true);
        if (this.initializeWithNoise) {
            if (state.parameters.exists(base.push(P_INITIAL_CONCENTRATION), null)) {
                state.output.warnOnce(String.format("%s: '%s' is set to true, so I'm ignoring the '%s' parameter.  Is this what you intended?", this.getClass().getSimpleName(), base.push(P_INITIALIZE_WITH_NOISE), base.push(P_INITIAL_CONCENTRATION)), base.push(P_INITIAL_CONCENTRATION));
            }
            this.noise = state.parameters.getDoubleWithDefault(base.push(P_NOISE), null, 1.0E-6);
            if (this.noise <= 0.0) {
                state.output.fatal(String.format("%s: '%s' is set to '%f', but must be positive.", this.getClass().getSimpleName(), base.push(P_NOISE), this.noise), base.push(P_NOISE));
            }
        } else {
            if (state.parameters.exists(base.push(P_INITIAL_CONCENTRATION), null)) {
                state.output.warnOnce(String.format("%s: '%s' is set to false, so I'm ignoring the '%s' parameter.  Is this what you intended?", this.getClass().getSimpleName(), base.push(P_INITIALIZE_WITH_NOISE), base.push(P_NOISE)), base.push(P_NOISE));
            }
            this.initialConcentration = state.parameters.getDoubleWithDefault(base.push(P_INITIAL_CONCENTRATION), null, 1.0E-6);
        }
        assert (this.repOK());
    }

    @Override
    public double get(EvolutionState state, Component c, int thread) {
        double value;
        assert (c != null);
        if (this.pheromones.containsKey(c)) {
            value = this.pheromones.get(c);
            if (!(value <= 0.0)) {
                return value;
            }
        } else {
            if (this.initializeWithNoise) {
                double perturbation = state.random[thread].nextDouble() * this.noise;
                this.pheromones.put(c, perturbation);
                return perturbation;
            }
            this.pheromones.put(c, this.initialConcentration);
            return this.initialConcentration;
        }
        state.output.fatal(String.format("%s: a pheremone value of '%f' was found, but must be positive.", this.getClass().getSimpleName(), value));
        throw new IllegalStateException("Unexpected error.  Please report.");
    }

    @Override
    public void set(Component c, double value) {
        assert (c != null);
        this.pheromones.put(c, value);
    }

    public boolean repOK() {
        return this.numComponents > 0 && this.pheromones != null && this.pheromones.size() <= this.numComponents;
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + this.numComponents;
        hash = 67 * hash + (int)(Double.doubleToLongBits(this.noise) ^ Double.doubleToLongBits(this.noise) >>> 32);
        hash = 67 * hash + (this.pheromones != null ? this.pheromones.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimplePheromoneTable)) {
            return false;
        }
        SimplePheromoneTable ref = (SimplePheromoneTable)o;
        return this.numComponents == ref.numComponents && this.noise == ref.noise && this.initializeWithNoise == ref.initializeWithNoise && this.initialConcentration == ref.initialConcentration && this.pheromones.equals(ref.pheromones);
    }
}

