/*
 * Decompiled with CFR 0.152.
 */
package ec.co.grasp;

import ec.EvolutionState;
import ec.Fitness;
import ec.Individual;
import ec.Species;
import ec.co.ConstructiveIndividual;
import ec.co.grasp.ConstructionRule;
import ec.util.Parameter;

public class GraspSpecies
extends Species {
    public static final Parameter DEFAULT_BASE = new Parameter("constructive");
    public static final String SPECIES_NAME = "constructive-species";
    public static final String P_CONSTRUCTION_RULE = "construction-rule";
    private ConstructionRule constructionRule;

    @Override
    public void setup(EvolutionState state, Parameter base) {
        this.setupSuper(state, base);
        assert (state != null);
        assert (base != null);
        this.constructionRule = (ConstructionRule)state.parameters.getInstanceForParameter(base.push(P_CONSTRUCTION_RULE), null, ConstructionRule.class);
        this.constructionRule.setup(state, base.push(P_CONSTRUCTION_RULE));
        assert (this.repOK());
    }

    private void setupSuper(EvolutionState state, Parameter base) {
        assert (state != null);
        assert (base != null);
        Parameter def = this.defaultBase();
        this.i_prototype = (Individual)state.parameters.getInstanceForParameter(base.push("ind"), def.push("ind"), Individual.class);
        this.i_prototype.species = this;
        this.i_prototype.setup(state, base.push("ind"));
        this.f_prototype = (Fitness)state.parameters.getInstanceForParameter(base.push("fitness"), def.push("fitness"), Fitness.class);
        this.f_prototype.setup(state, base.push("fitness"));
    }

    @Override
    public ConstructiveIndividual newIndividual(EvolutionState state, int thread) {
        assert (state != null);
        assert (thread >= 0);
        ConstructiveIndividual ind = (ConstructiveIndividual)super.newIndividual(state, thread);
        assert (this.repOK());
        return this.constructionRule.constructSolution(state, ind, thread);
    }

    @Override
    public Parameter defaultBase() {
        return DEFAULT_BASE.push(SPECIES_NAME);
    }

    public final boolean repOK() {
        return DEFAULT_BASE != null && SPECIES_NAME != null && !SPECIES_NAME.isEmpty() && P_CONSTRUCTION_RULE != null && !P_CONSTRUCTION_RULE.isEmpty() && this.constructionRule != null;
    }
}

