/*
 * Decompiled with CFR 0.152.
 */
package ec.coevolve;

import ec.Evaluator;
import ec.EvolutionState;
import ec.Individual;
import ec.coevolve.EncapsulatedIndividual;
import ec.coevolve.GroupedProblemForm;
import ec.coevolve.NRandomOneWayCompetitiveEvaluatorThread;
import ec.coevolve.NRandomTwoWayCompetitiveEvaluatorThread;
import ec.coevolve.RoundRobinCompetitiveEvaluatorThread;
import ec.util.Parameter;
import java.util.ArrayList;

public class CompetitiveEvaluator
extends Evaluator {
    private static final long serialVersionUID = 1L;
    public static final int STYLE_SINGLE_ELIMINATION = 1;
    public static final int STYLE_ROUND_ROBIN = 2;
    public static final int STYLE_N_RANDOM_COMPETITORS_ONEWAY = 3;
    public static final int STYLE_N_RANDOM_COMPETITORS_TWOWAY = 4;
    public static final String P_COMPETE_STYLE = "style";
    public int style;
    public static final String P_GROUP_SIZE = "group-size";
    public int groupSize;
    public static final String P_OVER_EVAL = "over-eval";
    public boolean allowOverEvaluation;
    int whereToPutInformation;

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        String temp = state.parameters.getStringWithDefault(base.push(P_COMPETE_STYLE), null, "");
        if (temp.equalsIgnoreCase("single-elim-tournament")) {
            this.style = 1;
        } else if (temp.equalsIgnoreCase("round-robin")) {
            this.style = 2;
        } else if (temp.equalsIgnoreCase("rand-1-way")) {
            this.style = 3;
        } else if (temp.equalsIgnoreCase("rand-2-way")) {
            this.style = 4;
        } else if (temp.equalsIgnoreCase("rand-2-ways")) {
            state.output.fatal("'rand-2-ways' is no longer a valid style name: use 'rand-2-way'", base.push(P_COMPETE_STYLE), null);
        } else {
            state.output.fatal("Incorrect value for parameter. Acceptable values: single-elim-tournament, round-robin, rand-1-way, rand-2-way", base.push(P_COMPETE_STYLE));
        }
        if (this.style == 3 || this.style == 4) {
            this.groupSize = state.parameters.getInt(base.push(P_GROUP_SIZE), null, 1);
            if (this.groupSize < 1) {
                state.output.fatal("Incorrect value for parameter", base.push(P_GROUP_SIZE));
            }
        }
        this.allowOverEvaluation = state.parameters.getBoolean(base.push(P_OVER_EVAL), null, false);
    }

    @Override
    public String runComplete(EvolutionState state) {
        return null;
    }

    public void randomizeOrder(EvolutionState state, ArrayList<Individual> individuals) {
        Individual[] queue = new Individual[individuals.size()];
        int len = queue.length;
        individuals.toArray(queue);
        for (int x = len; x > 0; --x) {
            int i = state.random[0].nextInt(x);
            individuals.set(x - 1, queue[i]);
            queue[i] = queue[x - 1];
        }
    }

    @Override
    public void evaluatePopulation(EvolutionState state) {
        int[] numinds = new int[state.evalthreads];
        int[] from = new int[state.evalthreads];
        boolean[] assessFitness = new boolean[state.population.subpops.size()];
        for (int i = 0; i < assessFitness.length; ++i) {
            assessFitness[i] = true;
        }
        for (int y = 0; y < state.evalthreads; ++y) {
            numinds[y] = y < state.evalthreads - 1 ? state.population.subpops.get((int)0).individuals.size() / state.evalthreads : state.population.subpops.get((int)0).individuals.size() / state.evalthreads + (state.population.subpops.get((int)0).individuals.size() - state.population.subpops.get((int)0).individuals.size() / state.evalthreads * state.evalthreads);
            from[y] = state.population.subpops.get((int)0).individuals.size() / state.evalthreads * y;
        }
        this.randomizeOrder(state, state.population.subpops.get((int)0).individuals);
        if (!this.p_problem.isGroupedProblem()) {
            state.output.fatal("Problem " + String.valueOf(this.p_problem) + " is not a grouped problem.");
        }
        GroupedProblemForm prob = (GroupedProblemForm)this.p_problem.clone();
        prob.preprocessPopulation(state, state.population, assessFitness, this.style == 1);
        switch (this.style) {
            case 1: {
                this.evalSingleElimination(state, state.population.subpops.get((int)0).individuals, 0, prob);
                break;
            }
            case 2: {
                this.evalRoundRobin(state, from, numinds, state.population.subpops.get((int)0).individuals, 0, prob);
                break;
            }
            case 3: {
                this.evalNRandomOneWay(state, from, numinds, state.population.subpops.get((int)0).individuals, 0, prob);
                break;
            }
            case 4: {
                this.evalNRandomTwoWay(state, from, numinds, state.population.subpops.get((int)0).individuals, 0, prob);
                break;
            }
            default: {
                state.output.fatal("Invalid competition style in CompetitiveEvaluator.evaluatePopulation()");
            }
        }
        state.incrementEvaluations(prob.postprocessPopulation(state, state.population, assessFitness, this.style == 1));
    }

    public void evalSingleElimination(EvolutionState state, ArrayList<Individual> individuals, int subpop, GroupedProblemForm prob) {
        Individual[] tourn = individuals.toArray(new Individual[individuals.size()]);
        int len = tourn.length;
        Individual[] competition = new Individual[2];
        int[] subpops = new int[]{subpop, subpop};
        boolean[] updates = new boolean[2];
        updates[1] = true;
        updates[0] = true;
        while (len > 1) {
            int x;
            for (x = 0; x < len / 2; ++x) {
                competition[0] = tourn[x];
                competition[1] = tourn[len - x - 1];
                prob.evaluate(state, competition, updates, true, subpops, 0);
            }
            for (x = 0; x < len / 2; ++x) {
                if (!tourn[len - x - 1].fitness.betterThan(tourn[x].fitness) && (!tourn[len - x - 1].fitness.equivalentTo(tourn[x].fitness) || !state.random[0].nextBoolean())) continue;
                Individual temp = tourn[x];
                tourn[x] = tourn[len - x - 1];
                tourn[len - x - 1] = temp;
            }
            if (len % 2 != 0) {
                len = 1 + len / 2;
                continue;
            }
            len /= 2;
        }
    }

    public void evalRoundRobin(EvolutionState state, int[] from, int[] numinds, ArrayList<Individual> individuals, int subpop, GroupedProblemForm prob) {
        if (state.evalthreads == 1) {
            this.evalRoundRobinPopChunk(state, from[0], numinds[0], 0, individuals, subpop, prob);
        } else {
            int y;
            Thread[] t = new Thread[state.evalthreads];
            for (y = 0; y < state.evalthreads; ++y) {
                RoundRobinCompetitiveEvaluatorThread r = new RoundRobinCompetitiveEvaluatorThread();
                r.threadnum = y;
                r.numinds = numinds[y];
                r.from = from[y];
                r.me = this;
                r.subpop = subpop;
                r.state = state;
                r.p = prob;
                r.inds = individuals;
                t[y] = new Thread(r);
                t[y].start();
            }
            for (y = 0; y < state.evalthreads; ++y) {
                try {
                    t[y].join();
                    continue;
                }
                catch (InterruptedException e) {
                    state.output.fatal("Whoa! The main evaluation thread got interrupted!  Dying...");
                }
            }
        }
    }

    public void evalRoundRobinPopChunk(EvolutionState state, int from, int numinds, int threadnum, ArrayList<Individual> individuals, int subpop, GroupedProblemForm prob) {
        Individual[] competition = new Individual[2];
        int[] subpops = new int[]{subpop, subpop};
        boolean[] updates = new boolean[2];
        updates[1] = true;
        updates[0] = true;
        int upperBound = from + numinds;
        for (int x = from; x < upperBound; ++x) {
            for (int y = x + 1; y < individuals.size(); ++y) {
                competition[0] = individuals.get(x);
                competition[1] = individuals.get(y);
                prob.evaluate(state, competition, updates, false, subpops, 0);
            }
        }
    }

    public void evalNRandomOneWay(EvolutionState state, int[] from, int[] numinds, ArrayList<Individual> individuals, int subpop, GroupedProblemForm prob) {
        if (state.evalthreads == 1) {
            this.evalNRandomOneWayPopChunk(state, from[0], numinds[0], 0, individuals, subpop, prob);
        } else {
            int y;
            Thread[] t = new Thread[state.evalthreads];
            for (y = 0; y < state.evalthreads; ++y) {
                NRandomOneWayCompetitiveEvaluatorThread r = new NRandomOneWayCompetitiveEvaluatorThread();
                r.threadnum = y;
                r.numinds = numinds[y];
                r.from = from[y];
                r.subpop = subpop;
                r.me = this;
                r.state = state;
                r.p = prob;
                r.inds = individuals;
                t[y] = new Thread(r);
                t[y].start();
            }
            for (y = 0; y < state.evalthreads; ++y) {
                try {
                    t[y].join();
                    continue;
                }
                catch (InterruptedException e) {
                    state.output.fatal("Whoa! The main evaluation thread got interrupted!  Dying...");
                }
            }
        }
    }

    public void evalNRandomOneWayPopChunk(EvolutionState state, int from, int numinds, int threadnum, ArrayList<Individual> individuals, int subpop, GroupedProblemForm prob) {
        Individual[] queue = individuals.toArray(new Individual[individuals.size()]);
        int len = queue.length;
        Individual[] competition = new Individual[2];
        int[] subpops = new int[]{subpop, subpop};
        boolean[] updates = new boolean[]{true, false};
        int upperBound = from + numinds;
        for (int x = from; x < upperBound; ++x) {
            competition[0] = individuals.get(x);
            int y = 0;
            while (y < this.groupSize) {
                int index = state.random[0].nextInt(len - y);
                competition[1] = queue[index];
                queue[index] = queue[len - y - 1];
                queue[len - y - 1] = competition[1];
                if (competition[1] == individuals.get(x)) continue;
                prob.evaluate(state, competition, updates, false, subpops, 0);
                ++y;
            }
        }
    }

    public void evalNRandomTwoWay(EvolutionState state, int[] from, int[] numinds, ArrayList<Individual> individuals, int subpop, GroupedProblemForm prob) {
        if (state.evalthreads == 1) {
            this.evalNRandomTwoWayPopChunk(state, from[0], numinds[0], 0, individuals, subpop, prob);
        } else {
            int y;
            Thread[] t = new Thread[state.evalthreads];
            for (y = 0; y < state.evalthreads; ++y) {
                NRandomTwoWayCompetitiveEvaluatorThread r = new NRandomTwoWayCompetitiveEvaluatorThread();
                r.threadnum = y;
                r.numinds = numinds[y];
                r.from = from[y];
                r.me = this;
                r.subpop = subpop;
                r.state = state;
                r.p = prob;
                r.inds = individuals;
                t[y] = new Thread(r);
                t[y].start();
            }
            for (y = 0; y < state.evalthreads; ++y) {
                try {
                    t[y].join();
                    continue;
                }
                catch (InterruptedException e) {
                    state.output.fatal("Whoa! The main evaluation thread got interrupted!  Dying...");
                }
            }
        }
    }

    public void evalNRandomTwoWayPopChunk(EvolutionState state, int from, int numinds, int threadnum, ArrayList<Individual> individuals, int subpop, GroupedProblemForm prob) {
        EncapsulatedIndividual[] individualsOrdered = new EncapsulatedIndividual[individuals.size()];
        EncapsulatedIndividual[] queue = new EncapsulatedIndividual[individuals.size()];
        for (int i = 0; i < individuals.size(); ++i) {
            individualsOrdered[i] = new EncapsulatedIndividual(individuals.get(i), 0);
        }
        Individual[] competition = new Individual[2];
        int[] subpops = new int[]{subpop, subpop};
        boolean[] updates = new boolean[2];
        updates[0] = true;
        int upperBound = from + numinds;
        for (int x = from; x < upperBound; ++x) {
            int index;
            int y;
            System.arraycopy(individualsOrdered, 0, queue, 0, queue.length);
            competition[0] = queue[x].ind;
            if (individuals.size() - x - 1 <= this.groupSize - queue[x].nOpponentsMet) {
                for (y = x + 1; y < queue.length; ++y) {
                    competition[1] = queue[y].ind;
                    updates[1] = queue[y].nOpponentsMet < this.groupSize || this.allowOverEvaluation;
                    prob.evaluate(state, competition, updates, false, subpops, 0);
                    ++queue[x].nOpponentsMet;
                    if (!updates[1]) continue;
                    ++queue[y].nOpponentsMet;
                }
            } else {
                y = 0;
                while (this.groupSize > queue[x].nOpponentsMet) {
                    index = state.random[0].nextInt(queue.length - x - 1 - y) + x + 1;
                    competition[1] = queue[index].ind;
                    updates[1] = queue[index].nOpponentsMet < this.groupSize || this.allowOverEvaluation;
                    prob.evaluate(state, competition, updates, false, subpops, 0);
                    ++queue[x].nOpponentsMet;
                    if (updates[1]) {
                        ++queue[index].nOpponentsMet;
                    }
                    EncapsulatedIndividual temp = queue[index];
                    queue[index] = queue[queue.length - y - 1];
                    queue[queue.length - y - 1] = temp;
                    ++y;
                }
            }
            if (queue[x].nOpponentsMet >= this.groupSize) continue;
            for (y = queue[x].nOpponentsMet; y < this.groupSize; ++y) {
                index = x > 0 ? state.random[0].nextInt(x) : state.random[0].nextInt(queue.length - 1) + 1;
                competition[1] = queue[index].ind;
                updates[1] = queue[index].nOpponentsMet < this.groupSize || this.allowOverEvaluation;
                prob.evaluate(state, competition, updates, false, subpops, 0);
                ++queue[x].nOpponentsMet;
                if (!updates[1]) continue;
                ++queue[index].nOpponentsMet;
            }
        }
    }

    int nextPowerOfTwo(int N) {
        int i;
        for (i = 1; i < N; i *= 2) {
        }
        return i;
    }

    void fillPositions(int[] positions, int who, int totalPerDepth, int total) {
        if (totalPerDepth >= total - 1) {
            positions[this.whereToPutInformation] = who;
            ++this.whereToPutInformation;
        } else {
            this.fillPositions(positions, who, totalPerDepth * 2 + 1, total);
            this.fillPositions(positions, totalPerDepth - who, totalPerDepth * 2 + 1, total);
        }
    }
}

