/*
 * Decompiled with CFR 0.152.
 */
package ec.coevolve;

import ec.Evaluator;
import ec.EvolutionState;
import ec.Individual;
import ec.Population;
import ec.SelectionMethod;
import ec.Subpopulation;
import ec.coevolve.GroupedProblemForm;
import ec.coevolve.GuruComparator;
import ec.util.MersenneTwisterFast;
import ec.util.Parameter;
import ec.util.QuickSort;
import ec.util.SortComparatorL;
import java.util.ArrayList;

public class MultiPopCoevolutionaryEvaluator
extends Evaluator {
    private static final long serialVersionUID = 1L;
    public static final String P_SUBPOP = "subpop";
    public static final String P_NUM_RAND_IND = "num-current";
    protected int numCurrent;
    public static final String P_NUM_SHUFFLED = "num-shuffled";
    protected int numShuffled;
    public static final String P_NUM_GURU = "num-gurus";
    protected int numGuru;
    Individual[][] guruIndividuals;
    public static final String P_NUM_IND = "num-prev";
    protected int numPrev;
    Population previousPopulation;
    public static final String P_SELECTION_METHOD_PREV = "select-prev";
    SelectionMethod[] selectionMethodPrev;
    public static final String P_SELECTION_METHOD_CURRENT = "select-current";
    SelectionMethod[] selectionMethodCurrent;
    Individual[] inds = null;
    boolean[] updates = null;

    @Override
    public void setup(EvolutionState state, Parameter base) {
        int i;
        Parameter tempSubpop;
        int numSubpopulations;
        super.setup(state, base);
        if (state.breeder.sequentialBreeding) {
            state.output.message("The Breeder is breeding sequentially, so the MultiPopCoevolutionaryEvaluator is also evaluating sequentially.");
        }
        if ((numSubpopulations = state.parameters.getInt(tempSubpop = new Parameter("pop").push("subpops"), null, 0)) <= 0) {
            state.output.fatal("Parameter not found, or it has a non-positive value.", tempSubpop);
        }
        this.numGuru = state.parameters.getInt(base.push(P_NUM_GURU), null, 0);
        if (this.numGuru < 0) {
            state.output.fatal("Parameter not found, or it has an incorrect value.", base.push(P_NUM_GURU));
        }
        this.numShuffled = state.parameters.getInt(base.push(P_NUM_SHUFFLED), null, 0);
        if (this.numShuffled < 0) {
            state.output.fatal("Parameter not found, or it has an incorrect value.", base.push(P_NUM_SHUFFLED));
        }
        this.numCurrent = state.parameters.getInt(base.push(P_NUM_RAND_IND), null, 0);
        this.selectionMethodCurrent = new SelectionMethod[numSubpopulations];
        if (this.numCurrent < 0) {
            state.output.fatal("Parameter not found, or it has an incorrect value.", base.push(P_NUM_RAND_IND));
        } else if (this.numCurrent == 0) {
            state.output.message("Not testing against current individuals:  Current Selection Methods will not be loaded.");
        } else if (this.numCurrent > 0) {
            for (i = 0; i < numSubpopulations; ++i) {
                this.selectionMethodCurrent[i] = (SelectionMethod)state.parameters.getInstanceForParameter(base.push(P_SUBPOP).push("" + i).push(P_SELECTION_METHOD_CURRENT), base.push(P_SELECTION_METHOD_CURRENT), SelectionMethod.class);
                if (this.selectionMethodCurrent[i] == null) {
                    state.output.error("No selection method provided for subpopulation " + i, base.push(P_SUBPOP).push("" + i).push(P_SELECTION_METHOD_CURRENT), base.push(P_SELECTION_METHOD_CURRENT));
                    continue;
                }
                this.selectionMethodCurrent[i].setup(state, base.push(P_SUBPOP).push("" + i).push(P_SELECTION_METHOD_CURRENT));
            }
        }
        this.numPrev = state.parameters.getInt(base.push(P_NUM_IND), null, 0);
        this.selectionMethodPrev = new SelectionMethod[numSubpopulations];
        if (this.numPrev < 0) {
            state.output.fatal("Parameter not found, or it has an incorrect value.", base.push(P_NUM_IND));
        } else if (this.numPrev == 0) {
            state.output.message("Not testing against previous individuals:  Previous Selection Methods will not be loaded.");
        } else if (this.numPrev > 0) {
            for (i = 0; i < numSubpopulations; ++i) {
                this.selectionMethodPrev[i] = (SelectionMethod)state.parameters.getInstanceForParameter(base.push(P_SUBPOP).push("" + i).push(P_SELECTION_METHOD_PREV), base.push(P_SELECTION_METHOD_PREV), SelectionMethod.class);
                if (this.selectionMethodPrev[i] == null) {
                    state.output.error("No selection method provided for subpopulation " + i, base.push(P_SUBPOP).push("" + i).push(P_SELECTION_METHOD_PREV), base.push(P_SELECTION_METHOD_PREV));
                    continue;
                }
                this.selectionMethodPrev[i].setup(state, base.push(P_SUBPOP).push("" + i).push(P_SELECTION_METHOD_PREV));
            }
        }
        if (this.numGuru + this.numCurrent + this.numPrev + this.numShuffled <= 0) {
            state.output.error("The total number of partners to be selected should be > 0.");
        }
        state.output.exitIfErrors();
    }

    @Override
    public String runComplete(EvolutionState state) {
        return null;
    }

    public boolean shouldEvaluateSubpop(EvolutionState state, int subpop, int threadnum) {
        return state.breeder.shouldBreedSubpop(state, subpop, threadnum);
    }

    @Override
    public void evaluatePopulation(EvolutionState state) {
        boolean[] preAssessFitness = new boolean[state.population.subpops.size()];
        boolean[] postAssessFitness = new boolean[state.population.subpops.size()];
        for (int i = 0; i < state.population.subpops.size(); ++i) {
            postAssessFitness[i] = this.shouldEvaluateSubpop(state, i, 0);
            preAssessFitness[i] = postAssessFitness[i] || state.generation == 0;
        }
        if (!this.p_problem.isGroupedProblem()) {
            state.output.fatal("Problem " + String.valueOf(this.p_problem) + " is not a grouped problem.");
        }
        this.beforeCoevolutionaryEvaluation(state, state.population, (GroupedProblemForm)((Object)this.p_problem));
        ((GroupedProblemForm)((Object)this.p_problem)).preprocessPopulation(state, state.population, preAssessFitness, false);
        this.performCoevolutionaryEvaluation(state, state.population, (GroupedProblemForm)((Object)this.p_problem));
        state.incrementEvaluations(((GroupedProblemForm)((Object)this.p_problem)).postprocessPopulation(state, state.population, postAssessFitness, false));
        this.afterCoevolutionaryEvaluation(state, (GroupedProblemForm)((Object)this.p_problem));
    }

    protected void beforeCoevolutionaryEvaluation(EvolutionState state, Population population, GroupedProblemForm prob) {
        if (state.generation == 0) {
            this.guruIndividuals = new Individual[state.population.subpops.size()][this.numGuru];
            for (int i = 0; i < this.guruIndividuals.length; ++i) {
                if (this.numGuru > state.population.subpops.get((int)i).individuals.size()) {
                    state.output.fatal("Number of guru partners is greater than the size of the subpopulation.");
                }
                for (int j = 0; j < this.numGuru; ++j) {
                    this.guruIndividuals[i][j] = (Individual)state.population.subpops.get((int)i).individuals.get(j).clone();
                }
            }
            if (this.numShuffled > 0) {
                int size = state.population.subpops.get((int)0).individuals.size();
                for (int i = 0; i < state.population.subpops.size(); ++i) {
                    if (state.population.subpops.get((int)i).individuals.size() == size) continue;
                    state.output.fatal("Shuffling was requested in MultiPopCoevolutionaryEvaluator, but the subpopulation sizes are not the same.  Specifically, subpopulation 0 has size " + size + " but subpopulation " + i + " has size " + state.population.subpops.get((int)i).individuals.size());
                }
            }
        }
    }

    protected void shuffle(EvolutionState state, int[] a) {
        MersenneTwisterFast mtf = state.random[0];
        for (int x = a.length - 1; x >= 1; --x) {
            int rand = mtf.nextInt(x + 1);
            int obj = a[x];
            a[x] = a[rand];
            a[rand] = obj;
        }
    }

    public void performCoevolutionaryEvaluation(EvolutionState state, Population population, GroupedProblemForm prob) {
        int i;
        int i2;
        int i3;
        int evaluations = 0;
        this.inds = new Individual[population.subpops.size()];
        this.updates = new boolean[population.subpops.size()];
        if (this.numCurrent > 0) {
            for (i3 = 0; i3 < this.selectionMethodCurrent.length; ++i3) {
                this.selectionMethodCurrent[i3].prepareToProduce(state, i3, 0);
            }
        }
        if (this.numPrev > 0) {
            for (i3 = 0; i3 < this.selectionMethodPrev.length; ++i3) {
                Population currentPopulation = state.population;
                state.population = this.previousPopulation;
                this.selectionMethodPrev[i3].prepareToProduce(state, i3, 0);
                state.population = currentPopulation;
            }
        }
        int[] subpops = new int[state.population.subpops.size()];
        for (int j = 0; j < subpops.length; ++j) {
            subpops[j] = j;
        }
        if (this.numShuffled > 0) {
            int[][][] ordering = null;
            ordering = new int[this.numShuffled][state.population.subpops.size()][state.population.subpops.get((int)0).individuals.size()];
            for (int c = 0; c < this.numShuffled; ++c) {
                for (int m = 0; m < state.population.subpops.size(); ++m) {
                    for (int i4 = 0; i4 < state.population.subpops.get((int)0).individuals.size(); ++i4) {
                        ordering[c][m][i4] = i4;
                    }
                    if (m == 0) continue;
                    this.shuffle(state, ordering[c][m]);
                }
            }
            for (i2 = 0; i2 < state.population.subpops.get((int)0).individuals.size(); ++i2) {
                for (int k = 0; k < this.numShuffled; ++k) {
                    for (int ind = 0; ind < this.inds.length; ++ind) {
                        this.inds[ind] = state.population.subpops.get((int)ind).individuals.get(ordering[k][ind][i2]);
                        this.updates[ind] = true;
                    }
                    prob.evaluate(state, this.inds, this.updates, false, subpops, 0);
                    ++evaluations;
                }
            }
        }
        for (int j = 0; j < state.population.subpops.size(); ++j) {
            if (!this.shouldEvaluateSubpop(state, j, 0)) continue;
            for (i2 = 0; i2 < state.population.subpops.get((int)j).individuals.size(); ++i2) {
                int ind;
                int k;
                Individual individual = state.population.subpops.get((int)j).individuals.get(i2);
                for (k = 0; k < this.guruIndividuals[j].length; ++k) {
                    for (ind = 0; ind < this.inds.length; ++ind) {
                        if (ind == j) {
                            this.inds[ind] = individual;
                            this.updates[ind] = true;
                            continue;
                        }
                        this.inds[ind] = this.guruIndividuals[ind][k];
                        this.updates[ind] = false;
                    }
                    prob.evaluate(state, this.inds, this.updates, false, subpops, 0);
                    ++evaluations;
                }
                for (k = 0; k < this.numCurrent; ++k) {
                    for (ind = 0; ind < this.inds.length; ++ind) {
                        if (ind == j) {
                            this.inds[ind] = individual;
                            this.updates[ind] = true;
                            continue;
                        }
                        this.inds[ind] = this.produceCurrent(ind, state, 0);
                        this.updates[ind] = true;
                    }
                    prob.evaluate(state, this.inds, this.updates, false, subpops, 0);
                    ++evaluations;
                }
                for (k = 0; k < this.numPrev; ++k) {
                    for (ind = 0; ind < this.inds.length; ++ind) {
                        if (ind == j) {
                            this.inds[ind] = individual;
                            this.updates[ind] = true;
                            continue;
                        }
                        this.inds[ind] = this.producePrevious(ind, state, 0);
                        this.updates[ind] = false;
                    }
                    prob.evaluate(state, this.inds, this.updates, false, subpops, 0);
                    ++evaluations;
                }
            }
        }
        if (this.numCurrent > 0) {
            for (i = 0; i < this.selectionMethodCurrent.length; ++i) {
                this.selectionMethodCurrent[i].finishProducing(state, i, 0);
            }
        }
        if (this.numPrev > 0) {
            for (i = 0; i < this.selectionMethodPrev.length; ++i) {
                Population currentPopulation = state.population;
                state.population = this.previousPopulation;
                this.selectionMethodPrev[i].finishProducing(state, i, 0);
                state.population = currentPopulation;
            }
        }
        state.output.message("Evaluations: " + evaluations);
    }

    protected Individual producePrevious(int subpopulation, EvolutionState state, int thread) {
        if (state.generation == 0) {
            return state.population.subpops.get((int)subpopulation).individuals.get(state.random[0].nextInt(state.population.subpops.get((int)subpopulation).individuals.size()));
        }
        Population currentPopulation = state.population;
        state.population = this.previousPopulation;
        Individual selected = state.population.subpops.get((int)subpopulation).individuals.get(this.selectionMethodPrev[subpopulation].produce(subpopulation, state, thread));
        state.population = currentPopulation;
        return selected;
    }

    protected Individual produceCurrent(int subpopulation, EvolutionState state, int thread) {
        return state.population.subpops.get((int)subpopulation).individuals.get(this.selectionMethodCurrent[subpopulation].produce(subpopulation, state, thread));
    }

    protected void afterCoevolutionaryEvaluation(EvolutionState state, GroupedProblemForm prob) {
        int i;
        if (this.numGuru > 0) {
            for (i = 0; i < state.population.subpops.size(); ++i) {
                if (!this.shouldEvaluateSubpop(state, i, 0)) continue;
                this.loadGurus(state, i);
            }
        }
        if (this.numPrev > 0) {
            this.previousPopulation = state.population.emptyClone();
            for (i = 0; i < state.population.subpops.size(); ++i) {
                for (int j = 0; j < state.population.subpops.get((int)i).individuals.size(); ++j) {
                    this.previousPopulation.subpops.get((int)i).individuals.add(j, (Individual)state.population.subpops.get((int)i).individuals.get(j).clone());
                }
            }
        }
    }

    void loadGurus(EvolutionState state, int whichSubpop) {
        Subpopulation subpop = state.population.subpops.get(whichSubpop);
        if (this.numGuru == 1) {
            int best = 0;
            ArrayList<Individual> oldinds = subpop.individuals;
            for (int x = 1; x < oldinds.size(); ++x) {
                if (!oldinds.get((int)x).fitness.betterThan(oldinds.get((int)best).fitness)) continue;
                best = x;
            }
            this.guruIndividuals[whichSubpop][0] = (Individual)state.population.subpops.get((int)whichSubpop).individuals.get(best).clone();
        } else if (this.numGuru > 0) {
            int[] orderedPop = new int[subpop.individuals.size()];
            for (int x = 0; x < subpop.individuals.size(); ++x) {
                orderedPop[x] = x;
            }
            QuickSort.qsort(orderedPop, (SortComparatorL)new GuruComparator(subpop.individuals));
            for (int j = 0; j < this.numGuru; ++j) {
                this.guruIndividuals[whichSubpop][j] = (Individual)state.population.subpops.get((int)whichSubpop).individuals.get(orderedPop[j]).clone();
            }
        }
    }
}

