/*
 * Decompiled with CFR 0.152.
 */
package ec.de;

import ec.Breeder;
import ec.EvolutionState;
import ec.Individual;
import ec.Population;
import ec.de.DEEvaluator;
import ec.util.Parameter;
import ec.vector.DoubleVectorIndividual;
import java.util.ArrayList;

public class DEBreeder
extends Breeder {
    public static final double CR_UNSPECIFIED = -1.0;
    public double F = 0.0;
    public double Cr = -1.0;
    public int retries = 0;
    public static final String P_F = "f";
    public static final String P_Cr = "cr";
    public static final String P_OUT_OF_BOUNDS_RETRIES = "out-of-bounds-retries";
    public Population previousPopulation = null;
    public int[] bestSoFarIndex = null;

    @Override
    public void setup(EvolutionState state, Parameter base) {
        if (!state.parameters.exists(base.push(P_Cr), null)) {
            this.Cr = -1.0;
        } else {
            this.Cr = state.parameters.getDouble(base.push(P_Cr), null, 0.0);
            if (this.Cr < 0.0 || this.Cr > 1.0) {
                state.output.fatal("Parameter not found, or its value is outside of [0.0,1.0].", base.push(P_Cr), null);
            }
        }
        this.F = state.parameters.getDouble(base.push(P_F), null, 0.0);
        if (this.F < 0.0 || this.F > 1.0) {
            state.output.fatal("Parameter not found, or its value is outside of [0.0,1.0].", base.push(P_F), null);
        }
        this.retries = state.parameters.getInt(base.push(P_OUT_OF_BOUNDS_RETRIES), null, 0);
        if (this.retries < 0) {
            state.output.fatal(" Retries must be a value >= 0.0.", base.push(P_OUT_OF_BOUNDS_RETRIES), null);
        }
    }

    public void prepareDEBreeder(EvolutionState state) {
        if (this.bestSoFarIndex == null || state.population.subpops.size() != this.bestSoFarIndex.length) {
            this.bestSoFarIndex = new int[state.population.subpops.size()];
        }
        for (int subpop = 0; subpop < state.population.subpops.size(); ++subpop) {
            ArrayList<Individual> inds = state.population.subpops.get((int)subpop).individuals;
            this.bestSoFarIndex[subpop] = 0;
            for (int j = 1; j < inds.size(); ++j) {
                if (!inds.get((int)j).fitness.betterThan(inds.get((int)this.bestSoFarIndex[subpop]).fitness)) continue;
                this.bestSoFarIndex[subpop] = j;
            }
        }
    }

    @Override
    public Population breedPopulation(EvolutionState state) {
        if (!(state.evaluator instanceof DEEvaluator)) {
            state.output.warnOnce("DEEvaluator not used, but DEBreeder used.  This is almost certainly wrong.");
        }
        this.prepareDEBreeder(state);
        Population newpop = state.population.emptyClone();
        for (int subpop = 0; subpop < state.population.subpops.size(); ++subpop) {
            if (state.population.subpops.get((int)subpop).individuals.size() < 4) {
                state.output.fatal("Subpopulation " + subpop + " has fewer than four individuals, and so cannot be used with DEBreeder.");
            }
            ArrayList<Individual> inds = newpop.subpops.get((int)subpop).individuals;
            int size = state.population.subpops.get((int)subpop).individuals.size();
            for (int i = 0; i < size; ++i) {
                newpop.subpops.get((int)subpop).individuals.add(this.createIndividual(state, subpop, i, 0));
            }
        }
        this.previousPopulation = state.population;
        return newpop;
    }

    public boolean valid(DoubleVectorIndividual ind) {
        return ind.isInRange();
    }

    public DoubleVectorIndividual createIndividual(EvolutionState state, int subpop, int index, int thread) {
        ArrayList<Individual> inds = state.population.subpops.get((int)subpop).individuals;
        DoubleVectorIndividual v = (DoubleVectorIndividual)state.population.subpops.get((int)subpop).species.newIndividual(state, thread);
        int retry = -1;
        do {
            int r2;
            int r1;
            int r0;
            ++retry;
            while ((r0 = state.random[thread].nextInt(inds.size())) == index) {
            }
            while ((r1 = state.random[thread].nextInt(inds.size())) == r0 || r1 == index) {
            }
            while ((r2 = state.random[thread].nextInt(inds.size())) == r1 || r2 == r0 || r2 == index) {
            }
            DoubleVectorIndividual g0 = (DoubleVectorIndividual)inds.get(r0);
            DoubleVectorIndividual g1 = (DoubleVectorIndividual)inds.get(r1);
            DoubleVectorIndividual g2 = (DoubleVectorIndividual)inds.get(r2);
            for (int i = 0; i < v.genome.length; ++i) {
                v.genome[i] = g0.genome[i] + this.F * (g1.genome[i] - g2.genome[i]);
            }
        } while (!this.valid(v) && retry < this.retries);
        if (retry >= this.retries && !this.valid(v)) {
            v.reset(state, thread);
        }
        return this.crossover(state, (DoubleVectorIndividual)inds.get(index), v, thread);
    }

    public DoubleVectorIndividual crossover(EvolutionState state, DoubleVectorIndividual target, DoubleVectorIndividual child, int thread) {
        if (this.Cr == -1.0) {
            state.output.warnOnce("Differential Evolution Parameter cr unspecified.  Assuming cr = 0.5");
        }
        int index = state.random[thread].nextInt(child.genome.length);
        double val = child.genome[index];
        for (int i = 0; i < child.genome.length; ++i) {
            if (!(state.random[thread].nextDouble() < this.Cr)) continue;
            child.genome[i] = target.genome[i];
        }
        child.genome[index] = val;
        return child;
    }
}

