/*
 * Decompiled with CFR 0.152.
 */
package ec.de;

import ec.EvolutionState;
import ec.Individual;
import ec.de.DEBreeder;
import ec.util.Parameter;
import ec.vector.DoubleVectorIndividual;
import java.util.ArrayList;

public class Rand1EitherOrDEBreeder
extends DEBreeder {
    public double PF = 0.0;
    public static final String P_PF = "pf";

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        this.PF = state.parameters.getDouble(base.push(P_PF), null, 0.0);
        if (this.PF < 0.0 || this.PF > 1.0) {
            state.output.fatal("Parameter not found, or its value is outside of [0.0,1.0].", base.push(P_PF), null);
        }
        if (state.parameters.exists(base.push("cr"), null)) {
            state.output.warning("Crossover parameter specified, but Rand1EitherOrDEBreeder does not use crossover.", base.push("cr"));
        }
    }

    @Override
    public DoubleVectorIndividual createIndividual(EvolutionState state, int subpop, int index, int thread) {
        ArrayList<Individual> inds = state.population.subpops.get((int)subpop).individuals;
        DoubleVectorIndividual v = (DoubleVectorIndividual)state.population.subpops.get((int)subpop).species.newIndividual(state, thread);
        int retry = -1;
        do {
            int r2;
            int r1;
            int r0;
            ++retry;
            while ((r0 = state.random[thread].nextInt(inds.size())) == index) {
            }
            while ((r1 = state.random[thread].nextInt(inds.size())) == r0 || r1 == index) {
            }
            while ((r2 = state.random[thread].nextInt(inds.size())) == r1 || r2 == r0 || r2 == index) {
            }
            DoubleVectorIndividual g0 = (DoubleVectorIndividual)inds.get(r0);
            DoubleVectorIndividual g1 = (DoubleVectorIndividual)inds.get(r1);
            DoubleVectorIndividual g2 = (DoubleVectorIndividual)inds.get(r2);
            for (int i = 0; i < v.genome.length; ++i) {
                v.genome[i] = state.random[thread].nextBoolean(this.PF) ? g0.genome[i] + this.F * (g1.genome[i] - g2.genome[i]) : g0.genome[i] + 0.5 * (this.F + 1.0) * (g1.genome[i] + g2.genome[i] - 2.0 * g0.genome[i]);
            }
        } while (!this.valid(v) && retry < this.retries);
        if (retry >= this.retries && !this.valid(v)) {
            v.reset(state, thread);
        }
        return v;
    }
}

