/*
 * Decompiled with CFR 0.152.
 */
package ec.display;

import ec.EvolutionState;
import ec.Evolve;
import ec.display.ControlPanel;
import ec.display.EvolutionStateEvent;
import ec.display.EvolutionStateListener;
import ec.display.ParametersPanel;
import ec.display.StatisticsChartPane;
import ec.display.SubpopulationPanel;
import ec.util.BadParameterException;
import ec.util.Checkpoint;
import ec.util.MersenneTwisterFast;
import ec.util.Output;
import ec.util.ParamClassLoadException;
import ec.util.Parameter;
import ec.util.ParameterDatabase;
import ec.util.ReflectedObject;
import ec.util.Version;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OptionalDataException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.filechooser.FileFilter;

public class Console
extends JFrame {
    private static final long serialVersionUID = 1L;
    static final int DEFAULT_HEIGHT = 500;
    static final int DEFAULT_WIDTH = 975;
    ParameterDatabase parameters = null;
    EvolutionState state = null;
    Thread playThread = null;
    boolean playing = false;
    boolean paused = false;
    Object buttonLock = new Object();
    Object cleanupLock = new Object();
    int currentJob;
    final String[] clArgs;
    JPanel jContentPane = null;
    JMenuBar jJMenuBar = null;
    JMenu fileMenu = null;
    JMenu helpMenu = null;
    JMenuItem exitMenuItem = null;
    JMenuItem aboutMenuItem = null;
    JTabbedPane jTabbedPane = null;
    JToolBar jToolBar = null;
    JButton playButton = null;
    JButton pauseButton = null;
    JButton stopButton = null;
    JButton stepButton = null;
    JMenuItem loadParametersMenuItem = null;
    ParametersPanel paramPanel = null;
    ControlPanel conPanel = null;
    JFrame aboutFrame;
    boolean threadIsToStop;
    boolean _step = false;
    int result;
    JMenuItem loadCheckpointMenuItem = null;
    JTabbedPane statisticsPane = null;
    JTabbedPane inspectionPane = null;
    JPanel statusPane = null;
    JTextField statusField = null;

    public Console(String[] clArgs) throws HeadlessException {
        this.clArgs = clArgs;
        this.initialize();
    }

    public Console(GraphicsConfiguration gc, String[] clArgs) {
        super(gc);
        this.clArgs = clArgs;
        this.initialize();
    }

    public Console(String title, String[] clArgs) throws HeadlessException {
        super(title);
        this.clArgs = clArgs;
        this.initialize();
    }

    public Console(String title, GraphicsConfiguration gc, String[] clArgs) {
        super(title, gc);
        this.clArgs = clArgs;
        this.initialize();
    }

    JTabbedPane getJTabbedPane() {
        if (this.jTabbedPane == null) {
            this.jTabbedPane = new JTabbedPane();
            this.conPanel = new ControlPanel(this);
            this.conPanel.disableControls();
            this.jTabbedPane.add("Control", this.conPanel);
            this.paramPanel = new ParametersPanel(this);
            this.jTabbedPane.add("Parameters", this.paramPanel);
            this.jTabbedPane.addTab("Statistics", null, this.getStatisticsPane(), null);
            this.jTabbedPane.addTab("Inspection", null, this.getInspectionPane(), null);
        }
        return this.jTabbedPane;
    }

    JToolBar getJToolBar() {
        if (this.jToolBar == null) {
            this.jToolBar = new JToolBar();
            this.jToolBar.add(this.getPlayButton());
            this.jToolBar.add(this.getStepButton());
            this.jToolBar.add(this.getPauseButton());
            this.jToolBar.add(this.getStopButton());
        }
        return this.jToolBar;
    }

    JButton getPlayButton() {
        if (this.playButton == null) {
            this.playButton = new JButton();
            this.playButton.setIcon(new ImageIcon(this.getClass().getResource("Play.png")));
            this.playButton.setEnabled(false);
            this.playButton.setToolTipText("Play");
            this.playButton.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    Object object = Console.this.buttonLock;
                    synchronized (object) {
                        if (!Console.this.playing || Console.this.playing && Console.this.paused) {
                            if (!Console.this.paused) {
                                Console.this.currentJob = 0;
                                Console.this.spawnPlayThread(false);
                            } else {
                                Console.this.resumePlayThread();
                            }
                            Console.this.playButton.setEnabled(false);
                            Console.this.stepButton.setEnabled(false);
                            Console.this.pauseButton.setEnabled(true);
                            Console.this.stopButton.setEnabled(true);
                            Console.this.conPanel.disableControls();
                            Console.this.paused = false;
                            Console.this.playing = true;
                        }
                    }
                }
            });
        }
        return this.playButton;
    }

    JButton getPauseButton() {
        if (this.pauseButton == null) {
            this.pauseButton = new JButton();
            this.pauseButton.setIcon(new ImageIcon(this.getClass().getResource("Pause.png")));
            this.pauseButton.setEnabled(false);
            this.pauseButton.setToolTipText("Pause");
            this.pauseButton.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    Object object = Console.this.buttonLock;
                    synchronized (object) {
                        if (Console.this.playing && !Console.this.paused) {
                            Console.this.paused = true;
                            Console.this.pausePlayThread();
                            Console.this.stepButton.setEnabled(true);
                            Console.this.playButton.setEnabled(true);
                            Console.this.pauseButton.setEnabled(false);
                        }
                    }
                }
            });
        }
        return this.pauseButton;
    }

    JButton getStopButton() {
        if (this.stopButton == null) {
            this.stopButton = new JButton();
            this.stopButton.setIcon(new ImageIcon(this.getClass().getResource("Stop.png")));
            this.stopButton.setEnabled(false);
            this.stopButton.setToolTipText("Stop");
            this.stopButton.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    Object object = Console.this.buttonLock;
                    synchronized (object) {
                        if (Console.this.playing) {
                            Console.this.killPlayThread();
                            Console.this.stopButton.setEnabled(false);
                            Console.this.pauseButton.setEnabled(false);
                            Console.this.stepButton.setEnabled(true);
                            Console.this.playButton.setEnabled(true);
                            Console.this.conPanel.enableControls();
                            Console.this.paused = false;
                            Console.this.playing = false;
                        }
                    }
                }
            });
        }
        return this.stopButton;
    }

    JButton getStepButton() {
        if (this.stepButton == null) {
            this.stepButton = new JButton();
            this.stepButton.setEnabled(false);
            this.stepButton.setIcon(new ImageIcon(this.getClass().getResource("Step.png")));
            this.stepButton.setPressedIcon(new ImageIcon(this.getClass().getResource("Stepping.png")));
            this.stepButton.setToolTipText("Step");
            this.stepButton.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    Object object = Console.this.buttonLock;
                    synchronized (object) {
                        Console.this.paused = true;
                        Console.this.setStep(true);
                        if (!Console.this.playing) {
                            Console.this.spawnPlayThread(false);
                            Console.this.stopButton.setEnabled(true);
                            Console.this.conPanel.disableControls();
                            Console.this.playing = true;
                        }
                        Thread thread = Console.this.playThread;
                        synchronized (thread) {
                            Console.this.playThread.notify();
                        }
                    }
                }
            });
        }
        return this.stepButton;
    }

    JMenuItem getLoadParametersMenuItem() {
        if (this.loadParametersMenuItem == null) {
            String PARAMFILE_EXT = "params";
            this.getAboutMenuItem();
            this.loadParametersMenuItem = new JMenuItem();
            this.loadParametersMenuItem.setText("Load Parameters...");
            this.loadParametersMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileDialog fileDialog = new FileDialog((Frame)Console.this, "Open...", 0);
                    fileDialog.setDirectory(System.getProperty("user.dir"));
                    fileDialog.setFile("*.params");
                    fileDialog.setVisible(true);
                    String fileName = fileDialog.getFile();
                    while (fileName != null && !fileName.endsWith(".params")) {
                        JOptionPane optPane = new JOptionPane(fileDialog.getFile() + " is not a legal parameters file", 0);
                        JDialog optDialog = optPane.createDialog(Console.this, "Error!");
                        optDialog.setVisible(true);
                        fileDialog.setFile("*.params");
                        fileDialog.setVisible(true);
                        fileName = fileDialog.getFile();
                    }
                    if (fileName != null) {
                        File f = new File(fileDialog.getDirectory(), fileName);
                        Console.this.loadParameters(f);
                        Console.this.playButton.setEnabled(true);
                        Console.this.stepButton.setEnabled(true);
                        Console.this.conPanel.enableControls();
                    }
                }
            });
        }
        return this.loadParametersMenuItem;
    }

    JMenuItem getLoadCheckpointMenuItem() {
        if (this.loadCheckpointMenuItem == null) {
            this.loadCheckpointMenuItem = new JMenuItem();
            this.loadCheckpointMenuItem.setText("Load Checkpoint...");
            this.loadCheckpointMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
                    chooser.setFileFilter(new FileFilter(this){

                        @Override
                        public boolean accept(File f) {
                            if (f.isDirectory()) {
                                return true;
                            }
                            String extension = null;
                            String filename = f.getName();
                            int idx = filename.lastIndexOf(46);
                            if (idx > 0 && idx < filename.length() - 1) {
                                extension = filename.substring(idx + 1).toLowerCase();
                            }
                            return extension != null && extension.equals("gz");
                        }

                        @Override
                        public String getDescription() {
                            return "Checkpoint Files";
                        }
                    });
                    int option = chooser.showOpenDialog(Console.this);
                    if (option == 0) {
                        File f = chooser.getSelectedFile();
                        Console.this.restoreFromCheckpoint(f);
                        Console.this.playButton.setEnabled(true);
                        Console.this.stepButton.setEnabled(true);
                    }
                }
            });
        }
        return this.loadCheckpointMenuItem;
    }

    JTabbedPane getStatisticsPane() {
        if (this.statisticsPane == null) {
            this.statisticsPane = new JTabbedPane();
        }
        return this.statisticsPane;
    }

    JTabbedPane getInspectionPane() {
        if (this.inspectionPane == null) {
            this.inspectionPane = new JTabbedPane();
        }
        return this.inspectionPane;
    }

    JPanel getStatusPane() {
        if (this.statusPane == null) {
            this.statusPane = new JPanel();
            this.statusPane.setLayout(new BoxLayout(this.statusPane, 0));
            this.statusPane.add((Component)this.getStatusField(), null);
        }
        return this.statusPane;
    }

    JTextField getStatusField() {
        if (this.statusField == null) {
            this.statusField = new JTextField();
            this.statusField.setEditable(false);
        }
        return this.statusField;
    }

    public static void main(String[] args) {
        Console application = new Console(args);
        application.setVisible(true);
    }

    void initialize() {
        this.setSize(975, 500);
        this.setDefaultCloseOperation(3);
        this.setJMenuBar(this.getJJMenuBar());
        this.setContentPane(this.getJContentPane());
        this.setJMenuBar(this.getJJMenuBar());
        this.setContentPane(this.getJContentPane());
        this.setTitle("ECJ Console");
        for (int i = 0; i < this.clArgs.length; ++i) {
            if (!this.clArgs[i].equalsIgnoreCase("file")) continue;
            File file = new File(this.clArgs[i + 1]);
            this.loadParameters(file);
            this.playButton.setEnabled(true);
            this.stepButton.setEnabled(true);
            this.conPanel.enableControls();
        }
    }

    JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJTabbedPane(), "Center");
            this.jContentPane.add((Component)this.getJToolBar(), "North");
            this.jContentPane.add((Component)this.getStatusPane(), "South");
        }
        return this.jContentPane;
    }

    JMenuBar getJJMenuBar() {
        if (this.jJMenuBar == null) {
            this.jJMenuBar = new JMenuBar();
            this.jJMenuBar.add(this.getFileMenu());
            this.jJMenuBar.add(this.getHelpMenu());
        }
        return this.jJMenuBar;
    }

    JMenu getFileMenu() {
        if (this.fileMenu == null) {
            this.fileMenu = new JMenu();
            this.fileMenu.setText("File");
            this.fileMenu.add(this.getLoadParametersMenuItem());
            this.fileMenu.add(this.getLoadCheckpointMenuItem());
            this.fileMenu.add(new JSeparator());
            this.fileMenu.add(this.getExitMenuItem());
        }
        return this.fileMenu;
    }

    JMenu getHelpMenu() {
        if (this.helpMenu == null) {
            this.helpMenu = new JMenu();
            this.helpMenu.setText("Help");
            this.helpMenu.add(this.getAboutMenuItem());
        }
        return this.helpMenu;
    }

    JMenuItem getExitMenuItem() {
        if (this.exitMenuItem == null) {
            this.exitMenuItem = new JMenuItem();
            this.exitMenuItem.setText("Exit");
            this.exitMenuItem.addActionListener(new ActionListener(this){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.exit(0);
                }
            });
        }
        return this.exitMenuItem;
    }

    JMenuItem getAboutMenuItem() {
        if (this.aboutMenuItem == null) {
            this.aboutMenuItem = new JMenuItem();
            this.aboutMenuItem.setText("About ECJ");
            this.aboutMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Console.this.aboutFrame == null) {
                        Console.this.aboutFrame = new JFrame("About ECJ");
                        JPanel p = new JPanel();
                        p.setBorder(BorderFactory.createEmptyBorder(25, 30, 30, 30));
                        Box b = new Box(1);
                        p.add((Component)b, "Center");
                        Console.this.aboutFrame.getContentPane().add((Component)p, "Center");
                        Console.this.aboutFrame.setResizable(false);
                        Font small = new Font("Dialog", 0, 10);
                        JLabel j = new JLabel("ECJ");
                        j.setFont(new Font("Serif", 0, 36));
                        b.add(j);
                        j = new JLabel("An Evolutionary Computation System");
                        b.add(j);
                        j = new JLabel("Version 28");
                        b.add(j);
                        JLabel spacer = new JLabel(" ");
                        spacer.setFont(new Font("Dialog", 0, 6));
                        b.add(spacer);
                        j = new JLabel("By Sean Luke");
                        b.add(j);
                        spacer = new JLabel(" ");
                        spacer.setFont(new Font("Dialog", 0, 6));
                        b.add(spacer);
                        j = new JLabel("Contributors:");
                        b.add(j);
                        j = new JLabel("     E. Scott, L. Panait, G. Balan, S. Paus, Z. Skolicki,");
                        b.add(j);
                        j = new JLabel("     R. Kicinger, E. Popovici, K. Sullivan, J. Harrison, J. Bassett,");
                        b.add(j);
                        spacer = new JLabel(" ");
                        spacer.setFont(new Font("Dialog", 0, 6));
                        b.add(spacer);
                        spacer = new JLabel(" ");
                        spacer.setFont(new Font("Dialog", 0, 6));
                        b.add(spacer);
                        j = new JLabel("ECJ's homepage is http://people.cs.gmu.edu/~eclab/projects/ecj/");
                        j.setFont(small);
                        b.add(j);
                        j = new JLabel("For help, send mail to ecj-help@cs.gmu.edu");
                        j.setFont(small);
                        b.add(j);
                        j = new JLabel("     (better: join ECJ-INTEREST at URL above)");
                        j.setFont(small);
                        b.add(j);
                        spacer.setFont(new Font("Dialog", 0, 6));
                        b.add(spacer);
                        j = new JLabel("Version 28 released on January 11, 2026.");
                        j.setFont(small);
                        b.add(j);
                        String javaVersion = System.getProperties().getProperty("java.version");
                        j = new JLabel("Current Java: " + javaVersion);
                        j.setFont(small);
                        b.add(j);
                        j = new JLabel("Minimum Java: 1.8");
                        j.setFont(small);
                        b.add(j);
                        Console.this.aboutFrame.pack();
                    }
                    if (!Console.this.aboutFrame.isVisible()) {
                        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
                        d.width -= Console.this.aboutFrame.getWidth();
                        d.height -= Console.this.aboutFrame.getHeight();
                        d.width /= 2;
                        d.height /= 2;
                        if (d.width < 0) {
                            d.width = 0;
                        }
                        if (d.height < 0) {
                            d.height = 0;
                        }
                        Console.this.aboutFrame.setLocation(d.width, d.height);
                    }
                    Console.this.aboutFrame.setVisible(true);
                }
            });
        }
        return this.aboutMenuItem;
    }

    void loadParameters(File f) {
        try {
            this.parameters = new ParameterDatabase(f, this.clArgs);
        }
        catch (FileNotFoundException ex) {
            Output.initialError("A File Not Found Exception was generated upon reading the parameter file \"" + f.getPath() + "\".\nHere it is:\n" + String.valueOf(ex), true);
        }
        catch (IOException ex) {
            Output.initialError("An IO Exception was generated upon reading the parameter file \"" + f.getPath() + "\".\nHere it is:\n" + String.valueOf(ex), true);
        }
        if (this.parameters == null) {
            Output.initialError("No parameter file was loaded", true);
        } else {
            this.paramPanel.loadParameters();
            this.conPanel.loadParameters();
        }
    }

    void restoreFromCheckpoint(File checkpoint) {
        try {
            this.state = Checkpoint.restoreFromCheckpoint(checkpoint.getCanonicalPath());
            this.parameters = this.state.parameters;
            this.paramPanel.loadParameters();
            this.conPanel.loadParameters();
            this.paused = true;
            this.setStep(false);
            this.spawnPlayThread(true);
            this.stopButton.setEnabled(true);
        }
        catch (OptionalDataException e) {
            Output.initialError("A ClassNotFoundException was generated uponstarting up from a checkpoint.\nHere it is:\n" + String.valueOf(e), true);
        }
        catch (ClassNotFoundException e) {
            Output.initialError("A ClassNotFoundException was generated uponstarting up from a checkpoint.\nHere it is:\n" + String.valueOf(e), true);
        }
        catch (IOException e) {
            Output.initialError("An IO Exception was generated uponstarting up, probably in setting up a log\nHere it is:\n" + String.valueOf(e), true);
        }
    }

    void tellThreadToStop() {
        this.threadIsToStop = true;
    }

    void setStep(boolean step) {
        this._step = step;
    }

    boolean isThreadToStop() {
        return this.threadIsToStop;
    }

    boolean getStep() {
        return this._step;
    }

    void setPaused(boolean paused) {
        this.paused = paused;
    }

    boolean isPaused() {
        return this.paused;
    }

    void spawnPlayThread(final boolean rfc) {
        this.threadIsToStop = false;
        Runnable run = new Runnable(){
            Vector<EvolutionStateListener> listeners = new Vector();
            boolean restoreFromCheckpoint = rfc;

            void addListener(EvolutionStateListener l) {
                this.listeners.add(l);
            }

            void firePostEvolutionStep() {
                EvolutionStateEvent evt = new EvolutionStateEvent(this);
                for (EvolutionStateListener l : this.listeners) {
                    l.postEvolution(evt);
                }
            }

            void restoreFromCheckpoint() {
                Console.this.state.startFromCheckpoint();
                Console.this.statisticsPane.removeAll();
                this.setupChartPanes();
                this.setupInspectionPanes();
            }

            void initializeEvolutionState() throws BadParameterException, ParamClassLoadException {
                int x;
                this.listeners.removeAllElements();
                Output output = Console.this.initializeOutput();
                int breedthreads = Evolve.determineThreads(output, Console.this.parameters, new Parameter("breedthreads"));
                int evalthreads = Evolve.determineThreads(output, Console.this.parameters, new Parameter("evalthreads"));
                MersenneTwisterFast[] random = new MersenneTwisterFast[breedthreads > evalthreads ? breedthreads : evalthreads];
                int[] seeds = new int[breedthreads > evalthreads ? breedthreads : evalthreads];
                Object seed_message = "Seed: ";
                for (x = 0; x < random.length; ++x) {
                    seeds[x] = Console.this.conPanel.getSeed(Console.this.currentJob, x);
                    seed_message = (String)seed_message + seeds[x] + " ";
                }
                for (x = 0; x < random.length; ++x) {
                    for (int y = x + 1; y < random.length; ++y) {
                        if (seeds[x] != seeds[y]) continue;
                        Output.initialError("seed." + x + " (" + seeds[x] + ") and seed." + y + " (" + seeds[y] + ") ought not be the same seed.", true);
                    }
                    random[x] = Evolve.primeGenerator(new MersenneTwisterFast(seeds[x]));
                }
                Console.this.state = (EvolutionState)Console.this.parameters.getInstanceForParameter(new Parameter("state"), null, EvolutionState.class);
                Console.this.state.parameters = Console.this.parameters;
                Console.this.state.random = random;
                Console.this.state.output = output;
                Object jobFilePrefix = Console.this.conPanel.getJobFilePrefix();
                if (Console.this.conPanel.getNumJobs() > 1) {
                    if (jobFilePrefix == null || ((String)jobFilePrefix).length() < 1) {
                        jobFilePrefix = "job";
                    }
                    jobFilePrefix = (String)jobFilePrefix + "." + Console.this.currentJob + ".";
                    Console.this.state.output.setFilePrefix((String)jobFilePrefix);
                }
                Console.this.state.evalthreads = evalthreads;
                Console.this.state.breedthreads = breedthreads;
                output.systemMessage("Threads:  breed/" + breedthreads + " eval/" + evalthreads);
                output.systemMessage((String)seed_message);
                Console.this.state.startFresh();
                if (Console.this.conPanel.getNumJobs() > 0) {
                    Console.this.state.checkpointPrefix = (String)jobFilePrefix + Console.this.state.checkpointPrefix;
                }
                if (Console.this.currentJob == 0) {
                    Console.this.statisticsPane.removeAll();
                }
                this.setupChartPanes();
                this.setupInspectionPanes();
            }

            void setupInspectionPanes() throws NumberFormatException, BadParameterException {
                Console.this.inspectionPane.removeAll();
                JScrollPane stateInspectionPane = new JScrollPane();
                JTree stateInspectionTree = new JTree(new ReflectedObject(Console.this.state));
                stateInspectionPane.setViewportView(stateInspectionTree);
                Console.this.inspectionPane.add("Evolution State", stateInspectionPane);
                Parameter p_subPops = new Parameter("pop.subpops");
                int numSubPops = Console.this.parameters.getInt(p_subPops, null);
                for (int subPop = 0; subPop < numSubPops; ++subPop) {
                    SubpopulationPanel subPopPane = new SubpopulationPanel(Console.this, subPop);
                    subPopPane.setup(Console.this.state, p_subPops.push("" + subPop));
                    Console.this.inspectionPane.add("SubPop " + subPop, subPopPane);
                    this.addListener(subPopPane);
                }
            }

            void setupChartPanes() throws BadParameterException {
                StatisticsChartPane statPane = new StatisticsChartPane();
                statPane.setup(Console.this.state, new Parameter("stat"));
                if (statPane.numCharts > 0) {
                    Console.this.statisticsPane.addTab("Job " + Console.this.currentJob, statPane);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    while (Console.this.currentJob < Console.this.conPanel.getNumJobs()) {
                        if (!this.restoreFromCheckpoint) {
                            this.initializeEvolutionState();
                        } else {
                            this.restoreFromCheckpoint();
                        }
                        Console.this.state.output.message("\nJob " + Console.this.currentJob);
                        Console.this.result = 2;
                        while (Console.this.result == 2 && !Thread.currentThread().isInterrupted() && !Console.this.isThreadToStop()) {
                            try {
                                Thread thread = Console.this.playThread;
                                synchronized (thread) {
                                    while (Console.this.isPaused() && !Console.this.getStep()) {
                                        Console.this.playThread.wait();
                                    }
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (Thread.currentThread().isInterrupted() || Console.this.isThreadToStop()) continue;
                            Console.this.result = Console.this.state.evolve();
                            this.firePostEvolutionStep();
                            Console.this.getStatusField().setText("Job: " + Console.this.currentJob + " Generation: " + Console.this.state.generation);
                            Console.this.setStep(false);
                        }
                        if (Console.this.result == 2) {
                            Console.this.result = 1;
                        }
                        if (Console.this.state != null && Console.this.result != 2) {
                            Console.this.state.finish(Console.this.result);
                        }
                        ++Console.this.currentJob;
                    }
                }
                catch (Exception e) {
                    System.err.println("Exception when running job:\n\t");
                    e.printStackTrace();
                }
                Console.this.conPanel.enableControls();
                Console.this.finishAndCleanup();
            }
        };
        this.playThread = new Thread(run);
        this.playThread.start();
    }

    Output initializeOutput() throws BadParameterException {
        Output output = new Output(true);
        output.addLog(0, false);
        output.addLog(1, true);
        output.systemMessage(Version.message());
        return output;
    }

    void pausePlayThread() {
        this.setPaused(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resumePlayThread() {
        Thread thread = this.playThread;
        synchronized (thread) {
            this.setPaused(false);
            this.playThread.notify();
        }
    }

    void killPlayThread() {
        block5: {
            this.tellThreadToStop();
            try {
                if (this.playThread == null) break block5;
                while (this.playThread.isAlive()) {
                    try {
                        this.playThread.interrupt();
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    this.playThread.join(50L);
                }
                this.playThread = null;
            }
            catch (InterruptedException ex) {
                System.out.println("Interrupted while killing the play thread.  Shouldn't happen.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishAndCleanup() {
        Object object = this.cleanupLock;
        synchronized (object) {
            this.stopButton.setEnabled(false);
            this.pauseButton.setEnabled(false);
            this.stepButton.setEnabled(true);
            this.playButton.setEnabled(true);
            this.paused = false;
            this.playing = false;
            this._step = false;
            this.currentJob = 0;
        }
    }
}

