/*
 * Decompiled with CFR 0.152.
 */
package ec.display;

import ec.display.Console;
import ec.util.Parameter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;

public class ControlPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    final Console console;
    static final String P_JOBFILEPREFIX = "job-file-prefix";
    JLabel jLabel = null;
    JTextField numGensField = null;
    JCheckBox quitOnRunCompleteCheckbox = null;
    JLabel jLabel1 = null;
    JTextField numJobsField = null;
    JLabel jLabel2 = null;
    JLabel jLabel3 = null;
    JTextField evalThreadsField = null;
    JTextField breedThreadsField = null;
    JPanel jPanel = null;
    JRadioButton seedFileRadioButton = null;
    JTextField seedFileField = null;
    JButton seedFileButton = null;
    JRadioButton randomSeedsRadioButton = null;
    JTable seedsTable = null;
    JScrollPane jScrollPane = null;
    JLabel jLabel6 = null;
    JCheckBox checkpointCheckBox = null;
    JPanel checkpointPanel = null;
    JLabel jLabel7 = null;
    JTextField checkpointModuloField = null;
    JLabel jLabel8 = null;
    JTextField prefixField = null;
    JLabel jLabel10 = null;
    ButtonGroup seedButtonGroup;
    JButton generateSeedsButton = null;
    JRadioButton sequentialSeedsRadioButton = null;
    JLabel jLabel5 = null;
    JTextField jobFilePrefixField = null;

    public ControlPanel(Console console) {
        this.console = console;
        this.initialize();
    }

    public void disableControls() {
        this.breedThreadsField.setEnabled(false);
        this.checkpointCheckBox.setEnabled(false);
        this.checkpointModuloField.setEnabled(false);
        this.evalThreadsField.setEnabled(false);
        this.generateSeedsButton.setEnabled(false);
        this.jobFilePrefixField.setEnabled(false);
        this.numGensField.setEnabled(false);
        this.numJobsField.setEnabled(false);
        this.prefixField.setEnabled(false);
        this.quitOnRunCompleteCheckbox.setEnabled(false);
        this.sequentialSeedsRadioButton.setEnabled(false);
        this.randomSeedsRadioButton.setEnabled(false);
        this.seedFileRadioButton.setEnabled(false);
        this.seedFileButton.setEnabled(false);
        this.seedsTable.setEnabled(false);
    }

    public void enableControls() {
        this.breedThreadsField.setEnabled(true);
        this.checkpointCheckBox.setEnabled(true);
        if (this.checkpointCheckBox.isSelected()) {
            this.checkpointModuloField.setEnabled(true);
            this.prefixField.setEnabled(true);
        }
        this.evalThreadsField.setEnabled(true);
        this.jobFilePrefixField.setEnabled(true);
        this.numGensField.setEnabled(true);
        this.numJobsField.setEnabled(true);
        this.quitOnRunCompleteCheckbox.setEnabled(true);
        this.sequentialSeedsRadioButton.setEnabled(true);
        this.randomSeedsRadioButton.setEnabled(true);
        if (this.randomSeedsRadioButton.isSelected()) {
            this.generateSeedsButton.setEnabled(true);
        }
        this.seedFileRadioButton.setEnabled(true);
        if (this.seedFileRadioButton.isSelected()) {
            this.seedFileButton.setEnabled(true);
        }
        this.seedsTable.setEnabled(true);
    }

    void initialize() {
        this.jLabel5 = new JLabel();
        GridBagConstraints gridBagConstraints28 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints37 = new GridBagConstraints();
        this.jLabel10 = new JLabel();
        GridBagConstraints gridBagConstraints45 = new GridBagConstraints();
        this.jLabel6 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel = new JLabel();
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints25 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints26 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints35 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints36 = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.setSize(975, 300);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.gridheight = 1;
        gridBagConstraints1.gridwidth = 1;
        gridBagConstraints1.anchor = 17;
        this.jLabel.setText("# Generations:");
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints2.ipadx = 30;
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 6;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.gridwidth = 2;
        gridBagConstraints5.gridx = 1;
        gridBagConstraints5.gridy = 0;
        gridBagConstraints5.anchor = 18;
        this.jLabel1.setText("# Jobs:");
        gridBagConstraints6.gridx = 2;
        gridBagConstraints6.gridy = 0;
        gridBagConstraints6.fill = 2;
        gridBagConstraints6.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints6.anchor = 18;
        gridBagConstraints6.gridwidth = 1;
        gridBagConstraints7.gridx = 1;
        gridBagConstraints7.gridy = 3;
        gridBagConstraints7.anchor = 17;
        this.jLabel2.setText("# Evaluation Threads:");
        gridBagConstraints8.gridx = 1;
        gridBagConstraints8.gridy = 4;
        gridBagConstraints8.anchor = 17;
        gridBagConstraints8.gridwidth = 1;
        this.jLabel3.setText("# Breeder Threads:");
        gridBagConstraints9.gridx = 2;
        gridBagConstraints9.gridy = 3;
        gridBagConstraints9.fill = 2;
        gridBagConstraints9.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints10.gridx = 2;
        gridBagConstraints10.gridy = 4;
        gridBagConstraints10.fill = 2;
        gridBagConstraints10.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints11.gridx = 11;
        gridBagConstraints11.gridy = 0;
        gridBagConstraints11.gridwidth = 6;
        gridBagConstraints11.fill = 1;
        gridBagConstraints11.gridheight = 13;
        gridBagConstraints11.weightx = 1.0;
        gridBagConstraints25.gridx = 1;
        gridBagConstraints25.gridy = 5;
        gridBagConstraints25.anchor = 17;
        gridBagConstraints25.insets = new Insets(0, 0, 0, 0);
        this.jLabel6.setText("Verbosity:");
        gridBagConstraints26.gridx = 2;
        gridBagConstraints26.gridy = 5;
        gridBagConstraints26.fill = 2;
        gridBagConstraints26.anchor = 17;
        gridBagConstraints26.weightx = 0.0;
        gridBagConstraints26.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints26.ipadx = 30;
        gridBagConstraints35.gridx = 1;
        gridBagConstraints35.gridy = 7;
        gridBagConstraints35.anchor = 17;
        gridBagConstraints35.gridwidth = 2;
        gridBagConstraints35.gridheight = 1;
        gridBagConstraints36.gridx = 1;
        gridBagConstraints36.gridy = 8;
        gridBagConstraints36.gridheight = 1;
        gridBagConstraints36.gridwidth = 3;
        gridBagConstraints36.anchor = 11;
        gridBagConstraints36.ipadx = 107;
        gridBagConstraints45.gridx = 5;
        gridBagConstraints45.gridy = 8;
        gridBagConstraints45.weighty = 1.0;
        this.jLabel10.setText("");
        gridBagConstraints28.gridx = 1;
        gridBagConstraints28.gridy = 1;
        gridBagConstraints28.anchor = 17;
        this.jLabel5.setText("Job file prefix:");
        gridBagConstraints37.gridx = 2;
        gridBagConstraints37.gridy = 1;
        gridBagConstraints37.fill = 2;
        gridBagConstraints37.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints37.gridwidth = 3;
        this.add((Component)this.jLabel, gridBagConstraints1);
        this.add((Component)this.getNumGensField(), gridBagConstraints2);
        this.add((Component)this.getQuitOnRunCompleteCheckbox(), gridBagConstraints4);
        this.add((Component)this.jLabel1, gridBagConstraints5);
        this.add((Component)this.getNumJobsField(), gridBagConstraints6);
        this.add((Component)this.jLabel2, gridBagConstraints7);
        this.add((Component)this.jLabel3, gridBagConstraints8);
        this.add((Component)this.getEvalThreadsField(), gridBagConstraints9);
        this.add((Component)this.getBreedThreadsField(), gridBagConstraints10);
        this.add((Component)this.getJPanel(), gridBagConstraints11);
        this.add((Component)this.jLabel6, gridBagConstraints25);
        this.add((Component)this.getCheckpointCheckBox(), gridBagConstraints35);
        this.add((Component)this.getCheckpointPanel(), gridBagConstraints36);
        this.add((Component)this.jLabel10, gridBagConstraints45);
        this.add((Component)this.jLabel5, gridBagConstraints28);
        this.add((Component)this.getJobFilePrefixField(), gridBagConstraints37);
        this.add(Box.createRigidArea(new Dimension(5, 0)));
    }

    JTextField getNumGensField() {
        if (this.numGensField == null) {
            this.numGensField = new JTextField();
            this.numGensField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        ControlPanel.this.console.parameters.set(new Parameter("generations"), ((JTextField)e.getSource()).getText());
                    } else if (e.getKeyCode() == 27) {
                        ((JTextField)e.getSource()).setText(ControlPanel.this.console.parameters.getString(new Parameter("generations"), null));
                    }
                }
            });
            this.numGensField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    ControlPanel.this.console.parameters.set(new Parameter("generations"), ((JTextField)e.getSource()).getText());
                    ControlPanel.this.resizeSeedTable();
                }
            });
        }
        return this.numGensField;
    }

    JCheckBox getQuitOnRunCompleteCheckbox() {
        if (this.quitOnRunCompleteCheckbox == null) {
            this.quitOnRunCompleteCheckbox = new JCheckBox();
            this.quitOnRunCompleteCheckbox.setText("Quit on Run Complete");
            this.quitOnRunCompleteCheckbox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ControlPanel.this.console.parameters.set(new Parameter("quit-on-run-complete"), "" + ((JCheckBox)e.getSource()).isSelected());
                }
            });
        }
        return this.quitOnRunCompleteCheckbox;
    }

    JTextField getNumJobsField() {
        if (this.numJobsField == null) {
            this.numJobsField = new JTextField();
            this.numJobsField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        ControlPanel.this.resizeSeedTable();
                    }
                }
            });
            this.numJobsField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    ControlPanel.this.resizeSeedTable();
                }
            });
        }
        return this.numJobsField;
    }

    public int getNumJobs() {
        try {
            return Integer.parseInt(this.getNumJobsField().getText());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public int getThreadCount(String text) {
        try {
            if (text.toLowerCase().trim().equals("auto")) {
                return Runtime.getRuntime().availableProcessors();
            }
            return Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    void resizeSeedTable() throws NumberFormatException {
        int numJobs = Integer.parseInt(this.numJobsField.getText());
        int breedThreads = this.getThreadCount(this.breedThreadsField.getText());
        int evalThreads = this.getThreadCount(this.evalThreadsField.getText());
        int numThreads = Math.max(breedThreads, evalThreads);
        DefaultTableModel model = (DefaultTableModel)this.seedsTable.getModel();
        model.setColumnCount(numThreads);
        Object[] columnHeaders = new String[numThreads];
        for (int i = 0; i < numThreads; ++i) {
            columnHeaders[i] = "Thread " + i;
        }
        model.setColumnIdentifiers(columnHeaders);
        model.setRowCount(numJobs);
        if (this.seedFileRadioButton.isSelected()) {
            File f = new File(this.seedFileField.getText());
            try {
                this.loadSeeds(f);
            }
            catch (IOException ex) {
                System.err.println(ex.getMessage());
            }
        } else if (this.randomSeedsRadioButton.isSelected()) {
            this.generateRandomSeeds();
        } else if (this.sequentialSeedsRadioButton.isSelected()) {
            int i = 0;
            try {
                for (int thread = 0; thread < numThreads; ++thread) {
                    int seed = this.console.parameters.getInt(new Parameter("seed." + thread), null);
                    for (int job = 0; job < numJobs; ++job) {
                        this.setSeed("" + (seed + i++), job, thread);
                    }
                }
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(null, "The seed parameter for at least one thread not a fixed number (perhaps it's set to 'time'?), so sequential seeds cannot be used.\nReverting to random number seeds for all threads.", "Adjusting Seeds", 1);
                this.randomSeedsRadioButton.setSelected(true);
                this.generateRandomSeeds();
            }
        } else {
            for (int job = 0; job < numJobs; ++job) {
                for (int thread = 0; thread < numThreads; ++thread) {
                    this.setSeed(this.console.parameters.getString(new Parameter("seed." + thread), null), job, thread);
                }
            }
        }
    }

    void generateRandomSeeds() throws NumberFormatException {
        int numJobs = Integer.parseInt(this.numJobsField.getText());
        int evalThreads = this.console.parameters.getInt(new Parameter("evalthreads"), null);
        int breedThreads = this.console.parameters.getInt(new Parameter("breedthreads"), null);
        assert (evalThreads == this.getThreadCount(this.evalThreadsField.getText()));
        assert (breedThreads == this.getThreadCount(this.breedThreadsField.getText()));
        int numThreads = Math.max(breedThreads, evalThreads);
        int seed = (int)System.currentTimeMillis();
        for (int job = 0; job < numJobs; ++job) {
            for (int thread = 0; thread < numThreads; ++thread) {
                seed = seed + job * Math.min(breedThreads, evalThreads) + thread * Math.max(breedThreads, evalThreads);
                this.setSeed("" + seed, job, thread);
            }
        }
    }

    public int getSeed(int experimentNum, int threadNum) {
        try {
            return Integer.parseInt((String)this.seedsTable.getValueAt(experimentNum, threadNum));
        }
        catch (RuntimeException e) {
            JOptionPane.showMessageDialog(null, "Error reading from seed table. Rebuilding random number seeds.", "Adjusting Seeds", 1);
            this.generateRandomSeeds();
            return Integer.valueOf((String)this.seedsTable.getValueAt(experimentNum, threadNum));
        }
    }

    public void setSeed(String seed, int experimentNum, int threadNum) {
        this.seedsTable.setValueAt(seed, experimentNum, threadNum);
    }

    JTextField getEvalThreadsField() {
        if (this.evalThreadsField == null) {
            this.evalThreadsField = new JTextField();
            this.evalThreadsField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        ControlPanel.this.console.parameters.set(new Parameter("evalthreads"), ((JTextField)e.getSource()).getText());
                        ControlPanel.this.resizeSeedTable();
                    } else if (e.getKeyCode() == 27) {
                        ((JTextField)e.getSource()).setText(ControlPanel.this.console.parameters.getString(new Parameter("evalthreads"), null));
                    }
                }
            });
            this.evalThreadsField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    ControlPanel.this.console.parameters.set(new Parameter("evalthreads"), ((JTextField)e.getSource()).getText());
                    ControlPanel.this.resizeSeedTable();
                }
            });
        }
        return this.evalThreadsField;
    }

    JTextField getBreedThreadsField() {
        if (this.breedThreadsField == null) {
            this.breedThreadsField = new JTextField();
            this.breedThreadsField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        ControlPanel.this.console.parameters.set(new Parameter("breedthreads"), ((JTextField)e.getSource()).getText());
                        ControlPanel.this.resizeSeedTable();
                    } else if (e.getKeyCode() == 27) {
                        ((JTextField)e.getSource()).setText(ControlPanel.this.console.parameters.getString(new Parameter("breedthreads"), null));
                    }
                }
            });
            this.breedThreadsField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    ControlPanel.this.console.parameters.set(new Parameter("breedthreads"), ((JTextField)e.getSource()).getText());
                    ControlPanel.this.resizeSeedTable();
                }
            });
        }
        return this.breedThreadsField;
    }

    JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints81 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            TitledBorder titledBorder28 = BorderFactory.createTitledBorder(null, "Random Seed(s)", 0, 0, null, null);
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            gridBagConstraints12.gridx = 0;
            gridBagConstraints12.gridy = 1;
            gridBagConstraints12.fill = 2;
            gridBagConstraints12.anchor = 13;
            gridBagConstraints12.gridwidth = 5;
            gridBagConstraints12.insets = new Insets(0, 20, 0, 0);
            gridBagConstraints12.weightx = 1.0;
            gridBagConstraints13.gridx = 5;
            gridBagConstraints13.gridy = 1;
            gridBagConstraints13.anchor = 17;
            gridBagConstraints13.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints14.gridx = 0;
            gridBagConstraints14.gridy = 3;
            gridBagConstraints14.gridwidth = 1;
            gridBagConstraints14.anchor = 17;
            gridBagConstraints19.gridwidth = 6;
            gridBagConstraints19.anchor = 17;
            gridBagConstraints21.gridx = 0;
            gridBagConstraints21.gridy = 7;
            gridBagConstraints21.fill = 1;
            gridBagConstraints21.gridwidth = 6;
            gridBagConstraints21.gridheight = 1;
            gridBagConstraints21.weighty = 1.0;
            gridBagConstraints21.weightx = 1.0;
            this.jPanel.setBorder(titledBorder28);
            titledBorder28.setBorder(BorderFactory.createEtchedBorder(1));
            gridBagConstraints81.gridx = 1;
            gridBagConstraints81.gridy = 3;
            gridBagConstraints15.gridx = 0;
            gridBagConstraints15.gridy = 2;
            gridBagConstraints15.anchor = 17;
            this.jPanel.add((Component)this.getSeedFileRadioButton(), gridBagConstraints19);
            this.jPanel.add((Component)this.getSeedFileField(), gridBagConstraints12);
            this.jPanel.add((Component)this.getSeedFileButton(), gridBagConstraints13);
            this.jPanel.add((Component)this.getRandomSeedsRadioButton(), gridBagConstraints14);
            this.jPanel.add((Component)this.getJScrollPane(), gridBagConstraints21);
            this.seedButtonGroup = new ButtonGroup();
            this.seedButtonGroup.add(this.getRandomSeedsRadioButton());
            this.seedButtonGroup.add(this.getSeedFileRadioButton());
            this.seedButtonGroup.add(this.getSequentialSeedsRadioButton());
            this.jPanel.add((Component)this.getGenerateSeedsButton(), gridBagConstraints81);
            this.jPanel.add((Component)this.getSequentialSeedsRadioButton(), gridBagConstraints15);
        }
        return this.jPanel;
    }

    JRadioButton getSeedFileRadioButton() {
        if (this.seedFileRadioButton == null) {
            this.seedFileRadioButton = new JRadioButton();
            this.seedFileRadioButton.setText("Seeds from file:");
            final ControlPanel cp = this;
            this.seedFileRadioButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        ControlPanel.this.seedFileField.setEnabled(true);
                        ControlPanel.this.seedFileButton.setEnabled(true);
                        String seedFileName = ControlPanel.this.seedFileField.getText();
                        File seedFile = null;
                        if (seedFileName == null || seedFileName.length() == 0) {
                            FileDialog fileDialog = new FileDialog((Frame)ControlPanel.this.console, "Load...", 0);
                            fileDialog.setDirectory(System.getProperty("user.dir"));
                            fileDialog.setFile("*.seed");
                            fileDialog.setVisible(true);
                            String fileName = fileDialog.getFile();
                            if (fileName != null) {
                                seedFile = new File(fileDialog.getDirectory(), fileName);
                            }
                        } else {
                            seedFile = new File(seedFileName);
                        }
                        if (seedFile != null) {
                            try {
                                cp.loadSeeds(seedFile);
                            }
                            catch (IOException ex) {
                                System.err.println(ex.getMessage());
                            }
                        }
                    } else {
                        ControlPanel.this.seedFileField.setEnabled(false);
                        ControlPanel.this.seedFileButton.setEnabled(false);
                    }
                }
            });
        }
        return this.seedFileRadioButton;
    }

    JTextField getSeedFileField() {
        if (this.seedFileField == null) {
            this.seedFileField = new JTextField();
            this.seedFileField.setEnabled(false);
            this.seedFileField.setEditable(false);
        }
        return this.seedFileField;
    }

    JButton getSeedFileButton() {
        if (this.seedFileButton == null) {
            this.seedFileButton = new JButton();
            this.seedFileButton.setText("...");
            this.seedFileButton.setEnabled(false);
            final ControlPanel cp = this;
            this.seedFileButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File seedFile = null;
                    FileDialog fileDialog = new FileDialog((Frame)ControlPanel.this.console, "Load...", 0);
                    fileDialog.setDirectory(System.getProperty("user.dir"));
                    fileDialog.setFile("*.seed");
                    fileDialog.setVisible(true);
                    String fileName = fileDialog.getFile();
                    if (fileName != null) {
                        seedFile = new File(fileDialog.getDirectory(), fileName);
                    }
                    if (seedFile != null) {
                        try {
                            cp.loadSeeds(seedFile);
                        }
                        catch (IOException ex) {
                            System.err.println(ex.getMessage());
                        }
                    }
                }
            });
        }
        return this.seedFileButton;
    }

    JRadioButton getRandomSeedsRadioButton() {
        if (this.randomSeedsRadioButton == null) {
            this.randomSeedsRadioButton = new JRadioButton();
            this.randomSeedsRadioButton.setText("Random Seeds");
            this.randomSeedsRadioButton.setSelected(true);
            this.randomSeedsRadioButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        ControlPanel.this.generateSeedsButton.setEnabled(true);
                    } else {
                        ControlPanel.this.generateSeedsButton.setEnabled(false);
                    }
                }
            });
        }
        return this.randomSeedsRadioButton;
    }

    JTable getSeedsTable() {
        if (this.seedsTable == null) {
            this.seedsTable = new JTable();
            this.seedsTable.setAutoResizeMode(0);
        }
        return this.seedsTable;
    }

    JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getSeedsTable());
            this.jScrollPane.setHorizontalScrollBarPolicy(32);
        }
        return this.jScrollPane;
    }

    void setEnabled(JPanel panel, boolean enabled) {
        Component[] components = panel.getComponents();
        for (int i = 0; i < components.length; ++i) {
            components[i].setEnabled(enabled);
        }
    }

    JCheckBox getCheckpointCheckBox() {
        if (this.checkpointCheckBox == null) {
            this.checkpointCheckBox = new JCheckBox();
            this.checkpointCheckBox.setText("Checkpoint");
            this.checkpointCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        ControlPanel.this.setEnabled(ControlPanel.this.checkpointPanel, true);
                    } else {
                        ControlPanel.this.setEnabled(ControlPanel.this.checkpointPanel, false);
                    }
                    ControlPanel.this.console.parameters.set(new Parameter("checkpoint"), "" + ((JCheckBox)e.getSource()).isSelected());
                }
            });
        }
        return this.checkpointCheckBox;
    }

    JPanel getCheckpointPanel() {
        if (this.checkpointPanel == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            this.jLabel8 = new JLabel();
            this.jLabel7 = new JLabel();
            GridBagConstraints gridBagConstraints39 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints40 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints41 = new GridBagConstraints();
            this.checkpointPanel = new JPanel();
            this.checkpointPanel.setLayout(new GridBagLayout());
            this.jLabel7.setText("Frequency:");
            this.jLabel7.setEnabled(false);
            gridBagConstraints39.fill = 2;
            gridBagConstraints39.gridx = 1;
            gridBagConstraints39.gridy = 0;
            gridBagConstraints39.ipady = 0;
            gridBagConstraints39.ipadx = 0;
            gridBagConstraints39.weightx = 0.0;
            gridBagConstraints39.insets = new Insets(0, 5, 0, 0);
            this.checkpointPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Checkpointing", 0, 0, null, null));
            this.jLabel8.setText("File Prefix:");
            this.jLabel8.setEnabled(false);
            gridBagConstraints40.gridx = 0;
            gridBagConstraints40.gridy = 1;
            gridBagConstraints40.anchor = 17;
            gridBagConstraints41.gridx = 1;
            gridBagConstraints41.gridy = 1;
            gridBagConstraints41.fill = 2;
            gridBagConstraints41.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints41.gridwidth = 2;
            gridBagConstraints41.weightx = 0.5;
            gridBagConstraints3.anchor = 17;
            this.checkpointPanel.add((Component)this.jLabel7, gridBagConstraints3);
            this.checkpointPanel.add((Component)this.getCheckpointModuloField(), gridBagConstraints39);
            this.checkpointPanel.add((Component)this.jLabel8, gridBagConstraints40);
            this.checkpointPanel.add((Component)this.getPrefixField(), gridBagConstraints41);
        }
        return this.checkpointPanel;
    }

    JTextField getCheckpointModuloField() {
        if (this.checkpointModuloField == null) {
            this.checkpointModuloField = new JTextField();
            this.checkpointModuloField.setPreferredSize(new Dimension(35, 20));
            this.checkpointModuloField.setEnabled(false);
            this.checkpointModuloField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        ControlPanel.this.console.parameters.set(new Parameter("checkpoint-modulo"), ((JTextField)e.getSource()).getText());
                    } else if (e.getKeyCode() == 27) {
                        ((JTextField)e.getSource()).setText(ControlPanel.this.console.parameters.getString(new Parameter("checkpoint-modulo"), null));
                    }
                }
            });
            this.checkpointModuloField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    ControlPanel.this.console.parameters.set(new Parameter("checkpoint-modulo"), ((JTextField)e.getSource()).getText());
                }
            });
        }
        return this.checkpointModuloField;
    }

    JTextField getPrefixField() {
        if (this.prefixField == null) {
            this.prefixField = new JTextField();
            this.prefixField.setEnabled(false);
            this.prefixField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        ControlPanel.this.console.parameters.set(new Parameter("checkpoint-prefix"), ((JTextField)e.getSource()).getText());
                    } else if (e.getKeyCode() == 27) {
                        ((JTextField)e.getSource()).setText(ControlPanel.this.console.parameters.getString(new Parameter("checkpoint-prefix"), null));
                    }
                }
            });
            this.prefixField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    ControlPanel.this.console.parameters.set(new Parameter("checkpoint-prefix"), ((JTextField)e.getSource()).getText());
                }
            });
        }
        return this.prefixField;
    }

    public void loadParameters() {
        this.numGensField.setText(this.console.parameters.getStringWithDefault(new Parameter("generations"), null, "1"));
        this.quitOnRunCompleteCheckbox.setSelected(this.console.parameters.getBoolean(new Parameter("quit-on-run-complete"), null, true));
        this.evalThreadsField.setText(this.console.parameters.getStringWithDefault(new Parameter("evalthreads"), null, "1"));
        this.breedThreadsField.setText(this.console.parameters.getStringWithDefault(new Parameter("breedthreads"), null, "1"));
        this.checkpointCheckBox.setSelected(this.console.parameters.getBoolean(new Parameter("checkpoint"), null, false));
        this.checkpointModuloField.setText(this.console.parameters.getStringWithDefault(new Parameter("checkpoint-modulo"), null, "10"));
        this.prefixField.setText(this.console.parameters.getStringWithDefault(new Parameter("checkpoint-prefix"), null, "gc"));
        this.numJobsField.setText("1");
        this.jobFilePrefixField.setText(this.console.parameters.getStringWithDefault(new Parameter(P_JOBFILEPREFIX), null, ""));
        this.resizeSeedTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadSeeds(File f) throws IOException {
        BufferedReader in = null;
        try {
            int job;
            in = new LineNumberReader(new InputStreamReader(new FileInputStream(f)));
            this.seedFileField.setText(f.getAbsolutePath());
            int numJobs = 0;
            try {
                numJobs = Integer.parseInt(this.numJobsField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            int evalThreads = this.getThreadCount(this.console.parameters.getString(new Parameter("evalthreads"), null));
            int breedThreads = this.getThreadCount(this.console.parameters.getString(new Parameter("breedthreads"), null));
            int numThreads = Math.max(evalThreads, breedThreads);
            int thread = 0;
            String lastSeed = null;
            for (job = 0; job < numJobs; ++job) {
                String seed = null;
                while (thread < numThreads && (seed = ((LineNumberReader)in).readLine()) != null) {
                    this.setSeed(seed, job, thread);
                    lastSeed = seed;
                    ++thread;
                }
                if (seed == null) break;
                thread = 0;
            }
            if (job * thread != numJobs * numThreads) {
                int seedNum = Integer.valueOf(lastSeed);
                while (job < numJobs) {
                    while (thread < numThreads) {
                        String seed = "" + ++seedNum;
                        this.setSeed(seed, job, thread);
                        ++thread;
                    }
                    thread = 0;
                    ++job;
                }
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    JButton getGenerateSeedsButton() {
        if (this.generateSeedsButton == null) {
            this.generateSeedsButton = new JButton();
            this.generateSeedsButton.setText("Generate");
            this.generateSeedsButton.setEnabled(false);
            this.generateSeedsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ControlPanel.this.generateRandomSeeds();
                }
            });
        }
        return this.generateSeedsButton;
    }

    JRadioButton getSequentialSeedsRadioButton() {
        if (this.sequentialSeedsRadioButton == null) {
            this.sequentialSeedsRadioButton = new JRadioButton();
            this.sequentialSeedsRadioButton.setText("Sequential");
            this.sequentialSeedsRadioButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        ControlPanel.this.resizeSeedTable();
                    }
                }
            });
        }
        return this.sequentialSeedsRadioButton;
    }

    JTextField getJobFilePrefixField() {
        if (this.jobFilePrefixField == null) {
            this.jobFilePrefixField = new JTextField();
            this.jobFilePrefixField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        ControlPanel.this.console.parameters.set(new Parameter(ControlPanel.P_JOBFILEPREFIX), ((JTextField)e.getSource()).getText());
                    } else if (e.getKeyCode() == 27) {
                        ((JTextField)e.getSource()).setText(ControlPanel.this.console.parameters.getStringWithDefault(new Parameter(ControlPanel.P_JOBFILEPREFIX), null, ""));
                    }
                }
            });
        }
        return this.jobFilePrefixField;
    }

    public String getJobFilePrefix() {
        return this.jobFilePrefixField.getText();
    }
}

