/*
 * Decompiled with CFR 0.152.
 */
package ec.eda.amalgam;

import ec.ECDefaults;
import ec.EvolutionState;
import ec.Individual;
import ec.Subpopulation;
import ec.eda.amalgam.AMALGAMDefaults;
import ec.util.MersenneTwisterFast;
import ec.util.Parameter;
import ec.vector.DoubleVectorIndividual;
import ec.vector.FloatVectorSpecies;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.interfaces.decomposition.CholeskyDecomposition;
import org.ejml.ops.CommonOps;

public class AMALGAMSpecies
extends FloatVectorSpecies {
    public static final String P_AMALGAM_SPECIES = "species";
    public static final String P_TAU = "tau";
    public static final String P_ETA_DEC = "eta-dec";
    public static final String P_THETA_SDR = "theta-sdr";
    public static final String P_ETA_SHIFT = "eta-shift";
    public static final String P_ETA_SIGMA = "eta-sigma";
    public static final String P_NIS_MAX = "nis-max";
    public static final String P_VARIANCE_TOLERANCE = "variance-tolerance";
    public static final String P_DELTA_AMS = "delta-ams";
    public static final String P_ALPHA_AMS = "alpha-ams";
    public static final String P_ALTERNATIVE_TERMINATION = "alternative-termination";
    public static final int P_PARAMETER_MISSING = -1;
    public boolean useAltTermination;
    public double tau;
    public double fitnessVarianceTolerance = 0.0;
    public int maximumNoImprovementStretch = 0;
    public int noImprovementStretch = 0;
    public double alphaAMS;
    public double userAlphaAMS;
    public double deltaAMS;
    public double etaP;
    public double userEtaP;
    public double etaS;
    public double userEtaS;
    public double distributionMultiplierDecrease;
    public double distributionMultiplierIncrease;
    public double distributionMultiplier;
    public double stDevRatioThresh;
    public DenseMatrix64F mean;
    public DenseMatrix64F prevMean;
    public DenseMatrix64F xAvgImp;
    public DenseMatrix64F meanShift;
    public DenseMatrix64F genCovarMatrix;
    public DenseMatrix64F aggCovarMatrix;
    public DenseMatrix64F covarMatrix;
    public DenseMatrix64F choleskyLower;
    public DenseMatrix64F temp;
    public DenseMatrix64F temp2;
    public DenseMatrix64F temp3;
    public DenseMatrix64F tempMatrix;
    public IdentityHashMap<Individual, Integer> constraintViolations;
    public boolean firstGeneration;

    @Override
    public Parameter defaultBase() {
        return AMALGAMDefaults.base().push(P_AMALGAM_SPECIES);
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        Parameter subpopBase = base.pop();
        Parameter subpopDefaultBase = ECDefaults.base().push("subpop");
        this.useAltTermination = state.parameters.getBoolean(base.push(P_ALTERNATIVE_TERMINATION), def.push(P_ALTERNATIVE_TERMINATION), false);
        if (!state.parameters.exists(base.push(P_TAU), def.push(P_TAU))) {
            state.output.message("AMALGAM tau was not provided, defaulting to 0.35");
            this.tau = 0.35;
        } else {
            this.tau = state.parameters.getDouble(base.push(P_TAU), def.push(P_TAU), 0.0);
            if (this.tau < 0.0 || this.tau > 1.0) {
                state.output.fatal("If AMALGAM tau is provided, it must be a valid number in the range [0,1]", base.push(P_TAU), def.push(P_TAU));
            }
        }
        if (!state.parameters.exists(base.push(P_ETA_DEC), def.push(P_ETA_DEC))) {
            state.output.message("AMALGAM eta-dec was not provided, defaulting to 0.9");
            this.distributionMultiplierDecrease = 0.9;
        } else {
            this.distributionMultiplierDecrease = state.parameters.getDouble(base.push(P_ETA_DEC), def.push(P_ETA_DEC), 0.0);
            if (this.distributionMultiplierDecrease < 0.0 || this.distributionMultiplierDecrease > 1.0) {
                state.output.fatal("If AMALGAM eta-dec is provided, it must be a valid number in the range [0,1]", base.push(P_ETA_DEC), def.push(P_ETA_DEC));
            }
        }
        this.distributionMultiplier = 1.0;
        this.distributionMultiplierIncrease = 1.0 / this.distributionMultiplierDecrease;
        if (!state.parameters.exists(base.push(P_THETA_SDR), def.push(P_THETA_SDR))) {
            state.output.message("AMALGAM theta-sdr was not provided, defaulting to 1.0");
            this.stDevRatioThresh = 1.0;
        } else {
            this.stDevRatioThresh = state.parameters.getDouble(base.push(P_THETA_SDR), def.push(P_THETA_SDR), 1.0);
            if (this.stDevRatioThresh < 0.0) {
                state.output.fatal("If AMALGAM theta-sdr is provided, it must be >= 0", base.push(P_THETA_SDR), def.push(P_THETA_SDR));
            }
        }
        if (!state.parameters.exists(base.push(P_VARIANCE_TOLERANCE), def.push(P_VARIANCE_TOLERANCE))) {
            state.output.message("AMALGAM variance-tolerance was not provided, defaulting to 0.0");
            this.fitnessVarianceTolerance = 0.0;
        } else {
            this.fitnessVarianceTolerance = state.parameters.getDouble(base.push(P_VARIANCE_TOLERANCE), def.push(P_VARIANCE_TOLERANCE), 0.0);
            if (this.fitnessVarianceTolerance < 0.0) {
                state.output.fatal("If AMALGAM variance-tolerance is provided, it must be >= 0", base.push(P_VARIANCE_TOLERANCE), def.push(P_VARIANCE_TOLERANCE));
            }
        }
        this.noImprovementStretch = 0;
        if (!state.parameters.exists(base.push(P_NIS_MAX), def.push(P_NIS_MAX))) {
            this.maximumNoImprovementStretch = 25 + this.genomeSize;
        } else {
            this.maximumNoImprovementStretch = state.parameters.getInt(base.push(P_NIS_MAX), def.push(P_NIS_MAX), 0);
            if (this.maximumNoImprovementStretch <= 0) {
                state.output.fatal("If AMALGAM nis-max is provided, it must be a valid integer > 0", base.push(P_NIS_MAX), def.push(P_NIS_MAX));
            }
        }
        if (!state.parameters.exists(base.push(P_DELTA_AMS), def.push(P_DELTA_AMS))) {
            state.output.message("AMALGAM delta-ams was not provided, defaulting to 2.0");
            this.deltaAMS = 2.0;
        } else {
            this.deltaAMS = state.parameters.getDouble(base.push(P_DELTA_AMS), def.push(P_DELTA_AMS), 0.0);
            if (this.deltaAMS <= 0.0) {
                state.output.fatal("If AMALGAM delta-ams is provided, it must be > 0", base.push(P_DELTA_AMS), def.push(P_DELTA_AMS));
            }
        }
        if (!state.parameters.exists(base.push(P_ALPHA_AMS), def.push(P_ALPHA_AMS))) {
            this.userAlphaAMS = -1.0;
        } else {
            this.userAlphaAMS = state.parameters.getDouble(base.push(P_ALPHA_AMS), def.push(P_ALPHA_AMS), -1.0);
            if (this.userAlphaAMS <= 0.0) {
                state.output.fatal("If AMALGAM alpha-ams is provided, it must be > 0", base.push(P_ALPHA_AMS), def.push(P_ALPHA_AMS));
            }
        }
        if (!state.parameters.exists(base.push(P_ETA_SHIFT), def.push(P_ETA_SHIFT))) {
            this.userEtaP = -1.0;
        } else {
            this.userEtaP = state.parameters.getDouble(base.push(P_ETA_SHIFT), def.push(P_ETA_SHIFT), -1.0);
            if (this.userEtaP < 0.0 || this.userEtaP > 1.0) {
                state.output.fatal("If AMALGAM eta-shift is provided, it must be a valid number in the range [0,1]", base.push(P_ETA_SHIFT), def.push(P_ETA_SHIFT));
            }
        }
        if (!state.parameters.exists(base.push(P_ETA_SIGMA), def.push(P_ETA_SIGMA))) {
            this.userEtaS = -1.0;
        } else {
            this.userEtaS = state.parameters.getDouble(base.push(P_ETA_SIGMA), def.push(P_ETA_SIGMA), -1.0);
            if (this.userEtaS < 0.0 || this.userEtaS > 1.0) {
                state.output.fatal("If AMALGAM eta-sigma is provided, it must be a valid number in the range [0,1]", base.push(P_ETA_SIGMA), def.push(P_ETA_SIGMA));
            }
        }
        this.alphaAMS = this.userAlphaAMS;
        this.etaP = this.userEtaP;
        this.etaS = this.userEtaS;
        this.mean = new DenseMatrix64F(this.genomeSize, 1);
        this.prevMean = new DenseMatrix64F(this.genomeSize, 1);
        this.xAvgImp = new DenseMatrix64F(this.genomeSize, 1);
        this.meanShift = new DenseMatrix64F(this.genomeSize, 1);
        this.genCovarMatrix = CommonOps.identity((int)this.genomeSize);
        this.aggCovarMatrix = CommonOps.identity((int)this.genomeSize);
        this.covarMatrix = CommonOps.identity((int)this.genomeSize);
        this.choleskyLower = CommonOps.identity((int)this.genomeSize);
        this.temp = new DenseMatrix64F(this.genomeSize, 1);
        this.temp3 = new DenseMatrix64F(this.genomeSize, 1);
        this.temp2 = new DenseMatrix64F(1, this.genomeSize);
        this.tempMatrix = new DenseMatrix64F(this.genomeSize, this.genomeSize);
        this.firstGeneration = true;
    }

    @Override
    public Object clone() {
        AMALGAMSpecies myobj = (AMALGAMSpecies)super.clone();
        myobj.fitnessVarianceTolerance = this.fitnessVarianceTolerance;
        this.noImprovementStretch = 0;
        myobj.noImprovementStretch = 0;
        this.maximumNoImprovementStretch = 0;
        myobj.maximumNoImprovementStretch = 0;
        myobj.tau = this.tau;
        myobj.alphaAMS = this.alphaAMS;
        myobj.deltaAMS = this.deltaAMS;
        myobj.userEtaP = this.userEtaP;
        myobj.userEtaS = this.userEtaS;
        myobj.distributionMultiplier = this.distributionMultiplier;
        myobj.distributionMultiplierDecrease = this.distributionMultiplierDecrease;
        myobj.distributionMultiplierIncrease = this.distributionMultiplierIncrease;
        myobj.stDevRatioThresh = this.stDevRatioThresh;
        myobj.mean.set((D1Matrix64F)this.mean);
        myobj.prevMean.set((D1Matrix64F)this.prevMean);
        myobj.xAvgImp.set((D1Matrix64F)this.xAvgImp);
        myobj.meanShift.set((D1Matrix64F)this.meanShift);
        myobj.genCovarMatrix.set((D1Matrix64F)this.genCovarMatrix);
        myobj.aggCovarMatrix.set((D1Matrix64F)this.aggCovarMatrix);
        myobj.covarMatrix.set((D1Matrix64F)this.covarMatrix);
        myobj.choleskyLower.set((D1Matrix64F)this.choleskyLower);
        myobj.constraintViolations = (IdentityHashMap)this.constraintViolations.clone();
        return myobj;
    }

    public void computeConstraintViolations(EvolutionState state, Subpopulation subpop) {
        this.constraintViolations = new IdentityHashMap();
        for (int i = 0; i < subpop.individuals.size(); ++i) {
            int cv = 0;
            DoubleVectorIndividual dvind = (DoubleVectorIndividual)subpop.individuals.get(i);
            for (int j = 0; j < this.genomeSize; ++j) {
                if (!(dvind.genome[j] < this.minGene(j)) && !(dvind.genome[j] > this.maxGene(j))) continue;
                ++cv;
            }
            this.constraintViolations.put(subpop.individuals.get(i), cv);
        }
    }

    public int compareIndividuals(Individual a, Individual b) {
        int constraintViolationB;
        int constraintViolationA = this.constraintViolations.get(a);
        if (constraintViolationA < (constraintViolationB = this.constraintViolations.get(b).intValue())) {
            return -1;
        }
        if (constraintViolationB < constraintViolationA) {
            return 1;
        }
        return a.compareTo(b);
    }

    public boolean isValid(DoubleVectorIndividual dvind) {
        for (int i = 0; i < this.genomeSize; ++i) {
            if (!(dvind.genome[i] < this.minGene(i)) && !(dvind.genome[i] > this.maxGene(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Individual newIndividual(EvolutionState state, int thread) {
        Individual newind;
        block5: {
            int i;
            newind = super.newIndividual(state, thread);
            MersenneTwisterFast random = state.random[thread];
            if (!(newind instanceof DoubleVectorIndividual)) {
                state.output.fatal("To use AMALGAMSpecies, the species must be initialized with a DoubleVectorIndividual.  But it contains a " + String.valueOf(newind));
            }
            DoubleVectorIndividual dvind = (DoubleVectorIndividual)newind;
            DenseMatrix64F genome = DenseMatrix64F.wrap((int)this.genomeSize, (int)1, (double[])dvind.genome);
            while (!this.firstGeneration) {
                for (i = 0; i < this.genomeSize; ++i) {
                    dvind.genome[i] = random.nextGaussian();
                }
                CommonOps.mult((RowD1Matrix64F)this.choleskyLower, (RowD1Matrix64F)genome, (RowD1Matrix64F)this.temp);
                CommonOps.add((D1Matrix64F)this.temp, (D1Matrix64F)this.mean, (D1Matrix64F)genome);
                if (!this.isValid(dvind)) {
                    continue;
                }
                break block5;
            }
            for (i = 0; i < this.genomeSize; ++i) {
                dvind.genome[i] = this.minGene(i) + (this.maxGene[i] - this.minGene(i)) * random.nextDouble();
            }
        }
        return newind;
    }

    public void adaptDistributionMultiplier(EvolutionState state, Subpopulation subpop) {
        boolean improved = false;
        int i = 1;
        while ((double)i < this.tau * (double)subpop.individuals.size()) {
            if (this.compareIndividuals(subpop.individuals.get(i), subpop.individuals.get(0)) < 0) {
                improved = true;
                break;
            }
            ++i;
        }
        if (improved) {
            this.noImprovementStretch = 0;
            if (this.distributionMultiplier < 1.0) {
                this.distributionMultiplier = 1.0;
            }
            this.xAvgImp = new DenseMatrix64F(this.genomeSize, 1);
            int count = 0;
            int j = 1;
            while ((double)j < this.tau * (double)subpop.individuals.size()) {
                if (this.compareIndividuals(subpop.individuals.get(j), subpop.individuals.get(0)) < 0) {
                    DoubleVectorIndividual dvind = (DoubleVectorIndividual)subpop.individuals.get(j);
                    DenseMatrix64F genome = DenseMatrix64F.wrap((int)this.genomeSize, (int)1, (double[])dvind.genome);
                    CommonOps.add((D1Matrix64F)this.xAvgImp, (D1Matrix64F)genome, (D1Matrix64F)this.xAvgImp);
                    ++count;
                }
                ++j;
            }
            CommonOps.scale((double)(1.0 / (double)count), (D1Matrix64F)this.xAvgImp, (D1Matrix64F)this.xAvgImp);
            CommonOps.subtract((D1Matrix64F)this.xAvgImp, (D1Matrix64F)this.mean, (D1Matrix64F)this.temp);
            CommonOps.invert((DenseMatrix64F)this.choleskyLower, (DenseMatrix64F)this.tempMatrix);
            CommonOps.mult((RowD1Matrix64F)this.tempMatrix, (RowD1Matrix64F)this.temp, (RowD1Matrix64F)this.temp3);
            double sdr = CommonOps.elementMaxAbs((D1Matrix64F)this.temp3);
            if (sdr > this.stDevRatioThresh) {
                this.distributionMultiplier *= this.distributionMultiplierIncrease;
            }
        } else {
            if (this.distributionMultiplier <= 1.0) {
                ++this.noImprovementStretch;
            }
            if (this.distributionMultiplier > 1.0 || this.noImprovementStretch > this.maximumNoImprovementStretch) {
                this.distributionMultiplier *= this.distributionMultiplierDecrease;
            }
            if (this.distributionMultiplier < 1.0 && this.noImprovementStretch < this.maximumNoImprovementStretch) {
                this.distributionMultiplier = 1.0;
            }
        }
    }

    public void selectForDiversity(EvolutionState state, Subpopulation subpop) {
        DoubleVectorIndividual dvind;
        int numBest;
        DoubleVectorIndividual bestInd = (DoubleVectorIndividual)subpop.individuals.get(0);
        for (numBest = 1; numBest < subpop.individuals.size() && (dvind = (DoubleVectorIndividual)subpop.individuals.get(numBest)).compareTo(bestInd) == 0; ++numBest) {
        }
        int numSelectedSoFar = 1;
        double[] distances = new double[numBest];
        Arrays.fill(distances, Double.POSITIVE_INFINITY);
        while ((double)numSelectedSoFar < this.tau * (double)subpop.individuals.size()) {
            double farthest = -1.0;
            for (int i = numSelectedSoFar; i < numBest; ++i) {
                double distance = subpop.individuals.get(numSelectedSoFar - 1).distanceTo(subpop.individuals.get(i));
                if (distance < distances[i]) {
                    distances[i] = distance;
                }
                if (!(distances[i] > farthest)) continue;
                farthest = distances[i];
                Individual tmp = subpop.individuals.get(i);
                subpop.individuals.set(i, subpop.individuals.get(numSelectedSoFar));
                subpop.individuals.set(numSelectedSoFar, tmp);
            }
            ++numSelectedSoFar;
        }
    }

    public void computeMean(EvolutionState state, Subpopulation subpop) {
        this.prevMean.set((D1Matrix64F)this.mean);
        CommonOps.fill((D1Matrix64F)this.mean, (double)0.0);
        if (this.distributionMultiplier >= 1.0) {
            int i = 0;
            while ((double)i < this.tau * (double)subpop.individuals.size()) {
                DoubleVectorIndividual dvind = (DoubleVectorIndividual)subpop.individuals.get(i);
                DenseMatrix64F genome = DenseMatrix64F.wrap((int)this.genomeSize, (int)1, (double[])dvind.genome);
                CommonOps.add((D1Matrix64F)this.mean, (D1Matrix64F)genome, (D1Matrix64F)this.mean);
                ++i;
            }
            CommonOps.scale((double)(1.0 / (double)i), (D1Matrix64F)this.mean, (D1Matrix64F)this.mean);
        } else {
            DoubleVectorIndividual dvind = (DoubleVectorIndividual)subpop.individuals.get(0);
            this.mean.set((D1Matrix64F)DenseMatrix64F.wrap((int)this.genomeSize, (int)1, (double[])dvind.genome));
        }
    }

    public void computeCovariance(EvolutionState state, Subpopulation subpop) {
        CommonOps.fill((D1Matrix64F)this.genCovarMatrix, (double)0.0);
        int i = 0;
        while ((double)i < this.tau * (double)subpop.individuals.size()) {
            DoubleVectorIndividual dvind = (DoubleVectorIndividual)subpop.individuals.get(i);
            DenseMatrix64F genome = DenseMatrix64F.wrap((int)this.genomeSize, (int)1, (double[])dvind.genome);
            CommonOps.subtract((D1Matrix64F)genome, (D1Matrix64F)this.mean, (D1Matrix64F)this.temp);
            CommonOps.transpose((DenseMatrix64F)this.temp, (DenseMatrix64F)this.temp2);
            CommonOps.multAdd((RowD1Matrix64F)this.temp, (RowD1Matrix64F)this.temp2, (RowD1Matrix64F)this.genCovarMatrix);
            ++i;
        }
        CommonOps.scale((double)(1.0 / (double)i), (D1Matrix64F)this.genCovarMatrix, (D1Matrix64F)this.genCovarMatrix);
        if (!this.firstGeneration) {
            CommonOps.scale((double)this.etaS, (D1Matrix64F)this.genCovarMatrix, (D1Matrix64F)this.genCovarMatrix);
            CommonOps.scale((double)(1.0 - this.etaS), (D1Matrix64F)this.aggCovarMatrix, (D1Matrix64F)this.aggCovarMatrix);
            CommonOps.add((D1Matrix64F)this.aggCovarMatrix, (D1Matrix64F)this.genCovarMatrix, (D1Matrix64F)this.aggCovarMatrix);
        } else {
            this.aggCovarMatrix.set((D1Matrix64F)this.genCovarMatrix);
        }
        CommonOps.scale((double)this.distributionMultiplier, (D1Matrix64F)this.aggCovarMatrix, (D1Matrix64F)this.covarMatrix);
        for (i = 0; i < this.genomeSize; ++i) {
            for (int j = 0; j < i; ++j) {
                this.covarMatrix.set(i, j, this.covarMatrix.get(j, i));
            }
        }
    }

    public void computeAMS(EvolutionState state, Subpopulation subpop) {
        CommonOps.subtract((D1Matrix64F)this.mean, (D1Matrix64F)this.prevMean, (D1Matrix64F)this.temp);
        if (!this.firstGeneration) {
            CommonOps.scale((double)this.etaP, (D1Matrix64F)this.temp);
            CommonOps.scale((double)(1.0 - this.etaP), (D1Matrix64F)this.meanShift);
            CommonOps.add((D1Matrix64F)this.meanShift, (D1Matrix64F)this.temp, (D1Matrix64F)this.meanShift);
        } else {
            this.meanShift.set((D1Matrix64F)this.temp);
        }
    }

    public void updateDistribution(EvolutionState state, Subpopulation subpop) {
        CommonOps.fill((D1Matrix64F)this.temp, (double)0.0);
        CommonOps.fill((D1Matrix64F)this.temp3, (double)0.0);
        CommonOps.fill((D1Matrix64F)this.temp2, (double)0.0);
        CommonOps.fill((D1Matrix64F)this.tempMatrix, (double)0.0);
        if (this.userEtaP == -1.0) {
            this.etaP = 1.0 - Math.exp(-1.2 * Math.pow((int)(this.tau * (double)subpop.individuals.size()), 0.31) / Math.pow(this.genomeSize, 0.5));
        }
        if (this.userEtaS == -1.0) {
            this.etaS = 1.0 - Math.exp(-1.1 * Math.pow((int)(this.tau * (double)subpop.individuals.size()), 1.2) / Math.pow(this.genomeSize, 1.6));
        }
        if (this.userAlphaAMS == -1.0) {
            this.alphaAMS = 0.5 * this.tau * (double)subpop.individuals.size() / (double)(subpop.individuals.size() - 1);
        }
        this.computeConstraintViolations(state, subpop);
        if (!this.firstGeneration) {
            this.adaptDistributionMultiplier(state, subpop);
        }
        Collections.sort(subpop.individuals, new Comparator<Individual>(){

            @Override
            public int compare(Individual a, Individual b) {
                return AMALGAMSpecies.this.compareIndividuals(a, b);
            }
        });
        if (subpop.individuals.get((int)((int)this.tau * subpop.individuals.size())).fitness.fitness() == subpop.individuals.get((int)0).fitness.fitness()) {
            this.selectForDiversity(state, subpop);
        }
        if (this.checkTerminationConditions(state, subpop)) {
            state.evaluator.setRunComplete("AMALGAMSpecies: Termination condition reached.");
        }
        this.computeMean(state, subpop);
        this.computeCovariance(state, subpop);
        this.computeAMS(state, subpop);
        CholeskyDecomposition chol = DecompositionFactory.chol((int)this.genomeSize, (boolean)true);
        this.tempMatrix.set((D1Matrix64F)this.covarMatrix);
        if (!chol.decompose((Matrix)this.tempMatrix)) {
            chol.getT((Matrix)this.choleskyLower);
        } else {
            chol.getT((Matrix)this.choleskyLower);
        }
    }

    public boolean checkTerminationConditions(EvolutionState state, Subpopulation subpop) {
        DoubleVectorIndividual dvind;
        int i;
        if (!this.useAltTermination) {
            return false;
        }
        if (this.distributionMultiplier < 1.0E-10) {
            return true;
        }
        double avg = 0.0;
        double var = 0.0;
        for (i = 0; i < subpop.individuals.size(); ++i) {
            dvind = (DoubleVectorIndividual)subpop.individuals.get(i);
            avg += dvind.fitness.fitness();
        }
        avg /= (double)subpop.individuals.size();
        for (i = 0; i < subpop.individuals.size(); ++i) {
            dvind = (DoubleVectorIndividual)subpop.individuals.get(i);
            var += (dvind.fitness.fitness() - avg) * (dvind.fitness.fitness() - avg);
        }
        if ((var /= (double)subpop.individuals.size()) <= 0.0) {
            var = 0.0;
        }
        return var < this.fitnessVarianceTolerance;
    }

    public void shiftIndividual(EvolutionState state, DoubleVectorIndividual ind) {
        DenseMatrix64F genome = DenseMatrix64F.wrap((int)this.genomeSize, (int)1, (double[])ind.genome);
        double shiftMult = 1.0;
        this.temp.set((D1Matrix64F)genome);
        do {
            genome.set((D1Matrix64F)this.temp);
            CommonOps.add((double)(shiftMult * this.deltaAMS * this.distributionMultiplier), (D1Matrix64F)this.meanShift, (D1Matrix64F)genome, (D1Matrix64F)genome);
        } while (!this.isValid(ind) && (shiftMult *= 0.5) > 1.0E-10);
    }
}

