/*
 * Decompiled with CFR 0.152.
 */
package ec.eda.cmaes;

import ec.ECDefaults;
import ec.EvolutionState;
import ec.Individual;
import ec.Subpopulation;
import ec.eda.cmaes.CMAESDefaults;
import ec.util.MersenneTwisterFast;
import ec.util.Parameter;
import ec.vector.DoubleVectorIndividual;
import ec.vector.FloatVectorSpecies;
import java.util.Collections;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix;
import org.ejml.data.RealMatrix64F;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.interfaces.decomposition.EigenDecomposition;
import org.ejml.ops.CommonOps;
import org.ejml.simple.SimpleBase;
import org.ejml.simple.SimpleMatrix;

public class CMAESSpecies
extends FloatVectorSpecies {
    public static final String P_CMAES_SPECIES = "cma-es.species";
    public static final String P_LAMBDA = "lambda";
    public static final String P_MU = "mu";
    public static final String P_SIGMA = "sigma";
    public static final String P_MEAN = "mean";
    public static final String P_WEIGHTS = "weight";
    public static final String P_CC = "cc";
    public static final String P_CS = "cs";
    public static final String P_C1 = "c1";
    public static final String P_CMU = "cmu";
    public static final String P_DAMPS = "damps";
    public static final String V_CENTER = "center";
    public static final String V_ZERO = "zero";
    public static final String V_RANDOM = "random";
    public static final String P_COVARIANCE = "covariance";
    public static final String V_IDENTITY = "identity";
    public static final String V_SCALED = "scaled";
    public static final String P_ALTERNATIVE_TERMINATION = "alternative-termination";
    public static final String P_ALTERNATIVE_GENERATOR = "alternative-generator";
    public static final String P_ALTERNATIVE_GENERATOR_TRIES = "alternative-generator-tries";
    public int lambda;
    public int mu;
    public double[] weights;
    public double mueff;
    public double cmu;
    public double c1;
    public double cc;
    public double cs;
    public double damps;
    public double sigma;
    public SimpleMatrix xmean;
    public SimpleMatrix c;
    public SimpleMatrix b;
    public SimpleMatrix d;
    public DenseMatrix64F bd;
    public DenseMatrix64F sbd;
    public SimpleMatrix invsqrtC;
    public SimpleMatrix ps;
    public SimpleMatrix pc;
    public double chiN;
    public int lastEigenDecompositionGeneration = -1;
    public boolean useAltTermination;
    public boolean useAltGenerator;
    public int altGeneratorTries = 100;
    public static final int DEFAULT_ALT_GENERATOR_TRIES = 100;
    public static final int MAX_TRIES_BEFORE_WARNING = 100000;

    @Override
    public Parameter defaultBase() {
        return CMAESDefaults.base().push(P_CMAES_SPECIES);
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        int i;
        int i2;
        int i3;
        super.setup(state, base);
        MersenneTwisterFast random = state.random[0];
        Parameter def = this.defaultBase();
        Parameter subpopBase = base.pop();
        Parameter subpopDefaultBase = ECDefaults.base().push("subpop");
        if (!state.parameters.exists(base.push(P_SIGMA), def.push(P_SIGMA))) {
            state.output.message("CMA-ES sigma was not provided, defaulting to 1.0");
            this.sigma = 1.0;
        } else {
            this.sigma = state.parameters.getDouble(base.push(P_SIGMA), def.push(P_SIGMA), 0.0);
            if (this.sigma <= 0.0) {
                state.output.fatal("If CMA-ES sigma is provided, it must be > 0.0", base.push(P_SIGMA), def.push(P_SIGMA));
            }
        }
        double[] cvals = new double[this.genomeSize];
        String covarianceInitialization = state.parameters.getStringWithDefault(base.push(P_COVARIANCE), def.push(P_COVARIANCE), V_IDENTITY);
        Object covs = "Initial Covariance: <";
        for (int i4 = 0; i4 < this.genomeSize; ++i4) {
            if (i4 > 0) {
                covs = (String)covs + ", ";
            }
            if (covarianceInitialization.equals(V_SCALED)) {
                cvals[i4] = this.maxGene(i4) - this.minGene(i4);
            } else if (covarianceInitialization.equals(V_IDENTITY)) {
                cvals[i4] = 1.0;
            } else {
                state.output.fatal("Invalid covariance initialization type " + covarianceInitialization, base.push(P_COVARIANCE), def.push(P_COVARIANCE));
            }
            int n = i4;
            cvals[n] = cvals[n] * cvals[i4];
            covs = (String)covs + cvals[i4];
        }
        state.output.message((String)covs + ">");
        int n = this.genomeSize;
        this.b = SimpleMatrix.identity((int)n);
        this.c = new SimpleMatrix(CommonOps.diag((double[])cvals));
        this.d = SimpleMatrix.identity((int)n);
        this.bd = CommonOps.identity((int)n, (int)n);
        this.sbd = CommonOps.identity((int)n, (int)n);
        this.invsqrtC = SimpleMatrix.identity((int)n);
        EigenDecomposition eig = DecompositionFactory.eig((int)this.genomeSize, (boolean)true, (boolean)true);
        if (eig.decompose((Matrix)((SimpleMatrix)this.c.copy()).getMatrix())) {
            SimpleMatrix dinv = new SimpleMatrix(this.genomeSize, this.genomeSize);
            for (int i5 = 0; i5 < this.genomeSize; ++i5) {
                double eigrt = Math.sqrt(eig.getEigenvalue((int)i5).real);
                this.d.set(i5, i5, eigrt);
                dinv.set(i5, i5, 1.0 / eigrt);
                CommonOps.insert((RealMatrix64F)((RealMatrix64F)eig.getEigenVector(i5)), (RealMatrix64F)this.b.getMatrix(), (int)0, (int)i5);
            }
            this.invsqrtC = (SimpleMatrix)this.b.mult((SimpleBase)((SimpleMatrix)dinv.mult((SimpleBase)((SimpleMatrix)this.b.transpose()))));
            CommonOps.mult((RowD1Matrix64F)this.b.getMatrix(), (RowD1Matrix64F)this.d.getMatrix(), (RowD1Matrix64F)this.bd);
        } else {
            state.output.fatal("CMA-ES eigendecomposition failed. ");
        }
        CommonOps.scale((double)this.sigma, (D1Matrix64F)this.bd, (D1Matrix64F)this.sbd);
        this.pc = new SimpleMatrix(n, 1);
        this.ps = new SimpleMatrix(n, 1);
        this.chiN = Math.sqrt(n) * (1.0 - 1.0 / (4.0 * (double)n) + 1.0 / (21.0 * (double)n * (double)n));
        this.xmean = new SimpleMatrix(this.genomeSize, 1);
        boolean meanSpecified = false;
        String val = state.parameters.getString(base.push(P_MEAN), def.push(P_MEAN));
        if (val != null) {
            meanSpecified = true;
            if (val.equals(V_CENTER)) {
                for (int i6 = 0; i6 < this.genomeSize; ++i6) {
                    this.xmean.set(i6, 0, (this.maxGene(i6) + this.minGene(i6)) / 2.0);
                }
            } else if (val.equals(V_ZERO)) {
                for (int i7 = 0; i7 < this.genomeSize; ++i7) {
                    this.xmean.set(i7, 0, 0.0);
                }
            } else if (val.equals(V_RANDOM)) {
                for (int i8 = 0; i8 < this.genomeSize; ++i8) {
                    this.xmean.set(i8, 0, state.random[0].nextDouble(true, true) * (this.maxGene(i8) - this.minGene(i8)) + this.minGene(i8));
                }
            } else {
                state.output.fatal("Unknown mean value specified: " + val, base.push(P_MEAN), def.push(P_MEAN));
            }
        } else {
            state.output.fatal("No default mean value specified.  Loading full mean from parameters.", base.push(P_MEAN), def.push(P_MEAN));
        }
        boolean nonDefaultMeanSpecified = false;
        for (int i9 = 0; i9 < this.genomeSize; ++i9) {
            double m_i = 0.0;
            try {
                m_i = state.parameters.getDouble(base.push(P_MEAN).push("" + i9), def.push(P_MEAN).push("" + i9));
                this.xmean.set(i9, 0, m_i);
                nonDefaultMeanSpecified = true;
                continue;
            }
            catch (NumberFormatException e) {
                if (meanSpecified) continue;
                state.output.error("No default mean value was specified, but CMA-ES mean index " + i9 + " is missing or not a number.", base.push(P_MEAN).push("" + i9), def.push(P_MEAN).push("" + i9));
            }
        }
        state.output.exitIfErrors();
        if (nonDefaultMeanSpecified && meanSpecified) {
            state.output.warning("A default mean value was specified, but certain mean values were overridden.");
        }
        Object mes = "Initial Mean: <";
        for (int i10 = 0; i10 < this.genomeSize - 1; ++i10) {
            mes = (String)mes + this.xmean.get(i10, 0) + ", ";
        }
        mes = (String)mes + this.xmean.get(this.genomeSize - 1, 0) + ">";
        state.output.message((String)mes);
        if (!state.parameters.exists(base.push(P_LAMBDA), def.push(P_LAMBDA))) {
            this.lambda = 4 + (int)Math.floor(3.0 * Math.log(n));
        } else {
            this.lambda = state.parameters.getInt(base.push(P_LAMBDA), def.push(P_LAMBDA), 1);
            if (this.lambda <= 0) {
                state.output.fatal("If the CMA-ES lambda parameter is provided, it must be a valid integer > 0", base.push(P_LAMBDA), def.push(P_LAMBDA));
            }
        }
        if (!state.parameters.exists(base.push(P_MU), def.push(P_MU))) {
            this.mu = (int)Math.floor((double)this.lambda / 2.0);
        } else {
            this.mu = state.parameters.getInt(base.push(P_MU), def.push(P_MU), 1);
            if (this.mu <= 0) {
                state.output.fatal("If the CMA-ES mu parameter is provided, it must be a valid integer > 0", base.push(P_MU), def.push(P_MU));
            }
        }
        if (this.mu > this.lambda) {
            state.output.fatal("CMA-ES mu must be <= lambda.  Presently mu=" + this.mu + " and lambda=" + this.lambda);
        }
        this.weights = new double[this.mu];
        boolean weightsSpecified = false;
        for (i3 = 0; i3 < this.mu; ++i3) {
            if (!state.parameters.exists(base.push(P_WEIGHTS).push("" + i3), def.push(P_WEIGHTS).push("" + i3))) continue;
            state.output.message("CMA-ES weight index " + i3 + " specified.  Loading all weights from parameters.");
            weightsSpecified = true;
            break;
        }
        if (weightsSpecified) {
            for (i3 = 0; i3 < this.mu; ++i3) {
                double m_i = 0.0;
                try {
                    this.weights[i3] = state.parameters.getDouble(base.push(P_WEIGHTS).push("" + i3), def.push(P_WEIGHTS).push("" + i3));
                    continue;
                }
                catch (NumberFormatException e) {
                    state.output.error("CMA-ES weight index " + i3 + " missing or not a number.", base.push(P_WEIGHTS).push("" + i3), def.push(P_WEIGHTS).push("" + i3));
                }
            }
            state.output.exitIfErrors();
        } else {
            for (i3 = 0; i3 < this.mu; ++i3) {
                this.weights[i3] = Math.log(((double)this.lambda + 1.0) / (2.0 * (double)(i3 + 1)));
            }
        }
        double sum = 0.0;
        for (i2 = 0; i2 < this.mu; ++i2) {
            sum += this.weights[i2];
        }
        i2 = 0;
        while (i2 < this.mu) {
            int n2 = i2++;
            this.weights[n2] = this.weights[n2] / sum;
        }
        double sumSqr = 0.0;
        for (i = 0; i < this.mu; ++i) {
            sumSqr += this.weights[i] * this.weights[i];
        }
        this.mueff = 1.0 / sumSqr;
        mes = "Weights: <";
        for (i = 0; i < this.weights.length - 1; ++i) {
            mes = (String)mes + this.weights[i] + ", ";
        }
        mes = (String)mes + (this.weights.length - 1) + ">";
        state.output.message((String)mes);
        this.useAltTermination = state.parameters.getBoolean(base.push(P_ALTERNATIVE_TERMINATION), def.push(P_ALTERNATIVE_TERMINATION), false);
        this.useAltGenerator = state.parameters.getBoolean(base.push(P_ALTERNATIVE_GENERATOR), def.push(P_ALTERNATIVE_GENERATOR), false);
        this.altGeneratorTries = state.parameters.getIntWithDefault(base.push(P_ALTERNATIVE_GENERATOR_TRIES), def.push(P_ALTERNATIVE_GENERATOR_TRIES), 100);
        if (this.altGeneratorTries < 1) {
            state.output.fatal("If specified (the default is 100), alt-generation-tries must be >= 1", base.push(P_ALTERNATIVE_GENERATOR_TRIES), def.push(P_ALTERNATIVE_GENERATOR_TRIES));
        }
        if (!state.parameters.exists(base.push(P_CC), def.push(P_CC))) {
            this.cc = (4.0 + this.mueff / (double)n) / ((double)n + 4.0 + 2.0 * this.mueff / (double)n);
        } else {
            this.cc = state.parameters.getDoubleWithMax(base.push(P_CC), def.push(P_CC), 0.0, 1.0);
            if (this.cc < 0.0) {
                state.output.fatal("If the CMA-ES cc parameter is provided, it must be a valid number in the range [0,1]", base.push(P_CC), def.push(P_CC));
            }
        }
        if (!state.parameters.exists(base.push(P_CS), def.push(P_CS))) {
            this.cs = (this.mueff + 2.0) / ((double)n + this.mueff + 5.0);
        } else {
            this.cs = state.parameters.getDoubleWithMax(base.push(P_CS), def.push(P_CS), 0.0, 1.0);
            if (this.cs < 0.0) {
                state.output.fatal("If the CMA-ES cs parameter is provided, it must be a valid number in the range [0,1]", base.push(P_CS), def.push(P_CS));
            }
        }
        if (!state.parameters.exists(base.push(P_C1), def.push(P_C1))) {
            this.c1 = 2.0 / (((double)n + 1.3) * ((double)n + 1.3) + this.mueff);
        } else {
            this.c1 = state.parameters.getDouble(base.push(P_C1), def.push(P_C1), 0.0);
            if (this.c1 < 0.0) {
                state.output.fatal("If the CMA-ES c1 parameter is provided, it must be a valid number >= 0.0", base.push(P_C1), def.push(P_C1));
            }
        }
        if (!state.parameters.exists(base.push(P_CMU), def.push(P_CMU))) {
            this.cmu = Math.min(1.0 - this.c1, 2.0 * (this.mueff - 2.0 + 1.0 / this.mueff) / (((double)n + 2.0) * ((double)n + 2.0) + this.mueff));
        } else {
            this.cmu = state.parameters.getDouble(base.push(P_CMU), def.push(P_CMU), 0.0);
            if (this.cmu < 0.0) {
                state.output.fatal("If the CMA-ES cmu parameter is provided, it must be a valid number >= 0.0", base.push(P_CMU), def.push(P_CMU));
            }
        }
        if (this.c1 > 1.0 - this.cmu) {
            state.output.fatal("CMA-ES c1 must be <= 1 - cmu.  You are using c1=" + this.c1 + " and cmu=" + this.cmu);
        }
        if (this.cmu > 1.0 - this.c1) {
            state.output.fatal("CMA-ES cmu must be <= 1 - c1.  You are using cmu=" + this.cmu + " and c1=" + this.c1);
        }
        if (!state.parameters.exists(base.push(P_DAMPS), def.push(P_DAMPS))) {
            this.damps = 1.0 + 2.0 * Math.max(0.0, Math.sqrt((this.mueff - 1.0) / ((double)n + 1.0)) - 1.0) + this.cs;
        } else {
            this.damps = state.parameters.getDouble(base.push(P_DAMPS), def.push(P_DAMPS), 0.0);
            if (this.damps <= 0.0) {
                state.output.fatal("If the CMA-ES damps parameter is provided, it must be a valid number > 0.0", base.push(P_DAMPS), def.push(P_DAMPS));
            }
        }
        double damps_min = 0.5;
        double damps_max = 2.0;
        if (this.damps > damps_max || this.damps < damps_min) {
            state.output.warning("CMA-ES damps ought to be close to 1.  You are using damps = " + this.damps);
        }
        state.output.message("lambda: " + this.lambda);
        state.output.message("mu:     " + this.mu);
        state.output.message("mueff:  " + this.mueff);
        state.output.message("cmu:    " + this.cmu);
        state.output.message("c1:     " + this.c1);
        state.output.message("cc:     " + this.cc);
        state.output.message("cs:     " + this.cs);
        state.output.message("damps:  " + this.damps);
    }

    @Override
    public Object clone() {
        CMAESSpecies myobj = (CMAESSpecies)super.clone();
        myobj.c = (SimpleMatrix)this.c.copy();
        myobj.b = (SimpleMatrix)this.b.copy();
        myobj.d = (SimpleMatrix)this.d.copy();
        myobj.bd = this.bd.copy();
        myobj.sbd = this.sbd.copy();
        myobj.invsqrtC = (SimpleMatrix)this.invsqrtC.copy();
        myobj.xmean = (SimpleMatrix)this.xmean.copy();
        myobj.ps = (SimpleMatrix)this.ps.copy();
        myobj.pc = (SimpleMatrix)this.pc.copy();
        return myobj;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Individual newIndividual(EvolutionState state, int thread) {
        newind = super.newIndividual(state, thread);
        random = state.random[thread];
        if (!(newind instanceof DoubleVectorIndividual)) {
            state.output.fatal("To use CMAESSpecies, the species must be initialized with a DoubleVectorIndividual.  But it contains a " + String.valueOf(newind));
        }
        dvind = (DoubleVectorIndividual)newind;
        genome = DenseMatrix64F.wrap((int)this.genomeSize, (int)1, (double[])dvind.genome);
        temp = new DenseMatrix64F(this.genomeSize, 1);
        tries = 0;
        while (true) {
            for (i = 0; i < this.genomeSize; ++i) {
                dvind.genome[i] = random.nextGaussian();
            }
            CommonOps.mult((RowD1Matrix64F)this.sbd, (RowD1Matrix64F)genome, (RowD1Matrix64F)temp);
            CommonOps.add((D1Matrix64F)temp, (D1Matrix64F)this.xmean.getMatrix(), (D1Matrix64F)genome);
            invalid_value = false;
            for (i = 0; i < this.genomeSize; ++i) {
                if (!(dvind.genome[i] < this.minGene(i)) && !(dvind.genome[i] > this.maxGene(i))) continue;
                if (this.useAltGenerator && tries > this.altGeneratorTries) {
                    dvind.genome[i] = state.random[thread].nextDouble() * (this.maxGene(i) - this.minGene(i)) + this.minGene(i);
                    continue;
                }
                invalid_value = true;
                break;
            }
            if (!invalid_value) break;
            if (++tries <= 100000) ** continue;
            state.output.warnOnce("CMA-ES may be slow because many individuals are being generated which\nare outside the min/max gene bounds.  If an individual violates a single\ngene bounds, it is rejected, so as the number of genes grows, the\nprobability of this happens increases exponentially.  You can deal\nwith this by decreasing sigma.  Alternatively you can use set\npop.subpop.0.alternative-generation=true (see the manual).\nFinally, if this is happening during initialization, you might also\nchange pop.subpop.0.species.covariance=scaled.\n");
        }
        return newind;
    }

    public void updateDistribution(EvolutionState state, Subpopulation subpop) {
        Collections.sort(subpop.individuals);
        SimpleMatrix artmp = new SimpleMatrix(this.genomeSize, this.mu);
        SimpleMatrix xold = this.xmean;
        this.xmean = new SimpleMatrix(this.genomeSize, 1);
        for (int i = 0; i < this.mu; ++i) {
            DoubleVectorIndividual dvind = (DoubleVectorIndividual)subpop.individuals.get(i);
            SimpleMatrix arz = new SimpleMatrix(this.genomeSize, 1, true, dvind.genome);
            arz = (SimpleMatrix)((SimpleMatrix)arz.minus((SimpleBase)xold)).divide(this.sigma);
            for (int j = 0; j < this.genomeSize; ++j) {
                this.xmean.set(j, 0, this.xmean.get(j, 0) + this.weights[i] * dvind.genome[j]);
                artmp.set(j, i, arz.get(j, 0));
            }
        }
        SimpleMatrix y = (SimpleMatrix)((SimpleMatrix)this.xmean.minus((SimpleBase)xold)).divide(this.sigma);
        SimpleMatrix bz = (SimpleMatrix)this.invsqrtC.mult((SimpleBase)y);
        SimpleMatrix bz_scaled = (SimpleMatrix)bz.scale(Math.sqrt(this.cs * (2.0 - this.cs) * this.mueff));
        this.ps = (SimpleMatrix)((SimpleMatrix)this.ps.scale(1.0 - this.cs)).plus((SimpleBase)bz_scaled);
        double h_sigma_value = this.ps.dot((SimpleBase)this.ps) / (1.0 - Math.pow(1.0 - this.cs, 2.0 * (double)(state.generation + 1))) / (double)this.genomeSize;
        boolean hsig = h_sigma_value < 2.0 + 4.0 / (double)(this.genomeSize + 1);
        SimpleMatrix y_scaled = (SimpleMatrix)y.scale((double)hsig * Math.sqrt(this.cc * (2.0 - this.cc) * this.mueff));
        this.pc = (SimpleMatrix)((SimpleMatrix)this.pc.scale(1.0 - this.cc)).plus((SimpleBase)y_scaled);
        this.c = (SimpleMatrix)this.c.scale(1.0 - this.c1 - this.cmu);
        this.c = (SimpleMatrix)this.c.plus((SimpleBase)((SimpleMatrix)((SimpleMatrix)((SimpleMatrix)this.pc.mult((SimpleBase)((SimpleMatrix)this.pc.transpose()))).plus((SimpleBase)((SimpleMatrix)this.c.scale((1.0 - (double)hsig) * this.cc * (2.0 - this.cc))))).scale(this.c1)));
        this.c = (SimpleMatrix)this.c.plus((SimpleBase)((SimpleMatrix)((SimpleMatrix)artmp.mult((SimpleBase)((SimpleMatrix)SimpleMatrix.diag((double[])this.weights).mult((SimpleBase)((SimpleMatrix)artmp.transpose()))))).scale(this.cmu)));
        this.sigma *= Math.exp(this.cs / this.damps * (this.ps.normF() / this.chiN - 1.0));
        if ((double)(state.generation - this.lastEigenDecompositionGeneration) > 1.0 / ((this.c1 + this.cmu) * (double)this.genomeSize * 10.0)) {
            this.lastEigenDecompositionGeneration = state.generation;
            for (int i = 0; i < this.genomeSize; ++i) {
                for (int j = 0; j < i; ++j) {
                    this.c.set(j, i, this.c.get(i, j));
                }
            }
            DenseMatrix64F copy = ((SimpleMatrix)this.c.copy()).getMatrix();
            EigenDecomposition eig = DecompositionFactory.eig((int)this.genomeSize, (boolean)true, (boolean)true);
            if (eig.decompose((Matrix)copy)) {
                SimpleMatrix dinv = new SimpleMatrix(this.genomeSize, this.genomeSize);
                for (int i = 0; i < this.genomeSize; ++i) {
                    double eigrt = Math.sqrt(eig.getEigenvalue((int)i).real);
                    this.d.set(i, i, eigrt);
                    dinv.set(i, i, 1.0 / eigrt);
                    CommonOps.insert((RealMatrix64F)((RealMatrix64F)eig.getEigenVector(i)), (RealMatrix64F)this.b.getMatrix(), (int)0, (int)i);
                }
                this.invsqrtC = (SimpleMatrix)this.b.mult((SimpleBase)((SimpleMatrix)dinv.mult((SimpleBase)((SimpleMatrix)this.b.transpose()))));
                CommonOps.mult((RowD1Matrix64F)this.b.getMatrix(), (RowD1Matrix64F)this.d.getMatrix(), (RowD1Matrix64F)this.bd);
            } else {
                state.output.fatal("CMA-ES eigendecomposition failed. ");
            }
        }
        CommonOps.scale((double)this.sigma, (D1Matrix64F)this.bd, (D1Matrix64F)this.sbd);
        if (this.useAltTermination && CommonOps.elementMax((D1Matrix64F)((SimpleMatrix)this.d.extractDiag()).getMatrix()) > 1.0E7 * CommonOps.elementMin((D1Matrix64F)((SimpleMatrix)this.d.extractDiag()).getMatrix())) {
            state.evaluator.setRunComplete("CMAESSpecies: Stopped because matrix condition exceeded limit.");
        }
    }
}

