/*
 * Decompiled with CFR 0.152.
 */
package ec.eda.dovs;

import ec.EvolutionState;
import ec.Individual;
import ec.Population;
import ec.eda.dovs.DOVSSpecies;
import ec.simple.SimpleInitializer;
import ec.vector.IntegerVectorIndividual;
import java.util.ArrayList;

public class DOVSInitializer
extends SimpleInitializer {
    private static final long serialVersionUID = 1L;

    @Override
    public Population initialPopulation(EvolutionState state, int thread) {
        Population p = super.initialPopulation(state, thread);
        for (int i = 0; i < p.subpops.size(); ++i) {
            if (!(p.subpops.get((int)i).species instanceof DOVSSpecies)) continue;
            DOVSSpecies species = (DOVSSpecies)p.subpops.get((int)i).species;
            if (p.subpops.get((int)i).individuals.size() != 1) {
                state.output.fatal("contain more than one start point");
            }
            species.visited.clear();
            species.visited.add(p.subpops.get((int)i).individuals.get(0));
            species.visitedIndexMap.put(p.subpops.get((int)i).individuals.get(0), 0);
            species.optimalIndex = 0;
            IntegerVectorIndividual ind = (IntegerVectorIndividual)species.visited.get(species.optimalIndex);
            for (int j = 0; j < species.genomeSize; ++j) {
                species.corners.get(j).insert(ind.genome[j], ind);
            }
            species.updateMostPromisingArea(state);
            int initialSize = p.subpops.get((int)i).initialSize;
            ArrayList<Individual> candidates = species.mostPromisingAreaSamples(state, initialSize);
            ArrayList<Individual> uniqueCandidates = species.uniqueSamples(state, candidates);
            p.subpops.get((int)i).individuals = uniqueCandidates;
        }
        return p;
    }
}

