/*
 * Decompiled with CFR 0.152.
 */
package ec.eda.dovs;

import ec.EvolutionState;
import ec.Individual;
import ec.Subpopulation;
import ec.eda.dovs.CornerMap;
import ec.eda.dovs.DOVSDefaults;
import ec.eda.dovs.DOVSFitness;
import ec.util.Parameter;
import ec.vector.IntegerVectorIndividual;
import ec.vector.IntegerVectorSpecies;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class DOVSSpecies
extends IntegerVectorSpecies {
    public static final String P_DOVS_SPECIES = "species";
    public static final String P_INITIAL_REPETITION = "initial-reps";
    public static final String P_STOCHASTIC = "stochastic";
    public static final String P_CONSTRAINTS_SIZE = "constraints-size";
    public static final String P_A = "constraints-A";
    public static final String P_B = "constraints-b";
    public static final String P_WARM_UP = "warmup";
    public int optimalIndex = -1;
    public int warmUp;
    public ArrayList<Individual> visited;
    public HashMap<Individual, Integer> visitedIndexMap;
    public ArrayList<CornerMap> corners;
    public ArrayList<Individual> activeSolutions;
    public ArrayList<Individual> Ek;
    public boolean stochastic;
    public int initialReps;
    public int repetition;
    public long numOfTotalSamples = 0L;
    public ArrayList<double[]> A;
    public double[] b;

    @Override
    public Parameter defaultBase() {
        return DOVSDefaults.base().push(P_DOVS_SPECIES);
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        this.activeSolutions = new ArrayList();
        this.Ek = new ArrayList();
        this.visited = new ArrayList();
        this.visitedIndexMap = new HashMap();
        this.corners = new ArrayList();
        for (int i = 0; i < this.genomeSize; ++i) {
            this.corners.add(new CornerMap());
        }
        Parameter def = this.defaultBase();
        this.stochastic = state.parameters.getBoolean(base.push(P_STOCHASTIC), def.push(P_STOCHASTIC), true);
        this.initialReps = state.parameters.getInt(base.push(P_INITIAL_REPETITION), def.push(P_INITIAL_REPETITION), 1);
        if (this.initialReps < 1) {
            state.output.fatal("Initial number of repetitions must be >= 1", base.push(P_INITIAL_REPETITION), def.push(P_INITIAL_REPETITION));
        }
        this.warmUp = state.parameters.getInt(base.push(P_WARM_UP), def.push(P_WARM_UP), 1);
        if (this.warmUp < 1) {
            state.output.fatal("Warm-up Period must be >= 1", base.push(P_WARM_UP), def.push(P_WARM_UP));
        }
        int size = state.parameters.getInt(base.push(P_CONSTRAINTS_SIZE), def.push(P_CONSTRAINTS_SIZE), 0);
        this.A = new ArrayList();
        this.b = new double[size];
        if (size > 0) {
            for (int x = 0; x < size; ++x) {
                Parameter defp;
                Parameter p = base.push(P_A).push("" + x);
                double[] d = state.parameters.getDoublesUnconstrained(p, defp = def.push(P_A).push("" + x), this.genomeSize);
                if (d == null) {
                    state.output.fatal("Row " + x + " of DOVSSpecies constraints array A must be a space- or tab-delimited list of exactly " + this.genomeSize + " numbers.", p, defp);
                }
                this.A.add(d);
            }
            Parameter p = base.push(P_B);
            Parameter defp = def.push(P_B);
            this.b = state.parameters.getDoublesUnconstrained(p, defp, size);
            if (this.b == null) {
                state.output.fatal("DOVSSpecies constraints vector b must be a space- or tab-delimited list of exactly " + size + " numbers.", p, defp);
            }
        }
        this.repetition = this.stochastic ? this.initialReps : 1;
    }

    public void updateMostPromisingArea(EvolutionState state) {
        throw new UnsupportedOperationException("updateMostPromisingArea method not implementd!");
    }

    public ArrayList<Individual> mostPromisingAreaSamples(EvolutionState state, int size) {
        throw new UnsupportedOperationException("mostPromisingAreaSamples method not implementd!");
    }

    public void findBestSample(EvolutionState state, Subpopulation subpop) {
        int i;
        this.Ek.clear();
        ArrayList<Individual> individuals = subpop.individuals;
        for (i = 0; i < individuals.size(); ++i) {
            this.Ek.add(individuals.get(i));
        }
        for (i = 0; i < this.activeSolutions.size(); ++i) {
            this.Ek.add(this.activeSolutions.get(i));
        }
        this.Ek.add(this.visited.get(this.optimalIndex));
        this.optimalIndex = this.findOptimalIndividual(this.Ek);
    }

    private int findOptimalIndividual(ArrayList<Individual> list) {
        double maximum = -2.147483648E9;
        IntegerVectorIndividual bestInd = null;
        for (int i = 0; i < list.size(); ++i) {
            IntegerVectorIndividual ind = (IntegerVectorIndividual)list.get(i);
            if (!(((DOVSFitness)ind.fitness).mean > maximum)) continue;
            maximum = ((DOVSFitness)ind.fitness).mean;
            bestInd = ind;
        }
        return this.visitedIndexMap.get(bestInd);
    }

    public ArrayList<Individual> uniqueSamples(EvolutionState state, ArrayList<Individual> candidates) {
        HashSet<Individual> set = new HashSet<Individual>();
        for (int i = 0; i < candidates.size(); ++i) {
            if (set.contains(candidates.get(i))) continue;
            set.add(candidates.get(i));
        }
        candidates = new ArrayList(set);
        ArrayList<Individual> Sk = new ArrayList<Individual>();
        for (int i = 0; i < candidates.size(); ++i) {
            IntegerVectorIndividual individual = (IntegerVectorIndividual)candidates.get(i);
            if (this.visitedIndexMap.containsKey(individual)) {
                int index = this.visitedIndexMap.get(individual);
                individual = (IntegerVectorIndividual)this.visited.get(index);
            } else {
                this.visited.add(individual);
                this.visitedIndexMap.put(individual, this.visited.size() - 1);
                for (int j = 0; j < this.genomeSize; ++j) {
                    this.corners.get(j).insert(individual.genome[j], individual);
                }
            }
            Sk.add(individual);
        }
        return Sk;
    }
}

