/*
 * Decompiled with CFR 0.152.
 */
package ec.eda.pbil;

import ec.Breeder;
import ec.EvolutionState;
import ec.Individual;
import ec.Population;
import ec.Subpopulation;
import ec.eda.pbil.PBILSpecies;
import ec.util.Parameter;
import java.util.ArrayList;

public class PBILBreeder
extends Breeder {
    @Override
    public void setup(EvolutionState state, Parameter base) {
    }

    @Override
    public Population breedPopulation(EvolutionState state) {
        Population pop = state.population;
        for (int i = 0; i < pop.subpops.size(); ++i) {
            Subpopulation subpop = pop.subpops.get(i);
            if (!(subpop.species instanceof PBILSpecies)) {
                state.output.fatal("To use PBILBreeder, subpopulation " + i + " must contain a PBILSpecies.  But it contains a " + String.valueOf(subpop.species));
            }
            PBILSpecies species = (PBILSpecies)subpop.species;
            species.updateDistribution(state, subpop);
            ArrayList<Individual> inds = subpop.individuals;
            for (int j = 0; j < inds.size(); ++j) {
                inds.set(j, species.newIndividual(state, 0));
            }
        }
        return pop;
    }
}

