/*
 * Decompiled with CFR 0.152.
 */
package ec.eda.pbil;

import ec.ECDefaults;
import ec.EvolutionState;
import ec.Individual;
import ec.Subpopulation;
import ec.util.MersenneTwisterFast;
import ec.util.Parameter;
import ec.vector.IntegerVectorIndividual;
import ec.vector.IntegerVectorSpecies;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class PBILSpecies
extends IntegerVectorSpecies {
    public static final String P_PBIL_SPECIES = "pbil.species";
    public static final String P_ALPHA = "alpha";
    public static final String P_B = "b";
    public double alpha;
    public int b;
    private List<double[]> distributions;

    public double[] getMarginalDistribution(int gene) {
        assert (gene >= 0);
        assert (gene < this.distributions.size());
        return Arrays.copyOf(this.distributions.get(gene), this.distributions.get(gene).length);
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        int i;
        assert (state != null);
        assert (base != null);
        super.setup(state, base);
        Parameter def = this.defaultBase();
        Parameter subpopDefaultBase = ECDefaults.base().push("subpop");
        for (i = 0; i < this.genomeSize; ++i) {
            state.output.message("minGene " + i + " = " + this.minGene[i]);
            state.output.message("maxGene " + i + " = " + this.maxGene[i]);
        }
        this.alpha = state.parameters.getDouble(base.push(P_ALPHA), subpopDefaultBase);
        if (this.alpha < 0.0 | this.alpha > 1.0) {
            state.output.fatal(String.format("%s: the %s parameter is %f, but must be a valid number in the range 0 to 1", this.getClass().getSimpleName(), base.push(P_ALPHA), this.alpha), base.push(P_ALPHA), def.push(P_ALPHA));
        }
        this.b = state.parameters.getInt(base.push(P_B), def.push(P_B), 1);
        if (this.b < 1) {
            state.output.fatal(String.format("%s: the %s parameter must be a positive integer.", this.getClass().getSimpleName(), base.push(P_B)), base.push(P_B), def.push(P_B));
        }
        this.distributions = new ArrayList<double[]>();
        for (i = 0; i < this.genomeSize; ++i) {
            double[] marginalDist = new double[(int)this.maxGene[i] - (int)this.minGene[i] + 1];
            int j = 0;
            while ((long)j < this.maxGene[i] - this.minGene[i] + 1L) {
                marginalDist[j] = 1.0 / (double)(this.maxGene[i] - this.minGene[i] + 1L);
                ++j;
            }
            this.distributions.add(marginalDist);
        }
        state.output.message("alpha: " + this.alpha);
        state.output.message("b:     " + this.b);
        assert (this.distributions.size() == this.genomeSize);
    }

    @Override
    public Object clone() {
        PBILSpecies myobj = (PBILSpecies)super.clone();
        return myobj;
    }

    @Override
    public Individual newIndividual(EvolutionState state, int thread) {
        int i;
        Individual newind = super.newIndividual(state, thread);
        MersenneTwisterFast random = state.random[thread];
        if (!(newind instanceof IntegerVectorIndividual)) {
            state.output.fatal("To use PBILSpecies, the species must be initialized with a IntegerVectorIndividual.  But it contains a " + String.valueOf(newind));
        }
        IntegerVectorIndividual ivind = (IntegerVectorIndividual)newind;
        ArrayList<double[]> temp = new ArrayList<double[]>();
        for (i = 0; i < this.genomeSize; ++i) {
            temp.add(this.distributions.get(i));
        }
        block1: for (i = 0; i < this.genomeSize; ++i) {
            double rand = random.nextDouble();
            boolean q = true;
            double cB = 0.0;
            int j = 0;
            while ((long)j < this.maxGene[i] - this.minGene[i] + 1L) {
                if (q) {
                    cB = ((double[])temp.get(i))[j];
                }
                if (rand < cB) {
                    ivind.genome[i] = j + (int)this.minGene[i];
                    continue block1;
                }
                if ((long)j < this.maxGene[i] - this.minGene[i]) {
                    cB += ((double[])temp.get(i))[j + 1];
                    q = false;
                }
                ++j;
            }
        }
        return ivind;
    }

    public void updateDistribution(EvolutionState state, Subpopulation subpop) {
        int i;
        Collections.sort(subpop.individuals);
        ArrayList<double[]> Nj = new ArrayList<double[]>();
        int[][] arz = new int[this.b][this.genomeSize];
        for (i = 0; i < this.b; ++i) {
            IntegerVectorIndividual ivind = (IntegerVectorIndividual)subpop.individuals.get(i);
            arz[i] = ivind.genome;
        }
        for (i = 0; i < this.genomeSize; ++i) {
            double[] Nj_temp = new double[(int)(this.maxGene[i] - this.minGene[i] + 1L)];
            int j = 0;
            while ((long)j < this.maxGene[i] - this.minGene[i] + 1L) {
                Nj_temp[j] = this.marginalDist(i, j, arz);
                ++j;
            }
            Nj.add(Nj_temp);
        }
        for (i = 0; i < this.genomeSize; ++i) {
            double[] tempDist = this.distributions.get(i);
            double[] tempNewDist = (double[])Nj.get(i);
            int j = 0;
            while ((long)j < this.maxGene[i] - this.minGene[i] + 1L) {
                int n = j;
                tempDist[n] = tempDist[n] * (1.0 - this.alpha);
                int n2 = j;
                tempNewDist[n2] = tempNewDist[n2] * this.alpha;
                int n3 = j;
                tempDist[n3] = tempDist[n3] + tempNewDist[j];
                ++j;
            }
            this.distributions.set(i, tempDist);
        }
    }

    private double marginalDist(int i, int k, int[][] arz) {
        double count = 0.0;
        for (int j = 0; j < this.b; ++j) {
            if (arz[j][i] != k + (int)this.minGene[i]) continue;
            count += 1.0;
        }
        return count / (double)this.b;
    }
}

