/*
 * Decompiled with CFR 0.152.
 */
package ec.eval;

import ec.EvolutionState;
import ec.Individual;
import ec.Population;
import ec.Problem;
import ec.co.Component;
import ec.co.ConstructiveIndividual;
import ec.co.ConstructiveProblemForm;
import ec.coevolve.GroupedProblemForm;
import ec.eval.Job;
import ec.eval.SlaveMonitor;
import ec.simple.SimpleProblemForm;
import ec.steadystate.QueueIndividual;
import ec.util.Parameter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.List;

public class MasterProblem
extends Problem
implements SimpleProblemForm,
GroupedProblemForm,
ConstructiveProblemForm {
    private static final long serialVersionUID = 1L;
    public static final String P_DEBUG_INFO = "debug-info";
    public static final String P_JOB_SIZE = "job-size";
    int jobSize;
    boolean showDebugInfo;
    public boolean batchMode;
    public transient SlaveMonitor monitor;
    public Problem problem;
    ArrayList<QueueIndividual> queue;

    @Override
    public Object clone() {
        MasterProblem c = (MasterProblem)super.clone();
        c.monitor = this.monitor;
        c.batchMode = this.batchMode;
        c.jobSize = this.jobSize;
        c.showDebugInfo = this.showDebugInfo;
        c.problem = (Problem)this.problem.clone();
        return c;
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        Thread.currentThread().setName("MainThread: ");
        super.setup(state, base);
        this.showDebugInfo = state.parameters.getBoolean(base.push(P_DEBUG_INFO), null, false);
        this.jobSize = state.parameters.getIntWithDefault(base.push(P_JOB_SIZE), null, 1);
        if (this.jobSize <= 0) {
            state.output.fatal("The job size must be an integer > 0.", base.push(P_JOB_SIZE));
        }
        this.batchMode = false;
    }

    @Override
    public void prepareToEvaluate(EvolutionState state, int threadnum) {
        if (this.jobSize > 1) {
            this.queue = new ArrayList();
        }
        this.batchMode = true;
    }

    @Override
    public void finishEvaluating(EvolutionState state, int threadnum) {
        if (this.showDebugInfo) {
            state.output.message(Thread.currentThread().getName() + "Waiting for all slaves to finish.");
        }
        this.flush(state, threadnum);
        this.queue = null;
        this.monitor.waitForAllSlavesToFinishEvaluating(state);
        this.batchMode = false;
        if (this.showDebugInfo) {
            state.output.message(Thread.currentThread().getName() + "All slaves have finished their jobs.");
        }
    }

    @Override
    public void evaluate(EvolutionState state, Individual ind, int subpopulation, int threadnum) {
        if (this.jobSize > 1 && this.batchMode) {
            this.queue.add(new QueueIndividual(ind, subpopulation));
            if (this.queue.size() >= this.jobSize) {
                this.flush(state, threadnum);
            }
        } else {
            this.evaluate(state, new Individual[]{ind}, new int[]{subpopulation}, threadnum);
        }
    }

    void flush(EvolutionState state, int threadnum) {
        if (this.queue != null && this.queue.size() > 0) {
            Individual[] inds = new Individual[this.queue.size()];
            int[] subpopulations = new int[this.queue.size()];
            for (int i = 0; i < this.queue.size(); ++i) {
                QueueIndividual qind = this.queue.get(i);
                inds[i] = qind.ind;
                subpopulations[i] = qind.subpop;
            }
            this.evaluate(state, inds, subpopulations, threadnum);
        }
        this.queue = new ArrayList();
    }

    void evaluate(EvolutionState state, Individual[] inds, int[] subpopulations, int threadnum) {
        if (this.showDebugInfo) {
            state.output.message(Thread.currentThread().getName() + "Starting a " + (this.batchMode ? "batched " : "") + "SimpleProblemForm evaluation.");
        }
        Job job = new Job();
        job.type = 1;
        job.inds = inds;
        job.subPops = subpopulations;
        job.updateFitness = new boolean[inds.length];
        for (int i = 0; i < inds.length; ++i) {
            job.updateFitness[i] = true;
        }
        this.monitor.scheduleJobForEvaluation(state, job);
        if (!this.batchMode) {
            this.monitor.waitForAllSlavesToFinishEvaluating(state);
        }
        if (this.showDebugInfo) {
            state.output.message(Thread.currentThread().getName() + "Finished a " + (this.batchMode ? "batched " : "") + "SimpleProblemForm evaluation.");
        }
    }

    @Override
    public void describe(EvolutionState state, Individual ind, int subpopulation, int threadnum, int log) {
        if (this.problem instanceof SimpleProblemForm) {
            ((SimpleProblemForm)((Object)this.problem)).describe(state, ind, subpopulation, threadnum, log);
        }
    }

    @Override
    public void preprocessPopulation(EvolutionState state, Population pop, boolean[] prepareForFitnessAssessment, boolean countVictoriesOnly) {
        if (!this.problem.isGroupedProblem()) {
            state.output.fatal("MasterProblem.preprocessPopulation(...) invoked, but the underlying Problem is not a grouped problem");
        }
        ((GroupedProblemForm)((Object)this.problem)).preprocessPopulation(state, pop, prepareForFitnessAssessment, countVictoriesOnly);
    }

    @Override
    public int postprocessPopulation(EvolutionState state, Population pop, boolean[] assessFitness, boolean countVictoriesOnly) {
        if (!this.problem.isGroupedProblem()) {
            state.output.fatal("MasterProblem.postprocessPopulation(...) invoked, but the underlying Problem is not a grouped problem");
        }
        return ((GroupedProblemForm)((Object)this.problem)).postprocessPopulation(state, pop, assessFitness, countVictoriesOnly);
    }

    @Override
    public void evaluate(EvolutionState state, Individual[] inds, boolean[] updateFitness, boolean countVictoriesOnly, int[] subpops, int threadnum) {
        if (this.showDebugInfo) {
            state.output.message("Starting a GroupedProblemForm evaluation.");
        }
        if (!this.problem.isGroupedProblem()) {
            state.output.fatal("MasterProblem.evaluate(...) invoked, but the underlying Problem is not a grouped problem");
        }
        Job job = new Job();
        job.type = 2;
        job.subPops = subpops;
        job.countVictoriesOnly = countVictoriesOnly;
        job.inds = inds;
        job.updateFitness = updateFitness;
        this.monitor.scheduleJobForEvaluation(state, job);
        if (!this.batchMode) {
            this.monitor.waitForAllSlavesToFinishEvaluating(state);
        }
        if (this.showDebugInfo) {
            state.output.message("Finished the GroupedProblemForm evaluation.");
        }
    }

    @Override
    public void initializeContacts(EvolutionState state) {
        if (this.showDebugInfo) {
            state.output.message(Thread.currentThread().getName() + "Spawning the server thread.");
        }
        this.monitor = new SlaveMonitor(state, this.showDebugInfo, this);
    }

    @Override
    public void reinitializeContacts(EvolutionState state) {
        this.initializeContacts(state);
    }

    @Override
    public void closeContacts(EvolutionState state, int result) {
        this.monitor.shutdown();
    }

    @Override
    public boolean canEvaluate() {
        return this.monitor.numAvailableSlaves() != 0;
    }

    public boolean evaluatedIndividualAvailable() {
        return this.monitor.evaluatedIndividualAvailable();
    }

    public QueueIndividual getNextEvaluatedIndividual() {
        return this.monitor.waitForIndividual();
    }

    @Override
    public void sendAdditionalData(EvolutionState state, DataOutputStream dataOut) {
        if (this.problem == null) {
            state.output.warning("Cannot call Problem.sendAdditionalData(...) because MasterProblem's problem is currently null.");
        } else {
            this.problem.sendAdditionalData(state, dataOut);
        }
    }

    @Override
    public void receiveAdditionalData(EvolutionState state, DataInputStream dataIn) {
        if (this.problem == null) {
            state.output.warning("Cannot call Problem.receiveAdditionalData(...) because MasterProblem's problem is currently null.");
        } else {
            this.problem.receiveAdditionalData(state, dataIn);
        }
    }

    @Override
    public void transferAdditionalData(EvolutionState state) {
        if (this.problem == null) {
            state.output.warning("Cannot call Problem.transferAdditionalData(...) because MasterProblem's problem is currently null.");
        } else {
            this.problem.transferAdditionalData(state);
        }
    }

    @Override
    public int numComponents() {
        if (!(this.problem instanceof ConstructiveProblemForm)) {
            throw new IllegalStateException(String.format("%s.numComponents() invoked, but the underlying Problem is not of %s", this.getClass().getSimpleName(), ConstructiveProblemForm.class.getSimpleName()));
        }
        return ((ConstructiveProblemForm)((Object)this.problem)).numComponents();
    }

    public boolean isCompleteSolution(ConstructiveIndividual solution) {
        if (!(this.problem instanceof ConstructiveProblemForm)) {
            throw new IllegalStateException(String.format("%s.isCompleteSolution() invoked, but the underlying Problem is not of %s", this.getClass().getSimpleName(), ConstructiveProblemForm.class.getSimpleName()));
        }
        return ((ConstructiveProblemForm)((Object)this.problem)).isCompleteSolution(solution);
    }

    public boolean isViolated(ConstructiveIndividual partialSolution, Component component) {
        if (!(this.problem instanceof ConstructiveProblemForm)) {
            throw new IllegalStateException(String.format("%s.isViolated() invoked, but the underlying Problem is not of %s", this.getClass().getSimpleName(), ConstructiveProblemForm.class.getSimpleName()));
        }
        return ((ConstructiveProblemForm)((Object)this.problem)).isViolated(partialSolution, component);
    }

    public List<Component> getAllComponents() {
        if (!(this.problem instanceof ConstructiveProblemForm)) {
            throw new IllegalStateException(String.format("%s.isViolated() invoked, but the underlying Problem is not of %s", this.getClass().getSimpleName(), ConstructiveProblemForm.class.getSimpleName()));
        }
        return ((ConstructiveProblemForm)((Object)this.problem)).getAllComponents();
    }

    public List<Component> getAllowedComponents(ConstructiveIndividual partialSolution) {
        if (!(this.problem instanceof ConstructiveProblemForm)) {
            throw new IllegalStateException(String.format("%s.getAllowedComponents() invoked, but the underlying Problem is not of %s", this.getClass().getSimpleName(), ConstructiveProblemForm.class.getSimpleName()));
        }
        return ((ConstructiveProblemForm)((Object)this.problem)).getAllowedComponents(partialSolution);
    }

    public Component getComponentFromString(String s) {
        if (!(this.problem instanceof ConstructiveProblemForm)) {
            throw new IllegalStateException(String.format("%s.getComponentFromString() invoked, but the underlying Problem is not of %s", this.getClass().getSimpleName(), ConstructiveProblemForm.class.getSimpleName()));
        }
        return ((ConstructiveProblemForm)((Object)this.problem)).getComponentFromString(s);
    }

    public Component getArbitraryComponent(EvolutionState state, int thread) {
        if (!(this.problem instanceof ConstructiveProblemForm)) {
            throw new IllegalStateException(String.format("%s.getArbitraryComponent() invoked, but the underlying Problem is not of %s", this.getClass().getSimpleName(), ConstructiveProblemForm.class.getSimpleName()));
        }
        return ((ConstructiveProblemForm)((Object)this.problem)).getArbitraryComponent(state, thread);
    }

    @Override
    public boolean isGroupedProblem() {
        return this.problem.isGroupedProblem();
    }
}

