/*
 * Decompiled with CFR 0.152.
 */
package ec.eval;

import ec.EvolutionState;
import ec.Evolve;
import ec.Individual;
import ec.coevolve.GroupedProblemForm;
import ec.eval.MasterProblem;
import ec.simple.SimpleProblemForm;
import ec.util.MersenneTwisterFast;
import ec.util.Output;
import ec.util.Parameter;
import ec.util.ParameterDatabase;
import ec.util.ThreadPool;
import ec.util.Version;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;

public class Slave {
    public static final String P_EVALNODELAY = "eval.no-delay";
    public static final String P_EVALSENDBUFER = "eval.send-buffer";
    public static final String P_EVALRECVBUFFER = "eval.recv-buffer";
    public static final String P_EVALSLAVENAME = "eval.slave.name";
    public static final String P_EVALMASTERHOST = "eval.master.host";
    public static final String P_EVALMASTERPORT = "eval.master.port";
    public static final String P_EVALCOMPRESSION = "eval.compression";
    public static final String P_RETURNINDIVIDUALS = "eval.return-inds";
    public static final String P_SILENT = "eval.slave.silent";
    public static final String P_MUZZLE = "eval.slave.muzzle";
    public static final byte V_NOTHING = 0;
    public static final byte V_INDIVIDUAL = 1;
    public static final byte V_FITNESS = 2;
    public static final byte V_SHUTDOWN = 0;
    public static final byte V_EVALUATESIMPLE = 1;
    public static final byte V_EVALUATEGROUPED = 2;
    public static final String A_FROM = "-from";
    public static final String A_AT = "-at";
    public static final String A_FILE = "-file";
    public static final String P_RUNTIME = "eval.slave.runtime";
    public static int runTime = 0;
    public static final String P_RUNEVOLVE = "eval.slave.run-evolve";
    public static boolean runEvolve = false;
    public static final String P_ONESHOT = "eval.slave.one-shot";
    public static boolean oneShot = false;
    public static final int SLEEP_TIME = 100;
    public static final ThreadPool pool = new ThreadPool();
    public static int slaveNum = -1;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        int masterPort;
        int x;
        EvolutionState state = null;
        ParameterDatabase parameters = null;
        Output output = null;
        for (int x2 = 0; x2 < args.length - 1; ++x2) {
            if (!args[x2].equals(A_FILE)) continue;
            try {
                parameters = new ParameterDatabase(new File(new File(args[x2 + 1]).getAbsolutePath()), args);
                parameters.set(new Parameter("eval").push("i-am-slave"), "true");
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
                Output.initialError("An exception was generated upon reading the parameter file \"" + args[x2 + 1] + "\".\nHere it is:\n" + String.valueOf(e), true);
            }
        }
        Class<Object> cls = null;
        for (x = 0; x < args.length - 1; ++x) {
            if (!args[x].equals(A_AT)) continue;
            try {
                if (parameters != null) {
                    Output.initialError("Both -from and -at arguments provided.  This is not permitted.\nFor help, try:  java ec.Evolve -help", true);
                    break;
                }
                cls = Class.forName(args[x + 1]);
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
                Output.initialError("An exception was generated upon extracting the class to load the parameter file relative to: " + args[x + 1] + "\nFor help, try:  java ec.Evolve -help\n\n" + String.valueOf(e), true);
            }
        }
        for (x = 0; x < args.length - 1; ++x) {
            if (!args[x].equals(A_FROM)) continue;
            try {
                if (parameters != null) {
                    Output.initialError("Both -file and -from arguments provided.  This is not permitted.\nFor help, try:  java ec.Evolve -help", true);
                } else {
                    if (cls == null) {
                        cls = Evolve.class;
                    }
                    parameters = new ParameterDatabase(args[x + 1], cls, args);
                    Output.initialMessage("Using database resource location " + parameters.getLabel());
                }
                parameters.set(new Parameter("eval").push("i-am-slave"), "true");
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
                Output.initialError("The parameter file is missing at the resource location: " + args[x + 1] + " relative to the class: " + String.valueOf(cls) + "\n\nFor help, try:  java ec.Evolve -help", true);
            }
        }
        if (parameters == null) {
            Output.initialError("No parameter file was specified.", true);
        }
        boolean returnIndividuals = parameters.getBoolean(new Parameter(P_RETURNINDIVIDUALS), null, false);
        boolean silent = parameters.getBoolean(new Parameter(P_SILENT), null, false);
        if (parameters.exists(new Parameter(P_MUZZLE), null)) {
            Output.initialWarning(String.valueOf(new Parameter(P_MUZZLE)) + " has been deprecated.  We suggest you use " + String.valueOf(new Parameter(P_SILENT)) + " or similar newer options.");
        }
        silent = silent || parameters.getBoolean(new Parameter(P_MUZZLE), null, false);
        Object slaveName = parameters.getString(new Parameter(P_EVALSLAVENAME), null);
        String masterHost = parameters.getString(new Parameter(P_EVALMASTERHOST), null);
        if (masterHost == null) {
            Output.initialError("Master Host missing", new Parameter(P_EVALMASTERHOST), true);
        }
        if ((masterPort = parameters.getInt(new Parameter(P_EVALMASTERPORT), null, 0)) == -1) {
            Output.initialError("Master Port missing", new Parameter(P_EVALMASTERPORT), true);
        }
        runTime = parameters.getInt(new Parameter(P_RUNTIME), null, 0);
        runEvolve = parameters.getBoolean(new Parameter(P_RUNEVOLVE), null, false);
        oneShot = parameters.getBoolean(new Parameter(P_ONESHOT), null, true);
        int noDelay = parameters.exists(new Parameter(P_EVALNODELAY), null) ? (parameters.getBoolean(new Parameter(P_EVALNODELAY), null, true) ? 1 : 0) : -1;
        int sendbuffer = parameters.getInt(new Parameter(P_EVALSENDBUFER), null, -1);
        int recvbuffer = parameters.getInt(new Parameter(P_EVALRECVBUFFER), null, -1);
        if (runEvolve && !returnIndividuals) {
            Output.initialError("You have the slave running in 'evolve' mode, but it's only returning fitnesses to the master, not whole individuals.  This is almost certainly wrong.", new Parameter(P_RUNEVOLVE), new Parameter(P_RETURNINDIVIDUALS), true);
        }
        if (!silent) {
            Output.initialMessage("ECJ Slave");
            if (runEvolve) {
                Output.initialMessage("Running in Evolve mode, evolve time is " + runTime + " milliseconds");
            }
            if (returnIndividuals) {
                Output.initialMessage("Whole individuals will be returned");
            } else {
                Output.initialMessage("Only fitnesses will be returned");
            }
        }
        Socket socket = null;
        while (true) {
            block79: {
                try {
                    try {
                        int evalthreads;
                        int breedthreads;
                        long connectAttemptCount = 0L;
                        if (!silent) {
                            Output.initialMessage("Connecting to master at " + masterHost + ":" + masterPort);
                        }
                        while (true) {
                            try {
                                socket = new Socket(masterHost, masterPort);
                            }
                            catch (ConnectException e) {
                                ++connectAttemptCount;
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException interruptedException) {}
                                continue;
                            }
                            break;
                        }
                        if (!silent) {
                            Output.initialMessage("Connected to master after " + connectAttemptCount * 100L + " ms");
                        }
                        DataInputStream dataIn = null;
                        DataOutputStream dataOut = null;
                        try {
                            boolean useCompression;
                            if (noDelay == 1) {
                                socket.setTcpNoDelay(true);
                                if (!silent) {
                                    Output.initialMessage("NoDelay -> ON");
                                }
                            } else if (noDelay == 0) {
                                socket.setTcpNoDelay(false);
                                if (!silent) {
                                    Output.initialMessage("NoDelay -> OFF");
                                }
                            }
                            if (sendbuffer >= 0) {
                                if (!silent) {
                                    Output.initialMessage("SendBuffer -> " + sendbuffer + " was " + socket.getSendBufferSize());
                                }
                                socket.setSendBufferSize(sendbuffer);
                            }
                            if (recvbuffer >= 0) {
                                if (!silent) {
                                    Output.initialMessage("RecvBuffer -> " + recvbuffer + " was " + socket.getReceiveBufferSize());
                                }
                                socket.setReceiveBufferSize(recvbuffer);
                            }
                            InputStream tmpIn = socket.getInputStream();
                            OutputStream tmpOut = socket.getOutputStream();
                            boolean bl = useCompression = tmpIn.read() != 0;
                            if (useCompression) {
                                tmpIn = Output.makeCompressingInputStream(tmpIn);
                                tmpOut = Output.makeCompressingOutputStream(tmpOut);
                                if (tmpIn == null || tmpOut == null) {
                                    String err = "You do not appear to have JZLib installed on your system, and so must set eval.compression=false.  To get JZLib, download from the ECJ website or from http://www.jcraft.com/jzlib/";
                                    if (!silent) {
                                        Output.initialMessage(err);
                                    }
                                    throw new Output.OutputExitException(err);
                                }
                            }
                            dataIn = new DataInputStream(tmpIn);
                            dataOut = new DataOutputStream(tmpOut);
                        }
                        catch (IOException e) {
                            String err = "Unable to open input stream from socket:\n" + String.valueOf(e);
                            if (!silent) {
                                Output.initialMessage(err);
                            }
                            throw new Output.OutputExitException(err);
                        }
                        slaveNum = dataIn.readInt();
                        if (slaveName == null) {
                            slaveName = socket.getLocalAddress().toString() + "/" + slaveNum;
                            if (!silent) {
                                Output.initialMessage("No slave name specified.  Using: " + (String)slaveName);
                            }
                        }
                        Output.initialMessage("I am slave " + (String)slaveName);
                        dataOut.writeUTF((String)slaveName);
                        dataOut.flush();
                        if (output != null) {
                            output.close();
                        }
                        output = new Output(false);
                        output.setThrowsErrors(true);
                        output.addLog(0, false);
                        output.addLog(1, true);
                        if (silent) {
                            output.getLog((int)0).silent = true;
                            output.getLog((int)1).silent = true;
                        }
                        if (!silent) {
                            output.systemMessage(Version.message());
                        }
                        MersenneTwisterFast[] random = new MersenneTwisterFast[(breedthreads = Evolve.determineThreads(output, parameters, new Parameter("breedthreads"))) > (evalthreads = Evolve.determineThreads(output, parameters, new Parameter("evalthreads"))) ? breedthreads : evalthreads];
                        int seed = dataIn.readInt();
                        for (int i = 0; i < random.length; ++i) {
                            random[i] = Evolve.primeGenerator(new MersenneTwisterFast(seed++));
                        }
                        state = (EvolutionState)parameters.getInstanceForParameter(new Parameter("state"), null, EvolutionState.class);
                        state.parameters = new ParameterDatabase();
                        state.parameters.addParent(parameters);
                        state.random = random;
                        state.output = output;
                        state.evalthreads = evalthreads;
                        state.breedthreads = breedthreads;
                        state.setup(state, null);
                        state.population = state.initializer.setupPopulation(state, 0);
                        MasterProblem storage = state.evaluator.masterproblem;
                        storage.receiveAdditionalData(state, dataIn);
                        storage.transferAdditionalData(state);
                        try {
                            block35: while (true) {
                                EvolutionState newState = state;
                                if (runEvolve) {
                                    ParameterDatabase coverDatabase = new ParameterDatabase();
                                    coverDatabase.addParent(state.parameters);
                                    newState = Evolve.initialize(coverDatabase, 0);
                                    newState.startFresh();
                                    newState.output.message("Replacing random number generators, ignore above seed message");
                                    newState.random = state.random;
                                    storage.transferAdditionalData(newState);
                                }
                                byte problemType = dataIn.readByte();
                                switch (problemType) {
                                    case 0: {
                                        socket.close();
                                        if (oneShot) {
                                            return;
                                        }
                                        throw new Output.OutputExitException("SHUTDOWN");
                                    }
                                    case 1: {
                                        Slave.evaluateSimpleProblemForm(newState, returnIndividuals, dataIn, dataOut, args);
                                        continue block35;
                                    }
                                    case 2: {
                                        Slave.evaluateGroupedProblemForm(newState, returnIndividuals, dataIn, dataOut);
                                        continue block35;
                                    }
                                }
                                state.output.fatal("Unknown problem form specified: " + problemType);
                            }
                        }
                        catch (Exception e) {
                            state.output.fatal("Unable to read type of evaluation from master.  Maybe the master closed its socket and exited?:\n" + String.valueOf(e));
                        }
                    }
                    catch (UnknownHostException e) {
                        if (state != null) {
                            state.output.fatal(e.getMessage());
                        } else if (!silent) {
                            Output.initialError("FATAL ERROR (EvolutionState not created yet): " + e.getMessage(), true);
                        }
                    }
                    catch (IOException e) {
                        if (state != null) {
                            state.output.fatal("Unable to connect to master:\n" + String.valueOf(e));
                            break block79;
                        }
                        if (!silent) {
                            Output.initialError("FATAL ERROR (EvolutionState not created yet): " + String.valueOf(e), true);
                        }
                    }
                }
                catch (Output.OutputExitException e) {
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (oneShot) {
                        throw e;
                    }
                }
                catch (OutOfMemoryError e) {
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (oneShot) {
                        throw e;
                    }
                    socket = null;
                    state = null;
                    System.gc();
                    System.err.println(e);
                }
            }
            if (oneShot && !silent) {
                Output.initialMessage("\n\nExiting Slave: this shouldn't have happened");
            }
            if (silent) continue;
            Output.initialMessage("\n\nResetting Slave");
        }
    }

    public static void evaluateSimpleProblemForm(final EvolutionState state, boolean returnIndividuals, DataInputStream dataIn, DataOutputStream dataOut, String[] args) {
        int numInds = 1;
        try {
            numInds = dataIn.readInt();
        }
        catch (Exception e) {
            state.output.fatal("Unable to read the number of individuals from the master:\n" + String.valueOf(e));
        }
        final int[] subpops = new int[numInds];
        int[] indsPerSubpop = new int[state.population.subpops.size()];
        for (int i = 0; i < numInds; ++i) {
            try {
                subpops[i] = dataIn.readInt();
                if (subpops[i] < 0 || subpops[i] >= state.population.subpops.size()) {
                    state.output.fatal("Bad subpop number for individual #" + i + ": " + subpops[i]);
                }
                int n = subpops[i];
                indsPerSubpop[n] = indsPerSubpop[n] + 1;
                continue;
            }
            catch (Exception e) {
                state.output.fatal("Unable to read the subpop number from the master:\n" + String.valueOf(e));
            }
        }
        boolean[] updateFitness = new boolean[numInds];
        final Individual[] inds = new Individual[numInds];
        if (!runEvolve) {
            ThreadPool.Worker[] threads = new ThreadPool.Worker[state.evalthreads];
            final SimpleProblemForm[] problems = new SimpleProblemForm[state.evalthreads];
            int[] indForThread = new int[state.evalthreads];
            for (int i = 0; i < problems.length; ++i) {
                problems[i] = (SimpleProblemForm)state.evaluator.p_problem.clone();
            }
            int t = 0;
            try {
                for (int i = 0; i < numInds; ++i) {
                    inds[i] = state.population.subpops.get((int)subpops[i]).species.newIndividual(state, dataIn);
                    updateFitness[i] = dataIn.readBoolean();
                    if (t >= state.evalthreads) {
                        t = 0;
                    }
                    if (threads[t] != null) {
                        pool.join(threads[t]);
                        Slave.returnIndividualsToMaster(state, inds, updateFitness, dataOut, returnIndividuals, indForThread[t]);
                    }
                    final int _i = i;
                    final int _t = t;
                    indForThread[t] = i;
                    threads[t] = pool.start(new Runnable(){

                        @Override
                        public void run() {
                            problems[_t].evaluate(state, inds[_i], subpops[_i], _t);
                        }
                    }, "Evaluation of individual " + i);
                    ++t;
                }
                for (t = 0; t < state.evalthreads; ++t) {
                    if (threads[t] == null) continue;
                    pool.join(threads[t]);
                    Slave.returnIndividualsToMaster(state, inds, updateFitness, dataOut, returnIndividuals, indForThread[t]);
                }
            }
            catch (Exception e) {
                state.output.fatal("Unable to read individual from master:\n" + String.valueOf(e));
            }
            try {
                dataOut.flush();
            }
            catch (IOException e) {
                state.output.fatal("Caught fatal IOException:\n" + String.valueOf(e));
            }
        } else {
            try {
                for (int i = 0; i < numInds; ++i) {
                    inds[i] = state.population.subpops.get((int)subpops[i]).species.newIndividual(state, dataIn);
                    updateFitness[i] = dataIn.readBoolean();
                }
            }
            catch (Exception e) {
                state.output.fatal("Unable to read individual from master:\n" + String.valueOf(e));
            }
            long startTime = System.currentTimeMillis();
            long endTime = 0L;
            for (int subpop = 0; subpop < state.population.subpops.size(); ++subpop) {
                if (state.population.subpops.get((int)subpop).individuals.size() == indsPerSubpop[subpop]) continue;
                state.population.subpops.get((int)subpop).individuals = new ArrayList(indsPerSubpop[subpop]);
            }
            int[] counts = new int[state.population.subpops.size()];
            for (int i = 0; i < numInds; ++i) {
                int n = subpops[i];
                int n2 = counts[n];
                counts[n] = n2 + 1;
                state.population.subpops.get((int)subpops[i]).individuals.set(n2, inds[i]);
            }
            int result = 2;
            while (result == 2) {
                result = state.evolve();
                endTime = System.currentTimeMillis();
                if (endTime - startTime <= (long)runTime) continue;
            }
            counts = new int[state.population.subpops.size()];
            for (int i = 0; i < numInds; ++i) {
                int n = subpops[i];
                int n3 = counts[n];
                counts[n] = n3 + 1;
                inds[i] = state.population.subpops.get((int)subpops[i]).individuals.get(n3);
            }
            state.finish(result);
            Evolve.cleanup(state);
            try {
                Slave.returnIndividualsToMaster(state, inds, updateFitness, dataOut, returnIndividuals, -1);
                dataOut.flush();
            }
            catch (IOException e) {
                state.output.fatal("Caught fatal IOException\n" + String.valueOf(e));
            }
        }
    }

    public static void evaluateGroupedProblemForm(EvolutionState state, boolean returnIndividuals, DataInputStream dataIn, DataOutputStream dataOut) {
        boolean countVictoriesOnly = false;
        int numInds = 1;
        try {
            countVictoriesOnly = dataIn.readBoolean();
            numInds = dataIn.readInt();
        }
        catch (Exception e) {
            state.output.fatal("Unable to read the number of individuals from the master:\n" + String.valueOf(e));
        }
        int[] subpops = new int[numInds];
        int[] indsPerSubpop = new int[state.population.subpops.size()];
        for (int i = 0; i < numInds; ++i) {
            try {
                subpops[i] = dataIn.readInt();
                if (subpops[i] < 0 || subpops[i] >= state.population.subpops.size()) {
                    state.output.fatal("Bad subpop number for individual #" + i + ": " + subpops[i]);
                }
                int n = subpops[i];
                indsPerSubpop[n] = indsPerSubpop[n] + 1;
                continue;
            }
            catch (Exception e) {
                state.output.fatal("Unable to read the subpop number from the master:\n" + String.valueOf(e));
            }
        }
        Individual[] inds = new Individual[numInds];
        boolean[] updateFitness = new boolean[numInds];
        try {
            for (int i = 0; i < inds.length; ++i) {
                inds[i] = state.population.subpops.get((int)subpops[i]).species.newIndividual(state, dataIn);
                updateFitness[i] = dataIn.readBoolean();
            }
        }
        catch (Exception e) {
            state.output.fatal("Unable to read individual from master:\n" + String.valueOf(e));
        }
        ((GroupedProblemForm)((Object)state.evaluator.p_problem)).evaluate(state, inds, updateFitness, countVictoriesOnly, subpops, 0);
        try {
            Slave.returnIndividualsToMaster(state, inds, updateFitness, dataOut, returnIndividuals, -1);
            dataOut.flush();
        }
        catch (IOException e) {
            state.output.fatal("Caught fatal IOException\n" + String.valueOf(e));
        }
    }

    static void returnIndividualsToMaster(EvolutionState state, Individual[] inds, boolean[] updateFitness, DataOutputStream dataOut, boolean returnIndividuals, int individualInQuestion) throws IOException {
        int startInd = individualInQuestion == -1 ? 0 : individualInQuestion;
        int endInd = individualInQuestion == -1 ? inds.length : individualInQuestion + 1;
        for (int i = startInd; i < endInd; ++i) {
            dataOut.writeByte(returnIndividuals ? 1 : (updateFitness[i] ? 2 : 0));
            if (returnIndividuals) {
                inds[i].writeIndividual(state, dataOut);
                continue;
            }
            if (!updateFitness[i]) continue;
            dataOut.writeBoolean(inds[i].evaluated);
            inds[i].fitness.writeFitness(state, dataOut);
        }
    }
}

