/*
 * Decompiled with CFR 0.152.
 */
package ec.eval;

import ec.EvolutionState;
import ec.eval.Job;
import ec.eval.SlaveMonitor;
import ec.util.ThreadPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.LinkedList;

class SlaveConnection {
    String slaveName;
    Socket evalSocket;
    DataOutputStream dataOut;
    public DataInputStream dataIn;
    EvolutionState state;
    SlaveMonitor slaveMonitor;
    ThreadPool.Worker reader;
    Runnable readerRun;
    ThreadPool.Worker writer;
    Runnable writerRun;
    LinkedList<Job> jobs = new LinkedList();
    boolean shuttingDown;
    Object shutDownLock = new int[0];
    boolean showDebugInfo;

    public SlaveConnection(EvolutionState state, String slaveName, Socket evalSocket, DataOutputStream dataOut, DataInputStream dataIn, SlaveMonitor slaveMonitor) {
        this.slaveName = slaveName;
        this.evalSocket = evalSocket;
        this.dataOut = dataOut;
        this.dataIn = dataIn;
        this.state = state;
        this.slaveMonitor = slaveMonitor;
        this.buildThreads();
        this.showDebugInfo = slaveMonitor.showDebugInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown(EvolutionState state) {
        LinkedList<Job> linkedList = this.shutDownLock;
        synchronized (linkedList) {
            if (this.shuttingDown) {
                return;
            }
            this.shuttingDown = true;
        }
        try {
            this.dataOut.writeByte(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.dataOut.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.dataOut.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.dataIn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.evalSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.slaveMonitor.unregisterSlave(this);
        linkedList = this.jobs;
        synchronized (linkedList) {
            this.slaveMonitor.notifyMonitor(this.jobs);
            this.reader.interrupt();
            this.writer.interrupt();
        }
        this.slaveMonitor.pool.join(this.reader, this.readerRun);
        this.slaveMonitor.pool.join(this.writer, this.writerRun);
        this.reader = null;
        this.writer = null;
        this.readerRun = null;
        this.writerRun = null;
        state.output.systemMessage("Slave " + this.slaveName + " shut down.");
        if (this.slaveMonitor.rescheduleLostJobs) {
            this.rescheduleJobs(state);
        }
    }

    public String toString() {
        return "Slave(" + this.slaveName + ")";
    }

    final void debug(String s) {
        if (this.showDebugInfo) {
            System.err.println(Thread.currentThread().getName() + "->" + s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numJobs() {
        LinkedList<Job> linkedList = this.jobs;
        synchronized (linkedList) {
            return this.jobs.size();
        }
    }

    void buildThreads() {
        this.readerRun = new Runnable(){

            @Override
            public void run() {
                while (SlaveConnection.this.readLoop()) {
                }
            }
        };
        this.reader = this.slaveMonitor.pool.start(this.readerRun);
        this.writerRun = new Runnable(){

            @Override
            public void run() {
                while (SlaveConnection.this.writeLoop()) {
                }
            }
        };
        this.writer = this.slaveMonitor.pool.start(this.writerRun);
    }

    Job oldestUnsentJob() {
        for (Job job : this.jobs) {
            if (job.sent) continue;
            job.sent = true;
            return job;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean writeLoop() {
        Job job = null;
        try {
            LinkedList<Job> linkedList = this.jobs;
            synchronized (linkedList) {
                job = this.oldestUnsentJob();
                if (job == null) {
                    this.debug(Thread.currentThread().getName() + "Waiting for a job to send");
                    this.jobs.wait();
                }
            }
            if (job != null) {
                this.debug(Thread.currentThread().getName() + "Sending Job");
                if (job.type == 1) {
                    this.dataOut.writeByte(1);
                } else {
                    this.dataOut.writeByte(2);
                    this.dataOut.writeBoolean(job.countVictoriesOnly);
                }
                this.dataOut.writeInt(job.inds.length);
                for (int x = 0; x < job.subPops.length; ++x) {
                    this.dataOut.writeInt(job.subPops[x]);
                }
                this.debug("Starting to transmit individuals");
                for (int i = 0; i < job.inds.length; ++i) {
                    job.inds[i].writeIndividual(this.state, this.dataOut);
                    this.dataOut.writeBoolean(job.updateFitness[i]);
                }
                this.dataOut.flush();
            }
        }
        catch (Exception e) {
            this.shutdown(this.state);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean readLoop() {
        Job job = null;
        try {
            byte val = this.dataIn.readByte();
            this.debug(this.toString() + " Incoming Job");
            LinkedList<Job> linkedList = this.jobs;
            synchronized (linkedList) {
                job = this.jobs.getFirst();
            }
            this.debug("Got job: " + String.valueOf(job));
            job.copyIndividualsForward();
            for (int i = 0; i < job.newinds.length; ++i) {
                this.debug(this.toString() + " Individual# " + i);
                this.debug(this.toString() + " Reading Byte");
                if (i > 0) {
                    val = this.dataIn.readByte();
                }
                this.debug(this.toString() + " Reading Individual");
                if (val == 1) {
                    job.newinds[i].readIndividual(this.state, this.dataIn);
                } else if (val == 2) {
                    job.newinds[i].evaluated = this.dataIn.readBoolean();
                    job.newinds[i].fitness.readFitness(this.state, this.dataIn);
                } else if (val == 0) {
                    // empty if block
                }
                this.debug(this.toString() + " Read Individual");
            }
            job.copyIndividualsBack(this.state);
            LinkedList<Job> linkedList2 = this.jobs;
            synchronized (linkedList2) {
                this.jobs.removeFirst();
            }
            this.slaveMonitor.notifySlaveAvailability(this, job, this.state);
        }
        catch (IOException e) {
            this.shutdown(this.state);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleJob(Job job) {
        LinkedList<Job> linkedList = this.jobs;
        synchronized (linkedList) {
            if (job.sent) {
                this.state.output.fatal("Tried to schedule a job which had already been scheduled.");
            }
            this.jobs.addLast(job);
            this.slaveMonitor.notifyMonitor(this.jobs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rescheduleJobs(EvolutionState state) {
        while (true) {
            Job job = null;
            LinkedList<Job> linkedList = this.jobs;
            synchronized (linkedList) {
                if (this.jobs.isEmpty()) {
                    return;
                }
                job = this.jobs.removeFirst();
            }
            this.debug(Thread.currentThread().getName() + " Waiting for a slave to reschedule the evaluation.");
            job.sent = false;
            this.slaveMonitor.scheduleJobForEvaluation(state, job);
            this.debug(Thread.currentThread().getName() + " Got a slave to reschedule the evaluation.");
        }
    }
}

