/*
 * Decompiled with CFR 0.152.
 */
package ec.eval;

import ec.EvolutionState;
import ec.Problem;
import ec.eval.Job;
import ec.eval.MasterProblem;
import ec.eval.SlaveConnection;
import ec.steadystate.QueueIndividual;
import ec.steadystate.SteadyStateEvolutionState;
import ec.util.Output;
import ec.util.Parameter;
import ec.util.ThreadPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class SlaveMonitor {
    public static final String P_EVALNODELAY = "eval.no-delay";
    public static final String P_EVALSENDBUFER = "eval.send-buffer";
    public static final String P_EVALRECVBUFFER = "eval.recv-buffer";
    public static final String P_EVALMASTERPORT = "eval.master.port";
    public static final String P_EVALCOMPRESSION = "eval.compression";
    public static final String P_MAXIMUMNUMBEROFCONCURRENTJOBSPERSLAVE = "eval.masterproblem.max-jobs-per-slave";
    public static final String P_RESCHEDULELOSTJOBS = "eval.masterproblem.reschedule-lost-jobs";
    public static final int SEED_INCREMENT = 7919;
    public EvolutionState state;
    boolean rescheduleLostJobs;
    ThreadPool pool;
    int slaveNum = 0;
    public ServerSocket servSock;
    public boolean useCompression;
    boolean shutdownInProgress = false;
    Object[] shutdownInProgressLock = new Object[0];
    int randomSeed;
    Thread thread;
    LinkedList<SlaveConnection> allSlaves = new LinkedList();
    LinkedList<SlaveConnection> availableSlaves = new LinkedList();
    int maxJobsPerSlave;
    boolean showDebugInfo;
    LinkedList<QueueIndividual> evaluatedIndividuals = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isShutdownInProgress() {
        Object[] objectArray = this.shutdownInProgressLock;
        synchronized (this.shutdownInProgressLock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.shutdownInProgress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setShutdownInProgress(boolean val) {
        Object[] objectArray = this.shutdownInProgressLock;
        synchronized (this.shutdownInProgressLock) {
            this.shutdownInProgress = val;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitOnMonitor(Object monitor) {
        try {
            if (Thread.interrupted()) {
                return false;
            }
            Object object = monitor;
            synchronized (object) {
                monitor.wait();
            }
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    public void notifyMonitor(Object monitor) {
        monitor.notifyAll();
    }

    final void debug(String s) {
        if (this.showDebugInfo) {
            System.err.println(Thread.currentThread().getName() + "->" + s);
        }
    }

    public SlaveMonitor(final EvolutionState state, boolean showDebugInfo, final MasterProblem problemPrototype) {
        this.showDebugInfo = showDebugInfo;
        this.state = state;
        this.pool = new ThreadPool();
        int port = state.parameters.getInt(new Parameter(P_EVALMASTERPORT), null);
        this.maxJobsPerSlave = state.parameters.getInt(new Parameter(P_MAXIMUMNUMBEROFCONCURRENTJOBSPERSLAVE), null);
        this.rescheduleLostJobs = state.parameters.getBoolean(new Parameter(P_RESCHEDULELOSTJOBS), null, true);
        this.useCompression = state.parameters.getBoolean(new Parameter(P_EVALCOMPRESSION), null, false);
        final int noDelay = state.parameters.exists(new Parameter(P_EVALNODELAY), null) ? (state.parameters.getBoolean(new Parameter(P_EVALNODELAY), null, true) ? 1 : 0) : -1;
        final int sendBuffer = state.parameters.getInt(new Parameter(P_EVALSENDBUFER), null, -1);
        final int recvBuffer = state.parameters.getInt(new Parameter(P_EVALRECVBUFFER), null, -1);
        try {
            this.servSock = new ServerSocket(port);
        }
        catch (IOException e) {
            state.output.fatal("Unable to bind to port " + port + ": " + String.valueOf(e));
        }
        this.randomSeed = (int)System.currentTimeMillis();
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setName("SlaveMonitor::    ");
                while (!SlaveMonitor.this.isShutdownInProgress()) {
                    Socket slaveSock = null;
                    while (slaveSock == null && !SlaveMonitor.this.isShutdownInProgress()) {
                        try {
                            slaveSock = SlaveMonitor.this.servSock.accept();
                        }
                        catch (IOException e) {
                            slaveSock = null;
                        }
                    }
                    if (slaveSock == null) break;
                    SlaveMonitor.this.debug(Thread.currentThread().getName() + " Slave attempts to connect.");
                    state.output.systemMessage(" Slave attempts to connect.");
                    Object connection = SlaveMonitor.this.registerSlave(state, slaveSock, problemPrototype, SlaveMonitor.this.useCompression, noDelay, sendBuffer, recvBuffer);
                    if (connection instanceof SlaveConnection) {
                        state.output.systemMessage("Slave " + ((SlaveConnection)connection).slaveName + " connected successfully.");
                        continue;
                    }
                    state.output.systemMessage("Slave " + (String)connection + " not permitted to connect.");
                }
                SlaveMonitor.this.debug(Thread.currentThread().getName() + " The monitor is shutting down.");
            }
        });
        this.thread.setDaemon(true);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object registerSlave(EvolutionState state, Socket socket, Problem problemPrototype, boolean useCompression, int noDelay, int sendBuffer, int recvBuffer) {
        try {
            if (noDelay == 1) {
                socket.setTcpNoDelay(true);
                Output.initialMessage("NoDelay -> ON");
            } else if (noDelay == 0) {
                socket.setTcpNoDelay(false);
                Output.initialMessage("NoDelay -> OFF");
            }
            if (sendBuffer >= 0) {
                Output.initialMessage("SendBuffer Changed from " + socket.getSendBufferSize() + " to " + sendBuffer);
                socket.setSendBufferSize(sendBuffer);
            }
            if (recvBuffer >= 0) {
                Output.initialMessage("RecvBuffer Changed from " + socket.getReceiveBufferSize() + " to " + recvBuffer);
                socket.setReceiveBufferSize(recvBuffer);
            }
            DataInputStream dataIn = null;
            DataOutputStream dataOut = null;
            InputStream tmpIn = socket.getInputStream();
            OutputStream tmpOut = socket.getOutputStream();
            tmpOut.write((byte)(useCompression ? 1 : 0));
            if (useCompression) {
                tmpIn = Output.makeCompressingInputStream(tmpIn);
                tmpOut = Output.makeCompressingOutputStream(tmpOut);
                if (tmpIn == null || tmpOut == null) {
                    state.output.fatal("You do not appear to have JZLib installed on your system, and so must set eval.compression=false. To get JZLib, download from the ECJ website or from http://www.jcraft.com/jzlib/");
                }
            }
            dataIn = new DataInputStream(tmpIn);
            dataOut = new DataOutputStream(tmpOut);
            dataOut.writeInt(this.slaveNum++);
            dataOut.flush();
            String slaveName = dataIn.readUTF();
            dataOut.writeInt(this.randomSeed);
            this.randomSeed += 7919;
            problemPrototype.sendAdditionalData(state, dataOut);
            dataOut.flush();
            if (this.isShutdownInProgress()) {
                try {
                    dataOut.writeByte(0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    dataOut.flush();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    dataOut.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    dataIn.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return slaveName;
            }
            SlaveConnection newSlave = new SlaveConnection(state, slaveName, socket, dataOut, dataIn, this);
            LinkedList<SlaveConnection> linkedList = this.allSlaves;
            synchronized (linkedList) {
                this.allSlaves.addLast(newSlave);
                this.notifyMonitor(this.allSlaves);
            }
            linkedList = this.availableSlaves;
            synchronized (linkedList) {
                this.availableSlaves.addLast(newSlave);
                this.notifyMonitor(this.availableSlaves);
            }
            return newSlave;
        }
        catch (IOException ex) {
            System.err.println(ex);
            return "UNKNOWN";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterSlave(SlaveConnection slave) {
        LinkedList<SlaveConnection> linkedList = this.allSlaves;
        synchronized (linkedList) {
            if (this.allSlaves.contains(slave)) {
                this.allSlaves.remove(slave);
                this.notifyMonitor(this.allSlaves);
            }
        }
        linkedList = this.availableSlaves;
        synchronized (linkedList) {
            if (this.availableSlaves.contains(slave)) {
                this.availableSlaves.remove(slave);
                this.notifyMonitor(this.availableSlaves);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.setShutdownInProgress(true);
        try {
            this.servSock.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.debug("Main Monitor Thread Shut Down");
        while (true) {
            SlaveConnection sc = null;
            LinkedList<SlaveConnection> linkedList = this.allSlaves;
            synchronized (linkedList) {
                if (this.allSlaves.isEmpty()) {
                    break;
                }
                sc = this.allSlaves.removeFirst();
            }
            this.debug("Shutting Down Slave" + String.valueOf(sc));
            if (sc != null) {
                sc.shutdown(this.state);
            }
            this.debug("Shut Down Slave" + String.valueOf(sc));
        }
        LinkedList<SlaveConnection> linkedList = this.allSlaves;
        synchronized (linkedList) {
            this.notifyMonitor(this.allSlaves);
        }
        this.pool.killAll();
        this.debug("Shut Down Completed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleJobForEvaluation(EvolutionState state, Job job) {
        if (this.isShutdownInProgress()) {
            return;
        }
        SlaveConnection result = null;
        LinkedList<SlaveConnection> linkedList = this.availableSlaves;
        synchronized (linkedList) {
            while (true) {
                if (!this.availableSlaves.isEmpty()) break;
                this.debug("Waiting for an available slave.");
                this.waitOnMonitor(this.availableSlaves);
            }
            result = this.availableSlaves.removeFirst();
            this.notifyMonitor(this.availableSlaves);
        }
        this.debug("Got a slave available for work.");
        result.scheduleJob(job);
        if (result.numJobs() < this.maxJobsPerSlave) {
            linkedList = this.availableSlaves;
            synchronized (linkedList) {
                if (!this.availableSlaves.contains(result)) {
                    this.availableSlaves.addLast(result);
                }
                this.notifyMonitor(this.availableSlaves);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForAllSlavesToFinishEvaluating(EvolutionState state) {
        LinkedList<SlaveConnection> linkedList = this.allSlaves;
        synchronized (linkedList) {
            for (SlaveConnection slaveConnection : this.allSlaves) {
                try {
                    slaveConnection.dataOut.flush();
                }
                catch (IOException iOException) {}
            }
            this.notifyMonitor(this.allSlaves);
        }
        boolean shouldCycle = true;
        LinkedList<SlaveConnection> linkedList2 = this.allSlaves;
        synchronized (linkedList2) {
            while (shouldCycle) {
                shouldCycle = false;
                for (SlaveConnection slaveConnection : this.allSlaves) {
                    int jobs = slaveConnection.numJobs();
                    if (jobs == 0) continue;
                    this.debug("Slave " + String.valueOf(slaveConnection) + " has " + jobs + " more jobs to finish.");
                    shouldCycle = true;
                    break;
                }
                if (!shouldCycle) continue;
                this.debug("Waiting for slaves to finish their jobs.");
                this.waitOnMonitor(this.allSlaves);
                this.debug("At least one job has been finished.");
            }
            this.notifyMonitor(this.allSlaves);
        }
        this.debug("All slaves have finished their jobs.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifySlaveAvailability(SlaveConnection slave, Job job, EvolutionState state) {
        LinkedList<Object> linkedList = this.allSlaves;
        synchronized (linkedList) {
            this.notifyMonitor(this.allSlaves);
        }
        if (slave.numJobs() < this.maxJobsPerSlave) {
            linkedList = this.availableSlaves;
            synchronized (linkedList) {
                if (!this.availableSlaves.contains(slave)) {
                    this.availableSlaves.addLast(slave);
                }
                this.notifyMonitor(this.availableSlaves);
            }
        }
        this.debug("Notify the monitor that the slave is available.");
        if (state instanceof SteadyStateEvolutionState) {
            linkedList = this.evaluatedIndividuals;
            synchronized (linkedList) {
                for (int x = 0; x < job.inds.length; ++x) {
                    this.evaluatedIndividuals.addLast(new QueueIndividual(job.inds[x], job.subPops[x]));
                }
                this.notifyMonitor(this.evaluatedIndividuals);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean evaluatedIndividualAvailable() {
        LinkedList<QueueIndividual> linkedList = this.evaluatedIndividuals;
        synchronized (linkedList) {
            try {
                this.evaluatedIndividuals.getFirst();
                return true;
            }
            catch (NoSuchElementException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueIndividual waitForIndividual() {
        while (true) {
            LinkedList<QueueIndividual> linkedList = this.evaluatedIndividuals;
            synchronized (linkedList) {
                if (this.evaluatedIndividualAvailable()) {
                    return this.evaluatedIndividuals.removeFirst();
                }
                this.debug("Waiting for individual to be evaluated.");
                this.waitOnMonitor(this.evaluatedIndividuals);
                this.debug("At least one individual has been finished.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int numAvailableSlaves() {
        int i = 0;
        LinkedList<SlaveConnection> linkedList = this.availableSlaves;
        synchronized (linkedList) {
            i = this.availableSlaves.size();
        }
        return i;
    }

    void writeObject(ObjectOutputStream out) throws IOException {
        this.state.output.fatal("Not implemented yet: SlaveMonitor.writeObject");
    }

    void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.state.output.fatal("Not implemented yet: SlaveMonitor.readObject");
    }
}

