/*
 * Decompiled with CFR 0.152.
 */
package ec.exchange;

import ec.EvolutionState;
import ec.Exchanger;
import ec.Individual;
import ec.Population;
import ec.SelectionMethod;
import ec.select.RandomSelection;
import ec.util.Parameter;
import java.io.Serializable;

public class InterPopulationExchange
extends Exchanger {
    private static final long serialVersionUID = 1L;
    public static final String P_SUBPOP = "subpop";
    public static final String P_MODULO = "mod";
    public static final String P_SIZE = "size";
    public static final String P_OFFSET = "start";
    public static final String P_DEST_FOR_SUBPOP = "num-dest";
    public static final String P_DEST = "dest";
    public static final String P_SELECT_METHOD = "select";
    public static final String P_SELECT_TO_DIE_METHOD = "select-to-die";
    public static final String P_CHATTY = "chatty";
    public Parameter base;
    IPEInformation[] exchangeInformation;
    Individual[][] immigrants;
    int[] nImmigrants;
    int nrSources;
    public boolean chatty;

    @Override
    public void setup(EvolutionState state, Parameter _base) {
        this.base = _base;
        Parameter p_numsubpops = new Parameter("pop").push("subpops");
        int numsubpops = state.parameters.getInt(p_numsubpops, null, 1);
        if (numsubpops == 0) {
            // empty if block
        }
        int[] incoming = new int[numsubpops];
        this.exchangeInformation = new IPEInformation[numsubpops];
        for (int i = 0; i < numsubpops; ++i) {
            this.exchangeInformation[i] = new IPEInformation();
        }
        this.nImmigrants = new int[numsubpops];
        Parameter localBase = this.base.push(P_SUBPOP);
        this.chatty = state.parameters.getBoolean(this.base.push(P_CHATTY), null, true);
        for (int i = 0; i < numsubpops; ++i) {
            Parameter p = localBase.push("" + i);
            this.exchangeInformation[i].immigrantsSelectionMethod = (SelectionMethod)state.parameters.getInstanceForParameter(p.push(P_SELECT_METHOD), this.base.push(P_SELECT_METHOD), SelectionMethod.class);
            if (this.exchangeInformation[i].immigrantsSelectionMethod == null) {
                state.output.fatal("Invalid parameter.", p.push(P_SELECT_METHOD), this.base.push(P_SELECT_METHOD));
            }
            this.exchangeInformation[i].immigrantsSelectionMethod.setup(state, p.push(P_SELECT_METHOD));
            this.exchangeInformation[i].indsToDieSelectionMethod = state.parameters.exists(p.push(P_SELECT_TO_DIE_METHOD), this.base.push(P_SELECT_TO_DIE_METHOD)) ? (SelectionMethod)state.parameters.getInstanceForParameter(p.push(P_SELECT_TO_DIE_METHOD), this.base.push(P_SELECT_TO_DIE_METHOD), SelectionMethod.class) : new RandomSelection();
            this.exchangeInformation[i].indsToDieSelectionMethod.setup(state, p.push(P_SELECT_TO_DIE_METHOD));
            this.exchangeInformation[i].modulo = state.parameters.getInt(p.push(P_MODULO), this.base.push(P_MODULO), 1);
            if (this.exchangeInformation[i].modulo == 0) {
                state.output.fatal("Parameter not found, or it has an incorrect value.", p.push(P_MODULO), this.base.push(P_MODULO));
            }
            this.exchangeInformation[i].offset = state.parameters.getInt(p.push(P_OFFSET), this.base.push(P_OFFSET), 0);
            if (this.exchangeInformation[i].offset == -1) {
                state.output.fatal("Parameter not found, or it has an incorrect value.", p.push(P_OFFSET), this.base.push(P_OFFSET));
            }
            this.exchangeInformation[i].size = state.parameters.getInt(p.push(P_SIZE), this.base.push(P_SIZE), 1);
            if (this.exchangeInformation[i].size == 0) {
                state.output.fatal("Parameter not found, or it has an incorrect value.", p.push(P_SIZE), this.base.push(P_SIZE));
            }
            this.exchangeInformation[i].numDest = state.parameters.getInt(p.push(P_DEST_FOR_SUBPOP), null, 0);
            if (this.exchangeInformation[i].numDest == -1) {
                state.output.fatal("Parameter not found, or it has an incorrect value.", p.push(P_DEST_FOR_SUBPOP));
            }
            this.exchangeInformation[i].destinations = new int[this.exchangeInformation[i].numDest];
            for (int j = 0; j < this.exchangeInformation[i].numDest; ++j) {
                this.exchangeInformation[i].destinations[j] = state.parameters.getInt(p.push(P_DEST).push("" + j), null, 0);
                if (this.exchangeInformation[i].destinations[j] == -1 || this.exchangeInformation[i].destinations[j] >= numsubpops) {
                    state.output.fatal("Parameter not found, or it has an incorrect value.", p.push(P_DEST).push("" + j));
                }
                int n = this.exchangeInformation[i].destinations[j];
                incoming[n] = incoming[n] + this.exchangeInformation[i].size;
            }
        }
        int max = -1;
        for (int i = 0; i < incoming.length; ++i) {
            if (max != -1 && max >= incoming[i]) continue;
            max = incoming[i];
        }
        this.immigrants = new Individual[numsubpops][max];
    }

    @Override
    public void initializeContacts(EvolutionState state) {
    }

    @Override
    public void reinitializeContacts(EvolutionState state) {
    }

    @Override
    public Population preBreedingExchangePopulation(EvolutionState state) {
        for (int i = 0; i < this.exchangeInformation.length; ++i) {
            if (state.generation < this.exchangeInformation[i].offset || this.exchangeInformation[i].modulo != 0 && (state.generation - this.exchangeInformation[i].offset) % this.exchangeInformation[i].modulo != 0) continue;
            for (int x = 0; x < this.exchangeInformation[i].numDest; ++x) {
                if (this.chatty) {
                    state.output.message("Sending the emigrants from subpopulation " + i + " to subpopulation " + this.exchangeInformation[i].destinations[x]);
                }
                this.exchangeInformation[i].immigrantsSelectionMethod.prepareToProduce(state, i, 0);
                for (int y = 0; y < this.exchangeInformation[i].size; ++y) {
                    int index = this.exchangeInformation[i].immigrantsSelectionMethod.produce(i, state, 0);
                    this.immigrants[this.exchangeInformation[i].destinations[x]][this.nImmigrants[this.exchangeInformation[i].destinations[x]]] = this.process(state, 0, null, this.exchangeInformation[i].destinations[x], (Individual)state.population.subpops.get((int)i).individuals.get(index).clone());
                    int n = this.exchangeInformation[i].destinations[x];
                    this.nImmigrants[n] = this.nImmigrants[n] + 1;
                }
                this.exchangeInformation[i].immigrantsSelectionMethod.finishProducing(state, i, 0);
            }
        }
        return state.population;
    }

    @Override
    public Population postBreedingExchangePopulation(EvolutionState state) {
        for (int x = 0; x < this.nImmigrants.length; ++x) {
            int i;
            if (this.nImmigrants[x] > 0 && this.chatty) {
                state.output.message("Immigrating " + this.nImmigrants[x] + " individuals from mailbox for subpopulation " + x);
            }
            int len = state.population.subpops.get((int)x).individuals.size();
            if (this.nImmigrants[x] >= state.population.subpops.get((int)x).individuals.size()) {
                state.output.fatal("Number of immigrants (" + this.nImmigrants[x] + ") is larger than subpopulation #" + x + "'s size (" + len + ").  This would cause an infinite loop in the selection-to-die procedure.");
            }
            boolean[] selected = new boolean[len];
            int[] indices = new int[this.nImmigrants[x]];
            for (i = 0; i < selected.length; ++i) {
                selected[i] = false;
            }
            this.exchangeInformation[x].indsToDieSelectionMethod.prepareToProduce(state, x, 0);
            for (i = 0; i < this.nImmigrants[x]; ++i) {
                do {
                    indices[i] = this.exchangeInformation[x].indsToDieSelectionMethod.produce(x, state, 0);
                } while (selected[indices[i]]);
                selected[indices[i]] = true;
            }
            this.exchangeInformation[x].indsToDieSelectionMethod.finishProducing(state, x, 0);
            for (int y = 0; y < this.nImmigrants[x]; ++y) {
                state.population.subpops.get((int)x).individuals.set(indices[y], this.immigrants[x][y]);
                state.population.subpops.get((int)x).individuals.get((int)indices[y]).evaluated = false;
            }
            this.nImmigrants[x] = 0;
        }
        return state.population;
    }

    @Override
    public String runComplete(EvolutionState state) {
        return null;
    }

    @Override
    public void closeContacts(EvolutionState state, int result) {
    }

    static class IPEInformation
    implements Serializable {
        SelectionMethod immigrantsSelectionMethod;
        SelectionMethod indsToDieSelectionMethod;
        int numDest;
        int[] destinations;
        int modulo;
        int offset;
        int size;

        IPEInformation() {
        }
    }
}

