/*
 * Decompiled with CFR 0.152.
 */
package ec.gp;

import ec.Clique;
import ec.EvolutionState;
import ec.gp.GPInitializer;
import ec.gp.GPNode;
import ec.gp.GPType;
import ec.util.Parameter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class GPFunctionSet
implements Clique {
    private static final long serialVersionUID = 1L;
    public static final String P_NAME = "name";
    public static final String P_FUNC = "func";
    public static final String P_SIZE = "size";
    public String name;
    public Hashtable nodes_h;
    public GPNode[][] nodes;
    public Hashtable nonterminals_h;
    public GPNode[][] nonterminals;
    public Hashtable terminals_h;
    public GPNode[][] terminals;
    public Hashtable nodesByName;
    public GPNode[][][] nodesByArity;
    public GPNode[][][] nonterminalsUnderArity;
    public GPNode[][][] nonterminalsOverArity;

    public String toString() {
        return this.name;
    }

    public void postProcessFunctionSet() {
        int y;
        int cur_a;
        int y2;
        int num_of_a;
        int a;
        int x;
        GPNode[] gpfi;
        GPType gpt;
        this.nodes = new GPNode[this.nodes_h.size()][];
        this.terminals = new GPNode[this.terminals_h.size()][];
        this.nonterminals = new GPNode[this.nonterminals_h.size()][];
        Enumeration e = this.nodes_h.keys();
        while (e.hasMoreElements()) {
            gpt = (GPType)e.nextElement();
            gpfi = (GPNode[])this.nodes_h.get(gpt);
            this.nodes[gpt.type] = gpfi;
        }
        e = this.nonterminals_h.keys();
        while (e.hasMoreElements()) {
            gpt = (GPType)e.nextElement();
            gpfi = (GPNode[])this.nonterminals_h.get(gpt);
            this.nonterminals[gpt.type] = gpfi;
        }
        e = this.terminals_h.keys();
        while (e.hasMoreElements()) {
            gpt = (GPType)e.nextElement();
            gpfi = (GPNode[])this.terminals_h.get(gpt);
            this.terminals[gpt.type] = gpfi;
        }
        int max_arity = 0;
        for (x = 0; x < this.nodes.length; ++x) {
            for (int y3 = 0; y3 < this.nodes[x].length; ++y3) {
                if (max_arity >= this.nodes[x][y3].children.length) continue;
                max_arity = this.nodes[x][y3].children.length;
            }
        }
        this.nodesByArity = new GPNode[this.nodes.length][max_arity + 1][];
        for (x = 0; x < this.nodes.length; ++x) {
            for (a = 0; a <= max_arity; ++a) {
                num_of_a = 0;
                for (y2 = 0; y2 < this.nodes[x].length; ++y2) {
                    if (this.nodes[x][y2].children.length != a) continue;
                    ++num_of_a;
                }
                this.nodesByArity[x][a] = new GPNode[num_of_a];
                cur_a = 0;
                for (y = 0; y < this.nodes[x].length; ++y) {
                    if (this.nodes[x][y].children.length != a) continue;
                    this.nodesByArity[x][a][cur_a++] = this.nodes[x][y];
                }
            }
        }
        this.nonterminalsUnderArity = new GPNode[this.nonterminals.length][max_arity + 1][];
        for (x = 0; x < this.nonterminals.length; ++x) {
            for (a = 0; a <= max_arity; ++a) {
                num_of_a = 0;
                for (y2 = 0; y2 < this.nonterminals[x].length; ++y2) {
                    if (this.nonterminals[x][y2].children.length > a) continue;
                    ++num_of_a;
                }
                this.nonterminalsUnderArity[x][a] = new GPNode[num_of_a];
                cur_a = 0;
                for (y = 0; y < this.nonterminals[x].length; ++y) {
                    if (this.nonterminals[x][y].children.length > a) continue;
                    this.nonterminalsUnderArity[x][a][cur_a++] = this.nonterminals[x][y];
                }
            }
        }
        this.nonterminalsOverArity = new GPNode[this.nonterminals.length][max_arity + 1][];
        for (x = 0; x < this.nonterminals.length; ++x) {
            for (a = 0; a <= max_arity; ++a) {
                num_of_a = 0;
                for (y2 = 0; y2 < this.nonterminals[x].length; ++y2) {
                    if (this.nonterminals[x][y2].children.length < a) continue;
                    ++num_of_a;
                }
                this.nonterminalsOverArity[x][a] = new GPNode[num_of_a];
                cur_a = 0;
                for (y = 0; y < this.nonterminals[x].length; ++y) {
                    if (this.nonterminals[x][y].children.length < a) continue;
                    this.nonterminalsOverArity[x][a][cur_a++] = this.nonterminals[x][y];
                }
            }
        }
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        int numFuncs;
        GPFunctionSet old_functionset;
        this.name = state.parameters.getString(base.push(P_NAME), null);
        if (this.name == null) {
            state.output.fatal("No name was given for this function set.", base.push(P_NAME));
        }
        if ((old_functionset = ((GPInitializer)state.initializer).functionSetRepository.put(this.name, this)) != null) {
            state.output.fatal("The GPFunctionSet \"" + this.name + "\" has been defined multiple times.", base.push(P_NAME));
        }
        if ((numFuncs = state.parameters.getInt(base.push(P_SIZE), null, 1)) < 1) {
            state.output.error("The GPFunctionSet \"" + this.name + "\" has no functions.", base.push(P_SIZE));
        }
        this.nodesByName = new Hashtable();
        Parameter p = base.push(P_FUNC);
        Vector<GPNode> tmp = new Vector<GPNode>();
        for (int x = 0; x < numFuncs; ++x) {
            Parameter pp = p.push("" + x);
            GPNode gpfi = (GPNode)state.parameters.getInstanceForParameter(pp, null, GPNode.class);
            gpfi.setup(state, pp);
            tmp.addElement(gpfi);
            GPNode[] nodes = (GPNode[])this.nodesByName.get(gpfi.name());
            if (nodes == null) {
                this.nodesByName.put(gpfi.name(), new GPNode[]{gpfi});
                continue;
            }
            GPNode[] nodes2 = new GPNode[nodes.length + 1];
            System.arraycopy(nodes, 0, nodes2, 0, nodes.length);
            nodes2[nodes2.length - 1] = gpfi;
            this.nodesByName.put(gpfi.name(), nodes2);
        }
        this.nodes_h = new Hashtable();
        this.terminals_h = new Hashtable();
        this.nonterminals_h = new Hashtable();
        Enumeration e = ((GPInitializer)state.initializer).typeRepository.elements();
        GPInitializer initializer = (GPInitializer)state.initializer;
        while (e.hasMoreElements()) {
            GPType typ = (GPType)e.nextElement();
            Vector<GPNode> nodes_v = new Vector<GPNode>();
            Vector<GPNode> terminals_v = new Vector<GPNode>();
            Vector<GPNode> nonterminals_v = new Vector<GPNode>();
            Enumeration v = tmp.elements();
            while (v.hasMoreElements()) {
                GPNode i = (GPNode)v.nextElement();
                if (!typ.compatibleWith(initializer, i.constraints((GPInitializer)initializer).returntype)) continue;
                nodes_v.addElement(i);
                if (i.children.length == 0) {
                    terminals_v.addElement(i);
                    continue;
                }
                nonterminals_v.addElement(i);
            }
            Object[] ii = new GPNode[nodes_v.size()];
            nodes_v.copyInto(ii);
            this.nodes_h.put(typ, ii);
            ii = new GPNode[terminals_v.size()];
            terminals_v.copyInto(ii);
            this.terminals_h.put(typ, ii);
            ii = new GPNode[nonterminals_v.size()];
            nonterminals_v.copyInto(ii);
            this.nonterminals_h.put(typ, ii);
        }
        state.output.exitIfErrors();
        this.postProcessFunctionSet();
    }

    public static GPFunctionSet functionSetFor(String functionSetName, EvolutionState state) {
        GPFunctionSet set = (GPFunctionSet)((GPInitializer)state.initializer).functionSetRepository.get(functionSetName);
        if (set == null) {
            state.output.error("The GP function set \"" + functionSetName + "\" could not be found.");
        }
        return set;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }
}

