/*
 * Decompiled with CFR 0.152.
 */
package ec.gp;

import ec.EvolutionState;
import ec.gp.GPAtomicType;
import ec.gp.GPDefaults;
import ec.gp.GPFunctionSet;
import ec.gp.GPNodeConstraints;
import ec.gp.GPSetType;
import ec.gp.GPTreeConstraints;
import ec.gp.GPType;
import ec.simple.SimpleInitializer;
import ec.util.Parameter;
import java.util.Enumeration;
import java.util.Hashtable;

public class GPInitializer
extends SimpleInitializer {
    private static final long serialVersionUID = 1L;
    public static final int SIZE_OF_BYTE = 256;
    public static final String P_TYPE = "type";
    public static final String P_NODECONSTRAINTS = "nc";
    public static final String P_TREECONSTRAINTS = "tc";
    public static final String P_FUNCTIONSETS = "fs";
    public static final String P_SIZE = "size";
    public static final String P_ATOMIC = "a";
    public static final String P_SET = "s";
    public Hashtable typeRepository;
    public GPType[] types;
    public int numAtomicTypes;
    public int numSetTypes;
    public Hashtable nodeConstraintRepository;
    public GPNodeConstraints[] nodeConstraints;
    public byte numNodeConstraints;
    public Hashtable functionSetRepository;
    public Hashtable treeConstraintRepository;
    public GPTreeConstraints[] treeConstraints;
    public byte numTreeConstraints;

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        this.setupTypes(state, GPDefaults.base().push(P_TYPE));
        this.setupNodeConstraints(state, GPDefaults.base().push(P_NODECONSTRAINTS));
        this.setupFunctionSets(state, GPDefaults.base().push(P_FUNCTIONSETS));
        this.setupTreeConstraints(state, GPDefaults.base().push(P_TREECONSTRAINTS));
    }

    public void setupTypes(EvolutionState state, Parameter base) {
        int y;
        state.output.message("Processing GP Types");
        this.typeRepository = new Hashtable();
        this.numSetTypes = 0;
        this.numAtomicTypes = 0;
        int x = state.parameters.getInt(base.push(P_ATOMIC).push(P_SIZE), null, 1);
        if (x <= 0) {
            state.output.fatal("The number of GP atomic types must be at least 1.", base.push(P_ATOMIC).push(P_SIZE));
        }
        for (y = 0; y < x; ++y) {
            new GPAtomicType().setup(state, base.push(P_ATOMIC).push("" + y));
        }
        if (state.parameters.exists(base.push(P_SET).push(P_SIZE), null)) {
            x = state.parameters.getInt(base.push(P_SET).push(P_SIZE), null, 1);
            if (x < 0) {
                state.output.fatal("The number of GP set types must be at least 0.", base.push(P_SET).push(P_SIZE));
            }
        } else {
            x = 0;
        }
        for (y = 0; y < x; ++y) {
            new GPSetType().setup(state, base.push(P_SET).push("" + y));
        }
        this.postProcessTypes();
    }

    public void postProcessTypes() {
        GPType t;
        int x = 0;
        Enumeration e = this.typeRepository.elements();
        while (e.hasMoreElements()) {
            t = (GPType)e.nextElement();
            if (!(t instanceof GPAtomicType)) continue;
            t.type = x++;
        }
        this.numAtomicTypes = x;
        e = this.typeRepository.elements();
        while (e.hasMoreElements()) {
            t = (GPType)e.nextElement();
            if (!(t instanceof GPSetType)) continue;
            ((GPSetType)t).postProcessSetType(this.numAtomicTypes);
            t.type = x++;
        }
        this.numSetTypes = x - this.numAtomicTypes;
        this.types = new GPType[this.numSetTypes + this.numAtomicTypes];
        e = this.typeRepository.elements();
        while (e.hasMoreElements()) {
            this.types[t.type] = t = (GPType)e.nextElement();
        }
    }

    public void setupNodeConstraints(EvolutionState state, Parameter base) {
        GPNodeConstraints c;
        state.output.message("Processing GP Node Constraints");
        this.nodeConstraintRepository = new Hashtable();
        this.nodeConstraints = new GPNodeConstraints[256];
        this.numNodeConstraints = 0;
        int x = state.parameters.getInt(base.push(P_SIZE), null, 1);
        if (x <= 0) {
            state.output.fatal("The number of GP node constraints must be at least 1.", base.push(P_SIZE));
        }
        for (int y = 0; y < x; ++y) {
            if (state.parameters.exists(base.push("" + y), null)) {
                c = (GPNodeConstraints)state.parameters.getInstanceForParameterEq(base.push("" + y), null, GPNodeConstraints.class);
            } else {
                state.output.message("No GP Node Constraints specified, assuming the default class: ec.gp.GPNodeConstraints for " + String.valueOf(base.push("" + y)));
                c = new GPNodeConstraints();
            }
            c.setup(state, base.push("" + y));
        }
        Enumeration e = this.nodeConstraintRepository.elements();
        while (e.hasMoreElements()) {
            c = (GPNodeConstraints)e.nextElement();
            c.constraintNumber = this.numNodeConstraints;
            this.nodeConstraints[this.numNodeConstraints] = c;
            this.numNodeConstraints = (byte)(this.numNodeConstraints + 1);
        }
    }

    public void setupFunctionSets(EvolutionState state, Parameter base) {
        state.output.message("Processing GP Function Sets");
        this.functionSetRepository = new Hashtable();
        int x = state.parameters.getInt(base.push(P_SIZE), null, 1);
        if (x <= 0) {
            state.output.fatal("The number of GPFunctionSets must be at least 1.", base.push(P_SIZE));
        }
        for (int y = 0; y < x; ++y) {
            GPFunctionSet c;
            if (state.parameters.exists(base.push("" + y), null)) {
                c = (GPFunctionSet)state.parameters.getInstanceForParameterEq(base.push("" + y), null, GPFunctionSet.class);
            } else {
                state.output.message("No GPFunctionSet specified, assuming the default class: ec.gp.GPFunctionSet for " + String.valueOf(base.push("" + y)));
                c = new GPFunctionSet();
            }
            c.setup(state, base.push("" + y));
        }
    }

    public void setupTreeConstraints(EvolutionState state, Parameter base) {
        GPTreeConstraints c;
        state.output.message("Processing GP Tree Constraints");
        this.treeConstraintRepository = new Hashtable();
        this.treeConstraints = new GPTreeConstraints[256];
        this.numTreeConstraints = 0;
        int x = state.parameters.getInt(base.push(P_SIZE), null, 1);
        if (x <= 0) {
            state.output.fatal("The number of GP tree constraints must be at least 1.", base.push(P_SIZE));
        }
        for (int y = 0; y < x; ++y) {
            if (state.parameters.exists(base.push("" + y), null)) {
                c = (GPTreeConstraints)state.parameters.getInstanceForParameterEq(base.push("" + y), null, GPTreeConstraints.class);
            } else {
                state.output.message("No GP Tree Constraints specified, assuming the default class: ec.gp.GPTreeConstraints for " + String.valueOf(base.push("" + y)));
                c = new GPTreeConstraints();
            }
            c.setup(state, base.push("" + y));
        }
        Enumeration e = this.treeConstraintRepository.elements();
        while (e.hasMoreElements()) {
            c = (GPTreeConstraints)e.nextElement();
            c.constraintNumber = this.numTreeConstraints;
            this.treeConstraints[this.numTreeConstraints] = c;
            this.numTreeConstraints = (byte)(this.numTreeConstraints + 1);
        }
    }
}

