/*
 * Decompiled with CFR 0.152.
 */
package ec.gp;

import ec.EvolutionState;
import ec.Problem;
import ec.Prototype;
import ec.gp.ADFStack;
import ec.gp.GPData;
import ec.gp.GPDefaults;
import ec.gp.GPFunctionSet;
import ec.gp.GPIndividual;
import ec.gp.GPInitializer;
import ec.gp.GPNodeConstraints;
import ec.gp.GPNodeGatherer;
import ec.gp.GPNodeParent;
import ec.gp.GPTree;
import ec.gp.GPType;
import ec.util.DecodeReturn;
import ec.util.Parameter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;

public abstract class GPNode
implements GPNodeParent,
Prototype {
    public static final String P_NODE = "node";
    public static final String P_NODECONSTRAINTS = "nc";
    public static final String GPNODEPRINTTAB = "    ";
    public static final int MAXPRINTBYTES = 40;
    public static final int NODESEARCH_ALL = 0;
    public static final int NODESEARCH_TERMINALS = 1;
    public static final int NODESEARCH_NONTERMINALS = 2;
    static final int NODESEARCH_CUSTOM = 3;
    public static final int CHILDREN_UNKNOWN = -1;
    public GPNodeParent parent;
    public GPNode[] children;
    public byte argposition;
    public byte constraints;

    public final GPNodeConstraints constraints(GPInitializer initializer) {
        return initializer.nodeConstraints[this.constraints];
    }

    @Override
    public Parameter defaultBase() {
        return GPDefaults.base().push(P_NODE);
    }

    public void checkConstraints(EvolutionState state, int tree, GPIndividual typicalIndividual, Parameter individualBase) {
        int numChildren = this.expectedChildren();
        if (numChildren >= 0 && this.children.length != numChildren) {
            state.output.error("Incorrect number of children for node " + this.toStringForError() + " at " + String.valueOf(individualBase) + ", was expecting " + numChildren + " but got " + this.children.length);
        }
    }

    public int expectedChildren() {
        return -1;
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        Parameter def = this.defaultBase();
        String s = state.parameters.getString(base.push(P_NODECONSTRAINTS), def.push(P_NODECONSTRAINTS));
        if (s == null) {
            state.output.fatal("No node constraints are defined for the GPNode " + this.toStringForError(), base.push(P_NODECONSTRAINTS), def.push(P_NODECONSTRAINTS));
        } else {
            this.constraints = GPNodeConstraints.constraintsFor((String)s, (EvolutionState)state).constraintNumber;
        }
        GPNodeConstraints constraintsObj = this.constraints((GPInitializer)state.initializer);
        int len = constraintsObj.childtypes.length;
        this.children = len == 0 ? constraintsObj.zeroChildren : new GPNode[len];
    }

    public final GPType parentType(GPInitializer initializer) {
        if (this.parent instanceof GPNode) {
            return ((GPNode)this.parent).constraints((GPInitializer)initializer).childtypes[this.argposition];
        }
        return ((GPTree)this.parent).constraints((GPInitializer)initializer).treetype;
    }

    final int verify(EvolutionState state, GPFunctionSet set, int index) {
        int x;
        if (!(state.initializer instanceof GPInitializer)) {
            state.output.error(index + ": Initializer is not a GPInitializer");
            return index + 1;
        }
        GPInitializer initializer = (GPInitializer)state.initializer;
        if (this.parent == null) {
            state.output.error(index + ": null parent");
            return index + 1;
        }
        if (this.argposition < 0) {
            state.output.error(index + ": negative argposition");
            return index + 1;
        }
        if (this.parent instanceof GPTree && ((GPTree)this.parent).child != this) {
            state.output.error(index + ": I think I am a root node, but my GPTree does not think I am a root node");
            return index + 1;
        }
        if (this.parent instanceof GPTree && this.argposition != 0) {
            state.output.error(index + ": I think I am a root node, but my argposition is not 0");
            return index + 1;
        }
        if (this.parent instanceof GPNode && this.argposition >= ((GPNode)this.parent).children.length) {
            state.output.error(index + ": argposition outside range of parent's children array");
            return index + 1;
        }
        if (this.parent instanceof GPNode && ((GPNode)this.parent).children[this.argposition] != this) {
            state.output.error(index + ": I am not found in the provided argposition (" + this.argposition + ") of my parent's children array");
            return index + 1;
        }
        if (this.children == null) {
            state.output.error(index + ": Null Children Array");
            return index + 1;
        }
        for (int x2 = 0; x2 < this.children.length; ++x2) {
            if (this.children[x2] == null) {
                state.output.error(index + ": Null Child (#" + x2 + " )");
                return index + 1;
            }
            if (this.children[x2].parent != this) {
                state.output.error(index + ": child #" + x2 + " does not have me as a parent");
                return index + 1;
            }
            if (this.children[x2].argposition < 0) {
                state.output.error(index + ": child #" + x2 + " argposition is negative");
                return index + 1;
            }
            if (this.children[x2].argposition == x2) continue;
            state.output.error(index + ": child #" + x2 + " argposition does not match position in the children array");
            return index + 1;
        }
        if (this.constraints < 0 || this.constraints >= initializer.numNodeConstraints) {
            state.output.error(index + ": Preposterous node constraints (" + this.constraints + ")");
            return index + 1;
        }
        if (this.parent instanceof GPNode && !this.constraints((GPInitializer)initializer).returntype.compatibleWith(initializer, ((GPNode)this.parent).constraints((GPInitializer)initializer).childtypes[this.argposition])) {
            state.output.error(index + ": Incompatable GP type between me and my parent");
            return index + 1;
        }
        if (this.parent instanceof GPTree && !this.constraints((GPInitializer)initializer).returntype.compatibleWith(initializer, ((GPTree)this.parent).constraints((GPInitializer)initializer).treetype)) {
            state.output.error(index + ": I am root, but incompatable GP type between me and my tree return type");
            return index + 1;
        }
        GPNode[] nodes = set.nodesByArity[this.constraints((GPInitializer)initializer).returntype.type][this.children.length];
        boolean there = false;
        for (x = 0; x < nodes.length; ++x) {
            if (nodes[x].getClass() != this.getClass()) continue;
            there = true;
            break;
        }
        if (!there) {
            state.output.error(index + ": I'm not in the function set.");
            return index + 1;
        }
        ++index;
        for (x = 0; x < this.children.length; ++x) {
            index = this.children[x].verify(state, set, index);
        }
        state.output.exitIfErrors();
        return index;
    }

    public final boolean swapCompatibleWith(GPInitializer initializer, GPNode node) {
        if (this.constraints((GPInitializer)initializer).returntype == node.constraints((GPInitializer)initializer).returntype) {
            return true;
        }
        GPType type = node.parent instanceof GPNode ? ((GPNode)node.parent).constraints((GPInitializer)initializer).childtypes[node.argposition] : ((GPTree)node.parent).constraints((GPInitializer)initializer).treetype;
        return this.constraints((GPInitializer)initializer).returntype.compatibleWith(initializer, type);
    }

    public int numNodes(GPNodeGatherer g) {
        int s = 0;
        for (int x = 0; x < this.children.length; ++x) {
            s += this.children[x].numNodes(g);
        }
        return s + (g.test(this) ? 1 : 0);
    }

    public int numNodes(int nodesearch) {
        int s = 0;
        for (int x = 0; x < this.children.length; ++x) {
            s += this.children[x].numNodes(nodesearch);
        }
        return s + (nodesearch == 0 || nodesearch == 1 && this.children.length == 0 || nodesearch == 2 && this.children.length > 0 ? 1 : 0);
    }

    public int depth() {
        int d = 0;
        for (int x = 0; x < this.children.length; ++x) {
            int newdepth = this.children[x].depth();
            if (newdepth <= d) continue;
            d = newdepth;
        }
        return d + 1;
    }

    public int pathLength(int nodesearch) {
        return this.pathLength(0, 0);
    }

    int pathLength(int nodesearch, int currentDepth) {
        int sum = currentDepth;
        if (nodesearch == 2 && this.children.length == 0 || nodesearch == 1 && this.children.length > 0) {
            sum = 0;
        }
        for (int x = 0; x < this.children.length; ++x) {
            sum += this.pathLength(nodesearch, currentDepth + 1);
        }
        return sum;
    }

    int meanDepth(int nodesearch) {
        return this.pathLength(nodesearch) / this.numNodes(nodesearch);
    }

    public int atDepth() {
        GPNodeParent cparent = this.parent;
        int count = 0;
        while (cparent != null && cparent instanceof GPNode) {
            ++count;
            cparent = ((GPNode)cparent).parent;
        }
        return count;
    }

    public Iterator iterator(final GPNodeGatherer g) {
        return new Iterator(){
            GPNode current;
            Iterator iter;
            {
                this.iter = GPNode.this.iterator();
            }

            void fill() {
                if (this.current == null) {
                    while (this.iter.hasNext()) {
                        GPNode node = (GPNode)this.iter.next();
                        if (!g.test(node)) continue;
                        this.current = node;
                        break;
                    }
                }
            }

            @Override
            public boolean hasNext() {
                this.fill();
                return this.current != null;
            }

            public Object next() {
                this.fill();
                GPNode obj = this.current;
                this.current = null;
                return obj;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator iterator(final int nodesearch) {
        return this.iterator(new GPNodeGatherer(){

            @Override
            public boolean test(GPNode node) {
                return nodesearch == 0 || nodesearch == 1 && node.children.length == 0 || nodesearch == 2 && node.children.length > 0;
            }
        });
    }

    public Iterator iterator() {
        return new Iterator(){
            GPNode current;
            boolean used;
            {
                this.current = GPNode.this;
                this.used = false;
            }

            void fill() {
                if (this.used && this.current != null) {
                    block5: {
                        if (this.current.children == null || this.current.children.length == 0) {
                            GPNode node = this.current;
                            while (true) {
                                if (node == GPNode.this) {
                                    this.current = null;
                                    break block5;
                                }
                                GPNode par = (GPNode)node.parent;
                                if (node.argposition + 1 < par.children.length) {
                                    this.current = par.children[node.argposition + 1];
                                    break block5;
                                }
                                node = par;
                            }
                        }
                        this.current = this.current.children[0];
                    }
                    this.used = false;
                }
            }

            @Override
            public boolean hasNext() {
                this.fill();
                return this.current != null;
            }

            public Object next() {
                this.fill();
                this.used = true;
                return this.current;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public GPNode nodeInPosition(int p, GPNodeGatherer g) {
        this.nodeInPosition(p, g, 3);
        return g.node;
    }

    public GPNode nodeInPosition(int p, int nodesearch) {
        GPNodeGatherer g = new GPNodeGatherer(){

            @Override
            public boolean test(GPNode node) {
                return true;
            }
        };
        this.nodeInPosition(p, g, nodesearch);
        return g.node;
    }

    int nodeInPosition(int p, GPNodeGatherer g, int nodesearch) {
        if (nodesearch == 0 || nodesearch == 1 && this.children.length == 0 || nodesearch == 2 && this.children.length > 0 || nodesearch == 3 && g.test(this)) {
            if (p == 0) {
                g.node = this;
                return -1;
            }
            --p;
        }
        for (int x = 0; x < this.children.length; ++x) {
            if ((p = this.children[x].nodeInPosition(p, g, nodesearch)) != -1) continue;
            return -1;
        }
        return p;
    }

    public GPNodeParent rootParent() {
        GPNodeParent cparent = this;
        while (cparent != null && cparent instanceof GPNode) {
            cparent = cparent.parent;
        }
        return cparent;
    }

    public boolean contains(GPNode subnode) {
        if (subnode == this) {
            return true;
        }
        for (int x = 0; x < this.children.length; ++x) {
            if (!this.children[x].contains(subnode)) continue;
            return true;
        }
        return false;
    }

    public void resetNode(EvolutionState state, int thread) {
    }

    public String errorInfo() {
        return "GPNode " + this.toString() + " in the function set for tree " + ((GPTree)this.rootParent()).treeNumber();
    }

    public GPNode lightClone() {
        try {
            GPNode obj = (GPNode)super.clone();
            int len = this.children.length;
            obj.children = len == 0 ? this.children : new GPNode[len];
            return obj;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public Object clone() {
        GPNode newnode = this.lightClone();
        for (int x = 0; x < this.children.length; ++x) {
            newnode.children[x] = this.children[x].cloneReplacing();
            newnode.children[x].parent = newnode;
            newnode.children[x].argposition = (byte)x;
        }
        return newnode;
    }

    public final GPNode cloneReplacing() {
        return (GPNode)this.clone();
    }

    public final GPNode cloneReplacing(GPNode newSubtree, GPNode oldSubtree) {
        if (this == oldSubtree) {
            return newSubtree.cloneReplacing();
        }
        GPNode newnode = this.lightClone();
        for (int x = 0; x < this.children.length; ++x) {
            newnode.children[x] = this.children[x].cloneReplacing(newSubtree, oldSubtree);
            newnode.children[x].parent = newnode;
            newnode.children[x].argposition = (byte)x;
        }
        return newnode;
    }

    public final GPNode cloneReplacingNoSubclone(GPNode newSubtree, GPNode oldSubtree) {
        if (this == oldSubtree) {
            return newSubtree;
        }
        GPNode newnode = this.lightClone();
        for (int x = 0; x < this.children.length; ++x) {
            newnode.children[x] = this.children[x].cloneReplacingNoSubclone(newSubtree, oldSubtree);
            newnode.children[x].parent = newnode;
            newnode.children[x].argposition = (byte)x;
        }
        return newnode;
    }

    public final GPNode cloneReplacing(GPNode[] newSubtrees, GPNode[] oldSubtrees) {
        int candidate = -1;
        for (int x = 0; x < oldSubtrees.length; ++x) {
            if (this != oldSubtrees[x]) continue;
            candidate = x;
            break;
        }
        if (candidate >= 0) {
            return newSubtrees[candidate].cloneReplacing(newSubtrees, oldSubtrees);
        }
        GPNode newnode = this.lightClone();
        for (int x = 0; x < this.children.length; ++x) {
            newnode.children[x] = this.children[x].cloneReplacing(newSubtrees, oldSubtrees);
            newnode.children[x].parent = newnode;
            newnode.children[x].argposition = (byte)x;
        }
        return newnode;
    }

    public final GPNode cloneReplacingAtomic(GPNode newNode, GPNode oldNode) {
        GPNode curnode;
        int numArgs;
        if (this == oldNode) {
            numArgs = Math.max(newNode.children.length, this.children.length);
            curnode = newNode;
        } else {
            numArgs = this.children.length;
            curnode = this.lightClone();
        }
        for (int x = 0; x < numArgs; ++x) {
            curnode.children[x] = this.children[x].cloneReplacingAtomic(newNode, oldNode);
            curnode.children[x].parent = curnode;
            curnode.children[x].argposition = (byte)x;
        }
        return curnode;
    }

    public final GPNode cloneReplacingAtomic(GPNode[] newNodes, GPNode[] oldNodes) {
        GPNode curnode;
        int numArgs;
        int x;
        int found = -1;
        for (x = 0; x < newNodes.length; ++x) {
            if (this != oldNodes[x]) continue;
            found = x;
            break;
        }
        if (found > -1) {
            numArgs = Math.max(newNodes[found].children.length, this.children.length);
            curnode = newNodes[found];
        } else {
            numArgs = this.children.length;
            curnode = this.lightClone();
        }
        for (x = 0; x < numArgs; ++x) {
            curnode.children[x] = this.children[x].cloneReplacingAtomic(newNodes, oldNodes);
            curnode.children[x].parent = curnode;
            curnode.children[x].argposition = (byte)x;
        }
        return curnode;
    }

    public final void replaceWith(GPNode newNode) {
        newNode.parent = this.parent;
        newNode.argposition = this.argposition;
        if (this.parent instanceof GPNode) {
            ((GPNode)this.parent).children[this.argposition] = newNode;
        } else {
            ((GPTree)this.parent).child = newNode;
        }
        for (int x = 0; x < this.children.length; x = (int)((byte)(x + 1))) {
            newNode.children[x] = this.children[x];
            newNode.children[x].parent = newNode;
            newNode.children[x].argposition = (byte)x;
        }
    }

    public boolean nodeEquivalentTo(GPNode node) {
        return this.getClass().equals(node.getClass()) && this.children.length == node.children.length && this.constraints == node.constraints;
    }

    public int nodeHashCode() {
        return this.getClass().hashCode();
    }

    public int rootedTreeHashCode() {
        int hash = this.nodeHashCode();
        for (int x = 0; x < this.children.length; ++x) {
            hash = (hash << 1 | hash >>> 31) ^ this.children[x].rootedTreeHashCode();
        }
        return hash;
    }

    public boolean nodeEquals(GPNode node) {
        return this.nodeEquivalentTo(node);
    }

    public boolean rootedTreeEquals(GPNode node) {
        if (!this.nodeEquals(node)) {
            return false;
        }
        for (int x = 0; x < this.children.length; ++x) {
            if (this.children[x].rootedTreeEquals(node.children[x])) continue;
            return false;
        }
        return true;
    }

    public int printNodeForHumans(EvolutionState state, int log) {
        return this.printNodeForHumans(state, log, 0);
    }

    public int printNodeForHumans(EvolutionState state, int log, int verbosity) {
        String n = this.toStringForHumans();
        state.output.print(n, log);
        return n.length();
    }

    public int printNode(EvolutionState state, int log) {
        this.printNode(state, log, 0);
        String n = this.toString();
        return n.length();
    }

    public int printNode(EvolutionState state, int log, int verbosity) {
        String n = this.toString();
        state.output.print(n, log);
        return n.length();
    }

    public int printNode(EvolutionState state, PrintWriter writer) {
        String n = this.toString();
        writer.print(n);
        return n.length();
    }

    public String name() {
        return this.toString();
    }

    public abstract String toString();

    public String toStringForHumans() {
        return this.toString();
    }

    public String toStringForError() {
        GPTree rootp = (GPTree)this.rootParent();
        if (rootp != null) {
            int tnum = ((GPTree)this.rootParent()).treeNumber();
            return this.toString() + (String)(tnum == -1 ? "" : " in tree " + tnum);
        }
        return this.toString();
    }

    public String makeGraphvizTree() {
        return "digraph g {\ngraph [ordering=out];\nnode [shape=rectangle];\n" + this.makeGraphvizSubtree("n") + "}\n";
    }

    protected String makeGraphvizSubtree(String prefix) {
        String body = prefix + "[label = \"" + this.toStringForHumans() + "\"];\n";
        for (int x = 0; x < this.children.length; ++x) {
            String newprefix = x < 10 ? prefix + x : prefix + "n" + x;
            body = body + this.children[x].makeGraphvizSubtree(newprefix);
            body = body + prefix + " -> " + newprefix + ";\n";
        }
        return body;
    }

    public String makeLatexTree() {
        if (this.children.length == 0) {
            return "\\gpbox{" + this.toStringForHumans() + "}";
        }
        String s = "\\begin{bundle}{\\gpbox{" + this.toStringForHumans() + "}}";
        for (int x = 0; x < this.children.length; ++x) {
            s = s + "\\chunk{" + this.children[x].makeLatexTree() + "}";
        }
        s = s + "\\end{bundle}";
        return s;
    }

    public String makeCTree(boolean parentMadeParens, boolean printTerminalsAsVariables, boolean useOperatorForm) {
        if (this.children.length == 0) {
            return printTerminalsAsVariables ? this.toStringForHumans() : this.toStringForHumans() + "()";
        }
        if (this.children.length == 1) {
            return this.toStringForHumans() + "(" + this.children[0].makeCTree(true, printTerminalsAsVariables, useOperatorForm) + ")";
        }
        if (this.children.length == 2 && useOperatorForm) {
            return (parentMadeParens ? "" : "(") + this.children[0].makeCTree(false, printTerminalsAsVariables, useOperatorForm) + " " + this.toStringForHumans() + " " + this.children[1].makeCTree(false, printTerminalsAsVariables, useOperatorForm) + (parentMadeParens ? "" : ")");
        }
        String s = this.toStringForHumans() + "(" + this.children[0].makeCTree(true, printTerminalsAsVariables, useOperatorForm);
        for (int x = 1; x < this.children.length; ++x) {
            s = s + ", " + this.children[x].makeCTree(true, printTerminalsAsVariables, useOperatorForm);
        }
        return s + ")";
    }

    public StringBuilder makeLispTree(StringBuilder buf) {
        if (this.children.length == 0) {
            return buf.append(this.toStringForHumans());
        }
        buf.append("(");
        buf.append(this.toStringForHumans());
        for (int x = 0; x < this.children.length; ++x) {
            buf.append(" ");
            this.children[x].makeLispTree(buf);
        }
        buf.append(")");
        return buf;
    }

    public String makeLispTree() {
        return this.makeLispTree(new StringBuilder()).toString();
    }

    public int printRootedTree(EvolutionState state, int log, int printbytes) {
        return this.printRootedTree(state, log, 0, printbytes);
    }

    public int printRootedTree(EvolutionState state, int log, int verbosity, int printbytes) {
        if (this.children.length > 0) {
            state.output.print(" (", verbosity, log);
            printbytes += 2;
        } else {
            state.output.print(" ", log);
            ++printbytes;
        }
        printbytes += this.printNode(state, log);
        for (int x = 0; x < this.children.length; ++x) {
            printbytes = this.children[x].printRootedTree(state, log, printbytes);
        }
        if (this.children.length > 0) {
            state.output.print(")", log);
            ++printbytes;
        }
        return printbytes;
    }

    public int printRootedTree(EvolutionState state, PrintWriter writer, int printbytes) {
        if (this.children.length > 0) {
            writer.print(" (");
            printbytes += 2;
        } else {
            writer.print(" ");
            ++printbytes;
        }
        printbytes += this.printNode(state, writer);
        for (int x = 0; x < this.children.length; ++x) {
            printbytes = this.children[x].printRootedTree(state, writer, printbytes);
        }
        if (this.children.length > 0) {
            writer.print(")");
            ++printbytes;
        }
        return printbytes;
    }

    public int printRootedTreeForHumans(EvolutionState state, int log, int tablevel, int printbytes) {
        return this.printRootedTreeForHumans(state, log, 0, tablevel, printbytes);
    }

    public int printRootedTreeForHumans(EvolutionState state, int log, int verbosity, int tablevel, int printbytes) {
        int x;
        if (printbytes > 40) {
            state.output.print("\n", log);
            ++tablevel;
            printbytes = 0;
            for (x = 0; x < tablevel; ++x) {
                state.output.print(GPNODEPRINTTAB, log);
            }
        }
        if (this.children.length > 0) {
            state.output.print(" (", log);
            printbytes += 2;
        } else {
            state.output.print(" ", log);
            ++printbytes;
        }
        printbytes += this.printNodeForHumans(state, log);
        for (x = 0; x < this.children.length; ++x) {
            printbytes = this.children[x].printRootedTreeForHumans(state, log, tablevel, printbytes);
        }
        if (this.children.length > 0) {
            state.output.print(")", log);
            ++printbytes;
        }
        return printbytes;
    }

    public GPNode readNode(DecodeReturn dret) {
        char c;
        int len = dret.data.length();
        String str2 = this.toString();
        int len2 = str2.length();
        if (dret.pos + len2 > len) {
            return null;
        }
        for (int x = 0; x < len2; ++x) {
            if (dret.data.charAt(dret.pos + x) == str2.charAt(x)) continue;
            return null;
        }
        if (dret.data.length() > dret.pos + len2 && !Character.isWhitespace(c = dret.data.charAt(dret.pos + len2)) && c != ')' && c != '(') {
            return null;
        }
        dret.pos += len2;
        return this.lightClone();
    }

    public void writeRootedTree(EvolutionState state, GPType expectedType, GPFunctionSet set, DataOutput dataOutput) throws IOException {
        int index;
        dataOutput.writeInt(this.children.length);
        boolean isTerminal = this.children.length == 0;
        GPNode[] gpfi = isTerminal ? set.terminals[expectedType.type] : set.nonterminals[expectedType.type];
        for (index = 0; index < gpfi.length && !gpfi[index].nodeEquivalentTo(this); ++index) {
        }
        if (index == gpfi.length) {
            state.output.fatal("No node in the function set can be found that is equivalent to the node " + String.valueOf(this) + " when performing writeRootedTree(EvolutionState, GPType, GPFunctionSet, DataOutput).");
        }
        dataOutput.writeInt(index);
        this.writeNode(state, dataOutput);
        GPInitializer initializer = (GPInitializer)state.initializer;
        for (int x = 0; x < this.children.length; ++x) {
            this.children[x].writeRootedTree(state, this.constraints((GPInitializer)initializer).childtypes[x], set, dataOutput);
        }
    }

    public static GPNode readRootedTree(EvolutionState state, DataInput dataInput, GPType expectedType, GPFunctionSet set, GPNodeParent parent, int argposition) throws IOException {
        int len = dataInput.readInt();
        int index = dataInput.readInt();
        boolean isTerminal = len == 0;
        GPNode[] gpfi = isTerminal ? set.terminals[expectedType.type] : set.nonterminals[expectedType.type];
        GPNode node = gpfi[index].lightClone();
        if (node.children == null || node.children.length != len) {
            state.output.fatal("Mismatch in number of children (" + len + ") when performing readRootedTree(...DataInput...) on " + String.valueOf(node));
        }
        node.parent = parent;
        node.argposition = (byte)argposition;
        node.readNode(state, dataInput);
        GPInitializer initializer = (GPInitializer)state.initializer;
        for (int x = 0; x < node.children.length; ++x) {
            node.children[x] = GPNode.readRootedTree(state, dataInput, node.constraints((GPInitializer)initializer).childtypes[x], set, node, x);
        }
        return node;
    }

    public void writeNode(EvolutionState state, DataOutput dataOutput) throws IOException {
    }

    public void readNode(EvolutionState state, DataInput dataInput) throws IOException {
    }

    public static GPNode readRootedTree(int linenumber, DecodeReturn dret, GPType expectedType, GPFunctionSet set, GPNodeParent parent, int argposition, EvolutionState state) {
        StringBuilder sb;
        int REPLACEMENT_CHAR = 64;
        boolean isTerminal = true;
        int len = dret.data.length();
        while (dret.pos < len && Character.isWhitespace(dret.data.charAt(dret.pos))) {
            ++dret.pos;
        }
        if (dret.pos >= len) {
            state.output.fatal("Reading line " + linenumber + ": Premature end of tree structure -- did you forget a close-parenthesis?\nThe tree was" + dret.data);
        }
        if (dret.data.charAt(dret.pos) == ')') {
            sb = new StringBuilder(dret.data);
            sb.setCharAt(dret.pos, '@');
            dret.data = sb.toString();
            state.output.fatal("Reading line " + linenumber + ": Premature ')' which I have replaced with a '@', in tree:\n" + dret.data);
        }
        if (dret.data.charAt(dret.pos) == '(') {
            isTerminal = false;
            ++dret.pos;
            while (dret.pos < len && Character.isWhitespace(dret.data.charAt(dret.pos))) {
                ++dret.pos;
            }
        }
        if (dret.pos >= len) {
            state.output.fatal("Reading line " + linenumber + ": Premature end of tree structure -- did you forget a close-parenthesis?\nThe tree was" + dret.data);
        }
        if (dret.data.charAt(dret.pos) == ')') {
            sb = new StringBuilder(dret.data);
            sb.setCharAt(dret.pos, '@');
            dret.data = sb.toString();
            state.output.fatal("Reading line " + linenumber + ": Premature ')' which I have replaced with a '@', in tree:\n" + dret.data);
        }
        GPNode[] gpfi = isTerminal ? set.terminals[expectedType.type] : set.nonterminals[expectedType.type];
        GPNode node = null;
        for (int x = 0; x < gpfi.length && (node = gpfi[x].readNode(dret)) == null; ++x) {
        }
        if (node == null) {
            if (dret.pos != 0) {
                StringBuilder sb2 = new StringBuilder(dret.data);
                sb2.setCharAt(dret.pos, '@');
                dret.data = sb2.toString();
            } else {
                dret.data = "@" + dret.data;
            }
            state.output.fatal("Reading line " + linenumber + ": I came across a symbol which I could not match up with a type-valid node.\nI have replaced the position immediately before the node in question with a '@':\n" + dret.data);
        }
        node.parent = parent;
        node.argposition = (byte)argposition;
        GPInitializer initializer = (GPInitializer)state.initializer;
        for (int x = 0; x < node.children.length; ++x) {
            node.children[x] = GPNode.readRootedTree(linenumber, dret, node.constraints((GPInitializer)initializer).childtypes[x], set, node, x, state);
        }
        if (!isTerminal) {
            while (dret.pos < len && Character.isWhitespace(dret.data.charAt(dret.pos))) {
                ++dret.pos;
            }
            if (dret.pos >= len) {
                state.output.fatal("Reading line " + linenumber + ": Premature end of tree structure -- did you forget a close-parenthesis?\nThe tree was" + dret.data);
            }
            if (dret.data.charAt(dret.pos) != ')') {
                if (dret.pos != 0) {
                    StringBuilder sb3 = new StringBuilder(dret.data);
                    sb3.setCharAt(dret.pos, '@');
                    dret.data = sb3.toString();
                } else {
                    dret.data = "@" + dret.data;
                }
                state.output.fatal("Reading line " + linenumber + ": A nonterminal node has too many arguments.  I have put a '@' just before the offending argument.\n" + dret.data);
            } else {
                ++dret.pos;
            }
        }
        return node;
    }

    public abstract void eval(EvolutionState var1, int var2, GPData var3, ADFStack var4, GPIndividual var5, Problem var6);
}

