/*
 * Decompiled with CFR 0.152.
 */
package ec.gp;

import ec.EvolutionState;
import ec.Prototype;
import ec.gp.GPFunctionSet;
import ec.gp.GPNode;
import ec.gp.GPNodeParent;
import ec.gp.GPType;
import ec.util.Parameter;
import ec.util.RandomChoice;

public abstract class GPNodeBuilder
implements Prototype {
    public static final int NOSIZEGIVEN = -1;
    public static final int CHECK_BOUNDARY = 8;
    public static final String P_MINSIZE = "min-size";
    public static final String P_MAXSIZE = "max-size";
    public static final String P_NUMSIZES = "num-sizes";
    public static final String P_SIZE = "size";
    public int minSize;
    public int maxSize;
    public double[] sizeDistribution;

    public boolean canPick() {
        return this.minSize != 0 || this.sizeDistribution != null;
    }

    public int pickSize(EvolutionState state, int thread) {
        if (this.minSize > 0) {
            return state.random[thread].nextInt(this.maxSize - this.minSize + 1) + this.minSize;
        }
        if (this.sizeDistribution != null) {
            return RandomChoice.pickFromDistribution(this.sizeDistribution, state.random[thread].nextDouble()) + 1;
        }
        throw new InternalError("Neither minSize nor sizeDistribution is defined in GPNodeBuilder");
    }

    @Override
    public Object clone() {
        try {
            GPNodeBuilder c = (GPNodeBuilder)super.clone();
            if (this.sizeDistribution != null) {
                c.sizeDistribution = (double[])this.sizeDistribution.clone();
            }
            return c;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        Parameter def = this.defaultBase();
        if (state.parameters.exists(base.push(P_MINSIZE), def.push(P_MINSIZE))) {
            if (!state.parameters.exists(base.push(P_MAXSIZE), def.push(P_MAXSIZE))) {
                state.output.fatal("This GPNodeBuilder has a min-size but not a max-size.");
            }
            this.minSize = state.parameters.getInt(base.push(P_MINSIZE), def.push(P_MINSIZE), 1);
            if (this.minSize == 0) {
                state.output.fatal("The GPNodeBuilder must have a min size >= 1.", base.push(P_MINSIZE), def.push(P_MINSIZE));
            }
            this.maxSize = state.parameters.getInt(base.push(P_MAXSIZE), def.push(P_MAXSIZE), 1);
            if (this.maxSize == 0) {
                state.output.fatal("The GPNodeBuilder must have a max size >= 1.", base.push(P_MAXSIZE), def.push(P_MAXSIZE));
            }
            if (this.minSize > this.maxSize) {
                state.output.fatal("The GPNodeBuilder must have min size <= max size.", base.push(P_MINSIZE), def.push(P_MINSIZE));
            }
        } else if (state.parameters.exists(base.push(P_MAXSIZE), def.push(P_MAXSIZE))) {
            state.output.fatal("This GPNodeBuilder has a max-size but not a min-size.", base.push(P_MAXSIZE), def.push(P_MAXSIZE));
        } else if (state.parameters.exists(base.push(P_NUMSIZES), def.push(P_NUMSIZES))) {
            int siz = state.parameters.getInt(base.push(P_NUMSIZES), def.push(P_NUMSIZES), 1);
            if (siz == 0) {
                state.output.fatal("The number of sizes in the GPNodeBuilder's distribution must be >= 1. ");
            }
            this.sizeDistribution = new double[siz];
            if (state.parameters.exists(base.push(P_SIZE).push("0"), def.push(P_SIZE).push("0"))) {
                state.output.warning("GPNodeBuilder does not use size #0 in the distribution", base.push(P_SIZE).push("0"), def.push(P_SIZE).push("0"));
            }
            double sum = 0.0;
            for (int x = 0; x < siz; ++x) {
                this.sizeDistribution[x] = state.parameters.getDouble(base.push(P_SIZE).push("" + (x + 1)), def.push(P_SIZE).push("" + (x + 1)), 0.0);
                if (this.sizeDistribution[x] < 0.0) {
                    state.output.warning("Distribution value #" + x + " negative or not defined, assumed to be 0.0", base.push(P_SIZE).push("" + (x + 1)), def.push(P_SIZE).push("" + (x + 1)));
                    this.sizeDistribution[x] = 0.0;
                }
                sum += this.sizeDistribution[x];
            }
            if (sum > 1.0) {
                state.output.warning("Distribution sums to greater than 1.0", base.push(P_SIZE), def.push(P_SIZE));
            }
            if (sum == 0.0) {
                state.output.fatal("Distribution is all 0's", base.push(P_SIZE), def.push(P_SIZE));
            }
            RandomChoice.organizeDistribution(this.sizeDistribution);
        }
    }

    public abstract GPNode newRootedTree(EvolutionState var1, GPType var2, int var3, GPNodeParent var4, GPFunctionSet var5, int var6, int var7);

    protected void warnAboutNoTerminalWithType(GPType type, boolean fail, EvolutionState state) {
        state.output.warnOnce("A GPNodeBuilder has been requested at least once to generate a one-node tree with a return value type-compatable with a certain type; but there is no TERMINAL which is type-compatable in this way.  As a result, the algorithm was forced to use a NON-TERMINAL, making the tree larger than requested, and exposing more child slots to fill, which if not carefully considered, could recursively repeat this problem and eventually fill all memory.");
        if (fail) {
            state.output.fatal(String.valueOf(this.getClass()) + " can't find a terminal type-compatable with " + String.valueOf(type) + " and cannot replace it with a nonterminal.  You may need to try a different node-builder algorithm.");
        } else {
            state.output.warnOnce(String.valueOf(this.getClass()) + " can't find a terminal type-compatable with " + String.valueOf(type));
        }
    }

    protected boolean warnAboutNonterminal(boolean test, GPType type, boolean fail, EvolutionState state) {
        if (test) {
            this.warnAboutNonTerminalWithType(type, fail, state);
        }
        return test;
    }

    protected void warnAboutNonTerminalWithType(GPType type, boolean fail, EvolutionState state) {
        state.output.warnOnce("A GPNodeBuilder has been requested at least once to generate a tree with a return value type-compatable with a certain type; but there is no NON-TERMINAL which is type-compatable in this way.  As a result, the algorithm was forced to use a TERMINAL, making the tree smaller than requested.");
        if (fail) {
            state.output.fatal(String.valueOf(this.getClass()) + " can't find a non-terminal type-compatable with " + String.valueOf(type) + " and cannot replace it with a terminal.  You may need to try a different node-builder algorithm.");
        } else {
            state.output.warnOnce(String.valueOf(this.getClass()) + " can't find a non-terminal type-compatable with " + String.valueOf(type));
        }
    }

    protected void errorAboutNoNodeWithType(GPType type, EvolutionState state) {
        state.output.fatal(String.valueOf(this.getClass()) + " could find no terminal or nonterminal type-compatable with " + String.valueOf(type));
    }
}

