/*
 * Decompiled with CFR 0.152.
 */
package ec.gp;

import ec.EvolutionState;
import ec.gp.GPAtomicType;
import ec.gp.GPInitializer;
import ec.gp.GPType;
import ec.util.Parameter;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;

public final class GPSetType
extends GPType {
    public static final String P_MEMBER = "member";
    public static final String P_SIZE = "size";
    public int[] types_packed;
    public boolean[] types_sparse;
    public Hashtable types_h;

    public void postProcessSetType(int totalAtomicTypes) {
        int x = 0;
        this.types_packed = new int[this.types_h.size()];
        this.types_sparse = new boolean[totalAtomicTypes];
        Enumeration e = this.types_h.elements();
        while (e.hasMoreElements()) {
            GPAtomicType t = (GPAtomicType)e.nextElement();
            this.types_packed[x++] = t.type;
            this.types_sparse[t.type] = true;
        }
        Arrays.sort(this.types_packed);
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        this.types_h = new Hashtable();
        int len = state.parameters.getInt(base.push(P_SIZE), null, 1);
        if (len <= 0) {
            state.output.fatal("The number of atomic types in the GPSetType " + this.name + " must be >= 1.", base.push(P_SIZE));
        }
        for (int x = 0; x < len; ++x) {
            GPType t;
            String s = state.parameters.getString(base.push(P_MEMBER).push("" + x), null);
            if (s == null) {
                state.output.fatal("Atomic type member #" + x + " is not defined for the GPSetType " + this.name + ".", base.push(P_MEMBER).push("" + x));
            }
            if (!((t = GPType.typeFor(s, state)) instanceof GPAtomicType)) {
                state.output.fatal("Atomic type member #" + x + " of GPSetType " + this.name + " is not a GPAtomicType.", base.push(P_MEMBER).push("" + x));
            }
            if (this.types_h.get(t) != null) {
                state.output.warning("Atomic type member #" + x + " is included more than once in GPSetType " + this.name + ".", base.push(P_MEMBER).push("" + x));
            }
            this.types_h.put(t, t);
        }
    }

    @Override
    public final boolean compatibleWith(GPInitializer initializer, GPType t) {
        if (t.type == this.type) {
            return true;
        }
        if (t.type < initializer.numAtomicTypes) {
            return this.types_sparse[t.type];
        }
        GPSetType s = (GPSetType)t;
        int x = 0;
        int y = 0;
        while (x < this.types_packed.length && y < s.types_packed.length) {
            if (this.types_packed[x] == s.types_packed[y]) {
                return true;
            }
            if (this.types_packed[x] < s.types_packed[y]) {
                ++x;
                continue;
            }
            ++y;
        }
        return false;
    }
}

