/*
 * Decompiled with CFR 0.152.
 */
package ec.gp.breed;

import ec.EvolutionState;
import ec.Individual;
import ec.gp.GPBreedingPipeline;
import ec.gp.GPIndividual;
import ec.gp.GPInitializer;
import ec.gp.GPNode;
import ec.gp.GPTree;
import ec.gp.GPType;
import ec.gp.breed.GPBreedDefaults;
import ec.util.Parameter;
import java.util.ArrayList;
import java.util.HashMap;

public class MutatePromotePipeline
extends GPBreedingPipeline {
    public static final String P_MUTATEPROMOTE = "mutate-promote";
    public static final String P_NUM_TRIES = "tries";
    public static final int NUM_SOURCES = 1;
    int tree;
    int numTries;
    private GPNode promotableNode;

    @Override
    public Parameter defaultBase() {
        return GPBreedDefaults.base().push(P_MUTATEPROMOTE);
    }

    @Override
    public int numSources() {
        return 1;
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        this.numTries = state.parameters.getInt(base.push(P_NUM_TRIES), def.push(P_NUM_TRIES), 1);
        if (this.numTries == 0) {
            state.output.fatal("MutatePromotePipeline has an invalid number of tries (it must be >= 1).", base.push(P_NUM_TRIES), def.push(P_NUM_TRIES));
        }
        this.tree = -1;
        if (state.parameters.exists(base.push("tree").push("0"), def.push("tree").push("0"))) {
            this.tree = state.parameters.getInt(base.push("tree").push("0"), def.push("tree").push("0"), 0);
            if (this.tree == -1) {
                state.output.fatal("Tree fixed value, if defined, must be >= 0");
            }
        }
    }

    private boolean promotable(GPInitializer initializer, GPNode node) {
        if (!(node.parent instanceof GPNode)) {
            return false;
        }
        GPNode parent = (GPNode)node.parent;
        GPType t = parent.parent instanceof GPNode ? ((GPNode)parent.parent).constraints((GPInitializer)initializer).childtypes[parent.argposition] : ((GPTree)parent.parent).constraints((GPInitializer)initializer).treetype;
        return node.constraints((GPInitializer)initializer).returntype.compatibleWith(initializer, t);
    }

    private void promoteSomething(GPNode node) {
        GPNode parent = (GPNode)node.parent;
        node.parent = parent.parent;
        node.argposition = parent.argposition;
        if (parent.parent instanceof GPNode) {
            ((GPNode)parent.parent).children[parent.argposition] = node;
        } else {
            ((GPTree)parent.parent).child = node;
        }
    }

    private int numPromotableNodes(GPInitializer initializer, GPNode root, int soFar) {
        if (this.promotable(initializer, root)) {
            ++soFar;
        }
        for (int x = 0; x < root.children.length; ++x) {
            soFar = this.numPromotableNodes(initializer, root.children[x], soFar);
        }
        return soFar;
    }

    private int pickPromotableNode(GPInitializer initializer, GPNode root, int num) {
        if (this.promotable(initializer, root) && --num == -1) {
            this.promotableNode = root;
            return num;
        }
        for (int x = 0; x < root.children.length && (num = this.pickPromotableNode(initializer, root.children[x], num)) != -1; ++x) {
        }
        return num;
    }

    @Override
    public int produce(int min, int max, int subpopulation, ArrayList<Individual> inds, EvolutionState state, int thread, HashMap<String, Object> misc) {
        int start = inds.size();
        int n = this.sources[0].produce(min, max, subpopulation, inds, state, thread, misc);
        if (!state.random[thread].nextBoolean(this.likelihood)) {
            return n;
        }
        GPInitializer initializer = (GPInitializer)state.initializer;
        for (int q = start; q < n + start; ++q) {
            GPIndividual i = (GPIndividual)inds.get(q);
            if (this.tree != -1 && (this.tree < 0 || this.tree >= i.trees.length)) {
                state.output.fatal("MutatePromotePipeline attempted to fix tree.0 to a value which was out of bounds of the array of the individual's trees.  Check the pipeline's fixed tree values -- they may be negative or greater than the number of trees in an individual");
            }
            for (int x = 0; x < this.numTries; ++x) {
                int t = this.tree == -1 ? (i.trees.length > 1 ? state.random[thread].nextInt(i.trees.length) : 0) : this.tree;
                int numpromote = this.numPromotableNodes(initializer, i.trees[t].child, 0);
                if (numpromote == 0) continue;
                this.pickPromotableNode(initializer, i.trees[t].child, state.random[thread].nextInt(numpromote));
                this.promoteSomething(this.promotableNode);
                i.evaluated = false;
                break;
            }
            inds.set(q, i);
        }
        return n;
    }
}

