/*
 * Decompiled with CFR 0.152.
 */
package ec.gp.build;

import ec.EvolutionState;
import ec.gp.GPFunctionSet;
import ec.gp.GPInitializer;
import ec.gp.GPNode;
import ec.gp.GPNodeBuilder;
import ec.gp.GPNodeParent;
import ec.gp.GPType;
import ec.gp.build.GPBuildDefaults;
import ec.gp.build.PTCFunctionSetForm;
import ec.util.Parameter;
import ec.util.RandomChoice;

public class PTC1
extends GPNodeBuilder {
    public static final String P_PTC1 = "ptc1";
    public static final String P_EXPECTED = "expected-size";
    public static final String P_MAXDEPTH = "max-depth";
    public int maxDepth;
    public int expectedSize;

    @Override
    public Parameter defaultBase() {
        return GPBuildDefaults.base().push(P_PTC1);
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        this.expectedSize = state.parameters.getInt(base.push(P_EXPECTED), def.push(P_EXPECTED), 1);
        if (this.expectedSize < 1) {
            state.output.fatal("Default expected size must be >= 1", base.push(P_EXPECTED), def.push(P_EXPECTED));
        }
        this.maxDepth = state.parameters.getInt(base.push(P_MAXDEPTH), def.push(P_MAXDEPTH), 1);
        if (this.maxDepth < 1) {
            state.output.fatal("Maximum depth must be >= 1", base.push(P_MAXDEPTH), def.push(P_MAXDEPTH));
        }
    }

    @Override
    public GPNode newRootedTree(EvolutionState state, GPType type, int thread, GPNodeParent parent, GPFunctionSet set, int argposition, int requestedSize) {
        if (!(set instanceof PTCFunctionSetForm)) {
            state.output.fatal("Set " + set.name + " is not of the form ec.gp.build.PTCFunctionSetForm, and so cannot be used with PTC Nodebuilders.");
        }
        if (requestedSize == -1) {
            return this.ptc1(state, 0, type, thread, parent, argposition, set, (PTCFunctionSetForm)((Object)set), ((PTCFunctionSetForm)((Object)set)).nonterminalSelectionProbabilities(this.expectedSize));
        }
        if (requestedSize < 1) {
            state.output.fatal("etc.gp.build.PTC1 was requested to build a tree, but a requested size was given that is < 1.");
        }
        return this.ptc1(state, 0, type, thread, parent, argposition, set, (PTCFunctionSetForm)((Object)set), ((PTCFunctionSetForm)((Object)set)).nonterminalSelectionProbabilities(requestedSize));
    }

    private GPNode ptc1(EvolutionState state, int current, GPType type, int thread, GPNodeParent parent, int argposition, GPFunctionSet set, PTCFunctionSetForm pset, double[] nonterminalSelectionProbabilities) {
        boolean triedTerminals = false;
        int t = type.type;
        GPNode[] terminals = set.terminals[t];
        GPNode[] nonterminals = set.nonterminals[t];
        GPNode[] nodes = set.nodes[t];
        if (nodes.length == 0) {
            this.errorAboutNoNodeWithType(type, state);
        }
        if (current + 1 >= this.maxDepth || !state.random[thread].nextBoolean(nonterminalSelectionProbabilities[t]) || this.warnAboutNonterminal(nonterminals.length == 0, type, false, state)) {
            triedTerminals = true;
            if (true && terminals.length != 0) {
                GPNode n = terminals[RandomChoice.pickFromDistribution(pset.terminalProbabilities(t), state.random[thread].nextDouble())].lightClone();
                n.resetNode(state, thread);
                n.argposition = (byte)argposition;
                n.parent = parent;
                return n;
            }
        }
        if (triedTerminals) {
            this.warnAboutNoTerminalWithType(type, false, state);
        }
        GPNode n = nonterminals[RandomChoice.pickFromDistribution(pset.nonterminalProbabilities(t), state.random[thread].nextDouble())].lightClone();
        n.resetNode(state, thread);
        n.argposition = (byte)argposition;
        n.parent = parent;
        GPType[] childtypes = n.constraints((GPInitializer)((GPInitializer)state.initializer)).childtypes;
        for (int x = 0; x < childtypes.length; ++x) {
            n.children[x] = this.ptc1(state, current + 1, childtypes[x], thread, n, x, set, pset, nonterminalSelectionProbabilities);
        }
        return n;
    }
}

