/*
 * Decompiled with CFR 0.152.
 */
package ec.gp.build;

import ec.EvolutionState;
import ec.gp.GPFunctionSet;
import ec.gp.GPInitializer;
import ec.gp.GPNode;
import ec.gp.GPNodeBuilder;
import ec.gp.GPNodeParent;
import ec.gp.GPType;
import ec.gp.build.GPBuildDefaults;
import ec.gp.build.UniformGPNodeStorage;
import ec.util.MersenneTwisterFast;
import ec.util.Parameter;
import ec.util.RandomChoice;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Hashtable;

public class Uniform
extends GPNodeBuilder {
    public static final String P_UNIFORM = "uniform";
    public static final String P_TRUEDISTRIBUTION = "true-dist";
    public GPFunctionSet[] functionsets;
    public Hashtable _functionsets;
    public Hashtable funcnodes;
    public int numfuncnodes;
    public int maxarity;
    public int maxtreesize;
    public BigInteger[][][] _truesizes;
    public double[][][] truesizes;
    public boolean useTrueDistribution;
    public BigInteger[][][] NUMTREESOFTYPE;
    public BigInteger[][][] NUMTREESROOTEDBYNODE;
    public BigInteger[][][][][] NUMCHILDPERMUTATIONS;
    public UniformGPNodeStorage[][][][] ROOT_D;
    public boolean[][][] ROOT_D_ZERO;
    public double[][][][][] CHILD_D;

    @Override
    public Parameter defaultBase() {
        return GPBuildDefaults.base().push(P_UNIFORM);
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        this.useTrueDistribution = state.parameters.getBoolean(base.push(P_TRUEDISTRIBUTION), def.push(P_TRUEDISTRIBUTION), false);
        if (this.minSize > 0) {
            this.maxtreesize = this.maxSize;
        } else if (this.sizeDistribution != null) {
            this.maxtreesize = this.sizeDistribution.length;
        } else {
            state.output.fatal("Uniform is used for the GP node builder, but no distribution was specified.  You must specify either a min/max size, or a full size distribution.", base.push("min-size"), def.push("min-size"));
        }
        this.preprocess(state, this.maxtreesize);
    }

    public int pickSize(EvolutionState state, int thread, int functionset, int type) {
        if (this.useTrueDistribution) {
            return RandomChoice.pickFromDistribution(this.truesizes[functionset][type], state.random[thread].nextDouble());
        }
        return super.pickSize(state, thread);
    }

    public void preprocess(EvolutionState state, int _maxtreesize) {
        int z;
        int y;
        int x;
        state.output.message("Determining Tree Sizes");
        this.maxtreesize = _maxtreesize;
        Hashtable functionSetRepository = ((GPInitializer)state.initializer).functionSetRepository;
        this.functionsets = new GPFunctionSet[functionSetRepository.size()];
        this._functionsets = new Hashtable();
        Enumeration e = functionSetRepository.elements();
        int count = 0;
        while (e.hasMoreElements()) {
            GPFunctionSet set = (GPFunctionSet)e.nextElement();
            this._functionsets.put(set, count);
            this.functionsets[count++] = set;
        }
        this.funcnodes = new Hashtable();
        Hashtable<GPNode, GPNode> t_nodes = new Hashtable<GPNode, GPNode>();
        count = 0;
        this.maxarity = 0;
        for (int x2 = 0; x2 < this.functionsets.length; ++x2) {
            for (int typ = 0; typ < this.functionsets[x2].nodes.length; ++typ) {
                for (int nod = 0; nod < this.functionsets[x2].nodes[typ].length; ++nod) {
                    GPNode n = this.functionsets[x2].nodes[typ][nod];
                    t_nodes.put(n, n);
                }
            }
            e = t_nodes.elements();
            while (e.hasMoreElements()) {
                GPNode tmpn = (GPNode)e.nextElement();
                if (this.maxarity < tmpn.children.length) {
                    this.maxarity = tmpn.children.length;
                }
                if (this.funcnodes.containsKey(tmpn)) continue;
                this.funcnodes.put(tmpn, count++);
            }
        }
        this.numfuncnodes = this.funcnodes.size();
        GPInitializer initializer = (GPInitializer)state.initializer;
        int numAtomicTypes = initializer.numAtomicTypes;
        int numSetTypes = initializer.numSetTypes;
        this.NUMTREESOFTYPE = new BigInteger[this.functionsets.length][numAtomicTypes + numSetTypes][this.maxtreesize + 1];
        this.NUMTREESROOTEDBYNODE = new BigInteger[this.functionsets.length][this.numfuncnodes][this.maxtreesize + 1];
        this.NUMCHILDPERMUTATIONS = new BigInteger[this.functionsets.length][this.numfuncnodes][this.maxtreesize + 1][this.maxtreesize + 1][this.maxarity];
        this.ROOT_D = new UniformGPNodeStorage[this.functionsets.length][numAtomicTypes + numSetTypes][this.maxtreesize + 1][];
        this.ROOT_D_ZERO = new boolean[this.functionsets.length][numAtomicTypes + numSetTypes][this.maxtreesize + 1];
        this.CHILD_D = new double[this.functionsets.length][this.numfuncnodes][this.maxtreesize + 1][this.maxtreesize + 1][];
        GPType[] types = ((GPInitializer)state.initializer).types;
        this._truesizes = new BigInteger[this.functionsets.length][numAtomicTypes + numSetTypes][this.maxtreesize + 1];
        for (x = 0; x < this.functionsets.length; ++x) {
            for (y = 0; y < numAtomicTypes + numSetTypes; ++y) {
                for (z = 1; z <= this.maxtreesize; ++z) {
                    BigInteger bigInteger = this.numTreesOfType(initializer, x, y, z);
                    this._truesizes[x][y][z] = bigInteger;
                    state.output.message("FunctionSet: " + this.functionsets[x].name + ", Type: " + types[y].name + ", Size: " + z + " num: " + String.valueOf(bigInteger));
                }
            }
        }
        state.output.message("Compiling Distributions");
        this.truesizes = new double[this.functionsets.length][numAtomicTypes + numSetTypes][this.maxtreesize + 1];
        for (x = 0; x < this.functionsets.length; ++x) {
            for (y = 0; y < numAtomicTypes + numSetTypes; ++y) {
                for (z = 1; z <= this.maxtreesize; ++z) {
                    this.truesizes[x][y][z] = this._truesizes[x][y][z].doubleValue();
                }
                RandomChoice.organizeDistribution(this.truesizes[x][y], true);
            }
        }
        this.computePercentages();
    }

    public final int intForNode(GPNode node) {
        return (Integer)this.funcnodes.get(node);
    }

    public BigInteger numTreesOfType(GPInitializer initializer, int functionset, int type, int size) {
        if (this.NUMTREESOFTYPE[functionset][type][size] == null) {
            GPNode[] nodes = this.functionsets[functionset].nodes[type];
            BigInteger count = BigInteger.valueOf(0L);
            for (int x = 0; x < nodes.length; ++x) {
                count = count.add(this.numTreesRootedByNode(initializer, functionset, nodes[x], size));
            }
            this.NUMTREESOFTYPE[functionset][type][size] = count;
        }
        return this.NUMTREESOFTYPE[functionset][type][size];
    }

    public BigInteger numTreesRootedByNode(GPInitializer initializer, int functionset, GPNode node, int size) {
        if (this.NUMTREESROOTEDBYNODE[functionset][this.intForNode(node)][size] == null) {
            BigInteger one = BigInteger.valueOf(1L);
            BigInteger count = BigInteger.valueOf(0L);
            int outof = size - 1;
            if (node.children.length == 0 && outof == 0) {
                count = one;
            } else if (node.children.length <= outof) {
                for (int s = 1; s <= outof; ++s) {
                    count = count.add(this.numChildPermutations(initializer, functionset, node, s, outof, 0));
                }
            }
            this.NUMTREESROOTEDBYNODE[functionset][this.intForNode((GPNode)node)][size] = count;
        }
        return this.NUMTREESROOTEDBYNODE[functionset][this.intForNode(node)][size];
    }

    public BigInteger numChildPermutations(GPInitializer initializer, int functionset, GPNode parent, int size, int outof, int pickchild) {
        if (this.NUMCHILDPERMUTATIONS[functionset][this.intForNode(parent)][size][outof][pickchild] == null) {
            BigInteger count = BigInteger.valueOf(0L);
            if (pickchild == parent.children.length - 1 && size == outof) {
                count = this.numTreesOfType(initializer, functionset, parent.constraints((GPInitializer)initializer).childtypes[pickchild].type, size);
            } else if (pickchild < parent.children.length - 1 && outof - size >= parent.children.length - pickchild - 1) {
                BigInteger cval = this.numTreesOfType(initializer, functionset, parent.constraints((GPInitializer)initializer).childtypes[pickchild].type, size);
                BigInteger tot = BigInteger.valueOf(0L);
                for (int s = 1; s <= outof - size; ++s) {
                    tot = tot.add(this.numChildPermutations(initializer, functionset, parent, s, outof - size, pickchild + 1));
                }
                count = cval.multiply(tot);
            }
            this.NUMCHILDPERMUTATIONS[functionset][this.intForNode((GPNode)parent)][size][outof][pickchild] = count;
        }
        return this.NUMCHILDPERMUTATIONS[functionset][this.intForNode(parent)][size][outof][pickchild];
    }

    private final double getProb(BigInteger i) {
        if (i == null) {
            return 0.0;
        }
        return i.doubleValue();
    }

    public void computePercentages() {
        int f;
        for (f = 0; f < this.NUMTREESOFTYPE.length; ++f) {
            for (int t = 0; t < this.NUMTREESOFTYPE[f].length; ++t) {
                block2: for (int s = 0; s < this.NUMTREESOFTYPE[f][t].length; ++s) {
                    int x;
                    this.ROOT_D[f][t][s] = new UniformGPNodeStorage[this.functionsets[f].nodes[t].length];
                    for (x = 0; x < this.ROOT_D[f][t][s].length; ++x) {
                        this.ROOT_D[f][t][s][x] = new UniformGPNodeStorage();
                        this.ROOT_D[f][t][s][x].node = this.functionsets[f].nodes[t][x];
                        this.ROOT_D[f][t][s][x].prob = this.getProb(this.NUMTREESROOTEDBYNODE[f][this.intForNode(this.ROOT_D[f][t][s][x].node)][s]);
                    }
                    for (x = 0; x < this.ROOT_D[f][t][s].length; ++x) {
                        if (this.ROOT_D[f][t][s][x].prob != 0.0) {
                            RandomChoice.organizeDistribution(this.ROOT_D[f][t][s], this.ROOT_D[f][t][s][0]);
                            this.ROOT_D_ZERO[f][t][s] = false;
                            continue block2;
                        }
                        this.ROOT_D_ZERO[f][t][s] = true;
                    }
                }
            }
        }
        for (f = 0; f < this.NUMCHILDPERMUTATIONS.length; ++f) {
            for (int p = 0; p < this.NUMCHILDPERMUTATIONS[f].length; ++p) {
                for (int o = 0; o < this.maxtreesize + 1; ++o) {
                    block8: for (int c = 0; c < this.maxarity; ++c) {
                        this.CHILD_D[f][p][o][c] = new double[o + 1];
                        for (int s = 0; s < this.CHILD_D[f][p][o][c].length; ++s) {
                            this.CHILD_D[f][p][o][c][s] = this.getProb(this.NUMCHILDPERMUTATIONS[f][p][s][o][c]);
                        }
                        for (int x = 0; x < this.CHILD_D[f][p][o][c].length; ++x) {
                            if (this.CHILD_D[f][p][o][c][x] == 0.0) continue;
                            RandomChoice.organizeDistribution(this.CHILD_D[f][p][o][c]);
                            continue block8;
                        }
                    }
                }
            }
        }
    }

    GPNode createTreeOfType(EvolutionState state, int thread, GPInitializer initializer, int functionset, int type, int size, MersenneTwisterFast mt) {
        int choice = RandomChoice.pickFromDistribution(this.ROOT_D[functionset][type][size], this.ROOT_D[functionset][type][size][0], mt.nextDouble());
        GPNode node = this.ROOT_D[functionset][type][size][choice].node.lightClone();
        node.resetNode(state, thread);
        if (node.children.length == 0 && size != 1) {
            System.out.println("Size: " + size + " Node: " + String.valueOf(node));
            for (int x = 0; x < this.ROOT_D[functionset][type][size].length; ++x) {
                System.out.println(x + String.valueOf(this.ROOT_D[functionset][type][size][x].node) + " " + this.ROOT_D[functionset][type][size][x].prob);
            }
        }
        if (size > 1) {
            this.fillNodeWithChildren(state, thread, initializer, functionset, node, this.ROOT_D[functionset][type][size][choice].node, 0, size - 1, mt);
        }
        return node;
    }

    void fillNodeWithChildren(EvolutionState state, int thread, GPInitializer initializer, int functionset, GPNode parent, GPNode parentc, int pickchild, int outof, MersenneTwisterFast mt) {
        if (pickchild == parent.children.length - 1) {
            parent.children[pickchild] = this.createTreeOfType(state, thread, initializer, functionset, parent.constraints((GPInitializer)initializer).childtypes[pickchild].type, outof, mt);
        } else {
            int size = RandomChoice.pickFromDistribution(this.CHILD_D[functionset][this.intForNode(parentc)][outof][pickchild], mt.nextDouble());
            parent.children[pickchild] = this.createTreeOfType(state, thread, initializer, functionset, parent.constraints((GPInitializer)initializer).childtypes[pickchild].type, size, mt);
            this.fillNodeWithChildren(state, thread, initializer, functionset, parent, parentc, pickchild + 1, outof - size, mt);
        }
        parent.children[pickchild].parent = parent;
        parent.children[pickchild].argposition = (byte)pickchild;
    }

    @Override
    public GPNode newRootedTree(EvolutionState state, GPType type, int thread, GPNodeParent parent, GPFunctionSet set, int argposition, int requestedSize) {
        int siz;
        int typ;
        int fset;
        GPInitializer initializer;
        block10: {
            initializer = (GPInitializer)state.initializer;
            if (requestedSize == -1) {
                int BOUNDARY = 20;
                int bound = 0;
                int fset2 = (Integer)this._functionsets.get(set);
                int siz2 = this.pickSize(state, thread, fset2, type.type);
                int typ2 = type.type;
                boolean checked = false;
                while (this.ROOT_D_ZERO[fset2][typ2][siz2]) {
                    block9: {
                        if (++bound == 20 && !checked) {
                            checked = true;
                            for (int x = 0; x < this.ROOT_D_ZERO[fset2][typ2].length; ++x) {
                                if (this.ROOT_D_ZERO[fset2][typ2][x]) {
                                    continue;
                                }
                                break block9;
                            }
                            state.output.fatal("ec.gp.build.Uniform was asked to build a tree with functionset " + String.valueOf(set) + " rooted with type " + String.valueOf(type) + ", but cannot because for some reason there are no trees of any valid size (within the specified size range) which exist for this function set and type.");
                        }
                    }
                    siz2 = this.pickSize(state, thread, fset2, typ2);
                }
                GPNode n = this.createTreeOfType(state, thread, initializer, fset2, typ2, siz2, state.random[thread]);
                n.parent = parent;
                n.argposition = (byte)argposition;
                return n;
            }
            if (requestedSize < 1) {
                state.output.fatal("ec.gp.build.Uniform requested to build a tree, but a requested size was given that is < 1.");
                return null;
            }
            fset = (Integer)this._functionsets.get(set);
            if (this.ROOT_D_ZERO[fset][typ = type.type][siz = requestedSize]) {
                int x;
                for (x = siz + 1; x < this.ROOT_D_ZERO[fset][typ].length; ++x) {
                    if (!this.ROOT_D_ZERO[fset][typ][siz]) continue;
                    siz = x;
                    break block10;
                }
                for (x = siz - 1; x >= 0; --x) {
                    if (!this.ROOT_D_ZERO[fset][typ][siz]) continue;
                    siz = x;
                    break block10;
                }
                state.output.fatal("ec.gp.build.Uniform was asked to build a tree with functionset " + String.valueOf(set) + " rooted with type " + String.valueOf(type) + ", and of size " + requestedSize + ", but cannot because for some reason there are no trees of any valid size (within the specified size range) which exist for this function set and type.");
            }
        }
        GPNode n = this.createTreeOfType(state, thread, initializer, fset, typ, siz, state.random[thread]);
        n.parent = parent;
        n.argposition = (byte)argposition;
        return n;
    }
}

