/*
 * Decompiled with CFR 0.152.
 */
package ec.gp.ge;

import ec.EvolutionState;
import ec.Individual;
import ec.gp.ERC;
import ec.gp.GPFunctionSet;
import ec.gp.GPIndividual;
import ec.gp.GPInitializer;
import ec.gp.GPNode;
import ec.gp.GPNodeParent;
import ec.gp.GPSpecies;
import ec.gp.GPTree;
import ec.gp.ge.GEDefaults;
import ec.gp.ge.GEIndividual;
import ec.gp.ge.GrammarFunctionNode;
import ec.gp.ge.GrammarNode;
import ec.gp.ge.GrammarParser;
import ec.gp.ge.GrammarRuleNode;
import ec.util.Parameter;
import ec.vector.IntegerVectorIndividual;
import ec.vector.IntegerVectorSpecies;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class GESpecies
extends IntegerVectorSpecies {
    private static final long serialVersionUID = 1L;
    public static final String P_GESPECIES = "species";
    public static final String P_FILE = "file";
    public static final String P_GPSPECIES = "gp-species";
    public static final String P_PARSER = "parser";
    public static final String P_PASSES = "passes";
    public static final String P_INITSCHEME = "init-scheme";
    public static final int BIG_TREE_ERROR = -1;
    public GPSpecies gpspecies;
    public HashMap ERCBank;
    public GrammarRuleNode[] grammar;
    public int passes;
    public String initScheme = "default";
    public GrammarParser parser_prototype;
    public GrammarParser[] grammarParser = null;

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter p = base;
        Parameter def = this.defaultBase();
        p = base.push(P_GPSPECIES);
        this.gpspecies = (GPSpecies)state.parameters.getInstanceForParameterEq(p, def.push(P_GPSPECIES), GPSpecies.class);
        this.gpspecies.setup(state, p);
        if (!(this.i_prototype instanceof IntegerVectorIndividual)) {
            state.output.fatal("The Individual class for the Species " + this.getClass().getName() + " is must be a subclass of ge.GEIndividual.", base);
        }
        this.ERCBank = new HashMap();
        GPIndividual gpi = (GPIndividual)this.gpspecies.i_prototype;
        GPTree[] trees = gpi.trees;
        int numGrammars = trees.length;
        this.parser_prototype = (GrammarParser)state.parameters.getInstanceForParameterEq(base.push(P_PARSER), def.push(P_PARSER), GrammarParser.class);
        this.grammar = new GrammarRuleNode[numGrammars];
        this.grammarParser = new GrammarParser[numGrammars];
        for (int i = 0; i < numGrammars; ++i) {
            p = base.push(P_FILE);
            InputStream grammarFile = state.parameters.getResource(p, (def = this.defaultBase()).push(P_FILE).push("" + i));
            if (grammarFile == null) {
                state.output.fatal("Error retrieving grammar file(s): " + def.toString() + ".file." + i + " is undefined.");
            }
            GPFunctionSet gpfs = trees[i].constraints((GPInitializer)((GPInitializer)state.initializer)).functionset;
            this.grammarParser[i] = (GrammarParser)this.parser_prototype.clone();
            BufferedReader br = new BufferedReader(new InputStreamReader(grammarFile));
            this.grammar[i] = this.grammarParser[i].parseRules(state, br, gpfs);
            this.grammarParser[i].enumerateGrammarTree(this.grammar[i]);
            this.grammarParser[i].populatePredictiveParseTable(this.grammar[i]);
            try {
                br.close();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.initScheme = state.parameters.getString(base.push(P_INITSCHEME), def.push(P_INITSCHEME));
        if (this.initScheme != null && this.initScheme.equals("sensible")) {
            state.output.warnOnce("Using a \"hacked\" version of \"sensible initialization\"");
        } else {
            state.output.warnOnce("Using default GE initialization scheme");
        }
        int MAXIMUM_PASSES = 1024;
        this.passes = state.parameters.getInt(base.push(P_PASSES), def.push(P_PASSES), 1);
        if (this.passes < 1 || this.passes > 1024) {
            state.output.fatal("Number of allowed passes must be >= 1 and <=1024, likely small, such as <= 16.", base.push(P_PASSES), def.push(P_PASSES));
        }
        int oldpasses = this.passes;
        this.passes = this.nextPowerOfTwo(this.passes);
        if (oldpasses != this.passes) {
            state.output.warning("Number of allowed passes must be a power of 2.  Bumping from " + oldpasses + " to " + this.passes, base.push(P_PASSES), def.push(P_PASSES));
        }
    }

    int nextPowerOfTwo(int v) {
        --v;
        v |= v >> 1;
        v |= v >> 2;
        v |= v >> 4;
        v |= v >> 8;
        v |= v >> 16;
        return ++v;
    }

    @Override
    public Individual newIndividual(EvolutionState state, int thread) {
        GEIndividual gei = null;
        if (this.initScheme != null && this.initScheme.equals("sensible")) {
            GPIndividual gpi = (GPIndividual)this.gpspecies.newIndividual(state, thread);
            gei = this.reverseMap(state, gpi, thread);
        } else {
            gei = (GEIndividual)super.newIndividual(state, thread);
            gei.species = this;
        }
        return gei;
    }

    public int makeTrees(EvolutionState state, GEIndividual ind, GPTree[] trees, int threadnum, HashMap ercMapsForFancyPrint) {
        int[] genome = ind.genome;
        int position = 0;
        for (int i = 1; i <= this.passes; i *= 2) {
            position = this.makeTrees(state, genome, trees, threadnum, ercMapsForFancyPrint);
            if (position >= 0 || i >= this.passes) continue;
            int[] old = genome;
            genome = new int[old.length * 2];
            System.arraycopy(old, 0, genome, 0, old.length);
            System.arraycopy(old, 0, genome, old.length, old.length);
        }
        return Math.min(position, ind.genome.length);
    }

    public int makeTrees(EvolutionState state, int[] genome, GPTree[] trees, int threadnum, HashMap ercMapsForFancyPrint) {
        int position = 0;
        for (int i = 0; i < trees.length; ++i) {
            if (position < 0) {
                return -1;
            }
            position = this.makeTree(state, genome, trees[i], position, i, threadnum, ercMapsForFancyPrint);
        }
        return position;
    }

    public int makeTree(EvolutionState state, int[] genome, GPTree tree, int position, int treeNum, int threadnum, HashMap ercMapsForFancyPrint) {
        GPNode root;
        int[] countNumberOfChromosomesUsed = new int[]{position};
        GPFunctionSet gpfs = tree.constraints((GPInitializer)((GPInitializer)state.initializer)).functionset;
        try {
            root = this.makeSubtree(countNumberOfChromosomesUsed, genome, state, gpfs, this.grammar[treeNum], treeNum, threadnum, ercMapsForFancyPrint, tree, (byte)0);
        }
        catch (BigTreeException e) {
            return -1;
        }
        if (root == null) {
            state.output.fatal("Invalid tree: tree #" + treeNum);
        }
        root.parent = tree;
        tree.child = root;
        return countNumberOfChromosomesUsed[0];
    }

    GPNode makeSubtree(int[] index, int[] genome, EvolutionState es, GPFunctionSet gpfs, GrammarRuleNode rule, int treeNum, int threadnum, HashMap ercMapsForFancyPrint, GPNodeParent parent, byte argposition) {
        if (index[0] >= genome.length) {
            throw new BigTreeException();
        }
        if (rule == null) {
            es.output.fatal("An undefined rule exists within the grammar.");
        }
        int i = rule.getNumChoices() > 1 ? (genome[index[0]] - (int)this.minGene(index[0])) % rule.getNumChoices() : 0;
        index[0] = index[0] + 1;
        GrammarNode choice = rule.getChoice(i);
        if (choice instanceof GrammarRuleNode) {
            GrammarRuleNode nextrule = (GrammarRuleNode)choice;
            return this.makeSubtree(index, genome, es, gpfs, nextrule, treeNum, threadnum, ercMapsForFancyPrint, parent, argposition);
        }
        GrammarFunctionNode funcgrammarnode = (GrammarFunctionNode)choice;
        GPNode validNode = funcgrammarnode.getGPNodePrototype();
        int numChildren = validNode.children.length;
        int numChildrenInGrammar = funcgrammarnode.getNumArguments();
        if (numChildren != numChildrenInGrammar) {
            es.output.fatal("GPNode " + validNode.toStringForHumans() + " requires " + numChildren + " children.  " + numChildrenInGrammar + " children found in the grammar.");
        }
        if (validNode instanceof ERC) {
            if (index[0] >= genome.length) {
                throw new BigTreeException();
            }
            int genomeVal = genome[index[0]];
            index[0] = index[0] + 1;
            validNode = this.obtainERC(es, genomeVal, threadnum, validNode, ercMapsForFancyPrint);
        } else {
            validNode = validNode.lightClone();
        }
        int childNumber = 0;
        for (int j = 0; j < funcgrammarnode.getNumArguments(); ++j) {
            validNode.children[childNumber] = this.makeSubtree(index, genome, es, gpfs, (GrammarRuleNode)funcgrammarnode.getArgument(j), treeNum, threadnum, ercMapsForFancyPrint, validNode, (byte)childNumber);
            if (validNode.children[childNumber] == null) {
                return null;
            }
            ++childNumber;
        }
        validNode.argposition = argposition;
        validNode.parent = parent;
        return validNode;
    }

    public GPNode obtainERC(EvolutionState state, int genomeVal, int threadnum, GPNode node, HashMap ercMapsForFancyPrint) {
        ArrayList<GPNode> ERCList = (ArrayList<GPNode>)this.ERCBank.get(genomeVal);
        if (ERCList == null) {
            ERCList = new ArrayList<GPNode>();
            this.ERCBank.put(genomeVal, ERCList);
        }
        GPNode dummy = null;
        for (int i = 0; i < ERCList.size(); ++i) {
            dummy = (GPNode)ERCList.get(i);
            if (!dummy.nodeEquivalentTo(node)) continue;
            if (ercMapsForFancyPrint != null) {
                ercMapsForFancyPrint.put(genomeVal, dummy);
            }
            return dummy.lightClone();
        }
        node = node.lightClone();
        node.resetNode(state, threadnum);
        ERCList.add(node);
        if (ercMapsForFancyPrint != null) {
            ercMapsForFancyPrint.put(genomeVal, node);
        }
        return node;
    }

    @Override
    public Object clone() {
        GESpecies other = (GESpecies)super.clone();
        other.gpspecies = (GPSpecies)this.gpspecies.clone();
        return other;
    }

    @Override
    public Parameter defaultBase() {
        return GEDefaults.base().push(P_GESPECIES);
    }

    public int consumed(EvolutionState state, GEIndividual ind, int threadnum) {
        GPIndividual newind = ((GPIndividual)this.gpspecies.i_prototype).lightClone();
        return this.makeTrees(state, ind, newind.trees, threadnum, null);
    }

    public GPIndividual map(EvolutionState state, GEIndividual ind, int threadnum, HashMap ercMapsForFancyPrint) {
        GPIndividual newind = ((GPIndividual)this.gpspecies.i_prototype).lightClone();
        newind.fitness = ind.fitness;
        newind.evaluated = false;
        newind.species = this.gpspecies;
        if (this.makeTrees(state, ind, newind.trees, threadnum, ercMapsForFancyPrint) < 0) {
            return null;
        }
        return newind;
    }

    public List flattenSexp(EvolutionState state, int threadnum, GPTree tree) {
        List nodeList = this.gatherNodeString(state, threadnum, tree.child, 0);
        return nodeList;
    }

    public List gatherNodeString(EvolutionState state, int threadnum, GPNode node, int index) {
        ArrayList<String> list = new ArrayList<String>();
        if (node instanceof ERC) {
            list.add(node.name().trim());
            list.add(this.getKeyFromNode(state, threadnum, node, index).trim());
        } else {
            list.add(node.toString().trim());
        }
        if (node.children.length > 0) {
            for (int i = 0; i < node.children.length; ++i) {
                List sublist = this.gatherNodeString(state, threadnum, node.children[i], ++index);
                list.addAll(sublist);
            }
        }
        return list;
    }

    public String getKeyFromNode(EvolutionState state, int threadnum, GPNode node, int index) {
        String str = null;
        if (this.ERCBank != null && !this.ERCBank.isEmpty()) {
            for (Map.Entry pairs : this.ERCBank.entrySet()) {
                ArrayList nodeList = (ArrayList)pairs.getValue();
                if (Collections.binarySearch(nodeList, node, new Comparator(this){

                    public int compare(Object o1, Object o2) {
                        if (o1 instanceof GPNode && o2 instanceof GPNode) {
                            return ((GPNode)o1).toString().compareTo(((GPNode)o2).toString());
                        }
                        return 0;
                    }
                }) < 0) continue;
                str = ((Integer)pairs.getKey()).toString();
                break;
            }
        }
        if (str == null) {
            if (this.ERCBank == null) {
                this.ERCBank = new HashMap();
            }
            int minIndex = 0;
            if (index < this.minGene.length) {
                minIndex = index;
            }
            Integer key = (int)this.minGene[minIndex] + state.random[threadnum].nextInt((int)(this.maxGene[minIndex] - this.minGene[minIndex] + 1L));
            ArrayList<GPNode> list = new ArrayList<GPNode>();
            list.add(node.lightClone());
            this.ERCBank.put(key, list);
            str = key.toString();
        }
        return str;
    }

    public int[] parseSexp(ArrayList flatSexp, GrammarParser gp) {
        ArrayList<Integer> intList = new ArrayList<Integer>();
        LinkedList input = new LinkedList((ArrayList)flatSexp.clone());
        Stack<String> stack = new Stack<String>();
        stack.push(((GrammarNode)gp.productionRuleList.get(0)).getHead());
        int index = 0;
        block0: while (!input.isEmpty()) {
            String token = (String)input.remove();
            while (true) {
                if (stack.peek().equals(token)) {
                    stack.pop();
                    if (!token.equals("ERC")) continue block0;
                    token = (String)input.remove();
                    intList.add(Integer.valueOf(token));
                    continue block0;
                }
                int rIndex = (Integer)gp.ruleHeadToIndex.get(stack.peek());
                int fIndex = (Integer)gp.functionHeadToIndex.get(token);
                Integer ruleIndex = gp.predictiveParseTable[rIndex][fIndex];
                GrammarNode action = (GrammarNode)gp.indexToRule.get(ruleIndex);
                int minIndex = 0;
                if (index < this.minGene.length) {
                    minIndex = index;
                }
                intList.add((Integer)gp.absIndexToRelIndex.get(ruleIndex) + (int)this.minGene[minIndex]);
                ++index;
                stack.pop();
                action = action.children.get(0);
                if (action instanceof GrammarFunctionNode) {
                    for (int i = ((GrammarFunctionNode)action).getNumArguments() - 1; i >= 0; --i) {
                        stack.push(((GrammarFunctionNode)action).getArgument(i).getHead());
                    }
                    stack.push(action.getHead());
                    continue;
                }
                if (!(action instanceof GrammarRuleNode)) continue;
                stack.push(((GrammarRuleNode)action).getHead());
            }
        }
        int[] genomeVals = new int[intList.size()];
        for (int i = 0; i < intList.size(); ++i) {
            genomeVals[i] = (Integer)intList.get(i);
        }
        return genomeVals;
    }

    public GEIndividual reverseMap(EvolutionState state, GPIndividual ind, int threadnum) {
        GEIndividual newind = (GEIndividual)this.i_prototype.clone();
        int longestIntLength = -1;
        int[] longestInt = null;
        for (int treeIndex = 0; treeIndex < ind.trees.length; ++treeIndex) {
            ArrayList flatSexp = (ArrayList)this.flattenSexp(state, threadnum, ind.trees[treeIndex]);
            int[] genomeVals = this.parseSexp(flatSexp, this.grammarParser[treeIndex]);
            if (genomeVals.length >= longestIntLength) {
                longestIntLength = genomeVals.length;
                longestInt = new int[genomeVals.length];
                System.arraycopy(genomeVals, 0, longestInt, 0, genomeVals.length);
            }
            genomeVals = null;
        }
        newind.genome = longestInt;
        newind.fitness = ind.fitness;
        newind.evaluated = false;
        newind.species = this;
        return newind;
    }

    static class BigTreeException
    extends RuntimeException {
        static final long serialVersionUID = 1L;

        BigTreeException() {
        }
    }
}

