/*
 * Decompiled with CFR 0.152.
 */
package ec.gp.ge;

import ec.EvolutionState;
import ec.Prototype;
import ec.gp.GPFunctionSet;
import ec.gp.ge.GEDefaults;
import ec.gp.ge.GrammarFunctionNode;
import ec.gp.ge.GrammarNode;
import ec.gp.ge.GrammarRuleNode;
import ec.util.Lexer;
import ec.util.Output;
import ec.util.Parameter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class GrammarParser
implements Prototype {
    public static final String P_PARSER = "parser";
    HashMap rules = new HashMap();
    GrammarRuleNode root = null;
    ArrayList productionRuleList = new ArrayList();
    HashMap indexToRule = new HashMap();
    HashMap ruleToIndex = new HashMap();
    HashMap functionHeadToIndex = new HashMap();
    HashMap ruleHeadToIndex = new HashMap();
    HashMap absIndexToRelIndex = new HashMap();
    HashMap ruleToFirstSet = new HashMap();
    HashMap ruleToFollowSet = new HashMap();
    HashMap ruleToPredictSet = new HashMap();
    int[][] predictiveParseTable = null;
    public static final String[] DEFAULT_REGEXES = new String[]{"\\p{Blank}*#[^\\n\\r]*", "\\p{Blank}*\\(", "\\p{Blank}*\\)", "\\p{Blank}*<[^<>()\\p{Space}]*>", "\\p{Blank}*[|]", "\\p{Blank}*::=", "\\p{Blank}*::=", "\\p{Blank}*::=", "\\p{Blank}*::=", "\\p{Blank}*[^<>()|\\p{Space}]+"};
    protected static final int COMMENT = 0;
    protected static final int LPAREN = 1;
    protected static final int RPAREN = 2;
    protected static final int RULE = 3;
    protected static final int PIPE = 4;
    protected static final int EQUALS = 5;
    protected static final int NUMERIC_CONSTANT = 6;
    protected static final int BOOLEAN_CONSTANT = 7;
    protected static final int STRING_CONSTANT = 8;
    protected static final int FUNCTION = 9;

    public String[] getRegexes() {
        return DEFAULT_REGEXES;
    }

    @Override
    public Parameter defaultBase() {
        return GEDefaults.base().push(P_PARSER);
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
    }

    @Override
    public Object clone() {
        try {
            GrammarParser other = (GrammarParser)super.clone();
            other.rules = (HashMap)this.rules.clone();
            return other;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    GrammarRuleNode getRule(HashMap rules, String head) {
        if (rules.containsKey(head)) {
            return (GrammarRuleNode)rules.get(head);
        }
        GrammarRuleNode node = new GrammarRuleNode(head);
        rules.put(head, node);
        return node;
    }

    GrammarRuleNode parseRule(EvolutionState state, Lexer lexer, GPFunctionSet gpfs) {
        GrammarRuleNode retResult = null;
        String token = lexer.nextToken().trim();
        if (token.length() == 0) {
            return null;
        }
        if (lexer.getMatchingIndex() == 0) {
            return null;
        }
        state.output.message("Parsing Rule: " + token);
        if (lexer.getMatchingIndex() == 3) {
            lexer.nextToken();
            if (lexer.getMatchingIndex() != 5) {
                state.output.fatal("GE Grammar Error.  Expecting equal sign after rule head: " + token);
            }
            retResult = this.getRule(this.rules, token);
            this.parseProductions(state, retResult, lexer, gpfs);
        } else {
            state.output.fatal("GE Grammar Error.  Unexpected token: Expecting rule head.: " + token);
        }
        return retResult;
    }

    void parseProductions(EvolutionState state, GrammarRuleNode retResult, Lexer lexer, GPFunctionSet gpfs) {
        do {
            String token = lexer.nextToken();
            if (lexer.getMatchingIndex() == 3) {
                retResult.addChoice(this.getRule(this.rules, token));
                token = lexer.nextToken();
                continue;
            }
            if (lexer.getMatchingIndex() != 1) {
                state.output.fatal("GE Grammar Error - Unexpected token for rule: " + retResult.getHead() + "Expecting '('.");
            }
            token = lexer.nextToken();
            if (lexer.getMatchingIndex() != 9) {
                state.output.fatal("GE Grammar Error - Expecting a function name after first '(' for rule: " + retResult.getHead() + " Error: " + token);
            } else {
                if (!gpfs.nodesByName.containsKey(token)) {
                    state.output.fatal("GPNode " + token + " is not defined in the function set.");
                }
                GrammarFunctionNode grammarfuncnode = new GrammarFunctionNode(gpfs, token);
                token = lexer.nextToken();
                while (lexer.getMatchingIndex() != 2) {
                    if (lexer.getMatchingIndex() != 3) {
                        state.output.fatal("GE Grammar Error - Expecting a rule name as argument for function definition: " + grammarfuncnode.getHead() + " Error on : " + token);
                    }
                    grammarfuncnode.addArgument(this.getRule(this.rules, token));
                    token = lexer.nextToken();
                }
                retResult.addChoice(grammarfuncnode);
            }
            token = lexer.nextToken();
            if (lexer.getMatchingIndex() == 4 || lexer.getMatchingIndex() == -1) continue;
            state.output.fatal("GE Grammar Error - Expecting either '|' delimiter or newline. Error on : " + token);
        } while (lexer.getMatchingIndex() == 4);
    }

    public GrammarRuleNode parseRules(EvolutionState state, BufferedReader reader, GPFunctionSet gpfs) {
        this.rules = new HashMap();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                GrammarRuleNode rule = this.parseRule(state, new Lexer(line.trim(), DEFAULT_REGEXES), gpfs);
                if (rule == null || this.root != null) continue;
                this.root = rule;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        state.output.exitIfErrors();
        return this.root;
    }

    public String toString() {
        Object ret = "Grammar[";
        Iterator i = this.rules.values().iterator();
        while (i.hasNext()) {
            ret = (String)ret + "\n" + String.valueOf(i.next());
        }
        return (String)ret + "\n\t]";
    }

    public boolean validateRules() {
        boolean isok = true;
        for (GrammarRuleNode rule : this.rules.values()) {
            if (rule.getNumChoices() >= 1) continue;
            System.out.println("Grammar is bad! - Rule not defined: " + String.valueOf(rule));
            isok = false;
        }
        if (isok) {
            System.out.println("All rules appear properly defined!");
            return true;
        }
        return false;
    }

    public void enumerateGrammarTree(GrammarNode gn) {
        LinkedList<GrammarNode> q = new LinkedList<GrammarNode>();
        int gnIndex = 0;
        int fIndex = 0;
        int rIndex = 0;
        this.ruleHeadToIndex.put(gn.getHead(), rIndex++);
        q.add(gn);
        while (!q.isEmpty()) {
            GrammarNode temp = (GrammarNode)q.remove();
            for (int i = 0; i < temp.children.size(); ++i) {
                GrammarRuleNode grn = new GrammarRuleNode(temp.head);
                GrammarNode child = ((GrammarRuleNode)temp).getChoice(i);
                grn.children.add(child);
                this.productionRuleList.add(grn);
                this.indexToRule.put(gnIndex, grn);
                this.ruleToIndex.put(grn, gnIndex);
                ++gnIndex;
                if (child instanceof GrammarRuleNode) {
                    this.ruleHeadToIndex.put(child.getHead(), rIndex++);
                    q.add(child);
                    continue;
                }
                if (!(child instanceof GrammarFunctionNode)) continue;
                this.functionHeadToIndex.put(child.getHead(), fIndex++);
            }
        }
        String oldHead = ((GrammarNode)this.indexToRule.get(0)).getHead();
        this.absIndexToRelIndex.put(0, 0);
        int relIndex = 1;
        for (int absIndex = 1; absIndex < this.indexToRule.size(); ++absIndex) {
            String currentHead = ((GrammarNode)this.indexToRule.get(absIndex)).getHead();
            if (!currentHead.equals(oldHead)) {
                relIndex = 0;
            }
            this.absIndexToRelIndex.put(absIndex, relIndex++);
            oldHead = currentHead;
        }
    }

    public ArrayList gatherFirstSets(GrammarNode gn, GrammarNode parent) {
        ArrayList<String> firstSet = new ArrayList<String>();
        if (gn instanceof GrammarRuleNode) {
            for (int i = 0; i < ((GrammarRuleNode)gn).getNumChoices(); ++i) {
                ArrayList set = this.gatherFirstSets(((GrammarRuleNode)gn).getChoice(i), gn);
                firstSet.addAll(set);
            }
            if (parent != null) {
                GrammarRuleNode treeEdge = new GrammarRuleNode(parent.getHead());
                treeEdge.children.add(gn);
                this.ruleToFirstSet.put(treeEdge, firstSet);
            }
        } else if (gn instanceof GrammarFunctionNode) {
            firstSet.add(gn.getHead());
            GrammarRuleNode treeEdge = new GrammarRuleNode(parent.getHead());
            treeEdge.children.add(gn);
            this.ruleToFirstSet.put(treeEdge, firstSet);
        }
        return firstSet;
    }

    public ArrayList gatherFollowSets(GrammarNode gn, GrammarNode parent) {
        ArrayList followSet = new ArrayList();
        return followSet;
    }

    public void gatherPredictSets(GrammarNode gn, GrammarNode parent) {
        this.gatherFirstSets(gn, null);
        this.gatherFollowSets(gn, null);
        if (this.ruleToFollowSet.isEmpty()) {
            this.ruleToPredictSet = (HashMap)this.ruleToFirstSet.clone();
        }
    }

    public void populatePredictiveParseTable(GrammarNode gn) {
    }

    public static void main(String[] args) throws FileNotFoundException {
        EvolutionState state = new EvolutionState();
        state.output = new Output(true);
        state.output.addLog(0, false);
        state.output.addLog(1, true);
        GrammarParser gp = new GrammarParser();
        gp.parseRules(state, new BufferedReader(new FileReader(new File(args[0]))), null);
        gp.validateRules();
        System.err.println(gp);
    }
}

