/*
 * Decompiled with CFR 0.152.
 */
package ec.gp.ge.breed;

import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.gp.ge.GEDefaults;
import ec.gp.ge.GEIndividual;
import ec.gp.ge.GESpecies;
import ec.util.Parameter;
import java.util.ArrayList;
import java.util.HashMap;

public class GETruncationPipeline
extends BreedingPipeline {
    public static final String P_TRUNCATION = "truncation";
    public static final int NUM_SOURCES = 1;

    @Override
    public int numSources() {
        return 1;
    }

    @Override
    public Parameter defaultBase() {
        return GEDefaults.base().push(P_TRUNCATION);
    }

    @Override
    public int produce(int min, int max, int subpopulation, ArrayList<Individual> inds, EvolutionState state, int thread, HashMap<String, Object> misc) {
        int start = inds.size();
        int n = this.sources[0].produce(min, max, subpopulation, inds, state, thread, misc);
        if (!state.random[thread].nextBoolean(this.likelihood)) {
            return n;
        }
        for (int q = start; q < n + start; ++q) {
            GEIndividual ind;
            GESpecies species = (GESpecies)ind.species;
            ind = (GEIndividual)inds.get(q);
            int consumed = species.consumed(state, ind, thread);
            if (consumed <= 1) continue;
            Object[] pieces = new Object[2];
            ind.split(new int[]{consumed}, pieces);
            ind.join(new Object[]{pieces[0]});
        }
        return n;
    }
}

