/*
 * Decompiled with CFR 0.152.
 */
package ec.gp.koza;

import ec.EvolutionState;
import ec.gp.GPIndividual;
import ec.gp.GPNode;
import ec.gp.GPNodeSelector;
import ec.gp.GPTree;
import ec.gp.koza.GPKozaDefaults;
import ec.util.Parameter;

public class KozaNodeSelector
implements GPNodeSelector {
    public static final String P_NODESELECTOR = "ns";
    public static final String P_TERMINAL_PROBABILITY = "terminals";
    public static final String P_NONTERMINAL_PROBABILITY = "nonterminals";
    public static final String P_ROOT_PROBABILITY = "root";
    public double rootProbability;
    public double terminalProbability;
    public double nonterminalProbability;
    public int nonterminals;
    public int terminals;
    public int nodes;

    @Override
    public Parameter defaultBase() {
        return GPKozaDefaults.base().push(P_NODESELECTOR);
    }

    public KozaNodeSelector() {
        this.reset();
    }

    @Override
    public Object clone() {
        try {
            KozaNodeSelector s = (KozaNodeSelector)super.clone();
            s.reset();
            return s;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        Parameter def = this.defaultBase();
        this.terminalProbability = state.parameters.getDoubleWithMax(base.push(P_TERMINAL_PROBABILITY), def.push(P_TERMINAL_PROBABILITY), 0.0, 1.0);
        if (this.terminalProbability == -1.0) {
            state.output.fatal("Invalid terminal probability for KozaNodeSelector ", base.push(P_TERMINAL_PROBABILITY), def.push(P_TERMINAL_PROBABILITY));
        }
        this.nonterminalProbability = state.parameters.getDoubleWithMax(base.push(P_NONTERMINAL_PROBABILITY), def.push(P_NONTERMINAL_PROBABILITY), 0.0, 1.0);
        if (this.nonterminalProbability == -1.0) {
            state.output.fatal("Invalid nonterminal probability for KozaNodeSelector ", base.push(P_NONTERMINAL_PROBABILITY), def.push(P_NONTERMINAL_PROBABILITY));
        }
        this.rootProbability = state.parameters.getDoubleWithMax(base.push(P_ROOT_PROBABILITY), def.push(P_ROOT_PROBABILITY), 0.0, 1.0);
        if (this.rootProbability == -1.0) {
            state.output.fatal("Invalid root probability for KozaNodeSelector ", base.push(P_ROOT_PROBABILITY), def.push(P_ROOT_PROBABILITY));
        }
        if (this.rootProbability + this.terminalProbability + this.nonterminalProbability > 1.0) {
            state.output.fatal("The terminal, nonterminal, and root for KozaNodeSelector" + String.valueOf(base) + " may not sum to more than 1.0. (" + this.terminalProbability + " " + this.nonterminalProbability + " " + this.rootProbability + ")", base);
        }
        this.reset();
    }

    @Override
    public void reset() {
        this.nodes = -1;
        this.terminals = -1;
        this.nonterminals = -1;
    }

    @Override
    public GPNode pickNode(EvolutionState s, int subpopulation, int thread, GPIndividual ind, GPTree tree) {
        double rnd = s.random[thread].nextDouble();
        if (rnd > this.nonterminalProbability + this.terminalProbability + this.rootProbability) {
            if (this.nodes == -1) {
                this.nodes = tree.child.numNodes(0);
            }
            return tree.child.nodeInPosition(s.random[thread].nextInt(this.nodes), 0);
        }
        if (rnd > this.nonterminalProbability + this.terminalProbability) {
            return tree.child;
        }
        if (rnd > this.nonterminalProbability) {
            if (this.terminals == -1) {
                this.terminals = tree.child.numNodes(1);
            }
            return tree.child.nodeInPosition(s.random[thread].nextInt(this.terminals), 1);
        }
        if (this.nonterminals == -1) {
            this.nonterminals = tree.child.numNodes(2);
        }
        if (this.nonterminals > 0) {
            return tree.child.nodeInPosition(s.random[thread].nextInt(this.nonterminals), 2);
        }
        return tree.child;
    }
}

