/*
 * Decompiled with CFR 0.152.
 */
package ec.gp.push;

import ec.EvolutionState;
import ec.gp.GPFunctionSet;
import ec.gp.GPIndividual;
import ec.gp.GPInitializer;
import ec.gp.GPNode;
import ec.gp.GPProblem;
import ec.gp.push.PushInstruction;
import ec.gp.push.Terminal;
import org.spiderland.Psh.Instruction;
import org.spiderland.Psh.Interpreter;
import org.spiderland.Psh.Program;

public abstract class PushProblem
extends GPProblem {
    StringBuilder buffer;

    @Override
    public Object clone() {
        PushProblem other = (PushProblem)super.clone();
        other.buffer = null;
        return other;
    }

    public Program getProgram(EvolutionState state, GPIndividual ind) {
        if (this.buffer == null) {
            this.buffer = new StringBuilder();
        } else {
            this.buffer.delete(0, this.buffer.length());
        }
        try {
            Object prog = ind.trees[0].child.makeLispTree(this.buffer).toString();
            if (!((String)prog).startsWith("(")) {
                prog = "(" + (String)prog + ")";
            }
            return new Program((String)prog);
        }
        catch (Exception e) {
            state.output.fatal("Push exception encountered while parsing program from GP Tree:\n" + String.valueOf(ind.trees[0].child.makeLispTree(this.buffer)) + "\n" + String.valueOf(e));
            return null;
        }
    }

    public Interpreter getInterpreter(EvolutionState state, GPIndividual ind, int threadnum) {
        Interpreter interpreter = new Interpreter(state.random[threadnum]);
        GPFunctionSet set = ind.trees[0].constraints((GPInitializer)((GPInitializer)state.initializer)).functionset;
        GPNode[] terminals = set.terminals[0];
        for (int i = 0; i < terminals.length; ++i) {
            if (!(terminals[i] instanceof Terminal)) continue;
            Terminal op = (Terminal)terminals[i];
            PushInstruction[] customInstructions = op.customInstructions;
            int[] indices = op.indices;
            String[] instructions = op.instructions;
            for (int j = 0; j < customInstructions.length; ++j) {
                System.err.println(instructions[indices[j]]);
                interpreter.AddInstruction(instructions[indices[j]], (Instruction)((PushInstruction)customInstructions[j].clone()));
            }
        }
        return interpreter;
    }

    public void executeProgram(Program program, Interpreter interpreter, int maxSteps) {
        interpreter.Execute(program, maxSteps);
    }

    public void resetInterpreter(Interpreter interpreter) {
        interpreter.ClearStacks();
    }

    public void pushOntoFloatStack(Interpreter interpreter, float val) {
        interpreter.floatStack().push(val);
    }

    public void pushOntoIntStack(Interpreter interpreter, int val) {
        interpreter.intStack().push(val);
    }

    public boolean isFloatStackEmpty(Interpreter interpreter) {
        return interpreter.floatStack().size() == 0;
    }

    public boolean isIntStackEmpty(Interpreter interpreter) {
        return interpreter.intStack().size() == 0;
    }

    public float topOfFloatStack(Interpreter interpreter) {
        return interpreter.floatStack().top();
    }

    public int topOfIntStack(Interpreter interpreter) {
        return interpreter.intStack().top();
    }
}

