/*
 * Decompiled with CFR 0.152.
 */
package ec.multiobjective;

import ec.EvolutionState;
import ec.Individual;
import ec.multiobjective.HypervolumeStatistics;
import ec.multiobjective.MultiObjectiveFitness;
import ec.simple.SimpleStatistics;
import ec.util.Parameter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class MultiObjectiveStatistics
extends SimpleStatistics {
    private static final long serialVersionUID = 1L;
    public static final String P_PARETO_FRONT_FILE = "front";
    public static final String P_SILENT_FRONT_FILE = "silent.front";
    public static final String P_DO_HYPERVOLUME = "do-hypervolume";
    public static final String P_REFERENCE_POINT = "reference-point";
    public boolean silentFront;
    public boolean doHypervolume;
    private double[] referencePoint;
    public int frontLog = 0;
    boolean warned = false;

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        if (state.parameters.exists(base.push("do-description"), null)) {
            state.output.warning("Descriptions are not printed out by " + this.getClass().getSimpleName(), base.push("do-description"));
        }
        if (state.parameters.exists(base.push("do-per-generation-description"), null)) {
            state.output.warning("Descriptions are not printed out by " + this.getClass().getSimpleName(), base.push("do-per-generation-description"));
        }
        this.silentFront = state.parameters.getBoolean(base.push("silent"), null, false);
        this.silentFront = state.parameters.getBoolean(base.push(P_SILENT_FRONT_FILE), null, this.silentFront);
        File frontFile = state.parameters.getFile(base.push(P_PARETO_FRONT_FILE), null);
        if (this.silentFront) {
            this.frontLog = -2;
        } else if (frontFile != null) {
            try {
                this.frontLog = state.output.addLog(frontFile, !this.compress, this.compress);
            }
            catch (IOException i) {
                state.output.fatal("An IOException occurred while trying to create the log " + String.valueOf(frontFile) + ":\n" + String.valueOf(i));
            }
        } else {
            state.output.warning("No Pareto Front statistics file specified, printing to stdout at end.", base.push(P_PARETO_FRONT_FILE));
        }
        this.doHypervolume = state.parameters.getBoolean(base.push(P_DO_HYPERVOLUME), null, false);
        if (this.doHypervolume) {
            if (!state.parameters.exists(base.push(P_REFERENCE_POINT), null)) {
                state.output.fatal(String.format("%s: '%s' is specified, but no '%s' was given.", this.getClass().getSimpleName(), base.push(P_DO_HYPERVOLUME), base.push(P_REFERENCE_POINT), P_REFERENCE_POINT));
            } else {
                this.referencePoint = state.parameters.getDoubles(base.push(P_REFERENCE_POINT), null, Double.NEGATIVE_INFINITY);
            }
        } else if (state.parameters.exists(base.push(P_REFERENCE_POINT), null)) {
            state.output.warning("Ignoring the provided reference point parameter, because the hypervolume parameter is set to false", base.push(P_REFERENCE_POINT));
        }
    }

    @Override
    public void postEvaluationStatistics(EvolutionState state) {
        super.bypassPostEvaluationStatistics(state);
        state.output.println("\nGeneration: " + state.generation, this.statisticslog);
        for (int s = 0; s < state.population.subpops.size(); ++s) {
            if (!this.doMessage && !this.doGeneration) continue;
            ArrayList<Individual> sortedFront = MultiObjectiveFitness.getSortedParetoFront(state.population.subpops.get((int)s).individuals);
            if (this.doGeneration) {
                state.output.println("Subpopulation " + s + ":", this.statisticslog);
                if (this.doHypervolume) {
                    double hv = HypervolumeStatistics.hypervolume(sortedFront, this.referencePoint);
                    state.output.println("Hypervolume: " + hv, this.statisticslog);
                    if (this.doMessage && !this.silentPrint) {
                        state.output.message("Subpop " + s + " hypervolume: " + hv);
                    }
                }
                state.output.println("\nFront: ", this.statisticslog);
                for (int i = 0; i < sortedFront.size(); ++i) {
                    sortedFront.get(i).printIndividualForHumans(state, this.statisticslog);
                }
            }
            if (!this.doMessage || this.silentPrint) continue;
            StringBuilder msg = new StringBuilder();
            for (int i = 0; i < sortedFront.size(); ++i) {
                Individual ind = sortedFront.get(i);
                MultiObjectiveFitness mof = (MultiObjectiveFitness)ind.fitness;
                double[] objectives = mof.getObjectives();
                msg.append("[");
                for (int j = 0; j < objectives.length; ++j) {
                    msg.append(objectives[j]);
                    if (j >= objectives.length - 1) continue;
                    msg.append(" ");
                }
                msg.append("] ");
            }
            state.output.message("Subpop " + s + " front: " + String.valueOf(msg));
        }
    }

    @Override
    public void finalStatistics(EvolutionState state, int result) {
        this.bypassFinalStatistics(state, result);
        if (this.doFinal) {
            state.output.println("\n\n\n PARETO FRONTS", this.statisticslog);
        }
        for (int s = 0; s < state.population.subpops.size(); ++s) {
            int i;
            if (this.doFinal) {
                state.output.println("\n\nPareto Front of Subpopulation " + s, this.statisticslog);
            }
            ArrayList<Individual> sortedFront = MultiObjectiveFitness.getSortedParetoFront(state.population.subpops.get((int)s).individuals);
            if (this.doFinal) {
                for (i = 0; i < sortedFront.size(); ++i) {
                    sortedFront.get(i).printIndividualForHumans(state, this.statisticslog);
                }
            }
            if (this.silentFront) continue;
            if (state.population.subpops.size() > 1) {
                state.output.println("Subpopulation " + s, this.frontLog);
            }
            for (i = 0; i < sortedFront.size(); ++i) {
                Individual ind = sortedFront.get(i);
                MultiObjectiveFitness mof = (MultiObjectiveFitness)ind.fitness;
                double[] objectives = mof.getObjectives();
                Object line = "";
                for (int f = 0; f < objectives.length; ++f) {
                    line = (String)line + objectives[f] + " ";
                }
                state.output.println((String)line, this.frontLog);
            }
        }
    }
}

