/*
 * Decompiled with CFR 0.152.
 */
package ec.multiobjective.nsga2;

import ec.EvolutionState;
import ec.Individual;
import ec.Population;
import ec.Subpopulation;
import ec.multiobjective.MultiObjectiveFitness;
import ec.multiobjective.nsga2.NSGA2MultiObjectiveFitness;
import ec.simple.SimpleBreeder;
import ec.util.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class NSGA2Breeder
extends SimpleBreeder {
    private static final long serialVersionUID = 1L;
    BreedingState breedingState;
    int[] numElites = null;
    Population oldPopulation = null;

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        for (int i = 0; i < this.elite.length; ++i) {
            if (!this.usingElitism(i)) continue;
            state.output.warning("You're using elitism with " + this.getClass().getSimpleName() + ", which is not permitted and will be ignored.  However the 'reevaluate-elites' parameter *will* be recognized.", base.push("elite").push("" + i));
        }
        if (this.sequentialBreeding) {
            state.output.fatal(this.getClass().getSimpleName() + "does not support sequential evaluation.", base.push("sequential"));
        }
        if (!this.clonePipelineAndPopulation) {
            state.output.fatal("clone-pipeline-and-population must be true for " + this.getClass().getSimpleName());
        }
        this.breedingState = BreedingState.BREEDING_COMPLETE;
    }

    @Override
    public int numElites(EvolutionState state, int subpopulation) {
        if (this.breedingState != BreedingState.ARCHIVE_LOADED) {
            state.output.fatal(String.format("%s: Tried to query numElites before loadElites() was called.", this.getClass().getSimpleName()));
        }
        return this.numElites[subpopulation];
    }

    @Override
    protected void loadElites(EvolutionState state, Population newpop) {
        int i;
        if (this.breedingState == BreedingState.ARCHIVE_LOADED) {
            state.output.fatal(String.format("%s: Tried to load elites for the next generation before breeding for the current generation was complete.", this.getClass().getSimpleName()));
        }
        this.numElites = new int[newpop.subpops.size()];
        for (i = 0; i < newpop.subpops.size(); ++i) {
            ArrayList<Individual> list = this.buildArchive(state, i);
            this.numElites[i] = list.size();
            newpop.subpops.get((int)i).individuals.addAll(list);
        }
        this.breedingState = BreedingState.ARCHIVE_LOADED;
        this.oldPopulation = state.population;
        state.population = state.population.emptyClone();
        for (i = 0; i < newpop.subpops.size(); ++i) {
            Subpopulation subpop = state.population.subpops.get(i);
            Subpopulation newsubpop = newpop.subpops.get(i);
            int ne = this.numElites[i];
            for (int j = 0; j < ne; ++j) {
                subpop.individuals.add(j, (Individual)newsubpop.individuals.get(j).clone());
            }
        }
    }

    @Override
    public void postProcess(EvolutionState state) {
        state.population = this.oldPopulation;
        this.oldPopulation = null;
    }

    @Override
    public Population breedPopulation(EvolutionState state) {
        Population result = super.breedPopulation(state);
        this.breedingState = BreedingState.BREEDING_COMPLETE;
        return result;
    }

    public ArrayList<Individual> buildArchive(EvolutionState state, int subpop) {
        ArrayList<ArrayList<Individual>> ranks = this.assignFrontRanks(state.population.subpops.get(subpop));
        if (!(state.population.subpops.get((int)subpop).species.f_prototype instanceof NSGA2MultiObjectiveFitness)) {
            state.output.fatal(String.format("%s: subpopulation %d is using %s to represent fitness, but NSGA2 requires %s or a subtype of %s.", this.getClass().getSimpleName(), subpop, state.population.subpops.get((int)subpop).species.f_prototype.getClass().getSimpleName(), NSGA2MultiObjectiveFitness.class.getSimpleName(), NSGA2MultiObjectiveFitness.class.getSimpleName()));
        }
        ArrayList<Individual> newSubpopulation = new ArrayList<Individual>();
        int size = ranks.size();
        int originalPopSize = state.population.subpops.get((int)subpop).individuals.size();
        int archiveSize = originalPopSize / 2;
        for (int i = 0; i < size; ++i) {
            ArrayList<Individual> rank = ranks.get(i);
            if (rank.size() + newSubpopulation.size() >= archiveSize) {
                this.assignSparsity(rank);
                Collections.sort(rank, new Comparator<Individual>(this){

                    @Override
                    public int compare(Individual i1, Individual i2) {
                        return Double.compare(((NSGA2MultiObjectiveFitness)i2.fitness).sparsity, ((NSGA2MultiObjectiveFitness)i1.fitness).sparsity);
                    }
                });
                int m = archiveSize - newSubpopulation.size();
                for (int j = 0; j < m; ++j) {
                    newSubpopulation.add(rank.get(j));
                }
                break;
            }
            newSubpopulation.addAll(rank);
        }
        ArrayList<Individual> archive = new ArrayList<Individual>(newSubpopulation);
        if (this.reevaluateElites[subpop]) {
            for (int i = 0; i < archive.size(); ++i) {
                archive.get((int)i).evaluated = false;
            }
        }
        return archive;
    }

    public ArrayList<ArrayList<Individual>> assignFrontRanks(Subpopulation subpop) {
        ArrayList<Individual> inds = subpop.individuals;
        ArrayList<ArrayList<Individual>> frontsByRank = MultiObjectiveFitness.partitionIntoRanks(inds);
        int numRanks = frontsByRank.size();
        for (int rank = 0; rank < numRanks; ++rank) {
            ArrayList<Individual> front = frontsByRank.get(rank);
            int numInds = front.size();
            for (int ind = 0; ind < numInds; ++ind) {
                ((NSGA2MultiObjectiveFitness)front.get((int)ind).fitness).rank = rank;
            }
        }
        return frontsByRank;
    }

    void assignSparsity(ArrayList<Individual> front) {
        int i;
        int numObjectives = ((NSGA2MultiObjectiveFitness)front.get((int)0).fitness).getObjectives().length;
        for (i = 0; i < front.size(); ++i) {
            ((NSGA2MultiObjectiveFitness)front.get((int)i).fitness).sparsity = 0.0;
        }
        for (i = 0; i < numObjectives; ++i) {
            final int o = i;
            Collections.sort(front, new Comparator<Individual>(){

                @Override
                public int compare(Individual i1, Individual i2) {
                    return Double.compare(((NSGA2MultiObjectiveFitness)i1.fitness).getObjective(o), ((NSGA2MultiObjectiveFitness)i2.fitness).getObjective(o));
                }
            });
            ((NSGA2MultiObjectiveFitness)front.get((int)0).fitness).sparsity = Double.POSITIVE_INFINITY;
            ((NSGA2MultiObjectiveFitness)front.get((int)(front.size() - 1)).fitness).sparsity = Double.POSITIVE_INFINITY;
            for (int j = 1; j < front.size() - 1; ++j) {
                NSGA2MultiObjectiveFitness f_j = (NSGA2MultiObjectiveFitness)front.get((int)j).fitness;
                NSGA2MultiObjectiveFitness f_jplus1 = (NSGA2MultiObjectiveFitness)front.get((int)(j + 1)).fitness;
                NSGA2MultiObjectiveFitness f_jminus1 = (NSGA2MultiObjectiveFitness)front.get((int)(j - 1)).fitness;
                f_j.sparsity += (f_jplus1.getObjective(o) - f_jminus1.getObjective(o)) / (f_j.maxObjective[o] - f_j.minObjective[o]);
            }
        }
    }

    public static enum BreedingState {
        ARCHIVE_LOADED,
        BREEDING_COMPLETE;

    }
}

