/*
 * Decompiled with CFR 0.152.
 */
package ec.multiobjective.nsga2;

import ec.EvolutionState;
import ec.Fitness;
import ec.multiobjective.MultiObjectiveFitness;
import ec.util.Code;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.LineNumberReader;

public class NSGA2MultiObjectiveFitness
extends MultiObjectiveFitness {
    private static final long serialVersionUID = 1L;
    public static final String NSGA2_RANK_PREAMBLE = "Rank: ";
    public static final String NSGA2_SPARSITY_PREAMBLE = "Sparsity: ";
    public int rank;
    public double sparsity;

    @Override
    public String[] getAuxilliaryFitnessNames() {
        return new String[]{"Rank", "Sparsity"};
    }

    @Override
    public double[] getAuxilliaryFitnessValues() {
        return new double[]{this.rank, this.sparsity};
    }

    @Override
    public String fitnessToString() {
        return super.fitnessToString() + "\nRank: " + Code.encode(this.rank) + "\nSparsity: " + Code.encode(this.sparsity);
    }

    @Override
    public String fitnessToStringForHumans() {
        return super.fitnessToStringForHumans() + "\nRank: " + this.rank + "\nSparsity: " + this.sparsity;
    }

    @Override
    public void readFitness(EvolutionState state, LineNumberReader reader) throws IOException {
        super.readFitness(state, reader);
        this.rank = Code.readIntegerWithPreamble(NSGA2_RANK_PREAMBLE, state, reader);
        this.sparsity = Code.readDoubleWithPreamble(NSGA2_SPARSITY_PREAMBLE, state, reader);
    }

    @Override
    public void writeFitness(EvolutionState state, DataOutput dataOutput) throws IOException {
        super.writeFitness(state, dataOutput);
        dataOutput.writeInt(this.rank);
        dataOutput.writeDouble(this.sparsity);
        this.writeTrials(state, dataOutput);
    }

    @Override
    public void readFitness(EvolutionState state, DataInput dataInput) throws IOException {
        super.readFitness(state, dataInput);
        this.rank = dataInput.readInt();
        this.sparsity = dataInput.readDouble();
        this.readTrials(state, dataInput);
    }

    @Override
    public boolean equivalentTo(Fitness _fitness) {
        NSGA2MultiObjectiveFitness other = (NSGA2MultiObjectiveFitness)_fitness;
        return this.rank == ((NSGA2MultiObjectiveFitness)_fitness).rank && this.sparsity == other.sparsity;
    }

    @Override
    public boolean betterThan(Fitness _fitness) {
        NSGA2MultiObjectiveFitness other = (NSGA2MultiObjectiveFitness)_fitness;
        if (this.rank < ((NSGA2MultiObjectiveFitness)_fitness).rank) {
            return true;
        }
        if (this.rank > ((NSGA2MultiObjectiveFitness)_fitness).rank) {
            return false;
        }
        return this.sparsity > other.sparsity;
    }
}

