/*
 * Decompiled with CFR 0.152.
 */
package ec.multiobjective.nsga3;

import ec.EvolutionState;
import ec.Fitness;
import ec.multiobjective.nsga2.NSGA2MultiObjectiveFitness;
import ec.util.Code;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;

public class NSGA3MultiObjectiveFitness
extends NSGA2MultiObjectiveFitness {
    private static final long serialVersionUID = 1L;
    public ArrayList<Double> normalizedFitness;

    @Override
    public String fitnessToString() {
        return super.fitnessToString() + "\nRank: " + Code.encode(this.rank);
    }

    @Override
    public String fitnessToStringForHumans() {
        return super.fitnessToStringForHumans() + "\nRank: " + this.rank;
    }

    @Override
    public void readFitness(EvolutionState state, LineNumberReader reader) throws IOException {
        super.readFitness(state, reader);
        this.rank = Code.readIntegerWithPreamble("Rank: ", state, reader);
    }

    public void initNorm() {
        this.normalizedFitness = new ArrayList();
    }

    public void initNorm(int length) {
        this.normalizedFitness = new ArrayList(length);
        for (int i = 0; i < length; ++i) {
            this.normalizedFitness.add(0.0);
        }
    }

    public ArrayList<Double> getNormFit() {
        return this.normalizedFitness;
    }

    public void setNormFit(ArrayList<Double> normFit) {
        this.normalizedFitness = normFit;
    }

    public void setNormValue(int position, Double value) {
        this.normalizedFitness.set(position, value);
    }

    @Override
    public boolean equivalentTo(Fitness _fitness) {
        return this.rank == ((NSGA3MultiObjectiveFitness)_fitness).rank;
    }

    @Override
    public boolean betterThan(Fitness _fitness) {
        return this.rank < ((NSGA3MultiObjectiveFitness)_fitness).rank;
    }
}

