/*
 * Decompiled with CFR 0.152.
 */
package ec.multiobjective.nsga3;

import ec.Individual;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class ReferencePoint
implements Serializable {
    private static final long serialVersionUID = 1L;
    ArrayList<Map.Entry<Double, Individual>> associates;
    int associations;
    ArrayList<Double> position;

    public ReferencePoint(int size) {
        this.position = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            this.position.add(0.0);
        }
        this.associations = 0;
        this.associates = new ArrayList();
    }

    public ReferencePoint(List<Double> point) {
        this.position = new ArrayList(point.size());
        for (Double d : point) {
            this.position.add(d);
        }
        this.associations = 0;
        this.associates = new ArrayList();
    }

    public List<Double> pos() {
        return this.position;
    }

    public int numAssociations() {
        return this.associations;
    }

    public boolean hasAssociates() {
        return this.associates.size() > 0;
    }

    public void clear() {
        this.associations = 0;
        this.associates.clear();
    }

    public void addAssociation() {
        ++this.associations;
    }

    public void addAssociate(Individual ind, double distance) {
        this.associates.add(new AbstractMap.SimpleEntry<Double, Individual>(distance, ind));
    }

    public Individual FindClosestAssociate() {
        double minDistance = Double.MAX_VALUE;
        Individual closetAssociate = null;
        for (Map.Entry<Double, Individual> p : this.associates) {
            if (!(p.getKey() < minDistance)) continue;
            minDistance = p.getKey();
            closetAssociate = p.getValue();
        }
        return closetAssociate;
    }

    public Individual RandomAssociate() {
        return this.associates.get(new Random().nextInt(this.associates.size())).getValue();
    }

    public void RemoveAssociate(Individual ind) {
        Iterator<Map.Entry<Double, Individual>> iter = this.associates.iterator();
        while (iter.hasNext()) {
            if (!iter.next().getValue().equals(ind)) continue;
            iter.remove();
            break;
        }
    }
}

