/*
 * Decompiled with CFR 0.152.
 */
package ec.multiobjective.spea2;

import ec.EvolutionState;
import ec.Individual;
import ec.Population;
import ec.Subpopulation;
import ec.multiobjective.MultiObjectiveFitness;
import ec.multiobjective.spea2.SPEA2MultiObjectiveFitness;
import ec.simple.SimpleBreeder;
import ec.util.MersenneTwisterFast;
import ec.util.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

public class SPEA2Breeder
extends SimpleBreeder {
    private static final long serialVersionUID = 1L;
    public static final String P_K = "k";
    public static final String P_NORMALIZE = "normalize-fitnesses";
    private int k;
    private static int NOT_SET = -1;
    private boolean normalize;
    private BreedingState breedingState;
    Population oldPopulation = null;

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        if (this.sequentialBreeding) {
            state.output.fatal("SPEA2Breeder does not support sequential evaluation.", base.push("sequential"));
        }
        if (!this.clonePipelineAndPopulation) {
            state.output.fatal("clonePipelineAndPopulation must be true for SPEA2Breeder.");
        }
        this.k = state.parameters.getIntWithDefault(base.push(P_K), null, NOT_SET);
        this.normalize = state.parameters.getBoolean(base.push(P_NORMALIZE), null, true);
        this.breedingState = BreedingState.BREEDING_COMPLETE;
    }

    @Override
    public Population breedPopulation(EvolutionState state) {
        Population result = super.breedPopulation(state);
        this.breedingState = BreedingState.BREEDING_COMPLETE;
        return result;
    }

    @Override
    public int numElites(EvolutionState state, int subpopulation) {
        if (this.breedingState != BreedingState.ARCHIVE_LOADED) {
            state.output.fatal(String.format("%s: Tried to query numElites before loadElites() was called.", this.getClass().getSimpleName()));
        }
        return this.numElites(state, this.oldPopulation, subpopulation);
    }

    private int numElites(EvolutionState state, Population referencePop, int subpopulation) {
        if (this.elite[subpopulation] != NOT_SET) {
            if (this.elite[subpopulation] > referencePop.subpops.get((int)subpopulation).individuals.size()) {
                state.output.error("The number of elites for subpopulation " + subpopulation + " exceeds the actual size of the subpopulation");
            }
            return this.elite[subpopulation];
        }
        if (this.eliteFrac[subpopulation] == 0.0) {
            return 0;
        }
        if (this.eliteFrac[subpopulation] != (double)NOT_SET) {
            return (int)Math.max(Math.floor((double)referencePop.subpops.get((int)subpopulation).individuals.size() * this.eliteFrac[subpopulation]), 1.0);
        }
        state.output.warnOnce("Elitism error (SPEA2Breeder).  This shouldn't be able to happen.  Please report.");
        return 0;
    }

    @Override
    protected void loadElites(EvolutionState state, Population newpop) {
        assert (state != null);
        assert (newpop != null);
        if (this.breedingState == BreedingState.ARCHIVE_LOADED) {
            state.output.fatal("Tried to load elites for the next generation before breeding for the current generation was complete.");
        }
        for (int sub = 0; sub < state.population.subpops.size(); ++sub) {
            ArrayList<Individual> newInds = newpop.subpops.get((int)sub).individuals;
            ArrayList<Individual> oldInds = state.population.subpops.get((int)sub).individuals;
            this.computeAuxiliaryData(state, oldInds);
            this.buildArchive(state, oldInds, newInds, this.numElites(state, state.population, sub));
        }
        this.oldPopulation = state.population;
        state.population = state.population.emptyClone();
        for (int i = 0; i < newpop.subpops.size(); ++i) {
            Subpopulation subpop = state.population.subpops.get(i);
            Subpopulation newsubpop = newpop.subpops.get(i);
            for (int j = 0; j < newsubpop.individuals.size(); ++j) {
                subpop.individuals.add(j, (Individual)newsubpop.individuals.get(j).clone());
            }
        }
        this.breedingState = BreedingState.ARCHIVE_LOADED;
        this.unmarkElitesEvaluated(state, newpop);
    }

    @Override
    public void postProcess(EvolutionState state) {
        state.population = this.oldPopulation;
        this.oldPopulation = null;
    }

    public double[] calculateDistancesFromIndividual(Individual ind, ArrayList<Individual> inds) {
        double[] d = new double[inds.size()];
        for (int i = 0; i < inds.size(); ++i) {
            d[i] = ((SPEA2MultiObjectiveFitness)ind.fitness).sumSquaredObjectiveDistance((SPEA2MultiObjectiveFitness)inds.get((int)i).fitness, this.normalize);
        }
        Arrays.sort(d);
        return d;
    }

    private void buildArchive(EvolutionState state, ArrayList<Individual> oldInds, ArrayList<Individual> newInds, int archiveSize) {
        ArrayList<Individual> archive = new ArrayList<Individual>();
        ArrayList<Individual> nonFront = new ArrayList<Individual>();
        MultiObjectiveFitness.partitionIntoParetoFront(oldInds, archive, nonFront);
        if (archive.size() < archiveSize) {
            Collections.sort(nonFront);
            int len = archiveSize - archive.size();
            for (int i = 0; i < len; ++i) {
                archive.add(nonFront.get(i));
            }
        }
        while (archive.size() > archiveSize) {
            Individual closest = archive.get(0);
            int closestIndex = 0;
            double[] closestD = this.calculateDistancesFromIndividual(closest, archive);
            block2: for (int i = 1; i < archive.size(); ++i) {
                Individual competitor = archive.get(i);
                double[] competitorD = this.calculateDistancesFromIndividual(competitor, archive);
                for (int k = 0; k < archive.size(); ++k) {
                    if (closestD[i] > competitorD[i]) {
                        closest = competitor;
                        closestD = competitorD;
                        closestIndex = k;
                        continue block2;
                    }
                    if (closestD[i] < competitorD[i]) continue block2;
                }
            }
            archive.set(closestIndex, archive.get(archive.size() - 1));
            archive.remove(archive.size() - 1);
        }
        newInds.addAll(archive);
    }

    private void computeAuxiliaryData(EvolutionState state, ArrayList<Individual> inds) {
        double[][] distances = this.calculateDistances(state, inds);
        for (int y = 0; y < inds.size(); ++y) {
            int myStrength = 0;
            for (int z = 0; z < inds.size(); ++z) {
                if (!((SPEA2MultiObjectiveFitness)inds.get((int)y).fitness).paretoDominates((MultiObjectiveFitness)inds.get((int)z).fitness)) continue;
                ++myStrength;
            }
            ((SPEA2MultiObjectiveFitness)inds.get((int)y).fitness).strength = myStrength;
        }
        int kTH = this.k == NOT_SET ? (int)Math.sqrt(inds.size()) : this.k;
        for (int y = 0; y < inds.size(); ++y) {
            double fitness = 0.0;
            for (int z = 0; z < inds.size(); ++z) {
                if (!((SPEA2MultiObjectiveFitness)inds.get((int)z).fitness).paretoDominates((MultiObjectiveFitness)inds.get((int)y).fitness)) continue;
                fitness += ((SPEA2MultiObjectiveFitness)inds.get((int)z).fitness).strength;
            }
            SPEA2MultiObjectiveFitness indYFitness = (SPEA2MultiObjectiveFitness)inds.get((int)y).fitness;
            double kthDistance = Math.sqrt(this.orderStatistics(distances[y], kTH + 1, state.random[0]));
            indYFitness.kthNNDistance = 1.0 / (2.0 + kthDistance);
            indYFitness.fitness = fitness + indYFitness.kthNNDistance;
        }
    }

    private double[][] calculateDistances(EvolutionState state, ArrayList<Individual> inds) {
        double[][] distances = new double[inds.size()][inds.size()];
        for (int y = 0; y < inds.size(); ++y) {
            distances[y][y] = 0.0;
            for (int z = y + 1; z < inds.size(); ++z) {
                double d = ((SPEA2MultiObjectiveFitness)inds.get((int)y).fitness).sumSquaredObjectiveDistance((SPEA2MultiObjectiveFitness)inds.get((int)z).fitness, this.normalize);
                distances[y][z] = d;
                distances[z][y] = d;
            }
        }
        return distances;
    }

    private double orderStatistics(double[] array, int kth, MersenneTwisterFast rng) {
        return this.randomizedSelect(array, 0, array.length - 1, kth, rng);
    }

    private double randomizedSelect(double[] array, int p, int r, int i, MersenneTwisterFast rng) {
        if (p == r) {
            return array[p];
        }
        int q = this.randomizedPartition(array, p, r, rng);
        int k = q - p + 1;
        if (i <= k) {
            return this.randomizedSelect(array, p, q, i, rng);
        }
        return this.randomizedSelect(array, q + 1, r, i - k, rng);
    }

    private int randomizedPartition(double[] array, int p, int r, MersenneTwisterFast rng) {
        int i = rng.nextInt(r - p + 1) + p;
        double tmp = array[i];
        array[i] = array[p];
        array[p] = tmp;
        return this.partition(array, p, r);
    }

    private int partition(double[] array, int p, int r) {
        double x = array[p];
        int i = p - 1;
        int j = r + 1;
        while (true) {
            if (array[--j] > x) {
                continue;
            }
            while (array[++i] < x) {
            }
            if (i >= j) break;
            double tmp = array[i];
            array[i] = array[j];
            array[j] = tmp;
        }
        return j;
    }

    public static enum BreedingState {
        ARCHIVE_LOADED,
        BREEDING_COMPLETE;

    }
}

