/*
 * Decompiled with CFR 0.152.
 */
package ec.multiobjective.spea2;

import ec.EvolutionState;
import ec.Fitness;
import ec.multiobjective.MultiObjectiveFitness;
import ec.util.Code;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.LineNumberReader;

public class SPEA2MultiObjectiveFitness
extends MultiObjectiveFitness {
    private static final long serialVersionUID = 1L;
    public static final String SPEA2_FITNESS_PREAMBLE = "Fitness: ";
    public static final String SPEA2_STRENGTH_PREAMBLE = "Strength: ";
    public static final String SPEA2_DISTANCE_PREAMBLE = "Distance: ";
    public double strength;
    public double kthNNDistance;
    public double fitness;

    @Override
    public String[] getAuxilliaryFitnessNames() {
        return new String[]{"Strength", "Raw Fitness", "Kth NN Distance"};
    }

    @Override
    public double[] getAuxilliaryFitnessValues() {
        return new double[]{this.strength, this.fitness, this.kthNNDistance};
    }

    @Override
    public String fitnessToString() {
        return super.fitnessToString() + "\nFitness: " + Code.encode(this.fitness) + "\nStrength: " + Code.encode(this.strength) + "\nDistance: " + Code.encode(this.kthNNDistance);
    }

    @Override
    public String fitnessToStringForHumans() {
        return super.fitnessToStringForHumans() + "\nStrength: " + this.strength + "\nDistance: " + this.kthNNDistance + " Fitness: " + this.fitness;
    }

    @Override
    public void readFitness(EvolutionState state, LineNumberReader reader) throws IOException {
        super.readFitness(state, reader);
        this.fitness = Code.readDoubleWithPreamble(SPEA2_FITNESS_PREAMBLE, state, reader);
        this.strength = Code.readDoubleWithPreamble(SPEA2_STRENGTH_PREAMBLE, state, reader);
        this.kthNNDistance = Code.readDoubleWithPreamble(SPEA2_DISTANCE_PREAMBLE, state, reader);
    }

    @Override
    public void writeFitness(EvolutionState state, DataOutput dataOutput) throws IOException {
        super.writeFitness(state, dataOutput);
        dataOutput.writeDouble(this.fitness);
        dataOutput.writeDouble(this.strength);
        dataOutput.writeDouble(this.fitness);
        dataOutput.writeDouble(this.kthNNDistance);
        this.writeTrials(state, dataOutput);
    }

    @Override
    public void readFitness(EvolutionState state, DataInput dataInput) throws IOException {
        super.readFitness(state, dataInput);
        this.fitness = dataInput.readDouble();
        this.strength = dataInput.readDouble();
        this.fitness = dataInput.readDouble();
        this.kthNNDistance = dataInput.readDouble();
        this.readTrials(state, dataInput);
    }

    @Override
    public boolean equivalentTo(Fitness _fitness) {
        return this.fitness == ((SPEA2MultiObjectiveFitness)_fitness).fitness;
    }

    @Override
    public boolean betterThan(Fitness _fitness) {
        return this.fitness < ((SPEA2MultiObjectiveFitness)_fitness).fitness;
    }
}

