/*
 * Decompiled with CFR 0.152.
 */
package ec.neat;

import ec.EvolutionState;
import ec.neat.NEATDefaults;
import ec.neat.NEATNode;
import ec.util.Code;
import ec.util.DecodeReturn;
import ec.util.Parameter;
import ec.vector.Gene;
import java.text.DecimalFormat;

public class NEATGene
extends Gene {
    public static final String P_GENE = "gene";
    public double weight;
    public NEATNode inNode;
    public NEATNode outNode;
    public int inNodeId;
    public int outNodeId;
    public boolean isRecurrent;
    public boolean timeDelay;
    public int innovationNumber;
    public double mutationNumber;
    public boolean enable;
    public boolean frozen;

    @Override
    public void setup(EvolutionState state, Parameter base) {
        this.weight = 0.0;
        this.inNodeId = 0;
        this.outNodeId = 0;
        this.inNode = null;
        this.outNode = null;
        this.isRecurrent = false;
        this.innovationNumber = 0;
        this.mutationNumber = 0.0;
        this.timeDelay = false;
        this.enable = true;
        this.frozen = false;
    }

    @Override
    public Parameter defaultBase() {
        return NEATDefaults.base().push(P_GENE);
    }

    @Override
    public void reset(EvolutionState state, int thread) {
        this.frozen = false;
        this.timeDelay = false;
    }

    public void reset(double w, int iNodeId, int oNodeId, boolean recur, int innov, double mutNum) {
        this.weight = w;
        this.inNodeId = iNodeId;
        this.outNodeId = oNodeId;
        this.inNode = null;
        this.outNode = null;
        this.isRecurrent = recur;
        this.innovationNumber = innov;
        this.mutationNumber = mutNum;
        this.timeDelay = false;
        this.enable = true;
        this.frozen = false;
    }

    @Override
    public Object clone() {
        NEATGene myobj = (NEATGene)super.clone();
        myobj.weight = this.weight;
        myobj.isRecurrent = this.isRecurrent;
        myobj.inNodeId = this.inNodeId;
        myobj.outNodeId = this.outNodeId;
        myobj.innovationNumber = this.innovationNumber;
        myobj.mutationNumber = this.mutationNumber;
        myobj.enable = this.enable;
        myobj.frozen = this.frozen;
        myobj.timeDelay = this.timeDelay;
        return myobj;
    }

    @Override
    public String printGeneToStringForHumans() {
        return this.printGeneToString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String mask03 = " 0.00000000000000000;-0.00000000000000000";
        DecimalFormat fmt03 = new DecimalFormat(mask03);
        String mask5 = " 0000";
        DecimalFormat fmt5 = new DecimalFormat(mask5);
        stringBuffer.append("\n [Link (" + fmt5.format(this.inNode.nodeId));
        stringBuffer.append("," + fmt5.format(this.outNode.nodeId));
        stringBuffer.append("]  innov (" + fmt5.format(this.innovationNumber));
        stringBuffer.append(", mut=" + fmt03.format(this.mutationNumber) + ")");
        stringBuffer.append(" Weight " + fmt03.format(this.weight));
        if (!this.enable) {
            stringBuffer.append(" -DISABLED-");
        }
        if (this.isRecurrent) {
            stringBuffer.append(" -RECUR-");
        }
        return stringBuffer.toString();
    }

    @Override
    public String printGeneToString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Code.encode(this.inNode.nodeId));
        stringBuilder.append(Code.encode(this.outNode.nodeId));
        stringBuilder.append(Code.encode(this.weight));
        stringBuilder.append(Code.encode(this.isRecurrent));
        stringBuilder.append(Code.encode(this.innovationNumber));
        stringBuilder.append(Code.encode(this.mutationNumber));
        stringBuilder.append(Code.encode(this.enable));
        return stringBuilder.toString();
    }

    @Override
    public void readGeneFromString(String string, EvolutionState state) {
        DecodeReturn dr = new DecodeReturn(string);
        Code.decode(dr);
        this.inNodeId = (int)dr.l;
        Code.decode(dr);
        this.outNodeId = (int)dr.l;
        Code.decode(dr);
        this.weight = dr.d;
        Code.decode(dr);
        this.isRecurrent = dr.l == 1L;
        Code.decode(dr);
        this.innovationNumber = (int)dr.l;
        Code.decode(dr);
        this.mutationNumber = dr.d;
        Code.decode(dr);
        this.enable = dr.l == 1L;
    }

    @Override
    public int hashCode() {
        int hash = this.innovationNumber;
        hash = hash * 31 + 17 + this.inNodeId;
        hash = hash * 31 + 17 + this.outNodeId;
        hash = hash * 31 + 17 + Float.floatToIntBits((float)this.weight);
        hash = hash * 31 + 17 + Float.floatToIntBits((float)this.mutationNumber);
        if (this.enable) {
            hash = hash * 31 + 17;
        }
        if (this.isRecurrent) {
            hash = hash * 31 + 13;
        }
        return hash;
    }

    @Override
    public boolean equals(Object o) {
        NEATGene g = (NEATGene)o;
        if (this.inNodeId != g.inNodeId) {
            return false;
        }
        if (this.outNodeId != g.outNodeId) {
            return false;
        }
        if (this.weight != g.weight) {
            return false;
        }
        if (this.isRecurrent != g.isRecurrent) {
            return false;
        }
        if (this.innovationNumber != g.innovationNumber) {
            return false;
        }
        if (this.mutationNumber != g.mutationNumber) {
            return false;
        }
        return this.enable == g.enable;
    }
}

