/*
 * Decompiled with CFR 0.152.
 */
package ec.neat;

import ec.EvolutionState;
import ec.Individual;
import ec.neat.NEATDefaults;
import ec.neat.NEATGene;
import ec.neat.NEATIndividual;
import ec.neat.NEATInnovation;
import ec.neat.NEATNetwork;
import ec.neat.NEATNode;
import ec.neat.NEATSubspecies;
import ec.util.Parameter;
import ec.vector.Gene;
import ec.vector.GeneVectorSpecies;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;

public class NEATSpecies
extends GeneVectorSpecies {
    public static final String P_SPECIES = "species";
    public static final String P_NODE = "node";
    public static final String P_NETWORK = "network";
    public static final String P_SUBSPECIES = "subspecies";
    public static final String P_INNOVATION = "innovation";
    public static final String P_WEIGHT_MUT_POWER = "weight-mut-power";
    public static final String P_DISJOINT_COEFF = "disjoint-coeff";
    public static final String P_EXCESS_COEFF = "excess-coeff";
    public static final String P_MUT_DIFF_COEFF = "mutdiff-coeff";
    public static final String P_COMPAT_THRESH = "compat-thresh";
    public static final String P_AGE_SIGNIFICANCE = "age-significance";
    public static final String P_SURVIVIAL_THRESH = "survival-thresh";
    public static final String P_MUTATE_ONLY_PROB = "mutate-only-prob";
    public static final String P_MUTATE_LINK_WEIGHT_PROB = "mutate-link-weight-prob";
    public static final String P_MUTATE_TOGGLE_ENABLE_PROB = "mutate-toggle-enable-prob";
    public static final String P_MUTATE_GENE_REENABLE_PROB = "mutate-gene-reenable-prob";
    public static final String P_MUTATE_ADD_NODE_PROB = "mutate-add-node-prob";
    public static final String P_MUTATE_ADD_LINK_PROB = "mutate-add-link-prob";
    public static final String P_INTERSPECIES_MATE_PROB = "interspecies-mate-prob";
    public static final String P_MATE_MULTIPOINT_PROB = "mate-multipoint-prob";
    public static final String P_MATE_MULTIPOINT_AVG_PROB = "mate-multipoint-avg-prob";
    public static final String P_MATE_SINGLE_POINT_PROB = "mate-singlepoint-prob";
    public static final String P_MATE_ONLY_PROB = "mate-only-prob";
    public static final String P_RECUR_ONLY_PROB = "recur-only-prob";
    public static final String P_DROPOFF_AGE = "dropoff-age";
    public static final String P_NEW_LINK_TRIES = "new-link-tries";
    public static final String P_NEW_NODE_TRIES = "new-node-tries";
    public static final String P_BABIES_STOLEN = "babies-stolen";
    public static final String P_MAX_NETWORK_DEPTH = "max-network-depth";
    public static final String P_ADD_NODE_MAX_GENOME_LENGTH = "add-node-max-genome-length";
    public NEATNode nodePrototype;
    public NEATNetwork networkPrototype;
    public NEATSubspecies subspeciesPrototype;
    public NEATInnovation innovationPrototype;
    public int currNodeId;
    private int currInnovNum;
    public double highestFitness;
    public int highestLastChanged;
    public double weightMutationPower;
    public double disjointCoeff;
    public double excessCoeff;
    public double mutDiffCoeff;
    public double compatThreshold;
    public double ageSignificance;
    public double survivalThreshold;
    public double mutateOnlyProb;
    public double mutateLinkWeightsProb;
    public double mutateToggleEnableProb;
    public double mutateGeneReenableProb;
    public double mutateAddNodeProb;
    public double mutateAddLinkProb;
    public double interspeciesMateRate;
    public double mateMultipointProb;
    public double mateMultipointAvgProb;
    public double mateSinglepointProb;
    public double mateOnlyProb;
    public double recurOnlyProb;
    public int dropoffAge;
    public int newLinkTries;
    public int newNodeTries;
    public int babiesStolen;
    public int maxNetworkDepth;
    public int addNodeMaxGenomeLength;
    public Parameter base;
    public ArrayList<NEATSubspecies> subspecies;
    public HashMap<NEATInnovation, NEATInnovation> innovations;
    private Object innoLock = new Object[0];

    @Override
    public void setup(EvolutionState state, Parameter base) {
        Parameter def = this.defaultBase();
        this.nodePrototype = (NEATNode)state.parameters.getInstanceForParameterEq(base.push(P_NODE), def.push(P_NODE), NEATNode.class);
        this.nodePrototype.setup(state, base.push(P_NODE));
        this.subspeciesPrototype = (NEATSubspecies)state.parameters.getInstanceForParameterEq(base.push(P_SUBSPECIES), def.push(P_SUBSPECIES), NEATSubspecies.class);
        this.subspeciesPrototype.setup(state, base.push(P_SUBSPECIES));
        this.innovationPrototype = (NEATInnovation)state.parameters.getInstanceForParameterEq(base.push(P_INNOVATION), def.push(P_INNOVATION), NEATInnovation.class);
        this.subspeciesPrototype.setup(state, base.push(P_INNOVATION));
        this.networkPrototype = (NEATNetwork)state.parameters.getInstanceForParameterEq(base.push(P_NETWORK), def.push(P_NETWORK), NEATNetwork.class);
        this.networkPrototype.setup(state, base.push(P_NETWORK));
        super.setup(state, base);
        this.subspecies = new ArrayList();
        this.innovations = new HashMap();
        this.highestFitness = 0.0;
        this.highestLastChanged = 0;
        this.weightMutationPower = state.parameters.getDouble(base.push(P_WEIGHT_MUT_POWER), def.push(P_WEIGHT_MUT_POWER), 2.5);
        this.disjointCoeff = state.parameters.getDouble(base.push(P_DISJOINT_COEFF), def.push(P_DISJOINT_COEFF), 1.0);
        this.excessCoeff = state.parameters.getDouble(base.push(P_EXCESS_COEFF), def.push(P_EXCESS_COEFF), 1.0);
        this.mutDiffCoeff = state.parameters.getDouble(base.push(P_MUT_DIFF_COEFF), def.push(P_MUT_DIFF_COEFF), 0.4);
        this.compatThreshold = state.parameters.getDouble(base.push(P_COMPAT_THRESH), def.push(P_COMPAT_THRESH), 3.0);
        this.ageSignificance = state.parameters.getDouble(base.push(P_AGE_SIGNIFICANCE), def.push(P_AGE_SIGNIFICANCE), 1.0);
        this.survivalThreshold = state.parameters.getDouble(base.push(P_SURVIVIAL_THRESH), def.push(P_SURVIVIAL_THRESH));
        this.mutateOnlyProb = this.boundProbabilityParameter(state, base, P_MUTATE_ONLY_PROB, "Mutate only probability");
        this.mutateLinkWeightsProb = this.boundProbabilityParameter(state, base, P_MUTATE_LINK_WEIGHT_PROB, "Mutate Link Weight probability");
        this.mutateToggleEnableProb = this.boundProbabilityParameter(state, base, P_MUTATE_TOGGLE_ENABLE_PROB, "Mutate Toggle Enable probability");
        this.mutateGeneReenableProb = this.boundProbabilityParameter(state, base, P_MUTATE_GENE_REENABLE_PROB, "Mutate Gene Reenable");
        this.mutateAddNodeProb = this.boundProbabilityParameter(state, base, P_MUTATE_ADD_NODE_PROB, "Mutate Add Node probability");
        this.mutateAddLinkProb = this.boundProbabilityParameter(state, base, P_MUTATE_ADD_LINK_PROB, "Mutate Add Link probability");
        this.interspeciesMateRate = this.boundProbabilityParameter(state, base, P_INTERSPECIES_MATE_PROB, "Interspecies Mate probability");
        this.mateMultipointProb = this.boundProbabilityParameter(state, base, P_MATE_MULTIPOINT_PROB, "Mate Multipoint probability");
        this.mateMultipointAvgProb = this.boundProbabilityParameter(state, base, P_MATE_MULTIPOINT_AVG_PROB, "Mate Multipoint Average probability");
        this.mateSinglepointProb = this.boundProbabilityParameter(state, base, P_MATE_SINGLE_POINT_PROB, "Single Point probability");
        this.mateOnlyProb = this.boundProbabilityParameter(state, base, P_MATE_ONLY_PROB, "Mate Only probability");
        this.recurOnlyProb = this.boundProbabilityParameter(state, base, P_RECUR_ONLY_PROB, "Recurrent Only probability");
        this.dropoffAge = state.parameters.getInt(base.push(P_DROPOFF_AGE), def.push(P_DROPOFF_AGE), 0);
        this.newLinkTries = state.parameters.getInt(base.push(P_NEW_LINK_TRIES), def.push(P_NEW_LINK_TRIES), 1);
        this.newNodeTries = state.parameters.getInt(base.push(P_NEW_NODE_TRIES), def.push(P_NEW_NODE_TRIES), 1);
        this.babiesStolen = state.parameters.getInt(base.push(P_BABIES_STOLEN), def.push(P_BABIES_STOLEN), 0);
        this.maxNetworkDepth = state.parameters.getInt(base.push(P_MAX_NETWORK_DEPTH), base.push(P_MAX_NETWORK_DEPTH), 30);
        this.addNodeMaxGenomeLength = state.parameters.getInt(base.push(P_ADD_NODE_MAX_GENOME_LENGTH), base.push(P_ADD_NODE_MAX_GENOME_LENGTH), 15);
    }

    double boundProbabilityParameter(EvolutionState state, Parameter base, String param, String description) {
        Parameter def = this.defaultBase();
        double probability = state.parameters.getDoubleWithMax(base.push(param), def.push(param), 0.0, 1.0);
        if (probability < 0.0) {
            state.output.fatal(description + " is a probability, and must be a value between 0.0 and 1.0.");
        }
        return probability;
    }

    @Override
    public Parameter defaultBase() {
        return NEATDefaults.base().push(P_SPECIES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int nextInnovationNumber() {
        Object object = this.innoLock;
        synchronized (object) {
            return this.currInnovNum++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInnovationNumber(int num) {
        Object object = this.innoLock;
        synchronized (object) {
            this.currInnovNum = num;
        }
    }

    public void speciate(EvolutionState state, Individual ind) {
        NEATIndividual neatInd = (NEATIndividual)ind;
        if (this.subspecies.size() == 0) {
            NEATSubspecies newSubspecies = (NEATSubspecies)this.subspeciesPrototype.emptyClone();
            newSubspecies.reset();
            this.subspecies.add(newSubspecies);
            newSubspecies.addNewGenIndividual(neatInd);
        } else {
            boolean found = false;
            for (int i = 0; i < this.subspecies.size(); ++i) {
                NEATIndividual represent = (NEATIndividual)this.subspecies.get(i).newGenerationFirst();
                if (represent == null) {
                    represent = (NEATIndividual)this.subspecies.get(i).first();
                }
                if (!(this.compatibility(neatInd, represent) < this.compatThreshold)) continue;
                this.subspecies.get(i).addNewGenIndividual(neatInd);
                found = true;
                break;
            }
            if (!found) {
                NEATSubspecies newSubspecies = (NEATSubspecies)this.subspeciesPrototype.emptyClone();
                newSubspecies.reset();
                this.subspecies.add(newSubspecies);
                newSubspecies.addNewGenIndividual(neatInd);
            }
        }
    }

    public NEATIndividual spawnWithTemplate(EvolutionState state, NEATSpecies species, int thread, NEATIndividual ind) {
        NEATIndividual newInd = (NEATIndividual)ind.clone();
        newInd.mutateLinkWeights(state, thread, species, 1.0, 1.0, MutationType.GAUSSIAN);
        newInd.setGeneration(state);
        newInd.createNetwork();
        return newInd;
    }

    public double compatibility(NEATIndividual a, NEATIndividual b) {
        int numExcess = 0;
        int numMatching = 0;
        int numDisjoint = 0;
        double mutTotalDiff = 0.0;
        int i = 0;
        int j = 0;
        while (i != a.genome.length || j != b.genome.length) {
            if (i == a.genome.length) {
                ++j;
                ++numExcess;
                continue;
            }
            if (j == b.genome.length) {
                ++i;
                ++numExcess;
                continue;
            }
            int aInno = ((NEATGene)a.genome[i]).innovationNumber;
            int bInno = ((NEATGene)b.genome[j]).innovationNumber;
            if (aInno == bInno) {
                ++numMatching;
                double mutDiff = Math.abs(((NEATGene)a.genome[i]).mutationNumber - ((NEATGene)b.genome[j]).mutationNumber);
                mutTotalDiff += mutDiff;
                ++i;
                ++j;
                continue;
            }
            if (aInno < bInno) {
                ++i;
                ++numDisjoint;
                continue;
            }
            if (bInno >= aInno) continue;
            ++j;
            ++numDisjoint;
        }
        double compatibility = this.disjointCoeff * ((double)numDisjoint / 1.0);
        compatibility += this.excessCoeff * ((double)numExcess / 1.0);
        return compatibility += this.mutDiffCoeff * (mutTotalDiff / (double)numMatching);
    }

    public void countOffspring(EvolutionState state, int subpop) {
        double total = 0.0;
        ArrayList<Individual> inds = state.population.subpops.get((int)subpop).individuals;
        for (int i = 0; i < inds.size(); ++i) {
            total += ((NEATIndividual)inds.get((int)i)).adjustedFitness;
        }
        double overallAverage = total / (double)inds.size();
        for (int i = 0; i < inds.size(); ++i) {
            ((NEATIndividual)inds.get((int)i)).expectedOffspring = ((NEATIndividual)inds.get((int)i)).adjustedFitness / overallAverage;
        }
        double skim = 0.0;
        int totalExpected = 0;
        for (int i = 0; i < this.subspecies.size(); ++i) {
            NEATSubspecies subs = this.subspecies.get(i);
            skim = subs.countOffspring(skim);
            totalExpected += subs.expectedOffspring;
        }
        if (totalExpected < inds.size()) {
            int i;
            int maxExpected = 0;
            int finalExpected = 0;
            NEATSubspecies best = null;
            for (i = 0; i < this.subspecies.size(); ++i) {
                if (this.subspecies.get((int)i).expectedOffspring >= maxExpected) {
                    maxExpected = this.subspecies.get((int)i).expectedOffspring;
                    best = this.subspecies.get(i);
                }
                finalExpected += this.subspecies.get((int)i).expectedOffspring;
            }
            ++best.expectedOffspring;
            if (++finalExpected < inds.size()) {
                state.output.warnOnce("Population has died");
                for (i = 0; i < this.subspecies.size(); ++i) {
                    this.subspecies.get((int)i).expectedOffspring = 0;
                }
                best.expectedOffspring = inds.size();
            }
        }
    }

    public void breedNewPopulation(EvolutionState state, int subpop, int thread) {
        NEATSubspecies subs;
        int i;
        ArrayList<Individual> inds = state.population.subpops.get((int)subpop).individuals;
        this.clearEvaluationFlag(inds);
        this.innovations.clear();
        for (int i2 = 0; i2 < this.subspecies.size(); ++i2) {
            this.subspecies.get(i2).adjustFitness(state, this.dropoffAge, this.ageSignificance);
            this.subspecies.get(i2).sortIndividuals();
            this.subspecies.get(i2).updateSubspeciesMaxFitness();
            this.subspecies.get(i2).markReproducableIndividuals(this.survivalThreshold);
        }
        this.countOffspring(state, subpop);
        ArrayList<NEATSubspecies> sortedSubspecies = new ArrayList<NEATSubspecies>(this.subspecies);
        Collections.sort(sortedSubspecies, new Comparator<NEATSubspecies>(this){

            @Override
            public int compare(NEATSubspecies o1, NEATSubspecies o2) {
                NEATIndividual ind1 = (NEATIndividual)o1.individuals.get(0);
                NEATIndividual ind2 = (NEATIndividual)o2.individuals.get(0);
                if (ind1.fitness.fitness() < ind2.fitness.fitness()) {
                    return 1;
                }
                if (ind1.fitness.fitness() > ind2.fitness.fitness()) {
                    return -1;
                }
                return 0;
            }
        });
        this.populationStagnation(state, subpop, sortedSubspecies);
        if (this.highestLastChanged >= this.dropoffAge + 5) {
            this.deltaCoding(state, subpop, sortedSubspecies);
        } else if (this.babiesStolen > 0) {
            this.stealBabies(state, thread, subpop, sortedSubspecies);
        }
        for (i = 0; i < sortedSubspecies.size(); ++i) {
            sortedSubspecies.get(i).removePoorFitnessIndividuals();
        }
        for (i = 0; i < sortedSubspecies.size(); ++i) {
            subs = sortedSubspecies.get(i);
            subs.newGenIndividuals.clear();
        }
        for (i = 0; i < sortedSubspecies.size(); ++i) {
            subs = sortedSubspecies.get(i);
            subs.reproduce(state, thread, subpop, sortedSubspecies);
        }
        for (i = 0; i < sortedSubspecies.size(); ++i) {
            subs = sortedSubspecies.get(i);
            ++subs.age;
        }
        ArrayList<NEATSubspecies> remainSubspecies = new ArrayList<NEATSubspecies>();
        ArrayList<Individual> newGenIndividuals = new ArrayList<Individual>();
        for (int i3 = 0; i3 < this.subspecies.size(); ++i3) {
            if (!this.subspecies.get(i3).hasNewGeneration()) continue;
            remainSubspecies.add(this.subspecies.get(i3));
            this.subspecies.get(i3).toNewGeneration();
            newGenIndividuals.addAll(this.subspecies.get((int)i3).individuals);
        }
        this.subspecies = remainSubspecies;
        state.population.subpops.get((int)subpop).individuals = newGenIndividuals;
    }

    public void deltaCoding(EvolutionState state, int subpop, ArrayList<NEATSubspecies> sortedSubspecies) {
        this.highestLastChanged = 0;
        int popSize = state.population.subpops.get((int)subpop).initialSize;
        int halfPop = popSize / 2;
        NEATSubspecies bestFitnessSubspecies = sortedSubspecies.get(0);
        ((NEATIndividual)bestFitnessSubspecies.first()).superChampionOffspring = halfPop;
        bestFitnessSubspecies.expectedOffspring = halfPop;
        bestFitnessSubspecies.ageOfLastImprovement = bestFitnessSubspecies.age;
        if (sortedSubspecies.size() >= 2) {
            ((NEATIndividual)sortedSubspecies.get((int)1).first()).superChampionOffspring = popSize - halfPop;
            sortedSubspecies.get((int)1).expectedOffspring = popSize - halfPop;
            sortedSubspecies.get((int)1).ageOfLastImprovement = sortedSubspecies.get((int)1).age;
            for (int i = 2; i < sortedSubspecies.size(); ++i) {
                sortedSubspecies.get((int)i).expectedOffspring = 0;
            }
        } else {
            ((NEATIndividual)bestFitnessSubspecies.first()).superChampionOffspring += popSize - halfPop;
            bestFitnessSubspecies.expectedOffspring = popSize - halfPop;
        }
    }

    public void populationStagnation(EvolutionState state, int subpop, ArrayList<NEATSubspecies> sortedSubspecies) {
        NEATIndividual bestFitnessIndividual = (NEATIndividual)sortedSubspecies.get((int)0).individuals.get(0);
        bestFitnessIndividual.popChampion = true;
        if (bestFitnessIndividual.fitness.fitness() > this.highestFitness) {
            this.highestFitness = bestFitnessIndividual.fitness.fitness();
            this.highestLastChanged = 0;
        } else {
            ++this.highestLastChanged;
        }
    }

    public void stealBabies(EvolutionState state, int thread, int subpop, ArrayList<NEATSubspecies> sortedSubspecies) {
        NEATSubspecies subs;
        int babiesAlreadyStolen = 0;
        for (int i = sortedSubspecies.size() - 1; i >= 0 && babiesAlreadyStolen < this.babiesStolen; --i) {
            NEATSubspecies subs2 = sortedSubspecies.get(i);
            if (subs2.age <= 5 || subs2.expectedOffspring <= 2) continue;
            int babiesNeeded = this.babiesStolen - babiesAlreadyStolen;
            if (subs2.expectedOffspring - 1 >= babiesNeeded) {
                subs2.expectedOffspring -= babiesNeeded;
                babiesAlreadyStolen = this.babiesStolen;
                continue;
            }
            babiesAlreadyStolen += subs2.expectedOffspring - 1;
            subs2.expectedOffspring = 1;
        }
        int[] quote = new int[3];
        quote[0] = quote[1] = this.babiesStolen / 5;
        quote[2] = this.babiesStolen / 10;
        boolean done = false;
        int quoteIndex = 0;
        Iterator<NEATSubspecies> iterator = sortedSubspecies.iterator();
        while (!done && iterator.hasNext()) {
            subs = iterator.next();
            if (subs.timeSinceLastImproved() > this.dropoffAge) continue;
            if (quoteIndex < quote.length) {
                if (babiesAlreadyStolen > quote[quoteIndex]) {
                    ((NEATIndividual)subs.first()).superChampionOffspring = quote[quoteIndex];
                    subs.expectedOffspring += quote[quoteIndex];
                    babiesAlreadyStolen -= quote[quoteIndex];
                }
                ++quoteIndex;
            } else if (quoteIndex >= quote.length && state.random[thread].nextBoolean(0.9)) {
                if (babiesAlreadyStolen > 3) {
                    ((NEATIndividual)subs.first()).superChampionOffspring = 3;
                    subs.expectedOffspring += 3;
                    babiesAlreadyStolen -= 3;
                } else {
                    ((NEATIndividual)subs.first()).superChampionOffspring = babiesAlreadyStolen;
                    subs.expectedOffspring += babiesAlreadyStolen;
                    babiesAlreadyStolen = 0;
                }
            }
            if (babiesAlreadyStolen != 0) continue;
            done = true;
        }
        if (babiesAlreadyStolen > 0) {
            state.output.message("Not all stolen babies assigned, giving to the best subspecies");
            subs = this.subspecies.get(0);
            ((NEATIndividual)subs.first()).superChampionOffspring += babiesAlreadyStolen;
            subs.expectedOffspring += babiesAlreadyStolen;
            babiesAlreadyStolen = 0;
        }
    }

    public Individual newIndividual(EvolutionState state, int thread, ArrayList<NEATNode> nodes, ArrayList<Gene> genes) {
        NEATIndividual newind = (NEATIndividual)super.newIndividual(state, thread);
        newind.reset(nodes, genes);
        return newind;
    }

    public boolean hasInnovation(NEATInnovation inno) {
        return this.innovations.containsKey(inno);
    }

    public NEATInnovation getInnovation(NEATInnovation inno) {
        return this.innovations.get(inno);
    }

    public void addInnovation(NEATInnovation inno) {
        this.innovations.put(inno, inno);
    }

    public void clearEvaluationFlag(ArrayList<Individual> individuals) {
        for (int i = 0; i < individuals.size(); ++i) {
            individuals.get((int)i).evaluated = false;
        }
    }

    public static enum MutationType {
        GAUSSIAN,
        COLDGAUSSIAN;

    }
}

