/*
 * Decompiled with CFR 0.152.
 */
package ec.neat;

import ec.EvolutionState;
import ec.Individual;
import ec.Prototype;
import ec.neat.NEATDefaults;
import ec.neat.NEATIndividual;
import ec.neat.NEATSpecies;
import ec.util.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class NEATSubspecies
implements Prototype {
    public static final String P_SUBSPECIES = "subspecies";
    public int age;
    public int ageOfLastImprovement;
    public double maxFitnessEver;
    public ArrayList<Individual> individuals;
    public ArrayList<Individual> newGenIndividuals;
    public int expectedOffspring;

    @Override
    public void setup(EvolutionState state, Parameter base) {
        this.age = 1;
        this.ageOfLastImprovement = 0;
        this.maxFitnessEver = 0.0;
        this.individuals = new ArrayList();
        this.newGenIndividuals = new ArrayList();
    }

    public Object emptyClone() {
        NEATSubspecies myobj = (NEATSubspecies)this.clone();
        this.individuals = new ArrayList();
        this.newGenIndividuals = new ArrayList();
        return myobj;
    }

    @Override
    public Object clone() {
        NEATSubspecies myobj = null;
        try {
            myobj = (NEATSubspecies)super.clone();
            myobj.age = this.age;
            myobj.ageOfLastImprovement = this.ageOfLastImprovement;
            myobj.maxFitnessEver = this.maxFitnessEver;
            myobj.expectedOffspring = this.expectedOffspring;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        return myobj;
    }

    public void reset() {
        this.age = 1;
        this.expectedOffspring = 0;
        this.ageOfLastImprovement = 0;
        this.maxFitnessEver = 0.0;
    }

    public Individual first() {
        if (this.individuals.size() > 0) {
            return this.individuals.get(0);
        }
        return null;
    }

    public Individual newGenerationFirst() {
        if (this.newGenIndividuals.size() > 0) {
            return this.newGenIndividuals.get(0);
        }
        return null;
    }

    @Override
    public Parameter defaultBase() {
        return NEATDefaults.base().push(P_SUBSPECIES);
    }

    public void adjustFitness(EvolutionState state, int dropoffAge, double ageSignificance) {
        int ageDebt = this.age - this.ageOfLastImprovement + 1 - dropoffAge;
        if (ageDebt == 0) {
            ageDebt = 1;
        }
        for (int i = 0; i < this.individuals.size(); ++i) {
            NEATIndividual ind = (NEATIndividual)this.individuals.get(i);
            ind.adjustedFitness = ind.fitness.fitness();
            if (ageDebt >= 1) {
                ind.adjustedFitness *= 0.01;
            }
            if (this.age <= 10) {
                ind.adjustedFitness *= ageSignificance;
            }
            if (ind.adjustedFitness < 0.0) {
                ind.adjustedFitness = 1.0E-4;
            }
            ind.adjustedFitness /= (double)this.individuals.size();
        }
    }

    public void sortIndividuals() {
        Collections.sort(this.individuals, new Comparator<Individual>(this){

            @Override
            public int compare(Individual i1, Individual i2) {
                NEATIndividual ind1 = (NEATIndividual)i1;
                NEATIndividual ind2 = (NEATIndividual)i2;
                if (ind1.adjustedFitness < ind2.adjustedFitness) {
                    return 1;
                }
                if (ind1.adjustedFitness > ind2.adjustedFitness) {
                    return -1;
                }
                return 0;
            }
        });
    }

    public void updateSubspeciesMaxFitness() {
        if (this.individuals.get((int)0).fitness.fitness() > this.maxFitnessEver) {
            this.ageOfLastImprovement = this.age;
            this.maxFitnessEver = this.individuals.get((int)0).fitness.fitness();
        }
    }

    public void markReproducableIndividuals(double survivalThreshold) {
        int numParents = (int)Math.floor(survivalThreshold * (double)this.individuals.size() + 1.0);
        ((NEATIndividual)this.first()).champion = true;
        for (int i = 0; i < this.individuals.size(); ++i) {
            NEATIndividual ind = (NEATIndividual)this.individuals.get(i);
            if (i < numParents) continue;
            ind.eliminate = true;
        }
    }

    public boolean hasNewGeneration() {
        return !this.newGenIndividuals.isEmpty();
    }

    public double countOffspring(double skim) {
        this.expectedOffspring = 0;
        double x1 = 0.0;
        double y1 = 1.0;
        double r1 = 0.0;
        double r2 = skim;
        int n1 = 0;
        int n2 = 0;
        for (int i = 0; i < this.individuals.size(); ++i) {
            x1 = ((NEATIndividual)this.individuals.get((int)i)).expectedOffspring;
            n1 = (int)(x1 / y1);
            r1 = x1 - (double)((int)(x1 / y1)) * y1;
            n2 += n1;
            if (!((r2 += r1) >= 1.0)) continue;
            ++n2;
            r2 -= 1.0;
        }
        this.expectedOffspring = n2;
        return r2;
    }

    public boolean reproduce(EvolutionState state, int thread, int subpop, ArrayList<NEATSubspecies> sortedSubspecies) {
        if (this.expectedOffspring > 0 && this.individuals.size() == 0) {
            state.output.fatal("Attempt to reproduce out of empty subspecies");
            return false;
        }
        if (this.expectedOffspring > state.population.subpops.get((int)subpop).initialSize) {
            state.output.fatal("Attempt to reproduce too many individuals");
            return false;
        }
        NEATSpecies species = (NEATSpecies)state.population.subpops.get((int)subpop).species;
        NEATIndividual bestIndividual = (NEATIndividual)this.first();
        boolean bestIndividualDone = false;
        for (int i = 0; i < this.expectedOffspring; ++i) {
            NEATIndividual newInd = null;
            if (bestIndividual.superChampionOffspring > 0) {
                newInd = (NEATIndividual)bestIndividual.clone();
                if (bestIndividual.superChampionOffspring > 1) {
                    if (state.random[thread].nextBoolean(0.8) || species.mutateAddLinkProb == 0.0) {
                        newInd.mutateLinkWeights(state, thread, species, species.weightMutationPower, 1.0, NEATSpecies.MutationType.GAUSSIAN);
                    } else {
                        newInd.createNetwork();
                        newInd.mutateAddLink(state, thread);
                    }
                }
                if (bestIndividual.superChampionOffspring == 1 && bestIndividual.popChampion) {
                    newInd.popChampionChild = true;
                    newInd.highFit = bestIndividual.fitness.fitness();
                }
                --bestIndividual.superChampionOffspring;
            } else if (!bestIndividualDone && this.expectedOffspring > 5) {
                newInd = (NEATIndividual)bestIndividual.clone();
                bestIndividualDone = true;
            } else if (state.random[thread].nextBoolean(species.mutateOnlyProb) || this.individuals.size() == 1) {
                parentIndex = state.random[thread].nextInt(this.individuals.size());
                Individual parent = this.individuals.get(parentIndex);
                newInd = (NEATIndividual)parent.clone();
                newInd.defaultMutate(state, thread);
            } else {
                parentIndex = state.random[thread].nextInt(this.individuals.size());
                NEATIndividual firstParent = (NEATIndividual)this.individuals.get(parentIndex);
                NEATIndividual secondParent = null;
                if (state.random[thread].nextBoolean(1.0 - species.interspeciesMateRate)) {
                    parentIndex = state.random[thread].nextInt(this.individuals.size());
                    secondParent = (NEATIndividual)this.individuals.get(parentIndex);
                } else {
                    NEATSubspecies randomSubspecies = this;
                    for (int giveUp = 0; randomSubspecies == this && giveUp < 5; ++giveUp) {
                        int index;
                        double value = state.random[thread].nextGaussian() / 4.0;
                        if (value > 1.0) {
                            value = 1.0;
                        }
                        int upperBound = (int)Math.floor(value * ((double)sortedSubspecies.size() - 1.0) + 0.5);
                        for (index = 0; index < upperBound; ++index) {
                        }
                        randomSubspecies = sortedSubspecies.get(index);
                    }
                    secondParent = (NEATIndividual)randomSubspecies.first();
                }
                newInd = firstParent.crossover(state, thread, secondParent);
                if (state.random[thread].nextBoolean(1.0 - species.mateOnlyProb) || firstParent == secondParent || species.compatibility(firstParent, secondParent) == 0.0) {
                    newInd.defaultMutate(state, thread);
                }
            }
            newInd.setGeneration(state);
            newInd.createNetwork();
            species.speciate(state, newInd);
        }
        return true;
    }

    public int timeSinceLastImproved() {
        return this.age - this.ageOfLastImprovement;
    }

    public void addNewGenIndividual(NEATIndividual neatInd) {
        this.newGenIndividuals.add(neatInd);
        neatInd.subspecies = this;
    }

    public void removePoorFitnessIndividuals() {
        ArrayList<NEATIndividual> remainIndividuals = new ArrayList<NEATIndividual>();
        for (int i = 0; i < this.individuals.size(); ++i) {
            NEATIndividual ind = (NEATIndividual)this.individuals.get(i);
            if (ind.eliminate) continue;
            remainIndividuals.add(ind);
        }
        this.individuals = remainIndividuals;
    }

    public void toNewGeneration() {
        this.individuals = this.newGenIndividuals;
        this.newGenIndividuals = new ArrayList();
    }
}

