/*
 * Decompiled with CFR 0.152.
 */
package ec.pso;

import ec.EvolutionState;
import ec.Fitness;
import ec.pso.PSOBreeder;
import ec.util.Code;
import ec.util.DecodeReturn;
import ec.util.MersenneTwisterFast;
import ec.util.Parameter;
import ec.vector.DoubleVectorIndividual;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.HashSet;

public class Particle
extends DoubleVectorIndividual {
    public static final String AUXILLARY_PREAMBLE = "Auxillary: ";
    public double[] velocity;
    public int[] neighborhood = null;
    public double[] neighborhoodBestGenome = null;
    public Fitness neighborhoodBestFitness = null;
    public double[] personalBestGenome = null;
    public Fitness personalBestFitness = null;

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object ind) {
        int j;
        if (!super.equals(ind)) {
            return false;
        }
        Particle i = (Particle)ind;
        if (this.velocity == null && i.velocity != null || this.velocity != null && i.velocity == null) {
            return false;
        }
        if (this.velocity != null) {
            if (this.velocity.length != i.velocity.length) {
                return false;
            }
            for (j = 0; j < this.velocity.length; ++j) {
                if (this.velocity[j] == i.velocity[j]) continue;
                return false;
            }
        }
        if (this.neighborhood == null && i.neighborhood != null || this.neighborhood != null && i.neighborhood == null) {
            return false;
        }
        if (this.neighborhood != null) {
            if (this.neighborhood.length != i.neighborhood.length) {
                return false;
            }
            for (j = 0; j < this.neighborhood.length; ++j) {
                if (this.neighborhood[j] == i.neighborhood[j]) continue;
                return false;
            }
        }
        if (this.neighborhoodBestGenome == null && i.neighborhoodBestGenome != null || this.neighborhoodBestGenome != null && i.neighborhoodBestGenome == null) {
            return false;
        }
        if (this.neighborhoodBestGenome != null) {
            if (this.neighborhoodBestGenome.length != i.neighborhoodBestGenome.length) {
                return false;
            }
            for (j = 0; j < this.neighborhoodBestGenome.length; ++j) {
                if (this.neighborhoodBestGenome[j] == i.neighborhoodBestGenome[j]) continue;
                return false;
            }
        }
        if (this.neighborhoodBestFitness == null && i.neighborhoodBestFitness != null || this.neighborhoodBestFitness != null && i.neighborhoodBestFitness == null) {
            return false;
        }
        if (this.neighborhoodBestFitness != null && !this.neighborhoodBestFitness.equals(i.neighborhoodBestFitness)) {
            return false;
        }
        if (this.personalBestGenome == null && i.personalBestGenome != null || this.personalBestGenome != null && i.personalBestGenome == null) {
            return false;
        }
        if (this.personalBestGenome != null) {
            if (this.personalBestGenome.length != i.personalBestGenome.length) {
                return false;
            }
            for (j = 0; j < this.personalBestGenome.length; ++j) {
                if (this.personalBestGenome[j] == i.personalBestGenome[j]) continue;
                return false;
            }
        }
        if (this.personalBestFitness == null && i.personalBestFitness != null || this.personalBestFitness != null && i.personalBestFitness == null) {
            return false;
        }
        return this.personalBestFitness == null || this.personalBestFitness.equals(i.personalBestFitness);
    }

    @Override
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        this.velocity = new double[this.genome.length];
    }

    @Override
    public Object clone() {
        Particle myobj = (Particle)super.clone();
        if (this.velocity != null) {
            this.velocity = (double[])this.velocity.clone();
        }
        if (this.neighborhood != null) {
            this.neighborhood = (int[])this.neighborhood.clone();
        }
        return myobj;
    }

    /*
     * Unable to fully structure code
     */
    public void update(EvolutionState state, int subpop, int myindex, int thread) {
        block5: {
            block6: {
                block4: {
                    if (this.personalBestFitness == null || this.fitness.betterThan(this.personalBestFitness)) {
                        this.personalBestFitness = (Fitness)this.fitness.clone();
                        this.personalBestGenome = (double[])this.genome.clone();
                    }
                    psob = (PSOBreeder)state.breeder;
                    if (this.neighborhood == null) break block4;
                    if (psob.neighborhood != 2) break block5;
                }
                if (psob.neighborhood != 0) break block6;
                this.neighborhood = this.createRandomPattern(myindex, psob.includeSelf, state.population.subpops.get((int)subpop).individuals.size(), psob.neighborhoodSize, state, thread);
                break block5;
            }
            if (psob.neighborhood == 1) ** GOTO lbl-1000
            if (psob.neighborhood == 2) lbl-1000:
            // 2 sources

            {
                this.neighborhood = this.createToroidalPattern(myindex, psob.includeSelf, state.population.subpops.get((int)subpop).individuals.size(), psob.neighborhoodSize);
            } else {
                state.output.fatal("internal error: invalid PSO neighborhood style: " + psob.neighborhood);
            }
        }
        this.neighborhoodBestFitness = this.fitness;
        this.neighborhoodBestGenome = this.genome;
        for (i = 0; i < this.neighborhood.length; ++i) {
            ind = this.neighborhood[i];
            if (!state.population.subpops.get((int)subpop).individuals.get((int)ind).fitness.betterThan(this.fitness)) continue;
            this.neighborhoodBestFitness = state.population.subpops.get((int)subpop).individuals.get((int)ind).fitness;
            this.neighborhoodBestGenome = ((DoubleVectorIndividual)state.population.subpops.get((int)subpop).individuals.get((int)ind)).genome;
        }
        this.neighborhoodBestFitness = (Fitness)this.neighborhoodBestFitness.clone();
        this.neighborhoodBestGenome = (double[])this.neighborhoodBestGenome.clone();
    }

    public void tweak(EvolutionState state, double[] globalBest, double velocityCoeff, double personalCoeff, double informantCoeff, double globalCoeff, int thread) {
        int x = 0;
        while (x < this.genomeLength()) {
            double newVelocity;
            double xCurrent = this.genome[x];
            double xPersonal = this.personalBestGenome[x];
            double xNeighbour = this.neighborhoodBestGenome[x];
            double xGlobal = globalBest[x];
            double beta = state.random[thread].nextDouble() * personalCoeff;
            double gamma = state.random[thread].nextDouble() * informantCoeff;
            double delta = state.random[thread].nextDouble() * globalCoeff;
            this.velocity[x] = newVelocity = velocityCoeff * this.velocity[x] + beta * (xPersonal - xCurrent) + gamma * (xNeighbour - xCurrent) + delta * (xGlobal - xCurrent);
            int n = x++;
            this.genome[n] = this.genome[n] + newVelocity;
        }
        this.evaluated = false;
    }

    int[] createRandomPattern(int myIndex, boolean includeSelf, int popsize, int neighborhoodSize, EvolutionState state, int threadnum) {
        MersenneTwisterFast mtf = state.random[threadnum];
        HashSet<Integer> already = new HashSet<Integer>();
        int[] neighbors = null;
        if (includeSelf) {
            neighbors = new int[neighborhoodSize + 1];
            neighbors[neighborhoodSize] = myIndex;
            already.add(myIndex);
        } else {
            neighbors = new int[neighborhoodSize];
        }
        Integer n = null;
        for (int i = 0; i < neighborhoodSize; ++i) {
            do {
                neighbors[i] = mtf.nextInt(popsize);
            } while (already.contains(n = Integer.valueOf(neighbors[i])));
            already.add(n);
        }
        return neighbors;
    }

    int[] createToroidalPattern(int myindex, boolean includeSelf, int popsize, int neighborhoodSize) {
        int i;
        int[] neighbors = null;
        if (includeSelf) {
            neighbors = new int[neighborhoodSize + 1];
            neighbors[neighborhoodSize] = myindex;
        } else {
            neighbors = new int[neighborhoodSize];
        }
        int pos = 0;
        for (i = myindex - neighborhoodSize / 2; i < myindex; ++i) {
            neighbors[pos++] = (i % popsize + popsize) % popsize;
        }
        for (i = myindex + 1; i < neighborhoodSize - neighborhoodSize / 2 + 1; ++i) {
            neighbors[pos++] = (i % popsize + popsize) % popsize;
        }
        return neighbors;
    }

    void resetAuxillaryInformation() {
        this.neighborhood = null;
        this.neighborhoodBestGenome = null;
        this.neighborhoodBestFitness = null;
        this.personalBestGenome = null;
        this.personalBestFitness = null;
        for (int i = 0; i < this.velocity.length; ++i) {
            this.velocity[i] = 0.0;
        }
    }

    @Override
    public void reset(EvolutionState state, int thread) {
        super.reset(state, thread);
        if (this.genome.length != this.velocity.length) {
            this.velocity = new double[this.genome.length];
        }
        this.resetAuxillaryInformation();
    }

    @Override
    public void setGenomeLength(int len) {
        super.setGenomeLength(len);
        if (this.genome.length != this.velocity.length) {
            this.velocity = new double[this.genome.length];
        }
        this.resetAuxillaryInformation();
    }

    @Override
    public void setGenome(Object gen) {
        super.setGenome(gen);
        if (this.genome.length != this.velocity.length) {
            this.velocity = new double[this.genome.length];
        }
        this.resetAuxillaryInformation();
    }

    @Override
    public void join(Object[] pieces) {
        super.join(pieces);
        if (this.genome.length != this.velocity.length) {
            this.velocity = new double[this.genome.length];
        }
        this.resetAuxillaryInformation();
    }

    StringBuilder encodeAuxillary() {
        int i;
        StringBuilder s = new StringBuilder();
        s.append(AUXILLARY_PREAMBLE);
        s.append(Code.encode(true));
        s.append(Code.encode(this.neighborhood != null));
        s.append(Code.encode(this.neighborhoodBestGenome != null));
        s.append(Code.encode(this.neighborhoodBestFitness != null));
        s.append(Code.encode(this.personalBestGenome != null));
        s.append(Code.encode(this.personalBestFitness != null));
        s.append("\n");
        s.append(Code.encode(this.velocity.length));
        for (i = 0; i < this.velocity.length; ++i) {
            s.append(Code.encode(this.velocity[i]));
        }
        s.append("\n");
        if (this.neighborhood != null) {
            s.append(Code.encode(this.neighborhood.length));
            for (i = 0; i < this.neighborhood.length; ++i) {
                s.append(Code.encode(this.neighborhood[i]));
            }
            s.append("\n");
        }
        if (this.neighborhoodBestGenome != null) {
            s.append(Code.encode(this.neighborhoodBestGenome.length));
            for (i = 0; i < this.neighborhoodBestGenome.length; ++i) {
                s.append(Code.encode(this.neighborhoodBestGenome[i]));
            }
            s.append("\n");
        }
        if (this.neighborhoodBestFitness != null) {
            s.append(this.neighborhoodBestFitness.fitnessToString());
        }
        if (this.personalBestGenome != null) {
            s.append(Code.encode(this.personalBestGenome.length));
            for (i = 0; i < this.personalBestGenome.length; ++i) {
                s.append(Code.encode(this.personalBestGenome[i]));
            }
            s.append("\n");
        }
        if (this.personalBestFitness != null) {
            s.append(this.personalBestFitness.fitnessToString());
        }
        s.append("\n");
        return s;
    }

    @Override
    public void printIndividual(EvolutionState state, int log) {
        super.printIndividual(state, log);
        state.output.println(this.encodeAuxillary().toString(), log);
    }

    @Override
    public void printIndividual(EvolutionState state, PrintWriter writer) {
        super.printIndividual(state, writer);
        writer.println(this.encodeAuxillary().toString());
    }

    @Override
    public void readIndividual(EvolutionState state, LineNumberReader reader) throws IOException {
        int i;
        String s;
        boolean pbf;
        super.readIndividual(state, reader);
        DecodeReturn d = new DecodeReturn(Code.readStringWithPreamble(AUXILLARY_PREAMBLE, state, reader));
        Code.decode(d);
        if (d.type != 0) {
            state.output.fatal("Line " + d.lineNumber + " should have six boolean values but seems to have fewer.");
        }
        boolean v = d.l != 0L;
        Code.decode(d);
        if (d.type != 0) {
            state.output.fatal("Line " + d.lineNumber + " should have six boolean values but seems to have fewer.");
        }
        boolean n = d.l != 0L;
        Code.decode(d);
        if (d.type != 0) {
            state.output.fatal("Line " + d.lineNumber + " should have six boolean values but seems to have fewer.");
        }
        boolean nb = d.l != 0L;
        Code.decode(d);
        if (d.type != 0) {
            state.output.fatal("Line " + d.lineNumber + " should have six boolean values but seems to have fewer.");
        }
        boolean nbf = d.l != 0L;
        Code.decode(d);
        if (d.type != 0) {
            state.output.fatal("Line " + d.lineNumber + " should have six boolean values but seems to have fewer.");
        }
        boolean pb = d.l != 0L;
        Code.decode(d);
        if (d.type != 0) {
            state.output.fatal("Line " + d.lineNumber + " should have six boolean values but seems to have fewer.");
        }
        boolean bl = pbf = d.l != 0L;
        if (v) {
            s = reader.readLine();
            d = new DecodeReturn(s);
            Code.decode(d);
            if (d.type != 4) {
                state.output.fatal("Velocity length missing.");
            }
            this.velocity = new double[(int)d.l];
            for (i = 0; i < this.velocity.length; ++i) {
                Code.decode(d);
                if (d.type != 7) {
                    state.output.fatal("Velocity information not long enough");
                }
                this.velocity[i] = d.d;
            }
        } else {
            this.velocity = new double[this.genome.length];
        }
        if (n) {
            s = reader.readLine();
            d = new DecodeReturn(s);
            Code.decode(d);
            if (d.type != 4) {
                state.output.fatal("Neighborhood length missing.");
            }
            this.neighborhood = new int[(int)d.l];
            for (i = 0; i < this.neighborhood.length; ++i) {
                Code.decode(d);
                if (d.type != 4) {
                    state.output.fatal("Neighborhood information not long enough");
                }
                this.neighborhood[i] = (int)d.l;
            }
        } else {
            this.neighborhood = null;
        }
        if (nb) {
            s = reader.readLine();
            d = new DecodeReturn(s);
            Code.decode(d);
            if (d.type != 4) {
                state.output.fatal("Neighborhood-Best length missing.");
            }
            this.neighborhoodBestGenome = new double[(int)d.l];
            for (i = 0; i < this.neighborhoodBestGenome.length; ++i) {
                Code.decode(d);
                if (d.type != 7) {
                    state.output.fatal("Neighborhood-Best genome not long enough");
                }
                this.neighborhoodBestGenome[i] = d.d;
            }
        } else {
            this.neighborhoodBestGenome = null;
        }
        if (nbf) {
            this.neighborhoodBestFitness = (Fitness)this.fitness.clone();
            this.neighborhoodBestFitness.readFitness(state, reader);
        }
        if (pb) {
            s = reader.readLine();
            d = new DecodeReturn(s);
            Code.decode(d);
            if (d.type != 4) {
                state.output.fatal("Personal-Best length missing.");
            }
            this.personalBestGenome = new double[(int)d.l];
            for (i = 0; i < this.personalBestGenome.length; ++i) {
                Code.decode(d);
                if (d.type != 7) {
                    state.output.fatal("Personal-Best genome not long enough");
                }
                this.personalBestGenome[i] = d.d;
            }
        } else {
            this.personalBestGenome = null;
        }
        if (pbf) {
            this.personalBestFitness = (Fitness)this.fitness.clone();
            this.personalBestFitness.readFitness(state, reader);
        }
    }

    @Override
    public void writeIndividual(EvolutionState state, DataOutput dataOutput) throws IOException {
        int i;
        super.writeIndividual(state, dataOutput);
        if (this.velocity != null) {
            dataOutput.writeBoolean(true);
            dataOutput.writeInt(this.velocity.length);
            for (i = 0; i < this.velocity.length; ++i) {
                dataOutput.writeDouble(this.velocity[i]);
            }
        } else {
            dataOutput.writeBoolean(false);
        }
        if (this.neighborhood != null) {
            dataOutput.writeBoolean(true);
            dataOutput.writeInt(this.neighborhood.length);
            for (i = 0; i < this.neighborhood.length; ++i) {
                dataOutput.writeDouble(this.neighborhood[i]);
            }
        } else {
            dataOutput.writeBoolean(false);
        }
        if (this.neighborhoodBestGenome != null) {
            dataOutput.writeBoolean(true);
            dataOutput.writeInt(this.neighborhoodBestGenome.length);
            for (i = 0; i < this.neighborhoodBestGenome.length; ++i) {
                dataOutput.writeDouble(this.neighborhoodBestGenome[i]);
            }
        } else {
            dataOutput.writeBoolean(false);
        }
        if (this.neighborhoodBestFitness != null) {
            dataOutput.writeBoolean(true);
            this.neighborhoodBestFitness.writeFitness(state, dataOutput);
        } else {
            dataOutput.writeBoolean(false);
        }
        if (this.personalBestGenome != null) {
            dataOutput.writeBoolean(true);
            dataOutput.writeInt(this.personalBestGenome.length);
            for (i = 0; i < this.personalBestGenome.length; ++i) {
                dataOutput.writeDouble(this.personalBestGenome[i]);
            }
        } else {
            dataOutput.writeBoolean(false);
        }
        if (this.personalBestFitness != null) {
            dataOutput.writeBoolean(true);
            this.personalBestFitness.writeFitness(state, dataOutput);
        } else {
            dataOutput.writeBoolean(false);
        }
    }

    @Override
    public void readIndividual(EvolutionState state, DataInput dataInput) throws IOException {
        int i;
        super.readIndividual(state, dataInput);
        if (dataInput.readBoolean()) {
            this.velocity = new double[dataInput.readInt()];
            for (i = 0; i < this.velocity.length; ++i) {
                this.velocity[i] = dataInput.readDouble();
            }
        } else {
            this.velocity = new double[this.genome.length];
        }
        if (dataInput.readBoolean()) {
            this.neighborhood = new int[dataInput.readInt()];
            for (i = 0; i < this.neighborhood.length; ++i) {
                this.neighborhood[i] = dataInput.readInt();
            }
        } else {
            this.neighborhood = null;
        }
        if (dataInput.readBoolean()) {
            this.neighborhoodBestGenome = new double[dataInput.readInt()];
            for (i = 0; i < this.neighborhoodBestGenome.length; ++i) {
                this.neighborhoodBestGenome[i] = dataInput.readDouble();
            }
        } else {
            this.neighborhoodBestGenome = null;
        }
        if (dataInput.readBoolean()) {
            this.neighborhoodBestFitness = (Fitness)this.fitness.clone();
            this.neighborhoodBestFitness.readFitness(state, dataInput);
        }
        if (dataInput.readBoolean()) {
            this.personalBestGenome = new double[dataInput.readInt()];
            for (i = 0; i < this.personalBestGenome.length; ++i) {
                this.personalBestGenome[i] = dataInput.readDouble();
            }
        } else {
            this.personalBestGenome = null;
        }
        if (dataInput.readBoolean()) {
            this.personalBestFitness = (Fitness)this.fitness.clone();
            this.personalBestFitness.readFitness(state, dataInput);
        }
    }
}

